/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.remote.app.model.impl;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.remote.app.model.RemoteAppEntry;
import com.liferay.remote.app.model.RemoteAppEntryModel;
import com.liferay.remote.app.model.RemoteAppEntrySoap;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the RemoteAppEntry service. Represents a row in the &quot;RemoteAppEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>RemoteAppEntryModel</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link RemoteAppEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RemoteAppEntryImpl
 * @generated
 */
@JSON(strict = true)
public class RemoteAppEntryModelImpl
	extends BaseModelImpl<RemoteAppEntry> implements RemoteAppEntryModel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a remote app entry model instance should use the <code>RemoteAppEntry</code> interface instead.
	 */
	public static final String TABLE_NAME = "RemoteAppEntry";

	public static final Object[][] TABLE_COLUMNS = {
		{"mvccVersion", Types.BIGINT}, {"uuid_", Types.VARCHAR},
		{"remoteAppEntryId", Types.BIGINT}, {"companyId", Types.BIGINT},
		{"userId", Types.BIGINT}, {"userName", Types.VARCHAR},
		{"createDate", Types.TIMESTAMP}, {"modifiedDate", Types.TIMESTAMP},
		{"customElementCSSURLs", Types.CLOB},
		{"customElementHTMLElementName", Types.VARCHAR},
		{"customElementURLs", Types.CLOB},
		{"friendlyURLMapping", Types.VARCHAR}, {"iFrameURL", Types.VARCHAR},
		{"instanceable", Types.BOOLEAN}, {"name", Types.VARCHAR},
		{"portletCategoryName", Types.VARCHAR}, {"properties", Types.CLOB},
		{"type_", Types.VARCHAR}
	};

	public static final Map<String, Integer> TABLE_COLUMNS_MAP =
		new HashMap<String, Integer>();

	static {
		TABLE_COLUMNS_MAP.put("mvccVersion", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("uuid_", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("remoteAppEntryId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("companyId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userId", Types.BIGINT);
		TABLE_COLUMNS_MAP.put("userName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("createDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("modifiedDate", Types.TIMESTAMP);
		TABLE_COLUMNS_MAP.put("customElementCSSURLs", Types.CLOB);
		TABLE_COLUMNS_MAP.put("customElementHTMLElementName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("customElementURLs", Types.CLOB);
		TABLE_COLUMNS_MAP.put("friendlyURLMapping", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("iFrameURL", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("instanceable", Types.BOOLEAN);
		TABLE_COLUMNS_MAP.put("name", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("portletCategoryName", Types.VARCHAR);
		TABLE_COLUMNS_MAP.put("properties", Types.CLOB);
		TABLE_COLUMNS_MAP.put("type_", Types.VARCHAR);
	}

	public static final String TABLE_SQL_CREATE =
		"create table RemoteAppEntry (mvccVersion LONG default 0 not null,uuid_ VARCHAR(75) null,remoteAppEntryId LONG not null primary key,companyId LONG,userId LONG,userName VARCHAR(75) null,createDate DATE null,modifiedDate DATE null,customElementCSSURLs TEXT null,customElementHTMLElementName VARCHAR(255) null,customElementURLs TEXT null,friendlyURLMapping VARCHAR(75) null,iFrameURL STRING null,instanceable BOOLEAN,name STRING null,portletCategoryName VARCHAR(75) null,properties TEXT null,type_ VARCHAR(75) null)";

	public static final String TABLE_SQL_DROP = "drop table RemoteAppEntry";

	public static final String ORDER_BY_JPQL =
		" ORDER BY remoteAppEntry.remoteAppEntryId ASC";

	public static final String ORDER_BY_SQL =
		" ORDER BY RemoteAppEntry.remoteAppEntryId ASC";

	public static final String DATA_SOURCE = "liferayDataSource";

	public static final String SESSION_FACTORY = "liferaySessionFactory";

	public static final String TX_MANAGER = "liferayTransactionManager";

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long COMPANYID_COLUMN_BITMASK = 1L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long UUID_COLUMN_BITMASK = 2L;

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *		#getColumnBitmask(String)}
	 */
	@Deprecated
	public static final long REMOTEAPPENTRYID_COLUMN_BITMASK = 4L;

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
	}

	/**
	 * Converts the soap model instance into a normal model instance.
	 *
	 * @param soapModel the soap model instance to convert
	 * @return the normal model instance
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static RemoteAppEntry toModel(RemoteAppEntrySoap soapModel) {
		if (soapModel == null) {
			return null;
		}

		RemoteAppEntry model = new RemoteAppEntryImpl();

		model.setMvccVersion(soapModel.getMvccVersion());
		model.setUuid(soapModel.getUuid());
		model.setRemoteAppEntryId(soapModel.getRemoteAppEntryId());
		model.setCompanyId(soapModel.getCompanyId());
		model.setUserId(soapModel.getUserId());
		model.setUserName(soapModel.getUserName());
		model.setCreateDate(soapModel.getCreateDate());
		model.setModifiedDate(soapModel.getModifiedDate());
		model.setCustomElementCSSURLs(soapModel.getCustomElementCSSURLs());
		model.setCustomElementHTMLElementName(
			soapModel.getCustomElementHTMLElementName());
		model.setCustomElementURLs(soapModel.getCustomElementURLs());
		model.setFriendlyURLMapping(soapModel.getFriendlyURLMapping());
		model.setIFrameURL(soapModel.getIFrameURL());
		model.setInstanceable(soapModel.isInstanceable());
		model.setName(soapModel.getName());
		model.setPortletCategoryName(soapModel.getPortletCategoryName());
		model.setProperties(soapModel.getProperties());
		model.setType(soapModel.getType());

		return model;
	}

	/**
	 * Converts the soap model instances into normal model instances.
	 *
	 * @param soapModels the soap model instances to convert
	 * @return the normal model instances
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	public static List<RemoteAppEntry> toModels(
		RemoteAppEntrySoap[] soapModels) {

		if (soapModels == null) {
			return null;
		}

		List<RemoteAppEntry> models = new ArrayList<RemoteAppEntry>(
			soapModels.length);

		for (RemoteAppEntrySoap soapModel : soapModels) {
			models.add(toModel(soapModel));
		}

		return models;
	}

	public RemoteAppEntryModelImpl() {
	}

	@Override
	public long getPrimaryKey() {
		return _remoteAppEntryId;
	}

	@Override
	public void setPrimaryKey(long primaryKey) {
		setRemoteAppEntryId(primaryKey);
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		return _remoteAppEntryId;
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(((Long)primaryKeyObj).longValue());
	}

	@Override
	public Class<?> getModelClass() {
		return RemoteAppEntry.class;
	}

	@Override
	public String getModelClassName() {
		return RemoteAppEntry.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<RemoteAppEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		for (Map.Entry<String, Function<RemoteAppEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<RemoteAppEntry, Object> attributeGetterFunction =
				entry.getValue();

			attributes.put(
				attributeName,
				attributeGetterFunction.apply((RemoteAppEntry)this));
		}

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<RemoteAppEntry, Object>>
			attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<RemoteAppEntry, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept(
					(RemoteAppEntry)this, entry.getValue());
			}
		}
	}

	public Map<String, Function<RemoteAppEntry, Object>>
		getAttributeGetterFunctions() {

		return _attributeGetterFunctions;
	}

	public Map<String, BiConsumer<RemoteAppEntry, Object>>
		getAttributeSetterBiConsumers() {

		return _attributeSetterBiConsumers;
	}

	private static Function<InvocationHandler, RemoteAppEntry>
		_getProxyProviderFunction() {

		Class<?> proxyClass = ProxyUtil.getProxyClass(
			RemoteAppEntry.class.getClassLoader(), RemoteAppEntry.class,
			ModelWrapper.class);

		try {
			Constructor<RemoteAppEntry> constructor =
				(Constructor<RemoteAppEntry>)proxyClass.getConstructor(
					InvocationHandler.class);

			return invocationHandler -> {
				try {
					return constructor.newInstance(invocationHandler);
				}
				catch (ReflectiveOperationException
							reflectiveOperationException) {

					throw new InternalError(reflectiveOperationException);
				}
			};
		}
		catch (NoSuchMethodException noSuchMethodException) {
			throw new InternalError(noSuchMethodException);
		}
	}

	private static final Map<String, Function<RemoteAppEntry, Object>>
		_attributeGetterFunctions;
	private static final Map<String, BiConsumer<RemoteAppEntry, Object>>
		_attributeSetterBiConsumers;

	static {
		Map<String, Function<RemoteAppEntry, Object>> attributeGetterFunctions =
			new LinkedHashMap<String, Function<RemoteAppEntry, Object>>();
		Map<String, BiConsumer<RemoteAppEntry, ?>> attributeSetterBiConsumers =
			new LinkedHashMap<String, BiConsumer<RemoteAppEntry, ?>>();

		attributeGetterFunctions.put(
			"mvccVersion", RemoteAppEntry::getMvccVersion);
		attributeSetterBiConsumers.put(
			"mvccVersion",
			(BiConsumer<RemoteAppEntry, Long>)RemoteAppEntry::setMvccVersion);
		attributeGetterFunctions.put("uuid", RemoteAppEntry::getUuid);
		attributeSetterBiConsumers.put(
			"uuid",
			(BiConsumer<RemoteAppEntry, String>)RemoteAppEntry::setUuid);
		attributeGetterFunctions.put(
			"remoteAppEntryId", RemoteAppEntry::getRemoteAppEntryId);
		attributeSetterBiConsumers.put(
			"remoteAppEntryId",
			(BiConsumer<RemoteAppEntry, Long>)
				RemoteAppEntry::setRemoteAppEntryId);
		attributeGetterFunctions.put("companyId", RemoteAppEntry::getCompanyId);
		attributeSetterBiConsumers.put(
			"companyId",
			(BiConsumer<RemoteAppEntry, Long>)RemoteAppEntry::setCompanyId);
		attributeGetterFunctions.put("userId", RemoteAppEntry::getUserId);
		attributeSetterBiConsumers.put(
			"userId",
			(BiConsumer<RemoteAppEntry, Long>)RemoteAppEntry::setUserId);
		attributeGetterFunctions.put("userName", RemoteAppEntry::getUserName);
		attributeSetterBiConsumers.put(
			"userName",
			(BiConsumer<RemoteAppEntry, String>)RemoteAppEntry::setUserName);
		attributeGetterFunctions.put(
			"createDate", RemoteAppEntry::getCreateDate);
		attributeSetterBiConsumers.put(
			"createDate",
			(BiConsumer<RemoteAppEntry, Date>)RemoteAppEntry::setCreateDate);
		attributeGetterFunctions.put(
			"modifiedDate", RemoteAppEntry::getModifiedDate);
		attributeSetterBiConsumers.put(
			"modifiedDate",
			(BiConsumer<RemoteAppEntry, Date>)RemoteAppEntry::setModifiedDate);
		attributeGetterFunctions.put(
			"customElementCSSURLs", RemoteAppEntry::getCustomElementCSSURLs);
		attributeSetterBiConsumers.put(
			"customElementCSSURLs",
			(BiConsumer<RemoteAppEntry, String>)
				RemoteAppEntry::setCustomElementCSSURLs);
		attributeGetterFunctions.put(
			"customElementHTMLElementName",
			RemoteAppEntry::getCustomElementHTMLElementName);
		attributeSetterBiConsumers.put(
			"customElementHTMLElementName",
			(BiConsumer<RemoteAppEntry, String>)
				RemoteAppEntry::setCustomElementHTMLElementName);
		attributeGetterFunctions.put(
			"customElementURLs", RemoteAppEntry::getCustomElementURLs);
		attributeSetterBiConsumers.put(
			"customElementURLs",
			(BiConsumer<RemoteAppEntry, String>)
				RemoteAppEntry::setCustomElementURLs);
		attributeGetterFunctions.put(
			"friendlyURLMapping", RemoteAppEntry::getFriendlyURLMapping);
		attributeSetterBiConsumers.put(
			"friendlyURLMapping",
			(BiConsumer<RemoteAppEntry, String>)
				RemoteAppEntry::setFriendlyURLMapping);
		attributeGetterFunctions.put("iFrameURL", RemoteAppEntry::getIFrameURL);
		attributeSetterBiConsumers.put(
			"iFrameURL",
			(BiConsumer<RemoteAppEntry, String>)RemoteAppEntry::setIFrameURL);
		attributeGetterFunctions.put(
			"instanceable", RemoteAppEntry::getInstanceable);
		attributeSetterBiConsumers.put(
			"instanceable",
			(BiConsumer<RemoteAppEntry, Boolean>)
				RemoteAppEntry::setInstanceable);
		attributeGetterFunctions.put("name", RemoteAppEntry::getName);
		attributeSetterBiConsumers.put(
			"name",
			(BiConsumer<RemoteAppEntry, String>)RemoteAppEntry::setName);
		attributeGetterFunctions.put(
			"portletCategoryName", RemoteAppEntry::getPortletCategoryName);
		attributeSetterBiConsumers.put(
			"portletCategoryName",
			(BiConsumer<RemoteAppEntry, String>)
				RemoteAppEntry::setPortletCategoryName);
		attributeGetterFunctions.put(
			"properties", RemoteAppEntry::getProperties);
		attributeSetterBiConsumers.put(
			"properties",
			(BiConsumer<RemoteAppEntry, String>)RemoteAppEntry::setProperties);
		attributeGetterFunctions.put("type", RemoteAppEntry::getType);
		attributeSetterBiConsumers.put(
			"type",
			(BiConsumer<RemoteAppEntry, String>)RemoteAppEntry::setType);

		_attributeGetterFunctions = Collections.unmodifiableMap(
			attributeGetterFunctions);
		_attributeSetterBiConsumers = Collections.unmodifiableMap(
			(Map)attributeSetterBiConsumers);
	}

	@JSON
	@Override
	public long getMvccVersion() {
		return _mvccVersion;
	}

	@Override
	public void setMvccVersion(long mvccVersion) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_mvccVersion = mvccVersion;
	}

	@JSON
	@Override
	public String getUuid() {
		if (_uuid == null) {
			return "";
		}
		else {
			return _uuid;
		}
	}

	@Override
	public void setUuid(String uuid) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_uuid = uuid;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public String getOriginalUuid() {
		return getColumnOriginalValue("uuid_");
	}

	@JSON
	@Override
	public long getRemoteAppEntryId() {
		return _remoteAppEntryId;
	}

	@Override
	public void setRemoteAppEntryId(long remoteAppEntryId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_remoteAppEntryId = remoteAppEntryId;
	}

	@JSON
	@Override
	public long getCompanyId() {
		return _companyId;
	}

	@Override
	public void setCompanyId(long companyId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_companyId = companyId;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), replaced by {@link
	 *             #getColumnOriginalValue(String)}
	 */
	@Deprecated
	public long getOriginalCompanyId() {
		return GetterUtil.getLong(
			this.<Long>getColumnOriginalValue("companyId"));
	}

	@JSON
	@Override
	public long getUserId() {
		return _userId;
	}

	@Override
	public void setUserId(long userId) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userId = userId;
	}

	@Override
	public String getUserUuid() {
		try {
			User user = UserLocalServiceUtil.getUserById(getUserId());

			return user.getUuid();
		}
		catch (PortalException portalException) {
			return "";
		}
	}

	@Override
	public void setUserUuid(String userUuid) {
	}

	@JSON
	@Override
	public String getUserName() {
		if (_userName == null) {
			return "";
		}
		else {
			return _userName;
		}
	}

	@Override
	public void setUserName(String userName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_userName = userName;
	}

	@JSON
	@Override
	public Date getCreateDate() {
		return _createDate;
	}

	@Override
	public void setCreateDate(Date createDate) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_createDate = createDate;
	}

	@JSON
	@Override
	public Date getModifiedDate() {
		return _modifiedDate;
	}

	public boolean hasSetModifiedDate() {
		return _setModifiedDate;
	}

	@Override
	public void setModifiedDate(Date modifiedDate) {
		_setModifiedDate = true;

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_modifiedDate = modifiedDate;
	}

	@JSON
	@Override
	public String getCustomElementCSSURLs() {
		if (_customElementCSSURLs == null) {
			return "";
		}
		else {
			return _customElementCSSURLs;
		}
	}

	@Override
	public void setCustomElementCSSURLs(String customElementCSSURLs) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_customElementCSSURLs = customElementCSSURLs;
	}

	@JSON
	@Override
	public String getCustomElementHTMLElementName() {
		if (_customElementHTMLElementName == null) {
			return "";
		}
		else {
			return _customElementHTMLElementName;
		}
	}

	@Override
	public void setCustomElementHTMLElementName(
		String customElementHTMLElementName) {

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_customElementHTMLElementName = customElementHTMLElementName;
	}

	@JSON
	@Override
	public String getCustomElementURLs() {
		if (_customElementURLs == null) {
			return "";
		}
		else {
			return _customElementURLs;
		}
	}

	@Override
	public void setCustomElementURLs(String customElementURLs) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_customElementURLs = customElementURLs;
	}

	@JSON
	@Override
	public String getFriendlyURLMapping() {
		if (_friendlyURLMapping == null) {
			return "";
		}
		else {
			return _friendlyURLMapping;
		}
	}

	@Override
	public void setFriendlyURLMapping(String friendlyURLMapping) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_friendlyURLMapping = friendlyURLMapping;
	}

	@JSON
	@Override
	public String getIFrameURL() {
		if (_iFrameURL == null) {
			return "";
		}
		else {
			return _iFrameURL;
		}
	}

	@Override
	public void setIFrameURL(String iFrameURL) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_iFrameURL = iFrameURL;
	}

	@JSON
	@Override
	public boolean getInstanceable() {
		return _instanceable;
	}

	@JSON
	@Override
	public boolean isInstanceable() {
		return _instanceable;
	}

	@Override
	public void setInstanceable(boolean instanceable) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_instanceable = instanceable;
	}

	@JSON
	@Override
	public String getName() {
		if (_name == null) {
			return "";
		}
		else {
			return _name;
		}
	}

	@Override
	public String getName(Locale locale) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId);
	}

	@Override
	public String getName(Locale locale, boolean useDefault) {
		String languageId = LocaleUtil.toLanguageId(locale);

		return getName(languageId, useDefault);
	}

	@Override
	public String getName(String languageId) {
		return LocalizationUtil.getLocalization(getName(), languageId);
	}

	@Override
	public String getName(String languageId, boolean useDefault) {
		return LocalizationUtil.getLocalization(
			getName(), languageId, useDefault);
	}

	@Override
	public String getNameCurrentLanguageId() {
		return _nameCurrentLanguageId;
	}

	@JSON
	@Override
	public String getNameCurrentValue() {
		Locale locale = getLocale(_nameCurrentLanguageId);

		return getName(locale);
	}

	@Override
	public Map<Locale, String> getNameMap() {
		return LocalizationUtil.getLocalizationMap(getName());
	}

	@Override
	public void setName(String name) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_name = name;
	}

	@Override
	public void setName(String name, Locale locale) {
		setName(name, locale, LocaleUtil.getDefault());
	}

	@Override
	public void setName(String name, Locale locale, Locale defaultLocale) {
		String languageId = LocaleUtil.toLanguageId(locale);
		String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

		if (Validator.isNotNull(name)) {
			setName(
				LocalizationUtil.updateLocalization(
					getName(), "Name", name, languageId, defaultLanguageId));
		}
		else {
			setName(
				LocalizationUtil.removeLocalization(
					getName(), "Name", languageId));
		}
	}

	@Override
	public void setNameCurrentLanguageId(String languageId) {
		_nameCurrentLanguageId = languageId;
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap) {
		setNameMap(nameMap, LocaleUtil.getDefault());
	}

	@Override
	public void setNameMap(Map<Locale, String> nameMap, Locale defaultLocale) {
		if (nameMap == null) {
			return;
		}

		setName(
			LocalizationUtil.updateLocalization(
				nameMap, getName(), "Name",
				LocaleUtil.toLanguageId(defaultLocale)));
	}

	@JSON
	@Override
	public String getPortletCategoryName() {
		if (_portletCategoryName == null) {
			return "";
		}
		else {
			return _portletCategoryName;
		}
	}

	@Override
	public void setPortletCategoryName(String portletCategoryName) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_portletCategoryName = portletCategoryName;
	}

	@JSON
	@Override
	public String getProperties() {
		if (_properties == null) {
			return "";
		}
		else {
			return _properties;
		}
	}

	@Override
	public void setProperties(String properties) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_properties = properties;
	}

	@JSON
	@Override
	public String getType() {
		if (_type == null) {
			return "";
		}
		else {
			return _type;
		}
	}

	@Override
	public void setType(String type) {
		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		_type = type;
	}

	@Override
	public long getContainerModelId() {
		return getRemoteAppEntryId();
	}

	@Override
	public void setContainerModelId(long containerModelId) {
		_remoteAppEntryId = containerModelId;
	}

	@Override
	public String getContainerModelName() {
		return String.valueOf(getName());
	}

	@Override
	public long getParentContainerModelId() {
		return 0;
	}

	@Override
	public void setParentContainerModelId(long parentContainerModelId) {
	}

	@Override
	public StagedModelType getStagedModelType() {
		return new StagedModelType(
			PortalUtil.getClassNameId(RemoteAppEntry.class.getName()));
	}

	public long getColumnBitmask() {
		if (_columnBitmask > 0) {
			return _columnBitmask;
		}

		if ((_columnOriginalValues == null) ||
			(_columnOriginalValues == Collections.EMPTY_MAP)) {

			return 0;
		}

		for (Map.Entry<String, Object> entry :
				_columnOriginalValues.entrySet()) {

			if (!Objects.equals(
					entry.getValue(), getColumnValue(entry.getKey()))) {

				_columnBitmask |= _columnBitmasks.get(entry.getKey());
			}
		}

		return _columnBitmask;
	}

	@Override
	public ExpandoBridge getExpandoBridge() {
		return ExpandoBridgeFactoryUtil.getExpandoBridge(
			getCompanyId(), RemoteAppEntry.class.getName(), getPrimaryKey());
	}

	@Override
	public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
		ExpandoBridge expandoBridge = getExpandoBridge();

		expandoBridge.setAttributes(serviceContext);
	}

	@Override
	public String[] getAvailableLanguageIds() {
		Set<String> availableLanguageIds = new TreeSet<String>();

		Map<Locale, String> nameMap = getNameMap();

		for (Map.Entry<Locale, String> entry : nameMap.entrySet()) {
			Locale locale = entry.getKey();
			String value = entry.getValue();

			if (Validator.isNotNull(value)) {
				availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
			}
		}

		return availableLanguageIds.toArray(
			new String[availableLanguageIds.size()]);
	}

	@Override
	public String getDefaultLanguageId() {
		String xml = getName();

		if (xml == null) {
			return "";
		}

		Locale defaultLocale = LocaleUtil.getDefault();

		return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
	}

	@Override
	public void prepareLocalizedFieldsForImport() throws LocaleException {
		Locale defaultLocale = LocaleUtil.fromLanguageId(
			getDefaultLanguageId());

		Locale[] availableLocales = LocaleUtil.fromLanguageIds(
			getAvailableLanguageIds());

		Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(
			RemoteAppEntry.class.getName(), getPrimaryKey(), defaultLocale,
			availableLocales);

		prepareLocalizedFieldsForImport(defaultImportLocale);
	}

	@Override
	@SuppressWarnings("unused")
	public void prepareLocalizedFieldsForImport(Locale defaultImportLocale)
		throws LocaleException {

		Locale defaultLocale = LocaleUtil.getDefault();

		String modelDefaultLanguageId = getDefaultLanguageId();

		String name = getName(defaultLocale);

		if (Validator.isNull(name)) {
			setName(getName(modelDefaultLanguageId), defaultLocale);
		}
		else {
			setName(getName(defaultLocale), defaultLocale, defaultLocale);
		}
	}

	@Override
	public RemoteAppEntry toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, RemoteAppEntry>
				escapedModelProxyProviderFunction =
					EscapedModelProxyProviderFunctionHolder.
						_escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(
				new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		RemoteAppEntryImpl remoteAppEntryImpl = new RemoteAppEntryImpl();

		remoteAppEntryImpl.setMvccVersion(getMvccVersion());
		remoteAppEntryImpl.setUuid(getUuid());
		remoteAppEntryImpl.setRemoteAppEntryId(getRemoteAppEntryId());
		remoteAppEntryImpl.setCompanyId(getCompanyId());
		remoteAppEntryImpl.setUserId(getUserId());
		remoteAppEntryImpl.setUserName(getUserName());
		remoteAppEntryImpl.setCreateDate(getCreateDate());
		remoteAppEntryImpl.setModifiedDate(getModifiedDate());
		remoteAppEntryImpl.setCustomElementCSSURLs(getCustomElementCSSURLs());
		remoteAppEntryImpl.setCustomElementHTMLElementName(
			getCustomElementHTMLElementName());
		remoteAppEntryImpl.setCustomElementURLs(getCustomElementURLs());
		remoteAppEntryImpl.setFriendlyURLMapping(getFriendlyURLMapping());
		remoteAppEntryImpl.setIFrameURL(getIFrameURL());
		remoteAppEntryImpl.setInstanceable(isInstanceable());
		remoteAppEntryImpl.setName(getName());
		remoteAppEntryImpl.setPortletCategoryName(getPortletCategoryName());
		remoteAppEntryImpl.setProperties(getProperties());
		remoteAppEntryImpl.setType(getType());

		remoteAppEntryImpl.resetOriginalValues();

		return remoteAppEntryImpl;
	}

	@Override
	public RemoteAppEntry cloneWithOriginalValues() {
		RemoteAppEntryImpl remoteAppEntryImpl = new RemoteAppEntryImpl();

		remoteAppEntryImpl.setMvccVersion(
			this.<Long>getColumnOriginalValue("mvccVersion"));
		remoteAppEntryImpl.setUuid(
			this.<String>getColumnOriginalValue("uuid_"));
		remoteAppEntryImpl.setRemoteAppEntryId(
			this.<Long>getColumnOriginalValue("remoteAppEntryId"));
		remoteAppEntryImpl.setCompanyId(
			this.<Long>getColumnOriginalValue("companyId"));
		remoteAppEntryImpl.setUserId(
			this.<Long>getColumnOriginalValue("userId"));
		remoteAppEntryImpl.setUserName(
			this.<String>getColumnOriginalValue("userName"));
		remoteAppEntryImpl.setCreateDate(
			this.<Date>getColumnOriginalValue("createDate"));
		remoteAppEntryImpl.setModifiedDate(
			this.<Date>getColumnOriginalValue("modifiedDate"));
		remoteAppEntryImpl.setCustomElementCSSURLs(
			this.<String>getColumnOriginalValue("customElementCSSURLs"));
		remoteAppEntryImpl.setCustomElementHTMLElementName(
			this.<String>getColumnOriginalValue(
				"customElementHTMLElementName"));
		remoteAppEntryImpl.setCustomElementURLs(
			this.<String>getColumnOriginalValue("customElementURLs"));
		remoteAppEntryImpl.setFriendlyURLMapping(
			this.<String>getColumnOriginalValue("friendlyURLMapping"));
		remoteAppEntryImpl.setIFrameURL(
			this.<String>getColumnOriginalValue("iFrameURL"));
		remoteAppEntryImpl.setInstanceable(
			this.<Boolean>getColumnOriginalValue("instanceable"));
		remoteAppEntryImpl.setName(this.<String>getColumnOriginalValue("name"));
		remoteAppEntryImpl.setPortletCategoryName(
			this.<String>getColumnOriginalValue("portletCategoryName"));
		remoteAppEntryImpl.setProperties(
			this.<String>getColumnOriginalValue("properties"));
		remoteAppEntryImpl.setType(
			this.<String>getColumnOriginalValue("type_"));

		return remoteAppEntryImpl;
	}

	@Override
	public int compareTo(RemoteAppEntry remoteAppEntry) {
		long primaryKey = remoteAppEntry.getPrimaryKey();

		if (getPrimaryKey() < primaryKey) {
			return -1;
		}
		else if (getPrimaryKey() > primaryKey) {
			return 1;
		}
		else {
			return 0;
		}
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof RemoteAppEntry)) {
			return false;
		}

		RemoteAppEntry remoteAppEntry = (RemoteAppEntry)object;

		long primaryKey = remoteAppEntry.getPrimaryKey();

		if (getPrimaryKey() == primaryKey) {
			return true;
		}
		else {
			return false;
		}
	}

	@Override
	public int hashCode() {
		return (int)getPrimaryKey();
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isEntityCacheEnabled() {
		return true;
	}

	/**
	 * @deprecated As of Athanasius (7.3.x), with no direct replacement
	 */
	@Deprecated
	@Override
	public boolean isFinderCacheEnabled() {
		return true;
	}

	@Override
	public void resetOriginalValues() {
		_columnOriginalValues = Collections.emptyMap();

		_setModifiedDate = false;

		_columnBitmask = 0;
	}

	@Override
	public CacheModel<RemoteAppEntry> toCacheModel() {
		RemoteAppEntryCacheModel remoteAppEntryCacheModel =
			new RemoteAppEntryCacheModel();

		remoteAppEntryCacheModel.mvccVersion = getMvccVersion();

		remoteAppEntryCacheModel.uuid = getUuid();

		String uuid = remoteAppEntryCacheModel.uuid;

		if ((uuid != null) && (uuid.length() == 0)) {
			remoteAppEntryCacheModel.uuid = null;
		}

		remoteAppEntryCacheModel.remoteAppEntryId = getRemoteAppEntryId();

		remoteAppEntryCacheModel.companyId = getCompanyId();

		remoteAppEntryCacheModel.userId = getUserId();

		remoteAppEntryCacheModel.userName = getUserName();

		String userName = remoteAppEntryCacheModel.userName;

		if ((userName != null) && (userName.length() == 0)) {
			remoteAppEntryCacheModel.userName = null;
		}

		Date createDate = getCreateDate();

		if (createDate != null) {
			remoteAppEntryCacheModel.createDate = createDate.getTime();
		}
		else {
			remoteAppEntryCacheModel.createDate = Long.MIN_VALUE;
		}

		Date modifiedDate = getModifiedDate();

		if (modifiedDate != null) {
			remoteAppEntryCacheModel.modifiedDate = modifiedDate.getTime();
		}
		else {
			remoteAppEntryCacheModel.modifiedDate = Long.MIN_VALUE;
		}

		remoteAppEntryCacheModel.customElementCSSURLs =
			getCustomElementCSSURLs();

		String customElementCSSURLs =
			remoteAppEntryCacheModel.customElementCSSURLs;

		if ((customElementCSSURLs != null) &&
			(customElementCSSURLs.length() == 0)) {

			remoteAppEntryCacheModel.customElementCSSURLs = null;
		}

		remoteAppEntryCacheModel.customElementHTMLElementName =
			getCustomElementHTMLElementName();

		String customElementHTMLElementName =
			remoteAppEntryCacheModel.customElementHTMLElementName;

		if ((customElementHTMLElementName != null) &&
			(customElementHTMLElementName.length() == 0)) {

			remoteAppEntryCacheModel.customElementHTMLElementName = null;
		}

		remoteAppEntryCacheModel.customElementURLs = getCustomElementURLs();

		String customElementURLs = remoteAppEntryCacheModel.customElementURLs;

		if ((customElementURLs != null) && (customElementURLs.length() == 0)) {
			remoteAppEntryCacheModel.customElementURLs = null;
		}

		remoteAppEntryCacheModel.friendlyURLMapping = getFriendlyURLMapping();

		String friendlyURLMapping = remoteAppEntryCacheModel.friendlyURLMapping;

		if ((friendlyURLMapping != null) &&
			(friendlyURLMapping.length() == 0)) {

			remoteAppEntryCacheModel.friendlyURLMapping = null;
		}

		remoteAppEntryCacheModel.iFrameURL = getIFrameURL();

		String iFrameURL = remoteAppEntryCacheModel.iFrameURL;

		if ((iFrameURL != null) && (iFrameURL.length() == 0)) {
			remoteAppEntryCacheModel.iFrameURL = null;
		}

		remoteAppEntryCacheModel.instanceable = isInstanceable();

		remoteAppEntryCacheModel.name = getName();

		String name = remoteAppEntryCacheModel.name;

		if ((name != null) && (name.length() == 0)) {
			remoteAppEntryCacheModel.name = null;
		}

		remoteAppEntryCacheModel.portletCategoryName = getPortletCategoryName();

		String portletCategoryName =
			remoteAppEntryCacheModel.portletCategoryName;

		if ((portletCategoryName != null) &&
			(portletCategoryName.length() == 0)) {

			remoteAppEntryCacheModel.portletCategoryName = null;
		}

		remoteAppEntryCacheModel.properties = getProperties();

		String properties = remoteAppEntryCacheModel.properties;

		if ((properties != null) && (properties.length() == 0)) {
			remoteAppEntryCacheModel.properties = null;
		}

		remoteAppEntryCacheModel.type = getType();

		String type = remoteAppEntryCacheModel.type;

		if ((type != null) && (type.length() == 0)) {
			remoteAppEntryCacheModel.type = null;
		}

		return remoteAppEntryCacheModel;
	}

	@Override
	public String toString() {
		Map<String, Function<RemoteAppEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 2);

		sb.append("{");

		for (Map.Entry<String, Function<RemoteAppEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<RemoteAppEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("\"");
			sb.append(attributeName);
			sb.append("\": ");

			Object value = attributeGetterFunction.apply((RemoteAppEntry)this);

			if (value == null) {
				sb.append("null");
			}
			else if (value instanceof Blob || value instanceof Date ||
					 value instanceof Map || value instanceof String) {

				sb.append(
					"\"" + StringUtil.replace(value.toString(), "\"", "'") +
						"\"");
			}
			else {
				sb.append(value);
			}

			sb.append(", ");
		}

		if (sb.index() > 1) {
			sb.setIndex(sb.index() - 1);
		}

		sb.append("}");

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		Map<String, Function<RemoteAppEntry, Object>> attributeGetterFunctions =
			getAttributeGetterFunctions();

		StringBundler sb = new StringBundler(
			(5 * attributeGetterFunctions.size()) + 4);

		sb.append("<model><model-name>");
		sb.append(getModelClassName());
		sb.append("</model-name>");

		for (Map.Entry<String, Function<RemoteAppEntry, Object>> entry :
				attributeGetterFunctions.entrySet()) {

			String attributeName = entry.getKey();
			Function<RemoteAppEntry, Object> attributeGetterFunction =
				entry.getValue();

			sb.append("<column><column-name>");
			sb.append(attributeName);
			sb.append("</column-name><column-value><![CDATA[");
			sb.append(attributeGetterFunction.apply((RemoteAppEntry)this));
			sb.append("]]></column-value></column>");
		}

		sb.append("</model>");

		return sb.toString();
	}

	private static class EscapedModelProxyProviderFunctionHolder {

		private static final Function<InvocationHandler, RemoteAppEntry>
			_escapedModelProxyProviderFunction = _getProxyProviderFunction();

	}

	private long _mvccVersion;
	private String _uuid;
	private long _remoteAppEntryId;
	private long _companyId;
	private long _userId;
	private String _userName;
	private Date _createDate;
	private Date _modifiedDate;
	private boolean _setModifiedDate;
	private String _customElementCSSURLs;
	private String _customElementHTMLElementName;
	private String _customElementURLs;
	private String _friendlyURLMapping;
	private String _iFrameURL;
	private boolean _instanceable;
	private String _name;
	private String _nameCurrentLanguageId;
	private String _portletCategoryName;
	private String _properties;
	private String _type;

	public <T> T getColumnValue(String columnName) {
		columnName = _attributeNames.getOrDefault(columnName, columnName);

		Function<RemoteAppEntry, Object> function =
			_attributeGetterFunctions.get(columnName);

		if (function == null) {
			throw new IllegalArgumentException(
				"No attribute getter function found for " + columnName);
		}

		return (T)function.apply((RemoteAppEntry)this);
	}

	public <T> T getColumnOriginalValue(String columnName) {
		if (_columnOriginalValues == null) {
			return null;
		}

		if (_columnOriginalValues == Collections.EMPTY_MAP) {
			_setColumnOriginalValues();
		}

		return (T)_columnOriginalValues.get(columnName);
	}

	private void _setColumnOriginalValues() {
		_columnOriginalValues = new HashMap<String, Object>();

		_columnOriginalValues.put("mvccVersion", _mvccVersion);
		_columnOriginalValues.put("uuid_", _uuid);
		_columnOriginalValues.put("remoteAppEntryId", _remoteAppEntryId);
		_columnOriginalValues.put("companyId", _companyId);
		_columnOriginalValues.put("userId", _userId);
		_columnOriginalValues.put("userName", _userName);
		_columnOriginalValues.put("createDate", _createDate);
		_columnOriginalValues.put("modifiedDate", _modifiedDate);
		_columnOriginalValues.put(
			"customElementCSSURLs", _customElementCSSURLs);
		_columnOriginalValues.put(
			"customElementHTMLElementName", _customElementHTMLElementName);
		_columnOriginalValues.put("customElementURLs", _customElementURLs);
		_columnOriginalValues.put("friendlyURLMapping", _friendlyURLMapping);
		_columnOriginalValues.put("iFrameURL", _iFrameURL);
		_columnOriginalValues.put("instanceable", _instanceable);
		_columnOriginalValues.put("name", _name);
		_columnOriginalValues.put("portletCategoryName", _portletCategoryName);
		_columnOriginalValues.put("properties", _properties);
		_columnOriginalValues.put("type_", _type);
	}

	private static final Map<String, String> _attributeNames;

	static {
		Map<String, String> attributeNames = new HashMap<>();

		attributeNames.put("uuid_", "uuid");
		attributeNames.put("type_", "type");

		_attributeNames = Collections.unmodifiableMap(attributeNames);
	}

	private transient Map<String, Object> _columnOriginalValues;

	public static long getColumnBitmask(String columnName) {
		return _columnBitmasks.get(columnName);
	}

	private static final Map<String, Long> _columnBitmasks;

	static {
		Map<String, Long> columnBitmasks = new HashMap<>();

		columnBitmasks.put("mvccVersion", 1L);

		columnBitmasks.put("uuid_", 2L);

		columnBitmasks.put("remoteAppEntryId", 4L);

		columnBitmasks.put("companyId", 8L);

		columnBitmasks.put("userId", 16L);

		columnBitmasks.put("userName", 32L);

		columnBitmasks.put("createDate", 64L);

		columnBitmasks.put("modifiedDate", 128L);

		columnBitmasks.put("customElementCSSURLs", 256L);

		columnBitmasks.put("customElementHTMLElementName", 512L);

		columnBitmasks.put("customElementURLs", 1024L);

		columnBitmasks.put("friendlyURLMapping", 2048L);

		columnBitmasks.put("iFrameURL", 4096L);

		columnBitmasks.put("instanceable", 8192L);

		columnBitmasks.put("name", 16384L);

		columnBitmasks.put("portletCategoryName", 32768L);

		columnBitmasks.put("properties", 65536L);

		columnBitmasks.put("type_", 131072L);

		_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
	}

	private long _columnBitmask;
	private RemoteAppEntry _escapedModel;

}