/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.remote.app.internal.search;

import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.search.BaseIndexer;
import com.liferay.portal.kernel.search.BooleanQuery;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.Summary;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.remote.app.model.RemoteAppEntry;
import com.liferay.remote.app.service.RemoteAppEntryLocalService;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={Indexer.class})
public class RemoteAppEntryIndexer
extends BaseIndexer<RemoteAppEntry> {
    public static final String CLASS_NAME = RemoteAppEntry.class.getName();
    private static final Log _log = LogFactoryUtil.getLog(RemoteAppEntryIndexer.class);
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    private Localization _localization;
    @Reference
    private RemoteAppEntryLocalService _remoteAppEntryLocalService;

    public String getClassName() {
        return CLASS_NAME;
    }

    public void postProcessSearchQuery(BooleanQuery searchQuery, BooleanFilter fullQueryBooleanFilter, SearchContext searchContext) throws Exception {
        this.addSearchTerm(searchQuery, searchContext, "entryClassPK", false);
        this.addSearchTerm(searchQuery, searchContext, "name", true);
        this.addSearchTerm(searchQuery, searchContext, "url", true);
    }

    protected void doDelete(RemoteAppEntry remoteAppEntry) throws Exception {
        this.deleteDocument(remoteAppEntry.getCompanyId(), remoteAppEntry.getRemoteAppEntryId());
    }

    protected Document doGetDocument(RemoteAppEntry remoteAppEntry) throws Exception {
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Indexing remote app entry " + remoteAppEntry));
        }
        Document document = this.getBaseModelDocument(CLASS_NAME, (BaseModel)remoteAppEntry);
        Localization localization = this.getLocalization();
        String[] nameAvailableLanguageIds = localization.getAvailableLanguageIds(remoteAppEntry.getName());
        String nameDefaultLanguageId = LocalizationUtil.getDefaultLanguageId((String)remoteAppEntry.getName());
        for (String nameAvailableLanguageId : nameAvailableLanguageIds) {
            String name = remoteAppEntry.getName(nameAvailableLanguageId);
            if (nameDefaultLanguageId.equals(nameAvailableLanguageId)) {
                document.addText("name", name);
            }
            document.addText(localization.getLocalizedName("name", nameAvailableLanguageId), name);
        }
        document.addText("url", remoteAppEntry.getUrl());
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Document " + remoteAppEntry + " indexed successfully"));
        }
        return document;
    }

    protected Summary doGetSummary(Document document, Locale locale, String snippet, PortletRequest portletRequest, PortletResponse portletResponse) {
        Summary summary = this.createSummary(document, "name", "url");
        summary.setMaxContentLength(200);
        return summary;
    }

    protected void doReindex(RemoteAppEntry remoteAppEntry) throws Exception {
        this._indexWriterHelper.updateDocument(this.getSearchEngineId(), remoteAppEntry.getCompanyId(), this.getDocument(remoteAppEntry), this.isCommitImmediately());
    }

    protected void doReindex(String className, long classPK) throws Exception {
        this.doReindex(this._remoteAppEntryLocalService.getRemoteAppEntry(classPK));
    }

    protected void doReindex(String[] ids) throws Exception {
        long companyId = GetterUtil.getLong((String)ids[0]);
        this.reindexRemoteAppEntries(companyId);
    }

    protected Localization getLocalization() {
        if (this._localization != null) {
            return this._localization;
        }
        return LocalizationUtil.getLocalization();
    }

    protected void reindexRemoteAppEntries(long companyId) throws PortalException {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = this._remoteAppEntryLocalService.getIndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setCompanyId(companyId);
        indexableActionableDynamicQuery.setPerformActionMethod(remoteAppEntry -> {
            block2: {
                try {
                    indexableActionableDynamicQuery.addDocuments(new Document[]{this.getDocument(remoteAppEntry)});
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block2;
                    _log.warn((Object)("Unable to index remote app entry " + remoteAppEntry.getRemoteAppEntryId()), (Throwable)portalException);
                }
            }
        });
        indexableActionableDynamicQuery.setSearchEngineId(this.getSearchEngineId());
        indexableActionableDynamicQuery.performActions();
    }
}

