/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.remote.app.model.impl;

import com.liferay.remote.app.model.RemoteAppEntry;
import com.liferay.remote.app.service.RemoteAppEntryLocalServiceUtil;

/**
 * The extended model base implementation for the RemoteAppEntry service. Represents a row in the &quot;RemoteAppEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link RemoteAppEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see RemoteAppEntryImpl
 * @see RemoteAppEntry
 * @generated
 */
public abstract class RemoteAppEntryBaseImpl
	extends RemoteAppEntryModelImpl implements RemoteAppEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a remote app entry model instance should use the <code>RemoteAppEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			RemoteAppEntryLocalServiceUtil.addRemoteAppEntry(this);
		}
		else {
			RemoteAppEntryLocalServiceUtil.updateRemoteAppEntry(this);
		}
	}

}