/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.internal.calculator;

import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.reading.time.calculator.ReadingTimeCalculator;
import com.liferay.reading.time.calculator.ReadingTimeModelInfo;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.select.Elements;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(immediate=true, service={ReadingTimeCalculator.class})
public class ReadingTimeCalculatorImpl
implements ReadingTimeCalculator {
    private static final List<String> _supportedContentTypes = Arrays.asList("text/html", "text/html; charset=UTF-8", "text", "text/plain", "text/plain; charset=UTF-8");
    private ServiceTrackerMap<String, ReadingTimeModelInfo<?>> _serviceTrackerMap;

    public Optional<Duration> calculate(GroupedModel groupedModel) {
        ReadingTimeModelInfo readingTimeModelInfo = (ReadingTimeModelInfo)this._serviceTrackerMap.getService((Object)groupedModel.getModelClassName());
        if (readingTimeModelInfo == null) {
            return Optional.empty();
        }
        return this.calculate(readingTimeModelInfo.getContent(groupedModel), readingTimeModelInfo.getContentType(groupedModel), readingTimeModelInfo.getLocale(groupedModel));
    }

    public Optional<Duration> calculate(String content, String contentType, Locale locale) {
        if (!_supportedContentTypes.contains(contentType)) {
            return Optional.empty();
        }
        if (Validator.isNull((String)content)) {
            return Optional.of(Duration.ZERO);
        }
        Document document = Jsoup.parseBodyFragment((String)content);
        String text = document.text();
        String[] words = text.split("(?:\\h|\\v)+");
        Duration readingTimeDuration = Duration.ofSeconds(Math.round((float)(60 * words.length) / 265.0f));
        Elements images = document.getElementsByTag("img");
        readingTimeDuration = readingTimeDuration.plus(Duration.ofSeconds(3 * images.size()));
        return Optional.of(readingTimeDuration);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ReadingTimeModelInfo.class, (String)"model.class.name");
    }

    @Deactivate
    protected void deactivate() {
        this._serviceTrackerMap.close();
    }
}

