/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.reading.time.service.impl;

import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.reading.time.calculator.ReadingTimeCalculator;
import com.liferay.reading.time.model.ReadingTimeEntry;
import com.liferay.reading.time.service.base.ReadingTimeEntryLocalServiceBaseImpl;
import java.time.Duration;
import java.util.Optional;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.reading.time.model.ReadingTimeEntry"}, service={AopService.class})
public class ReadingTimeEntryLocalServiceImpl
extends ReadingTimeEntryLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ReadingTimeCalculator _readingTimeCalculator;

    public ReadingTimeEntry addReadingTimeEntry(GroupedModel groupedModel, Duration readingTimeDuration) {
        return this.addReadingTimeEntry(groupedModel.getGroupId(), this._classNameLocalService.getClassNameId(groupedModel.getModelClass()), (Long)groupedModel.getPrimaryKeyObj(), readingTimeDuration);
    }

    public ReadingTimeEntry addReadingTimeEntry(long groupId, long classNameId, long classPK, Duration readingTimeDuration) {
        long entryId = this.counterLocalService.increment();
        ReadingTimeEntry entry = this.readingTimeEntryPersistence.create(entryId);
        entry.setGroupId(groupId);
        entry.setClassNameId(classNameId);
        entry.setClassPK(classPK);
        entry.setReadingTime(readingTimeDuration.toMillis());
        return (ReadingTimeEntry)this.readingTimeEntryPersistence.update((BaseModel)entry);
    }

    public ReadingTimeEntry deleteReadingTimeEntry(GroupedModel groupedModel) {
        ReadingTimeEntry readingTimeEntry = this.fetchReadingTimeEntry(groupedModel);
        if (readingTimeEntry != null) {
            return this.deleteReadingTimeEntry(readingTimeEntry);
        }
        return null;
    }

    public ReadingTimeEntry deleteReadingTimeEntry(long groupId, long classNameId, long classPK) {
        ReadingTimeEntry readingTimeEntry = this.fetchReadingTimeEntry(groupId, classNameId, classPK);
        if (readingTimeEntry != null) {
            return this.deleteReadingTimeEntry(readingTimeEntry);
        }
        return null;
    }

    public ReadingTimeEntry fetchOrAddReadingTimeEntry(GroupedModel groupedModel) {
        ReadingTimeEntry readingTimeEntry = this.fetchReadingTimeEntry(groupedModel);
        if (readingTimeEntry != null) {
            return readingTimeEntry;
        }
        return this.updateReadingTimeEntry(groupedModel);
    }

    public ReadingTimeEntry fetchReadingTimeEntry(GroupedModel groupedModel) {
        return this.fetchReadingTimeEntry(groupedModel.getGroupId(), this._classNameLocalService.getClassNameId(groupedModel.getModelClass()), (Long)groupedModel.getPrimaryKeyObj());
    }

    public ReadingTimeEntry fetchReadingTimeEntry(long groupId, long classNameId, long classPK) {
        return this.readingTimeEntryPersistence.fetchByG_C_C(groupId, classNameId, classPK);
    }

    public ReadingTimeEntry updateReadingTimeEntry(GroupedModel groupedModel) {
        Optional readingTimeOptional = this._readingTimeCalculator.calculate(groupedModel);
        if (readingTimeOptional.isPresent()) {
            return this.updateReadingTimeEntry(groupedModel.getGroupId(), this._classNameLocalService.getClassNameId(groupedModel.getModelClass()), (Long)groupedModel.getPrimaryKeyObj(), (Duration)readingTimeOptional.get());
        }
        return null;
    }

    public ReadingTimeEntry updateReadingTimeEntry(long groupId, long classNameId, long classPK, Duration readingTimeDuration) {
        ReadingTimeEntry readingTimeEntry = this.fetchReadingTimeEntry(groupId, classNameId, classPK);
        if (readingTimeEntry == null) {
            return this.addReadingTimeEntry(groupId, classNameId, classPK, readingTimeDuration);
        }
        readingTimeEntry.setReadingTime(readingTimeDuration.toMillis());
        return this.updateReadingTimeEntry(readingTimeEntry);
    }
}

