/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.push.notifications.model.impl;

import com.liferay.push.notifications.model.PushNotificationsDevice;
import com.liferay.push.notifications.service.PushNotificationsDeviceLocalServiceUtil;

/**
 * The extended model base implementation for the PushNotificationsDevice service. Represents a row in the &quot;PushNotificationsDevice&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link PushNotificationsDeviceImpl}.
 * </p>
 *
 * @author Bruno Farache
 * @see PushNotificationsDeviceImpl
 * @see PushNotificationsDevice
 * @generated
 */
public abstract class PushNotificationsDeviceBaseImpl
	extends PushNotificationsDeviceModelImpl
	implements PushNotificationsDevice {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a push notifications device model instance should use the <code>PushNotificationsDevice</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			PushNotificationsDeviceLocalServiceUtil.addPushNotificationsDevice(
				this);
		}
		else {
			PushNotificationsDeviceLocalServiceUtil.
				updatePushNotificationsDevice(this);
		}
	}

}