/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.push.notifications.internal.messaging;

import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.push.notifications.sender.Response;

/**
 * @author Bruno Farache
 */
public class PushNotificationsResponseMessageListener
	extends BaseMessageListener {

	public PushNotificationsResponseMessageListener(JSONFactory jsonFactory) {
		_jsonFactory = jsonFactory;
	}

	@Override
	protected void doReceive(Message message) throws Exception {
		Response response = (Response)message.getPayload();

		String json = _jsonFactory.serialize(response);

		if (!response.isSucceeded()) {
			_log.error(json);
		}
		else if (_log.isDebugEnabled()) {
			_log.debug(json);
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		PushNotificationsResponseMessageListener.class);

	private final JSONFactory _jsonFactory;

}