/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.push.notifications.internal.messaging;

import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.push.notifications.constants.PushNotificationsConstants;
import com.liferay.push.notifications.service.PushNotificationsDeviceLocalService;

/**
 * @author Silvio Santos
 * @author Bruno Farache
 */
public class PushNotificationsMessageListener extends BaseMessageListener {

	public PushNotificationsMessageListener(
		PushNotificationsDeviceLocalService
			pushNotificationsDeviceLocalService) {

		_pushNotificationsDeviceLocalService =
			pushNotificationsDeviceLocalService;
	}

	@Override
	protected void doReceive(Message message) throws Exception {
		JSONObject payloadJSONObject = (JSONObject)message.getPayload();

		JSONArray toUserIdsJSONArray = payloadJSONObject.getJSONArray(
			PushNotificationsConstants.KEY_TO_USER_IDS);

		long[] toUserIds = null;

		if (toUserIdsJSONArray != null) {
			toUserIds = new long[toUserIdsJSONArray.length()];

			for (int i = 0; i < toUserIdsJSONArray.length(); i++) {
				toUserIds[i] = toUserIdsJSONArray.getLong(i);
			}

			payloadJSONObject.remove(
				PushNotificationsConstants.KEY_TO_USER_IDS);
		}
		else {
			long userId = payloadJSONObject.getLong(
				PushNotificationsConstants.KEY_USER_ID);

			toUserIds = new long[] {userId};
		}

		try {
			_pushNotificationsDeviceLocalService.sendPushNotification(
				toUserIds, payloadJSONObject);
		}
		catch (Exception exception) {
			_log.error("Unable to send notification", exception);
		}
	}

	private static final Log _log = LogFactoryUtil.getLog(
		PushNotificationsMessageListener.class);

	private final PushNotificationsDeviceLocalService
		_pushNotificationsDeviceLocalService;

}