/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.microsoft.internal;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import java.util.Iterator;
import java.util.List;
import org.jboss.aerogear.windows.mpns.MPNS;
import org.jboss.aerogear.windows.mpns.MpnsNotification;
import org.jboss.aerogear.windows.mpns.MpnsNotificationBuilder;
import org.jboss.aerogear.windows.mpns.MpnsService;
import org.jboss.aerogear.windows.mpns.MpnsServiceBuilder;
import org.jboss.aerogear.windows.mpns.notifications.TileNotification;
import org.jboss.aerogear.windows.mpns.notifications.ToastNotification;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"platform=microsoft"}, service={PushNotificationsSender.class})
public class MicrosoftPushNotificationsSender
implements PushNotificationsSender {
    public static final String PLATFORM = "microsoft";
    @Reference
    private JSONFactory _jsonFactory;
    private volatile MpnsService _mpnsService;

    public void send(List<String> tokens, JSONObject payloadJSONObject) throws Exception {
        String from = "";
        if (payloadJSONObject.has("from")) {
            from = payloadJSONObject.getString("from");
        }
        String body = payloadJSONObject.getString("body");
        JSONObject newPayloadJSONObject = this._jsonFactory.createJSONObject();
        Iterator iterator = payloadJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            if (key.equals("from") || key.equals("body")) continue;
            newPayloadJSONObject.put(key, payloadJSONObject.get(key));
        }
        String attributes = this._getAttributes(newPayloadJSONObject);
        TileNotification tileNotification = this._buildTileNotification(from, body, attributes);
        ToastNotification toastNotification = this._buildToastNotification(from, body, attributes);
        for (String token : tokens) {
            this._mpnsService.push(token, (MpnsNotification)tileNotification);
            this._mpnsService.push(token, (MpnsNotification)toastNotification);
        }
    }

    @Activate
    protected void activate() {
        MpnsServiceBuilder mpnsServiceBuilder = MPNS.newService();
        this._mpnsService = mpnsServiceBuilder.build();
    }

    @Deactivate
    protected void deactivate() {
        this._mpnsService = null;
    }

    private TileNotification _buildTileNotification(String from, String body, String attributes) {
        MpnsNotificationBuilder mpnsNotificationBuilder = MPNS.newNotification();
        TileNotification.Builder builder = mpnsNotificationBuilder.tile();
        builder.backContent(body);
        builder.backTitle(from);
        builder.callbackUri(attributes);
        builder.count(1);
        builder.title(from);
        return builder.build();
    }

    private ToastNotification _buildToastNotification(String from, String body, String attributes) {
        MpnsNotificationBuilder mpnsNotificationBuilder = MPNS.newNotification();
        ToastNotification.Builder builder = mpnsNotificationBuilder.toast();
        builder.parameter(attributes);
        builder.subtitle(body);
        builder.title(from);
        return builder.build();
    }

    private String _getAttributes(JSONObject payloadJSONObject) {
        StringBundler sb = new StringBundler();
        Iterator iterator = payloadJSONObject.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            sb.append(key);
            sb.append('=');
            sb.append(payloadJSONObject.getString(key));
        }
        return sb.toString();
    }
}

