/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.firebase.internal;

import com.google.auth.oauth2.GoogleCredentials;
import com.google.auth.oauth2.ServiceAccountCredentials;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.push.notifications.exception.PushNotificationsException;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.sender.firebase.internal.configuration.FirebasePushNotificationsSenderConfiguration;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.push.notifications.sender.firebase.internal.configuration.FirebasePushNotificationsSenderConfiguration"}, immediate=true, property={"platform=firebase"}, service={PushNotificationsSender.class})
public class FirebasePushNotificationsSender
implements PushNotificationsSender {
    private static final int _OK_CODE = 200;
    private static final Log _log = LogFactoryUtil.getLog(FirebasePushNotificationsSender.class);
    private static final Set<String> _keys = SetUtil.fromArray((Object[])new String[]{"badge", "body", "bodyLocalizedKey", "bodyLocalizedArguments", "sound", "silent"});
    private String _firebaseCloudMessagingURL;
    private volatile FirebasePushNotificationsSenderConfiguration _firebasePushNotificationsSenderConfiguration;
    private volatile GoogleCredentials _googleCredentials;
    @Reference
    private Http _http;
    @Reference
    private JSONFactoryUtil _jsonFactoryUtil;
    private String _projectNumber;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(List<String> tokens, JSONObject payloadJSONObject) throws Exception {
        if (this._googleCredentials == null) {
            throw new PushNotificationsException("Firebase push notifications sender is not configured properly");
        }
        String accessToken = this._getAccessToken();
        if (tokens.size() > 1) {
            DeviceGroup deviceGroup = this._createDeviceGroup(accessToken, tokens);
            try {
                this._send(accessToken, payloadJSONObject, deviceGroup.getId());
            }
            finally {
                this._removeDeviceGroup(accessToken, deviceGroup, tokens);
            }
        } else {
            this._send(accessToken, payloadJSONObject, tokens.get(0));
        }
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) throws PortalException {
        this._firebasePushNotificationsSenderConfiguration = (FirebasePushNotificationsSenderConfiguration)ConfigurableUtil.createConfigurable(FirebasePushNotificationsSenderConfiguration.class, properties);
        if (Validator.isNull((String)this._firebasePushNotificationsSenderConfiguration.firebaseCloudMessagingURL()) || Validator.isNull((String)this._firebasePushNotificationsSenderConfiguration.projectNumber())) {
            this._googleCredentials = null;
            return;
        }
        this._initGoogleCloudServices();
    }

    @Deactivate
    protected void deactivate() {
        this._googleCredentials = null;
    }

    private JSONObject _buildAndroidData(JSONObject payloadJSONObject) {
        return JSONUtil.put((String)"notification", (Object)JSONUtil.put((String)"body", () -> payloadJSONObject.get("body")).put("body_loc_args", () -> {
            JSONArray bodyLocalizedArgumentsJSONArray = payloadJSONObject.getJSONArray("bodyLocalizedArguments");
            if (bodyLocalizedArgumentsJSONArray == null) {
                return null;
            }
            ArrayList<String> bodyLocalizedArguments = new ArrayList<String>();
            for (int i = 0; i < bodyLocalizedArgumentsJSONArray.length(); ++i) {
                bodyLocalizedArguments.add(bodyLocalizedArgumentsJSONArray.getString(i));
            }
            return bodyLocalizedArguments;
        }).put("body_loc_key", () -> payloadJSONObject.get("bodyLocalizedKey")).put("notification_count", () -> {
            if (payloadJSONObject.has("badge")) {
                return payloadJSONObject.getInt("badge");
            }
            return null;
        }).put("sound", () -> payloadJSONObject.get("sound")).put("title", () -> payloadJSONObject.get("title")).put("title_loc_args", () -> {
            JSONArray titleLocalizedArgumentsJSONArray = payloadJSONObject.getJSONArray("titleLocalizedArguments");
            if (titleLocalizedArgumentsJSONArray == null) {
                return null;
            }
            ArrayList<String> localizedArguments = new ArrayList<String>();
            for (int i = 0; i < titleLocalizedArgumentsJSONArray.length(); ++i) {
                localizedArguments.add(titleLocalizedArgumentsJSONArray.getString(i));
            }
            return localizedArguments;
        }).put("title_loc_key", () -> payloadJSONObject.get("titleLocalizedKey")));
    }

    private JSONObject _buildMessagePayload(JSONObject payloadJSONObject) {
        Iterator keysIterator = payloadJSONObject.keys();
        FirebasePushNotificationsSender firebasePushNotificationsSender = this;
        JSONObject jsonObject = firebasePushNotificationsSender._jsonFactoryUtil.createJSONObject();
        while (keysIterator.hasNext()) {
            String key = (String)keysIterator.next();
            if (_keys.contains(key)) continue;
            jsonObject.put(key, payloadJSONObject.get(key));
        }
        return JSONUtil.put((String)"payload", (Object)jsonObject.toString());
    }

    private DeviceGroup _createDeviceGroup(String authorizationToken, List<String> tokens) throws Exception {
        Http.Options options = new Http.Options();
        options.addHeader("access_token_auth", "true");
        options.addHeader("project_id", this._projectNumber);
        options.addHeader("Authorization", "Bearer " + authorizationToken);
        options.addHeader("Content-Type", "application/json");
        String name = StringUtil.randomString();
        options.setBody(JSONUtil.put((String)"notification_key_name", (Object)name).put("operation", "create").put("registration_ids", tokens).toString(), "application/json", "UTF-8");
        options.setLocation(this._firebaseCloudMessagingURL + "/fcm/notification");
        options.setPost(true);
        String responseString = this._http.URLtoString(options);
        Http.Response optionsResponse = options.getResponse();
        if (optionsResponse.getResponseCode() != 200) {
            throw new PushNotificationsException("Unable to create notification group");
        }
        JSONObject responseJSONObject = JSONFactoryUtil.createJSONObject((String)responseString);
        return new DeviceGroup(responseJSONObject.getString("notification_key"), name);
    }

    private String _getAccessToken() throws Exception {
        try {
            this._googleCredentials.refresh();
            return this._googleCredentials.getAccessToken().getTokenValue();
        }
        catch (Exception exception) {
            throw new PushNotificationsException("Unable to get access token", (Throwable)exception);
        }
    }

    private void _initGoogleCloudServices() throws PortalException {
        this._firebaseCloudMessagingURL = this._firebasePushNotificationsSenderConfiguration.firebaseCloudMessagingURL();
        this._projectNumber = this._firebasePushNotificationsSenderConfiguration.projectNumber();
        String serviceAccountKey = this._firebasePushNotificationsSenderConfiguration.serviceAccountKey();
        try {
            if (Validator.isBlank((String)serviceAccountKey)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)"Using application default credentials because service account key was not set");
                }
                this._googleCredentials = ServiceAccountCredentials.getApplicationDefault();
            } else {
                this._googleCredentials = ServiceAccountCredentials.fromStream((InputStream)new ByteArrayInputStream(serviceAccountKey.getBytes())).createScoped(Arrays.asList("https://www.googleapis.com/auth/firebase.messaging"));
            }
        }
        catch (IOException ioException) {
            throw new PortalException("Unable to authenticate with Firebase", (Throwable)ioException);
        }
    }

    private void _removeDeviceGroup(String authorizationToken, DeviceGroup deviceGroup, List<String> tokens) throws Exception {
        Http.Options options = new Http.Options();
        options.addHeader("access_token_auth", "true");
        options.addHeader("project_id", this._projectNumber);
        options.addHeader("Authorization", "Bearer " + authorizationToken);
        options.addHeader("Content-Type", "application/json");
        options.setBody(JSONUtil.put((String)"notification_key", (Object)deviceGroup.getId()).put("notification_key_name", deviceGroup.getName()).put("operation", "remove").put("registration_ids", tokens).toString(), "application/json", "UTF-8");
        options.setLocation(this._firebaseCloudMessagingURL + "/fcm/notification");
        options.setPost(true);
        this._http.URLtoString(options);
        Http.Response optionsResponse = options.getResponse();
        if (optionsResponse.getResponseCode() != 200) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to remove notification group with ID ", deviceGroup.getId(), " and name ", deviceGroup.getName()}));
        }
    }

    private void _send(String accessToken, JSONObject payloadJSONObject, String token) throws Exception {
        Http.Options options = new Http.Options();
        options.addHeader("Authorization", "Bearer " + accessToken);
        options.addHeader("Content-Type", "application/json");
        options.setBody(JSONUtil.put((String)"message", (Object)JSONUtil.put((String)"android", (Object)this._buildAndroidData(payloadJSONObject)).put("data", this._buildMessagePayload(payloadJSONObject)).put("token", token)).toString(), "application/json", "UTF-8");
        ServiceAccountCredentials serviceAccountCredentials = (ServiceAccountCredentials)this._googleCredentials;
        options.setLocation(StringBundler.concat((String[])new String[]{this._firebaseCloudMessagingURL, "/v1/projects/", serviceAccountCredentials.getProjectId(), "/messages:send"}));
        options.setPost(true);
        String responseString = this._http.URLtoString(options);
        Http.Response response = options.getResponse();
        if (response.getResponseCode() != 200) {
            _log.error((Object)StringBundler.concat((String[])new String[]{"Unable to send notification with token ", token, " and reason ", responseString}));
            throw new PushNotificationsException("Unable to send push notification");
        }
    }

    private class DeviceGroup {
        private final String _id;
        private final String _name;

        public DeviceGroup(String id, String name) {
            this._id = id;
            this._name = name;
        }

        public String getId() {
            return this._id;
        }

        public String getName() {
            return this._name;
        }
    }
}

