/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.push.notifications.sender.firebase.internal;

import com.liferay.mobile.fcm.Message;
import com.liferay.mobile.fcm.Notification;
import com.liferay.mobile.fcm.Sender;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.json.JSONArray;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.push.notifications.exception.PushNotificationsException;
import com.liferay.push.notifications.sender.PushNotificationsSender;
import com.liferay.push.notifications.sender.firebase.internal.configuration.FirebasePushNotificationsSenderConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.push.notifications.sender.firebase.internal.configuration.FirebasePushNotificationsSenderConfiguration"}, immediate=true, property={"platform=firebase"})
public class FirebasePushNotificationsSender
implements PushNotificationsSender {
    public static final String PLATFORM = "firebase";
    private static final Log _log = LogFactoryUtil.getLog(FirebasePushNotificationsSender.class);
    private volatile FirebasePushNotificationsSenderConfiguration _firebasePushNotificationsSenderConfiguration;
    private volatile Sender _sender;

    public void send(List<String> tokens, JSONObject payloadJSONObject) throws Exception {
        if (this._sender == null) {
            throw new PushNotificationsException("Firebase push notifications sender is not configured properly");
        }
        this._sender.send(this.buildMessage(tokens, payloadJSONObject));
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._firebasePushNotificationsSenderConfiguration = (FirebasePushNotificationsSenderConfiguration)ConfigurableUtil.createConfigurable(FirebasePushNotificationsSenderConfiguration.class, properties);
        String apiKey = this._firebasePushNotificationsSenderConfiguration.apiKey();
        if (Validator.isNull((String)apiKey)) {
            this._sender = null;
            return;
        }
        this._sender = new Sender(apiKey);
    }

    protected Message buildMessage(List<String> tokens, JSONObject payloadJSONObject) {
        Message.Builder builder = new Message.Builder();
        boolean silent = payloadJSONObject.getBoolean("silent");
        if (silent) {
            builder.contentAvailable(silent);
        }
        builder.notification(this.buildNotification(payloadJSONObject));
        builder.to(tokens);
        payloadJSONObject.remove("silent");
        if (payloadJSONObject.length() > 0) {
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("payload", payloadJSONObject.toString());
            builder.data(data);
        }
        return builder.build();
    }

    protected Notification buildNotification(JSONObject payloadJSONObject) {
        String sound;
        JSONArray bodyLocalizedArgumentsJSONArray;
        String bodyLocalizedKey;
        String body;
        Notification.Builder builder = new Notification.Builder();
        if (payloadJSONObject.has("badge")) {
            builder.badge(payloadJSONObject.getInt("badge"));
        }
        if (Validator.isNotNull((String)(body = payloadJSONObject.getString("body")))) {
            builder.body(body);
        }
        if (Validator.isNotNull((String)(bodyLocalizedKey = payloadJSONObject.getString("bodyLocalizedKey")))) {
            builder.bodyLocalizationKey(bodyLocalizedKey);
        }
        if ((bodyLocalizedArgumentsJSONArray = payloadJSONObject.getJSONArray("bodyLocalizedArguments")) != null) {
            ArrayList<String> bodyLocalizedArguments = new ArrayList<String>();
            for (int i = 0; i < bodyLocalizedArgumentsJSONArray.length(); ++i) {
                bodyLocalizedArguments.add(bodyLocalizedArgumentsJSONArray.getString(i));
            }
            builder.bodyLocalizationArguments(bodyLocalizedArguments);
        }
        if (Validator.isNotNull((String)(sound = payloadJSONObject.getString("sound")))) {
            builder.sound(sound);
        }
        payloadJSONObject.remove("badge");
        payloadJSONObject.remove("body");
        payloadJSONObject.remove("bodyLocalizedKey");
        payloadJSONObject.remove("bodyLocalizedArguments");
        payloadJSONObject.remove("sound");
        return builder.build();
    }

    @Deactivate
    protected void deactivate() {
        this._sender = null;
    }
}

