/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.push.notifications.sender.android.internal.configuration;

import aQute.bnd.annotation.metatype.Meta;

import com.liferay.portal.configuration.metatype.annotations.ExtendedObjectClassDefinition;

/**
 * @author Andrea Di Giorgi
 */
@ExtendedObjectClassDefinition(category = "other")
@Meta.OCD(
	id = "com.liferay.push.notifications.sender.android.internal.configuration.AndroidPushNotificationsSenderConfiguration",
	localization = "content/Language",
	name = "android-push-notifications-sender-configuration-name"
)
public interface AndroidPushNotificationsSenderConfiguration {

	@Meta.AD(
		description = "android-api-key-description",
		name = "android-api-key-name", required = false
	)
	public String apiKey();

	@Meta.AD(
		description = "retries-description", name = "retries-name",
		required = false
	)
	public int retries();

}