/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.push.notifications.sender.android.internal;

import com.google.android.gcm.server.Result;

import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.push.notifications.sender.BaseResponse;

/**
 * @author Bruno Farache
 */
public class AndroidResponse extends BaseResponse {

	public AndroidResponse(
		Result result, String token, JSONObject payloadJSONObject) {

		super(AndroidPushNotificationsSender.PLATFORM);

		this.token = token;

		canonicalRegistrationId = result.getCanonicalRegistrationId();
		id = result.getMessageId();
		payload = payloadJSONObject.toString();
		status = result.getErrorCodeName();

		if (Validator.isNull(status)) {
			succeeded = true;
		}
	}

	public String getCanonicalRegistrationId() {
		return canonicalRegistrationId;
	}

	protected String canonicalRegistrationId;

}