/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.internal;

import com.liferay.project.templates.extensions.util.FileUtil;
import com.liferay.project.templates.extensions.util.ProjectTemplatesUtil;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import org.apache.maven.archetype.common.DefaultArchetypeArtifactManager;
import org.apache.maven.archetype.exception.UnknownArchetype;
import org.apache.maven.artifact.repository.ArtifactRepository;

public class ArchetyperArchetypeArtifactManager
extends DefaultArchetypeArtifactManager {
    private final List<File> _archetypesFiles;

    public ArchetyperArchetypeArtifactManager(List<File> archetypesFiles) {
        this._archetypesFiles = archetypesFiles;
    }

    @Override
    public boolean exists(String archetypeGroupId, String archetypeArtifactId, String archetypeVersion, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> remoteRepositories) {
        return true;
    }

    @Override
    public File getArchetypeFile(String groupId, String artifactId, String version, ArtifactRepository archetypeRepository, ArtifactRepository localRepository, List<ArtifactRepository> repositories) throws UnknownArchetype {
        File archetypeFile = null;
        for (File archetypesFile : this._archetypesFiles) {
            try {
                if (archetypesFile.isDirectory()) {
                    for (File file : archetypesFile.listFiles()) {
                        try {
                            String bundleVersion = FileUtil.getManifestProperty(file, "Bundle-Version");
                            String bundleSymbolicName = FileUtil.getManifestProperty(file, "Bundle-SymbolicName");
                            if (!bundleVersion.equals(version) || !bundleSymbolicName.equals(artifactId)) continue;
                            archetypeFile = file;
                            break;
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                if (archetypeFile == null) continue;
                break;
            }
            catch (Exception exception) {
            }
        }
        if (archetypeFile == null) {
            try {
                archetypeFile = ProjectTemplatesUtil.getArchetypeFile(artifactId);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (archetypeFile == null) {
            throw new UnknownArchetype();
        }
        return archetypeFile;
    }

    @Override
    public ClassLoader getArchetypeJarLoader(File archetypeFile) throws UnknownArchetype {
        try {
            URI uri = archetypeFile.toURI();
            return new URLClassLoader(new URL[]{uri.toURL()}, null);
        }
        catch (MalformedURLException malformedURLException) {
            throw new UnknownArchetype(malformedURLException);
        }
    }
}

