/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.extensions.util;

import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import com.liferay.project.templates.extensions.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ProjectTemplatesUtil {
    private static final Map<String, File> _archetypeFiles = new HashMap<String, File>();

    public static File getArchetypeFile(String artifactId) throws IOException {
        if (_archetypeFiles.containsKey(artifactId)) {
            return _archetypeFiles.get(artifactId);
        }
        Properties projectTemplateJarVersionsProperties = ProjectTemplatesUtil.getProjectTemplateJarVersionsProperties();
        if (!projectTemplateJarVersionsProperties.containsKey(artifactId)) {
            return null;
        }
        String version = String.valueOf(projectTemplateJarVersionsProperties.get(artifactId));
        try {
            String jarName = ProjectTemplatesUtil.getArchetypeJarName(artifactId, version);
            InputStream inputStream = ProjectTemplatesUtil.class.getResourceAsStream(jarName);
            Path archetypePath = Files.createTempFile("temp-archetype", null, new FileAttribute[0]);
            Files.copy(inputStream, archetypePath, StandardCopyOption.REPLACE_EXISTING);
            File archetypeFile = archetypePath.toFile();
            _archetypeFiles.put(artifactId, archetypeFile);
            archetypeFile.deleteOnExit();
            return archetypeFile;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static File getArchetypeFile(String artifactId, File file) throws IOException {
        File archetypeFile = ProjectTemplatesUtil.getArchetypeFile(artifactId);
        if (archetypeFile != null) {
            return archetypeFile;
        }
        try (JarFile jarFile = new JarFile(file);){
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                String name;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || !(name = jarEntry.getName()).startsWith(artifactId + "-")) continue;
                Path archetypePath = Files.createTempFile("temp-archetype", null, new FileAttribute[0]);
                Files.copy(jarFile.getInputStream(jarEntry), archetypePath, StandardCopyOption.REPLACE_EXISTING);
                archetypeFile = archetypePath.toFile();
                _archetypeFiles.put(artifactId, archetypeFile);
                archetypeFile.deleteOnExit();
            }
        }
        return archetypeFile;
    }

    public static String getArchetypeJarName(String artifactId, String version) {
        return "/" + artifactId + "-" + version + ".jar";
    }

    public static List<String> getArchetypeJarNames() throws IOException {
        ArrayList<String> archetypeJarNames = new ArrayList<String>();
        Properties projectTemplateJarVersionsProperties = ProjectTemplatesUtil.getProjectTemplateJarVersionsProperties();
        Set<String> artifactIds = projectTemplateJarVersionsProperties.stringPropertyNames();
        for (String artifactId : artifactIds) {
            String version = projectTemplateJarVersionsProperties.getProperty(artifactId);
            String jarName = ProjectTemplatesUtil.getArchetypeJarName(artifactId, version);
            archetypeJarNames.add(jarName);
        }
        return archetypeJarNames;
    }

    public static String getArchetypeVersion(String artifactId) throws IOException {
        Properties projectTemplateJarVersionsProperties = ProjectTemplatesUtil.getProjectTemplateJarVersionsProperties();
        return projectTemplateJarVersionsProperties.getProperty(artifactId);
    }

    public static Properties getProjectTemplateJarVersionsProperties() throws IOException {
        Properties projectTemplateJarVersionsProperties = new Properties();
        try (InputStream inputStream = ProjectTemplatesUtil.class.getResourceAsStream("/project-template-jar-versions.properties");){
            projectTemplateJarVersionsProperties.load(inputStream);
        }
        return projectTemplateJarVersionsProperties;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getTemplateFile(ProjectTemplatesArgs projectTemplatesArgs) throws Exception {
        template = projectTemplatesArgs.getTemplate();
        templateVersion = projectTemplatesArgs.getTemplateVersion();
        var3_3 = projectTemplatesArgs.getArchetypesDirs().iterator();
        while (true) {
            block13: {
                block12: {
                    if (!var3_3.hasNext()) {
                        artifactId = "com.liferay.project.templates." + template.replace('-', '.');
                        return ProjectTemplatesUtil.getArchetypeFile(artifactId);
                    }
                    archetypesDir = var3_3.next();
                    if (!archetypesDir.isDirectory()) continue;
                    archetypesDirPath = archetypesDir.toPath();
                    directoryStream = Files.newDirectoryStream(archetypesDirPath, "*.project.templates.*");
                    try lbl-1000:
                    // 4 sources

                    {
                        for (Path path : directoryStream) {
                            try {
                                bundleSymbolicName = FileUtil.getManifestProperty(path.toFile(), "Bundle-SymbolicName");
                                templateName = ProjectTemplatesUtil.getTemplateName(bundleSymbolicName);
                                if (!templateName.equals(template)) continue;
                                templateFile = path.toFile();
                                if (templateVersion == null) {
                                    var12_15 = templateFile;
                                    if (directoryStream == null) return var12_15;
                                    break block12;
                                }
                                ** GOTO lbl-1000
                            }
                            catch (IOException var9_12) {
                            }
                        }
                        break block13;
                    }
                    catch (Throwable var7_8) {
                        if (directoryStream == null) throw var7_8;
                        try {
                            directoryStream.close();
                            throw var7_8;
                        }
                        catch (Throwable var8_10) {
                            var7_8.addSuppressed(var8_10);
                        }
                        throw var7_8;
                    }
                }
                directoryStream.close();
                return var12_15;
lbl-1000:
                // 1 sources

                {
                    bundleVersion = FileUtil.getManifestProperty(templateFile, "Bundle-Version");
                    if (!templateVersion.equals(bundleVersion)) ** GOTO lbl-1000
                    var13_16 = templateFile;
                    if (directoryStream == null) return var13_16;
                }
                directoryStream.close();
                return var13_16;
            }
            if (directoryStream == null) continue;
            directoryStream.close();
        }
    }

    public static String getTemplateName(String name) {
        String projectTemplatesString = "project.templates.";
        try {
            if (!name.contains(projectTemplatesString)) {
                return name;
            }
            int projectTemplatesEndIndex = name.indexOf(projectTemplatesString) + projectTemplatesString.length();
            int dashIndex = name.indexOf("-");
            if (dashIndex < 0) {
                dashIndex = name.length();
            }
            String templateName = name.substring(projectTemplatesEndIndex, dashIndex);
            return templateName.replace('.', '-');
        }
        catch (Throwable throwable) {
            return name;
        }
    }
}

