/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.project.templates.internal.util;

import java.lang.reflect.Field;

/**
 * @author Gregory Amerson
 */
public class ReflectionUtil {

	public static Field getField(Class<?> clazz, String name) throws Exception {
		Field field = clazz.getDeclaredField(name);

		field.setAccessible(true);

		return field;
	}

	public static void setFieldValue(
			Class<?> clazz, String name, Object object, Object value)
		throws Exception {

		Field field = getField(clazz, name);

		field.set(object, value);
	}

	public static void setFieldValue(Field field, Object object, Object value)
		throws Exception {

		field.set(object, value);
	}

}