/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.war.mvc.portlet.internal;

import com.liferay.project.templates.extensions.ProjectTemplateCustomizer;
import com.liferay.project.templates.extensions.ProjectTemplatesArgs;
import com.liferay.project.templates.extensions.util.FileUtil;
import com.liferay.project.templates.extensions.util.VersionUtil;
import java.io.File;
import java.nio.file.Path;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;

public class WarMVCPortletProjectTemplateCustomizer
implements ProjectTemplateCustomizer {
    public String getTemplateName() {
        return "war-mvc-portlet";
    }

    public void onAfterGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, File destinationDir, ArchetypeGenerationResult archetypeGenerationResult) throws Exception {
        Path destinationDirPath = destinationDir.toPath();
        Path projectPath = destinationDirPath.resolve(projectTemplatesArgs.getName());
        File buildDir = projectPath.toFile();
        File webINFDir = new File(buildDir, "src/main/webapp/WEB-INF");
        String liferayVersion = projectTemplatesArgs.getLiferayVersion();
        String minorVersionString = String.valueOf(VersionUtil.getMinorVersion((String)liferayVersion));
        if (VersionUtil.isLiferayQuarterlyVersion((String)liferayVersion)) {
            minorVersionString = "4";
        }
        File liferayDisplayXMLFile = new File(webINFDir, "liferay-display.xml");
        File liferayPortletXMLFile = new File(webINFDir, "liferay-portlet.xml");
        FileUtil.replaceString((File)liferayDisplayXMLFile, (String)"7.0", (String)("7." + minorVersionString));
        FileUtil.replaceString((File)liferayDisplayXMLFile, (String)"7_0", (String)("7_" + minorVersionString));
        FileUtil.replaceString((File)liferayPortletXMLFile, (String)"7.0", (String)("7." + minorVersionString));
        FileUtil.replaceString((File)liferayPortletXMLFile, (String)"7_0", (String)("7_" + minorVersionString));
    }

    public void onBeforeGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, ArchetypeGenerationRequest archetypeGenerationRequest) throws Exception {
    }
}

