/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.project.templates.theme.contributor.internal;

import com.beust.jcommander.Parameter;

import com.liferay.project.templates.extensions.ProjectTemplatesArgsExt;

/**
 * @author Gregory Amerson
 */
public class ThemeContributorProjectTemplatesArgs
	implements ProjectTemplatesArgsExt {

	public String getContributorType() {
		return _contributorType;
	}

	@Override
	public String getTemplateName() {
		return "theme-contributor";
	}

	public void setContributorType(String contributorType) {
		_contributorType = contributorType;
	}

	@Parameter(
		description = "Used to identify your module as a Theme Contributor. Also, used to add the Liferay-Theme-Contributor-Type and Web-ContextPath bundle headers.",
		names = "--contributor-type", required = true
	)
	private String _contributorType;

}