/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.project.templates.service.wrapper.internal;

import com.beust.jcommander.Parameter;

import com.liferay.project.templates.extensions.ProjectTemplatesArgsExt;

/**
 * @author Gregory Amerson
 */
public class ServiceWrapperProjectTemplatesArgs
	implements ProjectTemplatesArgsExt {

	public String getService() {
		return _service;
	}

	@Override
	public String getTemplateName() {
		return "service-wrapper";
	}

	public void setService(String service) {
		_service = service;
	}

	@Parameter(
		description = "Provide the name of the service to be implemented.",
		names = "--service", required = true
	)
	private String _service;

}