/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.project.templates.service.builder.internal;

import com.liferay.project.templates.ProjectTemplateCustomizer;
import com.liferay.project.templates.ProjectTemplatesArgs;
import com.liferay.project.templates.WorkspaceUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.Properties;
import org.apache.maven.archetype.ArchetypeGenerationRequest;
import org.apache.maven.archetype.ArchetypeGenerationResult;

public class ServiceBuilderProjectTemplateCustomizer
implements ProjectTemplateCustomizer {
    public void onAfterGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, File destinationDir, ArchetypeGenerationResult archetypeGenerationResult) throws Exception {
    }

    public void onBeforeGenerateProject(ProjectTemplatesArgs projectTemplatesArgs, ArchetypeGenerationRequest archetypeGenerationRequest) throws Exception {
        String artifactId = archetypeGenerationRequest.getArtifactId();
        String apiPath = ":" + artifactId + "-api";
        File destinationDir = new File(archetypeGenerationRequest.getOutputDirectory());
        File workspaceDir = WorkspaceUtil.getWorkspaceDir((File)destinationDir);
        if (workspaceDir != null) {
            Path destinationDirPath = destinationDir.toPath();
            Path workspaceDirPath = workspaceDir.toPath();
            destinationDirPath = destinationDirPath.toAbsolutePath();
            workspaceDirPath = workspaceDirPath.toAbsolutePath();
            String relativePath = String.valueOf(workspaceDirPath.relativize(destinationDirPath));
            relativePath = relativePath.replace(File.separatorChar, ':');
            apiPath = ":" + relativePath + ":" + artifactId + apiPath;
        }
        Properties properties = archetypeGenerationRequest.getProperties();
        properties.put("apiPath", apiPath);
    }
}

