/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.project.templates.service.builder.internal;

import com.beust.jcommander.Parameter;

import com.liferay.project.templates.extensions.ProjectTemplatesArgsExt;

/**
 * @author Gregory Amerson
 */
public class ServiceBuilderProjectTemplatesArgs
	implements ProjectTemplatesArgsExt {

	public String getAddOns() {
		return _addOns;
	}

	public String getDependencyInjector() {
		return _dependencyInjector;
	}

	@Override
	public String getTemplateName() {
		return "service-builder";
	}

	public void setAddOns(String addOns) {
		_addOns = addOns;
	}

	public void setDependencyInjector(String dependencyInjector) {
		_dependencyInjector = dependencyInjector;
	}

	@Parameter(
		description = "Set to true for add on options.", names = "--add-ons"
	)
	private String _addOns = "false";

	@Parameter(
		description = "Specify the preferred dependency injection method. (ds|spring)",
		names = "--dependency-injector"
	)
	private String _dependencyInjector = "ds";

}