/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.messageboards.service.impl;

import com.liferay.message.boards.kernel.exception.MailingListEmailAddressException;
import com.liferay.message.boards.kernel.exception.MailingListInServerNameException;
import com.liferay.message.boards.kernel.exception.MailingListInUserNameException;
import com.liferay.message.boards.kernel.exception.MailingListOutEmailAddressException;
import com.liferay.message.boards.kernel.exception.MailingListOutServerNameException;
import com.liferay.message.boards.kernel.exception.MailingListOutUserNameException;
import com.liferay.message.boards.kernel.model.MBMailingList;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelperUtil;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactoryUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.CalendarFactoryUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.messageboards.messaging.MailingListRequest;
import com.liferay.portlet.messageboards.service.base.MBMailingListLocalServiceBaseImpl;
import java.util.Calendar;
import java.util.Date;

public class MBMailingListLocalServiceImpl
extends MBMailingListLocalServiceBaseImpl {
    public MBMailingList addMailingList(long userId, long groupId, long categoryId, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean active, ServiceContext serviceContext) throws PortalException {
        User user = this.userPersistence.findByPrimaryKey(userId);
        this.validate(emailAddress, inServerName, inUserName, outEmailAddress, outCustom, outServerName, outUserName, active);
        long mailingListId = this.counterLocalService.increment();
        MBMailingList mailingList = this.mbMailingListPersistence.create(mailingListId);
        mailingList.setUuid(serviceContext.getUuid());
        mailingList.setGroupId(groupId);
        mailingList.setCompanyId(user.getCompanyId());
        mailingList.setUserId(user.getUserId());
        mailingList.setUserName(user.getFullName());
        mailingList.setCategoryId(categoryId);
        mailingList.setEmailAddress(emailAddress);
        mailingList.setInProtocol(inUseSSL ? inProtocol + "s" : inProtocol);
        mailingList.setInServerName(inServerName);
        mailingList.setInServerPort(inServerPort);
        mailingList.setInUseSSL(inUseSSL);
        mailingList.setInUserName(inUserName);
        mailingList.setInPassword(inPassword);
        mailingList.setInReadInterval(inReadInterval);
        mailingList.setOutEmailAddress(outEmailAddress);
        mailingList.setOutCustom(outCustom);
        mailingList.setOutServerName(outServerName);
        mailingList.setOutServerPort(outServerPort);
        mailingList.setOutUseSSL(outUseSSL);
        mailingList.setOutUserName(outUserName);
        mailingList.setOutPassword(outPassword);
        mailingList.setAllowAnonymous(allowAnonymous);
        mailingList.setActive(active);
        this.mbMailingListPersistence.update((BaseModel)mailingList);
        if (active) {
            this.scheduleMailingList(mailingList);
        }
        return mailingList;
    }

    public void deleteCategoryMailingList(long groupId, long categoryId) throws PortalException {
        MBMailingList mailingList = this.mbMailingListPersistence.findByG_C(groupId, categoryId);
        this.deleteMailingList(mailingList);
    }

    public void deleteMailingList(long mailingListId) throws PortalException {
        MBMailingList mailingList = this.mbMailingListPersistence.findByPrimaryKey(mailingListId);
        this.deleteMailingList(mailingList);
    }

    public void deleteMailingList(MBMailingList mailingList) throws PortalException {
        this.unscheduleMailingList(mailingList);
        this.mbMailingListPersistence.remove((BaseModel)mailingList);
    }

    public MBMailingList fetchCategoryMailingList(long groupId, long categoryId) {
        return this.mbMailingListPersistence.fetchByG_C(groupId, categoryId);
    }

    public MBMailingList getCategoryMailingList(long groupId, long categoryId) throws PortalException {
        return this.mbMailingListPersistence.findByG_C(groupId, categoryId);
    }

    public MBMailingList updateMailingList(long mailingListId, String emailAddress, String inProtocol, String inServerName, int inServerPort, boolean inUseSSL, String inUserName, String inPassword, int inReadInterval, String outEmailAddress, boolean outCustom, String outServerName, int outServerPort, boolean outUseSSL, String outUserName, String outPassword, boolean allowAnonymous, boolean active, ServiceContext serviceContext) throws PortalException {
        this.validate(emailAddress, inServerName, inUserName, outEmailAddress, outCustom, outServerName, outUserName, active);
        MBMailingList mailingList = this.mbMailingListPersistence.findByPrimaryKey(mailingListId);
        mailingList.setEmailAddress(emailAddress);
        mailingList.setInProtocol(inUseSSL ? inProtocol + "s" : inProtocol);
        mailingList.setInServerName(inServerName);
        mailingList.setInServerPort(inServerPort);
        mailingList.setInUseSSL(inUseSSL);
        mailingList.setInUserName(inUserName);
        mailingList.setInPassword(inPassword);
        mailingList.setInReadInterval(inReadInterval);
        mailingList.setOutEmailAddress(outEmailAddress);
        mailingList.setOutCustom(outCustom);
        mailingList.setOutServerName(outServerName);
        mailingList.setOutServerPort(outServerPort);
        mailingList.setOutUseSSL(outUseSSL);
        mailingList.setOutUserName(outUserName);
        mailingList.setOutPassword(outPassword);
        mailingList.setAllowAnonymous(allowAnonymous);
        mailingList.setActive(active);
        this.mbMailingListPersistence.update((BaseModel)mailingList);
        if (active) {
            this.scheduleMailingList(mailingList);
        }
        return mailingList;
    }

    protected String getSchedulerGroupName(MBMailingList mailingList) {
        return "liferay/message_boards_mailing_list".concat("/").concat(String.valueOf(mailingList.getMailingListId()));
    }

    protected void scheduleMailingList(MBMailingList mailingList) throws PortalException {
        String groupName = this.getSchedulerGroupName(mailingList);
        Calendar startDate = CalendarFactoryUtil.getCalendar();
        Trigger trigger = TriggerFactoryUtil.createTrigger((String)groupName, (String)groupName, (Date)startDate.getTime(), (int)mailingList.getInReadInterval(), (TimeUnit)TimeUnit.MINUTE);
        MailingListRequest mailingListRequest = new MailingListRequest();
        mailingListRequest.setCompanyId(mailingList.getCompanyId());
        mailingListRequest.setUserId(mailingList.getUserId());
        mailingListRequest.setGroupId(mailingList.getGroupId());
        mailingListRequest.setCategoryId(mailingList.getCategoryId());
        mailingListRequest.setInProtocol(mailingList.getInProtocol());
        mailingListRequest.setInServerName(mailingList.getInServerName());
        mailingListRequest.setInServerPort(mailingList.getInServerPort());
        mailingListRequest.setInUseSSL(mailingList.getInUseSSL());
        mailingListRequest.setInUserName(mailingList.getInUserName());
        mailingListRequest.setInPassword(mailingList.getInPassword());
        mailingListRequest.setAllowAnonymous(mailingList.getAllowAnonymous());
        SchedulerEngineHelperUtil.schedule((Trigger)trigger, (StorageType)StorageType.PERSISTED, null, (String)"liferay/message_boards_mailing_list", (Object)mailingListRequest, (int)0);
    }

    protected void unscheduleMailingList(MBMailingList mailingList) throws PortalException {
        String groupName = this.getSchedulerGroupName(mailingList);
        SchedulerEngineHelperUtil.unschedule((String)groupName, (StorageType)StorageType.PERSISTED);
    }

    protected void validate(String emailAddress, String inServerName, String inUserName, String outEmailAddress, boolean outCustom, String outServerName, String outUserName, boolean active) throws PortalException {
        if (!active) {
            return;
        }
        if (!Validator.isEmailAddress((String)emailAddress)) {
            throw new MailingListEmailAddressException(emailAddress);
        }
        if (Validator.isNull((String)inServerName)) {
            throw new MailingListInServerNameException("In server name is null");
        }
        if (Validator.isNull((String)inUserName)) {
            throw new MailingListInUserNameException("In user name is null");
        }
        if (Validator.isNull((String)outEmailAddress)) {
            throw new MailingListOutEmailAddressException("Out email address is null");
        }
        if (outCustom) {
            if (Validator.isNull((String)outServerName)) {
                throw new MailingListOutServerNameException("Out server name is null");
            }
            if (Validator.isNull((String)outUserName)) {
                throw new MailingListOutUserNameException("Out user name is null");
            }
        }
    }
}

