/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.documentlibrary.store;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.store.StoreWrapper;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import com.liferay.registry.ServiceReference;
import com.liferay.registry.ServiceTrackerCustomizer;
import com.liferay.registry.collections.ServiceTrackerCollections;
import com.liferay.registry.collections.ServiceTrackerMap;
import java.util.List;
import java.util.Set;

public class StoreFactory {
    private static final Log _log = LogFactoryUtil.getLog(StoreFactory.class);
    private static StoreFactory _storeFactory;
    private static boolean _warned;
    private volatile Store _store;
    private final ServiceTrackerMap<String, Store> _storeServiceTrackerMap = ServiceTrackerCollections.openSingleValueMap(Store.class, (String)"store.type", (ServiceTrackerCustomizer)new StoreServiceTrackerCustomizer());
    private String _storeType;
    private final ServiceTrackerMap<String, List<StoreWrapper>> _storeWrapperServiceTrackerMap = ServiceTrackerCollections.openMultiValueMap(StoreWrapper.class, (String)"store.type");

    public static StoreFactory getInstance() {
        if (_storeFactory == null) {
            _storeFactory = new StoreFactory();
        }
        return _storeFactory;
    }

    public void checkProperties() {
        if (_warned) {
            return;
        }
        String dlHookImpl = PropsUtil.get("dl.hook.impl");
        if (Validator.isNull((String)dlHookImpl)) {
            _warned = true;
            return;
        }
        boolean found = false;
        for (String key : this._storeServiceTrackerMap.keySet()) {
            Store store = this.getStore(key);
            Class<?> clazz = store.getClass();
            String className = clazz.getName();
            if (!dlHookImpl.equals(className)) continue;
            PropsValues.DL_STORE_IMPL = className;
            found = true;
            break;
        }
        if (!found) {
            PropsValues.DL_STORE_IMPL = dlHookImpl;
        }
        if (_log.isWarnEnabled()) {
            StringBundler sb = new StringBundler(13);
            sb.append("Liferay is configured with the legacy ");
            sb.append("property \"dl.hook.impl=");
            sb.append(dlHookImpl);
            sb.append("\" ");
            sb.append("in portal-ext.properties. Please reconfigure ");
            sb.append("to use the new property \"");
            sb.append("dl.store.impl");
            sb.append("\". Liferay will ");
            sb.append("attempt to temporarily set \"");
            sb.append("dl.store.impl");
            sb.append("=");
            sb.append(PropsValues.DL_STORE_IMPL);
            sb.append("\".");
            _log.warn((Object)sb.toString());
        }
        _warned = true;
    }

    public void destroy() {
        this._storeServiceTrackerMap.close();
        this._storeWrapperServiceTrackerMap.close();
    }

    public Store getStore() {
        if (this._store == null) {
            if (Validator.isNull((String)this._storeType)) {
                this.setStore(PropsValues.DL_STORE_IMPL);
            } else {
                this.setStore(this._storeType);
            }
        }
        if (this._store == null) {
            throw new IllegalStateException("Store is not available");
        }
        return this._store;
    }

    public Store getStore(String key) {
        Store store = (Store)this._storeServiceTrackerMap.getService((Object)key);
        List storeWrappers = (List)this._storeWrapperServiceTrackerMap.getService((Object)key);
        if (storeWrappers == null) {
            return store;
        }
        for (StoreWrapper storeWrapper : storeWrappers) {
            store = storeWrapper.wrap(store);
        }
        return store;
    }

    public String[] getStoreTypes() {
        Set storeTypes = this._storeServiceTrackerMap.keySet();
        return storeTypes.toArray(new String[storeTypes.size()]);
    }

    public void setStore(String key) {
        if (key == null) {
            this._store = null;
            this._storeType = null;
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)("Set " + key));
        }
        this._store = this.getStore(key);
        this._storeType = key;
    }

    private class StoreServiceTrackerCustomizer
    implements ServiceTrackerCustomizer<Store, Store> {
        private StoreServiceTrackerCustomizer() {
        }

        public Store addingService(ServiceReference<Store> serviceReference) {
            this.cleanUp(serviceReference);
            Registry registry = RegistryUtil.getRegistry();
            return (Store)registry.getService(serviceReference);
        }

        public void modifiedService(ServiceReference<Store> serviceReference, Store service) {
            this.cleanUp(serviceReference);
        }

        public void removedService(ServiceReference<Store> serviceReference, Store service) {
            this.cleanUp(serviceReference);
            Registry registry = RegistryUtil.getRegistry();
            registry.ungetService(serviceReference);
        }

        protected void cleanUp(ServiceReference<Store> serviceReference) {
            String storeType = (String)serviceReference.getProperty("store.type");
            if (Validator.isNotNull((String)StoreFactory.this._storeType) && StoreFactory.this._storeType.equals(storeType)) {
                StoreFactory.this._store = null;
            }
        }
    }
}

