/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet;

import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.TemplateResourceLoaderUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.Writer;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.GenericPortlet;
import javax.portlet.MimeResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;

public class VelocityPortlet
extends GenericPortlet {
    private String _actionTemplateId;
    private String _editTemplateId;
    private String _helpTemplateId;
    private String _portletContextName;
    private String _resourceTemplateId;
    private String _viewTemplateId;

    public void doEdit(RenderRequest renderRequest, RenderResponse renderResponse) throws IOException, PortletException {
        if (renderRequest.getPreferences() == null) {
            super.doEdit(renderRequest, renderResponse);
            return;
        }
        try {
            this.mergeTemplate(this._editTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void doHelp(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.mergeTemplate(this._helpTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void doView(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            this.mergeTemplate(this._viewTemplateId, (PortletRequest)renderRequest, (PortletResponse)renderResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void init(PortletConfig portletConfig) throws PortletException {
        super.init(portletConfig);
        PortletContext portletContext = portletConfig.getPortletContext();
        this._portletContextName = portletContext.getPortletContextName();
        this._actionTemplateId = this.getTemplateId(this.getInitParameter("action-template"));
        this._editTemplateId = this.getTemplateId(this.getInitParameter("edit-template"));
        this._helpTemplateId = this.getTemplateId(this.getInitParameter("help-template"));
        this._resourceTemplateId = this.getTemplateId(this.getInitParameter("resource-template"));
        this._viewTemplateId = this.getTemplateId(this.getInitParameter("view-template"));
    }

    public void processAction(ActionRequest actionRequest, ActionResponse actionResponse) throws PortletException {
        if (Validator.isNull((String)this._actionTemplateId)) {
            return;
        }
        try {
            this.mergeTemplate(this._actionTemplateId, (PortletRequest)actionRequest, (PortletResponse)actionResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    public void serveResource(ResourceRequest resourceRequest, ResourceResponse resourceResponse) throws IOException, PortletException {
        if (Validator.isNull((String)this._resourceTemplateId)) {
            super.serveResource(resourceRequest, resourceResponse);
            return;
        }
        try {
            this.mergeTemplate(this._resourceTemplateId, (PortletRequest)resourceRequest, (PortletResponse)resourceResponse);
        }
        catch (Exception e) {
            throw new PortletException((Throwable)e);
        }
    }

    protected String getTemplateId(String name) {
        if (Validator.isNull((String)name)) {
            return name;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(this._portletContextName);
        sb.append("_SERVLET_CONTEXT_");
        sb.append("/html");
        sb.append(name);
        return sb.toString();
    }

    protected void mergeTemplate(String templateId, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        TemplateResource templateResource = TemplateResourceLoaderUtil.getTemplateResource((String)"vm", (String)templateId);
        if (templateResource == null) {
            throw new Exception("Unable to load template resource " + templateId);
        }
        Template template = TemplateManagerUtil.getTemplate((String)"vm", (TemplateResource)templateResource, (boolean)false);
        this.prepareTemplate(template, portletRequest, portletResponse);
        this.mergeTemplate(templateId, template, portletRequest, portletResponse);
    }

    protected void mergeTemplate(String templateId, Template template, PortletRequest portletRequest, PortletResponse portletResponse) throws Exception {
        Object writer = null;
        if (portletResponse instanceof MimeResponse) {
            MimeResponse mimeResponse = (MimeResponse)portletResponse;
            writer = mimeResponse.getWriter();
        } else {
            writer = new UnsyncStringWriter();
        }
        template.processTemplate((Writer)writer);
    }

    protected void prepareTemplate(Template template, PortletRequest portletRequest, PortletResponse portletResponse) {
        template.put((Object)"portletConfig", (Object)this.getPortletConfig());
        template.put((Object)"portletContext", (Object)this.getPortletContext());
        template.put((Object)"preferences", (Object)portletRequest.getPreferences());
        template.put((Object)"userInfo", portletRequest.getAttribute("javax.portlet.userinfo"));
        template.put((Object)"portletRequest", (Object)portletRequest);
        if (portletRequest instanceof ActionRequest) {
            template.put((Object)"actionRequest", (Object)portletRequest);
        } else if (portletRequest instanceof RenderRequest) {
            template.put((Object)"renderRequest", (Object)portletRequest);
        } else {
            template.put((Object)"resourceRequest", (Object)portletRequest);
        }
        template.put((Object)"portletResponse", (Object)portletResponse);
        if (portletResponse instanceof ActionResponse) {
            template.put((Object)"actionResponse", (Object)portletResponse);
        } else if (portletRequest instanceof RenderResponse) {
            template.put((Object)"renderResponse", (Object)portletResponse);
        } else {
            template.put((Object)"resourceResponse", (Object)portletResponse);
        }
    }
}

