/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.json.JSONObjectImpl;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterNode;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterNodeResponses;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.license.util.LicenseManagerUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.MethodKey;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ReleaseInfo;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.util.Encryptor;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URL;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import javax.crypto.KeyGenerator;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.BasicHttpClientConnectionManager;

public class LicenseUtil {
    public static final String LICENSE_REPOSITORY_DIR = PropsValues.LIFERAY_HOME.concat("/data/license");
    public static final String LICENSE_SERVER_URL = GetterUtil.get((String)PropsUtil.get("license.server.url"), (String)"https://www.liferay.com");
    private static final String _PROXY_PASSWORD = GetterUtil.getString((String)PropsUtil.get("license.proxy.password"));
    private static final int _PROXY_PORT = GetterUtil.getInteger((String)PropsUtil.get("license.proxy.port"), (int)80);
    private static final String _PROXY_URL = PropsUtil.get("license.proxy.url");
    private static final String _PROXY_USER_NAME = GetterUtil.getString((String)PropsUtil.get("license.proxy.username"));
    private static final Log _log = LogFactoryUtil.getLog(LicenseUtil.class);
    private static String _encryptedSymmetricKey;
    private static final MethodHandler _getServerInfoMethodHandler;
    private static Set<String> _ipAddresses;
    private static Set<String> _macAddresses;
    private static final MethodKey _registerOrderMethodKey;
    private static byte[] _serverIdBytes;
    private static Key _symmetricKey;

    public static Map<String, String> getClusterServerInfo(String clusterNodeId) throws Exception {
        ClusterNode localClusterNode = ClusterExecutorUtil.getLocalClusterNode();
        String localClusterNodeId = localClusterNode.getClusterNodeId();
        if (clusterNodeId.equals(localClusterNodeId)) {
            return LicenseUtil.getServerInfo();
        }
        List clusterNodes = ClusterExecutorUtil.getClusterNodes();
        ClusterNode clusterNode = null;
        for (ClusterNode curClusterNode : clusterNodes) {
            String curClusterNodeId = curClusterNode.getClusterNodeId();
            if (!curClusterNodeId.equals(clusterNodeId)) continue;
            clusterNode = curClusterNode;
            break;
        }
        if (clusterNode == null) {
            return null;
        }
        try {
            ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((Serializable)_getServerInfoMethodHandler, (String[])new String[]{clusterNodeId});
            FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
            ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20000L, TimeUnit.MILLISECONDS);
            ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode.getClusterNodeId());
            return (Map)((Object)clusterNodeResponse.getResult());
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            throw e;
        }
    }

    public static Set<String> getIpAddresses() {
        if (_ipAddresses != null) {
            return new HashSet<String>(_ipAddresses);
        }
        _ipAddresses = new HashSet<String>();
        try {
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : networkInterfaces) {
                ArrayList<InetAddress> inetAddresses = Collections.list(networkInterface.getInetAddresses());
                for (InetAddress inetAddress : inetAddresses) {
                    if (inetAddress.isLinkLocalAddress() || inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    _ipAddresses.add(inetAddress.getHostAddress());
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to read local server's IP addresses");
            _log.error((Object)e, (Throwable)e);
        }
        return new HashSet<String>(_ipAddresses);
    }

    public static Set<String> getMacAddresses() {
        if (_macAddresses != null) {
            return new HashSet<String>(_macAddresses);
        }
        _macAddresses = new HashSet<String>();
        try {
            ArrayList<NetworkInterface> networkInterfaces = Collections.list(NetworkInterface.getNetworkInterfaces());
            for (NetworkInterface networkInterface : networkInterfaces) {
                byte[] hardwareAddress = networkInterface.getHardwareAddress();
                if (ArrayUtil.isEmpty((byte[])hardwareAddress)) continue;
                StringBuilder sb = new StringBuilder(hardwareAddress.length * 3 - 1);
                String hexString = StringUtil.bytesToHexString((byte[])hardwareAddress);
                for (int i = 0; i < hexString.length(); i += 2) {
                    if (i != 0) {
                        sb.append(':');
                    }
                    sb.append(Character.toLowerCase(hexString.charAt(i)));
                    sb.append(Character.toLowerCase(hexString.charAt(i + 1)));
                }
                _macAddresses.add(sb.toString());
            }
        }
        catch (Exception e) {
            _log.error((Object)"Unable to read local server's MAC addresses");
            _log.error((Object)e, (Throwable)e);
        }
        return new HashSet<String>(_macAddresses);
    }

    public static byte[] getServerIdBytes() throws Exception {
        if (_serverIdBytes != null) {
            return _serverIdBytes;
        }
        File serverIdFile = new File(LICENSE_REPOSITORY_DIR + "/server/serverId");
        if (!serverIdFile.exists()) {
            return new byte[0];
        }
        _serverIdBytes = FileUtil.getBytes((File)serverIdFile);
        return _serverIdBytes;
    }

    public static Map<String, String> getServerInfo() {
        HashMap<String, String> serverInfo = new HashMap<String, String>();
        serverInfo.put("hostName", PortalUtil.getComputerName());
        serverInfo.put("ipAddresses", StringUtil.merge(LicenseUtil.getIpAddresses()));
        serverInfo.put("macAddresses", StringUtil.merge(LicenseUtil.getMacAddresses()));
        return serverInfo;
    }

    public static void registerOrder(HttpServletRequest request) {
        String orderUuid = ParamUtil.getString((HttpServletRequest)request, (String)"orderUuid");
        String productEntryName = ParamUtil.getString((HttpServletRequest)request, (String)"productEntryName");
        int maxServers = ParamUtil.getInteger((HttpServletRequest)request, (String)"maxServers");
        List clusterNodes = ClusterExecutorUtil.getClusterNodes();
        if (clusterNodes.size() <= 1 || Validator.isNull((String)productEntryName) || Validator.isNull((String)orderUuid)) {
            Map<String, Object> attributes = LicenseUtil.registerOrder(orderUuid, productEntryName, maxServers);
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                request.setAttribute(entry.getKey(), entry.getValue());
            }
        } else {
            for (ClusterNode clusterNode : clusterNodes) {
                boolean register = ParamUtil.getBoolean((HttpServletRequest)request, (String)(clusterNode.getClusterNodeId() + "_register"));
                if (!register) continue;
                try {
                    LicenseUtil._registerClusterOrder(request, clusterNode, orderUuid, productEntryName, maxServers);
                }
                catch (Exception e) {
                    _log.error((Object)e, (Throwable)e);
                    InetAddress inetAddress = clusterNode.getBindInetAddress();
                    String message = "Error contacting " + inetAddress.getHostName();
                    if (clusterNode.getPortalPort() != -1) {
                        message = message + ":" + clusterNode.getPortalPort();
                    }
                    request.setAttribute(clusterNode.getClusterNodeId() + "_ERROR_MESSAGE", (Object)message);
                }
            }
        }
    }

    public static Map<String, Object> registerOrder(String orderUuid, String productEntryName, int maxServers) {
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        if (Validator.isNull((String)orderUuid)) {
            return attributes;
        }
        try {
            JSONObject jsonObject = LicenseUtil._createRequest(orderUuid, productEntryName, maxServers);
            String response = LicenseUtil.sendRequest(jsonObject.toString());
            JSONObjectImpl responseJSONObject = new JSONObjectImpl(response);
            attributes.put("ORDER_PRODUCT_ID", responseJSONObject.getString("productId"));
            attributes.put("ORDER_PRODUCTS", LicenseUtil._getOrderProducts(responseJSONObject));
            String errorMessage = responseJSONObject.getString("errorMessage");
            if (Validator.isNotNull((String)errorMessage)) {
                attributes.put("ERROR_MESSAGE", errorMessage);
                return attributes;
            }
            String licenseXML = responseJSONObject.getString("licenseXML");
            if (Validator.isNotNull((String)licenseXML)) {
                LicenseManagerUtil.registerLicense((JSONObject)responseJSONObject);
                attributes.clear();
                attributes.put("SUCCESS_MESSAGE", "Your license has been successfully registered.");
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
            attributes.put("ERROR_MESSAGE", "There was an error contacting " + LICENSE_SERVER_URL);
        }
        return attributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendRequest(String request) throws Exception {
        CloseableHttpClient httpClient = null;
        BasicHttpClientConnectionManager httpClientConnectionManager = new BasicHttpClientConnectionManager();
        try {
            HttpClientBuilder httpClientBuilder = HttpClientBuilder.create();
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)httpClientConnectionManager);
            String serverURL = LICENSE_SERVER_URL;
            if (!serverURL.endsWith("/")) {
                serverURL = serverURL + "/";
            }
            serverURL = serverURL + "osb-portlet/license";
            URI uri = new URI(serverURL);
            HttpPost httpPost = new HttpPost(uri);
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            HttpHost proxyHttpHost = null;
            if (Validator.isNotNull((String)_PROXY_URL)) {
                if (_log.isInfoEnabled()) {
                    _log.info((Object)("Using proxy " + _PROXY_URL + ":" + _PROXY_PORT));
                }
                proxyHttpHost = new HttpHost(_PROXY_URL, _PROXY_PORT);
                if (Validator.isNotNull((String)_PROXY_USER_NAME)) {
                    credentialsProvider.setCredentials(new AuthScope(_PROXY_URL, _PROXY_PORT), (Credentials)new UsernamePasswordCredentials(_PROXY_USER_NAME, _PROXY_PASSWORD));
                }
            }
            httpClientBuilder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
            httpClientBuilder.setProxy(proxyHttpHost);
            httpClient = httpClientBuilder.build();
            ByteArrayEntity byteArrayEntity = new ByteArrayEntity(LicenseUtil._encryptRequest(serverURL, request));
            byteArrayEntity.setContentType("application/json");
            httpPost.setEntity((HttpEntity)byteArrayEntity);
            HttpResponse httpResponse = httpClient.execute((HttpUriRequest)httpPost);
            HttpEntity httpEntity = httpResponse.getEntity();
            String response = LicenseUtil._decryptResponse(serverURL, httpEntity.getContent());
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Server response: " + response));
            }
            if (Validator.isNull((String)response)) {
                throw new Exception("Server response is null");
            }
            String string = response;
            return string;
        }
        finally {
            if (httpClient != null) {
                httpClientConnectionManager.shutdown();
            }
        }
    }

    public static void writeServerProperties(byte[] serverIdBytes) throws Exception {
        File serverIdFile = new File(LICENSE_REPOSITORY_DIR + "/server/serverId");
        FileUtil.write((File)serverIdFile, (byte[])serverIdBytes);
    }

    private static JSONObject _createRequest(String orderUuid, String productEntryName, int maxServers) throws Exception {
        JSONObjectImpl jsonObject = new JSONObjectImpl();
        jsonObject.put("version", 2);
        jsonObject.put("orderUuid", orderUuid);
        jsonObject.put("liferayVersion", ReleaseInfo.getBuildNumber());
        if (Validator.isNull((String)productEntryName)) {
            jsonObject.put("cmd", "QUERY");
        } else {
            jsonObject.put("cmd", "REGISTER");
            if (productEntryName.startsWith("basic")) {
                String[] productNameArray;
                jsonObject.put("productEntryName", "basic");
                if (productEntryName.equals("basic-cluster")) {
                    jsonObject.put("cluster", true);
                    jsonObject.put("maxServers", maxServers);
                } else if (productEntryName.startsWith("basic-") && (productNameArray = StringUtil.split((String)productEntryName, (String)"-")).length >= 3) {
                    jsonObject.put("offeringEntryId", productNameArray[1]);
                    jsonObject.put("clusterId", productNameArray[2]);
                }
            } else {
                jsonObject.put("productEntryName", productEntryName);
            }
            jsonObject.put("hostName", PortalUtil.getComputerName());
            jsonObject.put("ipAddresses", StringUtil.merge(LicenseUtil.getIpAddresses()));
            jsonObject.put("macAddresses", StringUtil.merge(LicenseUtil.getMacAddresses()));
            jsonObject.put("serverId", Arrays.toString(LicenseUtil.getServerIdBytes()));
        }
        return jsonObject;
    }

    private static String _decryptResponse(String serverURL, InputStream inputStream) throws Exception {
        if (serverURL.startsWith("https")) {
            return StringUtil.read((InputStream)inputStream);
        }
        byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
        if (bytes == null || bytes.length <= 0) {
            return null;
        }
        bytes = Encryptor.decryptUnencodedAsBytes((Key)_symmetricKey, (byte[])bytes);
        return new String(bytes, "UTF-8");
    }

    private static byte[] _encryptRequest(String serverURL, String request) throws Exception {
        byte[] bytes = request.getBytes("UTF-8");
        if (serverURL.startsWith("https")) {
            return bytes;
        }
        JSONObjectImpl jsonObject = new JSONObjectImpl();
        bytes = Encryptor.encryptUnencoded((Key)_symmetricKey, (byte[])bytes);
        jsonObject.put("content", Base64.objectToString((Object)bytes));
        jsonObject.put("key", _encryptedSymmetricKey);
        return jsonObject.toString().getBytes("UTF-8");
    }

    private static Map<String, String> _getOrderProducts(JSONObject jsonObject) {
        JSONObject productsJSONObject = jsonObject.getJSONObject("productsJSONObject");
        if (productsJSONObject == null) {
            return null;
        }
        TreeMap<String, String> sortedMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Iterator itr = productsJSONObject.keys();
        while (itr.hasNext()) {
            String key = (String)itr.next();
            sortedMap.put(key, productsJSONObject.getString(key));
        }
        return sortedMap;
    }

    private static void _initKeys() {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        if (classLoader == null || _encryptedSymmetricKey != null) {
            return;
        }
        try {
            URL url = classLoader.getResource("com/liferay/portal/license/public.key");
            byte[] bytes = IOUtils.toByteArray((InputStream)url.openStream());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(bytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128, new SecureRandom());
            _symmetricKey = keyGenerator.generateKey();
            byte[] encryptedSymmetricKey = Encryptor.encryptUnencoded((Key)publicKey, (byte[])_symmetricKey.getEncoded());
            _encryptedSymmetricKey = Base64.objectToString((Object)encryptedSymmetricKey);
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
    }

    private static void _registerClusterOrder(HttpServletRequest request, ClusterNode clusterNode, String orderUuid, String productEntryName, int maxServers) throws Exception {
        MethodHandler methodHandler = new MethodHandler(_registerOrderMethodKey, new Object[]{orderUuid, productEntryName, maxServers});
        ClusterRequest clusterRequest = ClusterRequest.createUnicastRequest((Serializable)methodHandler, (String[])new String[]{clusterNode.getClusterNodeId()});
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        ClusterNodeResponses clusterNodeResponses = futureClusterResponses.get(20000L, TimeUnit.MILLISECONDS);
        ClusterNodeResponse clusterNodeResponse = clusterNodeResponses.getClusterResponse(clusterNode.getClusterNodeId());
        Map attributes = (Map)((Object)clusterNodeResponse.getResult());
        for (Map.Entry entry : attributes.entrySet()) {
            request.setAttribute(clusterNode.getClusterNodeId() + "_" + (String)entry.getKey(), entry.getValue());
        }
    }

    static {
        _getServerInfoMethodHandler = new MethodHandler(new MethodKey(LicenseUtil.class, "getServerInfo", new Class[0]), new Object[0]);
        _registerOrderMethodKey = new MethodKey(LicenseUtil.class, "registerOrder", new Class[]{String.class, String.class, Integer.TYPE});
        LicenseUtil._initKeys();
    }
}

