/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.util;

import com.liferay.portal.kernel.security.pacl.DoPrivileged;
import com.liferay.portal.kernel.util.FriendlyURLNormalizer;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.util.Normalizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@DoPrivileged
public class FriendlyURLNormalizerImpl
implements FriendlyURLNormalizer {
    private static final Pattern _friendlyURLHyphenPattern = Pattern.compile("(-)\\1+");
    private static final Pattern _friendlyURLPattern = Pattern.compile("[^a-z0-9./_-]");

    public String normalize(String friendlyURL) {
        return this.normalize(friendlyURL, _friendlyURLPattern);
    }

    public String normalize(String friendlyURL, Pattern friendlyURLPattern) {
        if (Validator.isNull((String)friendlyURL)) {
            return friendlyURL;
        }
        friendlyURL = StringUtil.toLowerCase((String)friendlyURL);
        friendlyURL = Normalizer.normalizeToAscii((String)friendlyURL);
        Matcher matcher = friendlyURLPattern.matcher(friendlyURL);
        friendlyURL = matcher.replaceAll("-");
        matcher = _friendlyURLHyphenPattern.matcher(friendlyURL);
        friendlyURL = matcher.replaceAll("-");
        return friendlyURL;
    }
}

