/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.upgrade.v6_1_0;

import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.store.DLStoreUtil;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.portal.image.DLHook;
import com.liferay.portal.image.DatabaseHook;
import com.liferay.portal.image.FileSystemHook;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.image.Hook;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Image;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Base64;
import com.liferay.portal.kernel.util.ClassLoaderUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.LoggingTimer;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.uuid.PortalUUIDUtil;
import com.liferay.portal.upgrade.AutoBatchPreparedStatementUtil;
import com.liferay.portal.upgrade.v6_1_0.util.UpdateSyncUtil;
import com.liferay.portal.util.PropsValues;
import java.io.IOException;
import java.io.InputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UpgradeImageGallery
extends UpgradeProcess {
    private static final String _IG_FOLDER_CLASS_NAME = "com.liferay.portlet.imagegallery.model.IGFolder";
    private static final String _IG_IMAGE_CLASS_NAME = "com.liferay.portlet.imagegallery.model.IGImage";
    private static final Log _log = LogFactoryUtil.getLog(UpgradeImageGallery.class);
    private final Hook _sourceHook;
    private final String _sourceHookClassName;

    public UpgradeImageGallery() throws Exception {
        ClassLoader classLoader = ClassLoaderUtil.getPortalClassLoader();
        this._sourceHookClassName = Validator.isNotNull((String)PropsValues.IMAGE_HOOK_IMPL) ? PropsValues.IMAGE_HOOK_IMPL : FileSystemHook.class.getName();
        Class<?> clazz = classLoader.loadClass(this._sourceHookClassName);
        this._sourceHook = (Hook)clazz.newInstance();
    }

    protected void addDLFileEntry(String uuid, long fileEntryId, long groupId, long companyId, long userId, String userName, long versionUserId, String versionUserName, Timestamp createDate, Timestamp modifiedDate, long repositoryId, long folderId, String name, String extension, String mimeType, String title, String description, String extraSettings, long fileEntryTypeId, String version, long size, int readCount, long smallImageId, long largeImageId, long custom1ImageId, long custom2ImageId) throws Exception {
        StringBundler sb = new StringBundler(9);
        sb.append("insert into DLFileEntry (uuid_, fileEntryId, groupId, ");
        sb.append("companyId, userId, userName, versionUserId, ");
        sb.append("versionUserName, createDate, modifiedDate, ");
        sb.append("repositoryId, folderId, name, extension, mimeType, ");
        sb.append("title, description, extraSettings, fileEntryTypeId, ");
        sb.append("version, size_, readCount, smallImageId, ");
        sb.append("largeImageId, custom1ImageId, custom2ImageId) values (");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setString(1, uuid);
            ps.setLong(2, fileEntryId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setLong(7, versionUserId);
            ps.setString(8, versionUserName);
            ps.setTimestamp(9, createDate);
            ps.setTimestamp(10, modifiedDate);
            ps.setLong(11, repositoryId);
            ps.setLong(12, folderId);
            ps.setString(13, name);
            ps.setString(14, extension);
            ps.setString(15, mimeType);
            ps.setString(16, title);
            ps.setString(17, description);
            ps.setString(18, extraSettings);
            ps.setLong(19, fileEntryTypeId);
            ps.setString(20, version);
            ps.setLong(21, size);
            ps.setInt(22, readCount);
            ps.setLong(23, smallImageId);
            ps.setLong(24, largeImageId);
            ps.setLong(25, custom1ImageId);
            ps.setLong(26, custom2ImageId);
            ps.executeUpdate();
        }
    }

    protected void addDLFileVersion(long fileVersionId, long groupId, long companyId, long userId, String userName, Timestamp createDate, long repositoryId, long folderId, long fileEntryId, String extension, String mimeType, String title, String description, String changeLog, String extraSettings, long fileEntryTypeId, String version, long size, int status, long statusByUserId, String statusByUserName, Timestamp statusDate) throws Exception {
        StringBundler sb = new StringBundler(8);
        sb.append("insert into DLFileVersion (fileVersionId, groupId, ");
        sb.append("companyId, userId, userName, createDate, ");
        sb.append("modifiedDate, repositoryId, folderId, fileEntryId, ");
        sb.append("extension, mimeType, title, description, changeLog, ");
        sb.append("extraSettings, fileEntryTypeId, version, size_, ");
        sb.append("status, statusByUserId, statusByUserName, statusDate) ");
        sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ");
        sb.append("?, ?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setLong(1, fileVersionId);
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            ps.setTimestamp(6, createDate);
            ps.setTimestamp(7, statusDate);
            ps.setLong(8, repositoryId);
            ps.setLong(9, folderId);
            ps.setLong(10, fileEntryId);
            ps.setString(11, extension);
            ps.setString(12, mimeType);
            ps.setString(13, title);
            ps.setString(14, description);
            ps.setString(15, changeLog);
            ps.setString(16, extraSettings);
            ps.setLong(17, fileEntryTypeId);
            ps.setString(18, version);
            ps.setLong(19, size);
            ps.setInt(20, status);
            ps.setLong(21, statusByUserId);
            ps.setString(22, statusByUserName);
            ps.setTimestamp(23, statusDate);
            ps.executeUpdate();
        }
    }

    protected void addDLFolderEntry(String uuid, long folderId, long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate, long repositoryId, long parentFolderId, String name, String description, Timestamp lastPostDate) throws Exception {
        StringBundler sb = new StringBundler(5);
        sb.append("insert into DLFolder (uuid_, folderId, groupId, ");
        sb.append("companyId, userId, userName, createDate, ");
        sb.append("modifiedDate, repositoryId, mountPoint, ");
        sb.append("parentFolderId, name, description, lastPostDate) ");
        sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setString(1, uuid);
            ps.setLong(2, folderId);
            ps.setLong(3, groupId);
            ps.setLong(4, companyId);
            ps.setLong(5, userId);
            ps.setString(6, userName);
            ps.setTimestamp(7, createDate);
            ps.setTimestamp(8, modifiedDate);
            ps.setLong(9, repositoryId);
            ps.setBoolean(10, false);
            ps.setLong(11, parentFolderId);
            ps.setString(12, name);
            ps.setString(13, description);
            ps.setTimestamp(14, lastPostDate);
            ps.executeUpdate();
        }
    }

    protected void addIGImageDLFileEntryType() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            if (!PropsValues.DL_FILE_ENTRY_TYPE_IG_IMAGE_AUTO_CREATE_ON_UPGRADE) {
                return;
            }
            try (PreparedStatement ps = this.connection.prepareStatement("select distinct companyId from IGImage");
                 ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    long companyId = rs.getLong("companyId");
                    long groupId = this.getCompanyGroupId(companyId);
                    long userId = this.getDefaultUserId(companyId);
                    Timestamp now = new Timestamp(System.currentTimeMillis());
                    this.addIGImageDLFileEntryType(groupId, companyId, userId, "", now, now);
                }
            }
        }
    }

    protected void addIGImageDLFileEntryType(long groupId, long companyId, long userId, String userName, Timestamp createDate, Timestamp modifiedDate) throws Exception {
        StringBundler sb = new StringBundler(4);
        sb.append("insert into DLFileEntryType (uuid_, groupId, ");
        sb.append("companyId, userId, userName, createDate, ");
        sb.append("modifiedDate, name, description, fileEntryTypeId) ");
        sb.append("values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
            ps.setString(1, PortalUUIDUtil.generate());
            ps.setLong(2, groupId);
            ps.setLong(3, companyId);
            ps.setLong(4, userId);
            ps.setString(5, userName);
            ps.setTimestamp(6, createDate);
            ps.setTimestamp(7, modifiedDate);
            ps.setString(8, "image-gallery-image");
            ps.setString(9, "image-gallery-image");
            ps.setLong(10, this.increment());
            ps.executeUpdate();
        }
    }

    protected void deleteConflictingIGPermissions(String igResourceName, String dlResourceName) throws Exception {
        String selectSQL = "select companyId, scope, primKey, roleId from ResourcePermission where name = ?";
        String deleteSQL = "delete from ResourcePermission where name = ? and companyId = ? and scope = ? and primKey = ? and roleId = ?";
        try (PreparedStatement ps1 = this.connection.prepareStatement(selectSQL);){
            ps1.setString(1, igResourceName);
            try (ResultSet rs = ps1.executeQuery();
                 PreparedStatement ps2 = AutoBatchPreparedStatementUtil.autoBatch(this.connection.prepareStatement(deleteSQL));){
                while (rs.next()) {
                    ps2.setString(1, dlResourceName);
                    ps2.setLong(2, rs.getLong("companyId"));
                    ps2.setInt(3, rs.getInt("scope"));
                    ps2.setString(4, rs.getString("primKey"));
                    ps2.setLong(5, rs.getLong("roleId"));
                    ps2.addBatch();
                }
                ps2.executeBatch();
            }
        }
    }

    protected void doUpgrade() throws Exception {
        this.addIGImageDLFileEntryType();
        this.updateIGFolderEntries();
        this.updateIGImageEntries();
        this.updateIGFolderPermissions();
        this.updateIGImagePermissions();
        this.migrateImageFiles();
        UpdateSyncUtil.updateSyncs(this.connection);
    }

    protected long getBitwiseValue(Map<String, Long> bitwiseValues, List<String> actionIds) {
        long bitwiseValue = 0L;
        for (String actionId : actionIds) {
            Long actionIdBitwiseValue = bitwiseValues.get(actionId);
            if (actionIdBitwiseValue == null) continue;
            bitwiseValue |= actionIdBitwiseValue.longValue();
        }
        return bitwiseValue;
    }

    /*
     * Exception decompiling
     */
    protected Map<String, Long> getBitwiseValues(String name) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected long getCompanyGroupId(long companyId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected byte[] getDatabaseImageAsBytes(Image image) throws SQLException {
        try (PreparedStatement ps = this.connection.prepareStatement("select text_ from Image where imageId = ?");){
            ps.setLong(1, image.getImageId());
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    String getTextObj = rs.getString("text_");
                    byte[] byArray = (byte[])Base64.stringToObject((String)getTextObj);
                    return byArray;
                }
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)("Image " + image.getImageId() + " is not in the database"));
                }
            }
        }
        return new byte[0];
    }

    /*
     * Exception decompiling
     */
    protected long getDefaultUserId(long companyId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected byte[] getHookImageAsBytes(Image image) throws IOException, PortalException, SQLException {
        InputStream is = this.getHookImageAsStream(image);
        return FileUtil.getBytes((InputStream)is);
    }

    protected InputStream getHookImageAsStream(Image image) throws PortalException, SQLException {
        InputStream is = null;
        if (this._sourceHook instanceof DatabaseHook) {
            byte[] bytes = this.getDatabaseImageAsBytes(image);
            is = new UnsyncByteArrayInputStream(bytes);
        } else {
            is = this._sourceHook.getImageAsStream(image);
        }
        return is;
    }

    /*
     * Exception decompiling
     */
    protected Image getImage(long imageId) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    protected long getMaxFileVersionId(long fileEntryId) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected List<String> getResourceActionIds(Map<String, Long> bitwiseValues, long actionIdsLong) {
        ArrayList<String> actionIds = new ArrayList<String>();
        for (String actionId : bitwiseValues.keySet()) {
            long bitwiseValue = bitwiseValues.get(actionId);
            if ((actionIdsLong & bitwiseValue) != bitwiseValue) continue;
            actionIds.add(actionId);
        }
        return actionIds;
    }

    protected void migrateFile(long repositoryId, long companyId, String name, Image image) throws Exception {
        byte[] bytes = this.getHookImageAsBytes(image);
        if (name == null) {
            name = image.getImageId() + "." + image.getType();
        }
        if (DLStoreUtil.hasFile((long)companyId, (long)repositoryId, (String)name)) {
            DLStoreUtil.deleteFile((long)companyId, (long)repositoryId, (String)name);
        }
        DLStoreUtil.addFile((long)companyId, (long)repositoryId, (String)name, (boolean)false, (byte[])bytes);
    }

    protected void migrateImage(long imageId) throws Exception {
        Image image = this.getImage(imageId);
        try {
            this.migrateFile(0L, 0L, null, image);
        }
        catch (Exception e) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Ignoring exception for image " + imageId), (Throwable)e);
            }
            return;
        }
        this._sourceHook.deleteImage(image);
    }

    protected void migrateImage(long fileEntryId, long companyId, long groupId, long folderId, String name, long smallImageId, long largeImageId, long custom1ImageId, long custom2ImageId) throws Exception {
        long fileVersionId;
        Image largeImage;
        block8: {
            largeImage = null;
            if (largeImageId != 0L) {
                largeImage = this.getImage(largeImageId);
                long repositoryId = DLFolderConstants.getDataRepositoryId((long)groupId, (long)folderId);
                try {
                    this.migrateFile(repositoryId, companyId, name, largeImage);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) break block8;
                    _log.warn((Object)("Ignoring exception for migrating image " + largeImageId), (Throwable)e);
                }
            }
        }
        if ((smallImageId != 0L || custom1ImageId != 0L || custom2ImageId != 0L) && (fileVersionId = this.getMaxFileVersionId(fileEntryId)) != 0L) {
            if (smallImageId != 0L) {
                this.migrateThumbnail(companyId, groupId, fileEntryId, fileVersionId, largeImageId, smallImageId, 0L, 0L);
            }
            if (custom1ImageId != 0L) {
                this.migrateThumbnail(companyId, groupId, fileEntryId, fileVersionId, largeImageId, custom1ImageId, custom1ImageId, 0L);
            }
            if (custom2ImageId != 0L) {
                this.migrateThumbnail(companyId, groupId, fileEntryId, fileVersionId, largeImageId, custom2ImageId, 0L, custom2ImageId);
            }
        }
        if (largeImageId != 0L) {
            this._sourceHook.deleteImage(largeImage);
            this.runSQL("delete from Image where imageId = " + largeImageId);
        }
    }

    protected void migrateImageFiles() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            Throwable throwable;
            ResultSet rs;
            StringBundler sb = new StringBundler(8);
            sb.append("select fileEntryId, companyId, groupId, folderId, ");
            sb.append("name, smallImageId, largeImageId, custom1ImageId, ");
            sb.append("custom2ImageId from DLFileEntry where ((smallImageId ");
            sb.append("is not null) and (smallImageId != 0)) or ");
            sb.append("((largeImageId is not null) and (largeImageId != 0)) ");
            sb.append("or ((custom1ImageId is not null) and (custom1ImageId ");
            sb.append("!= 0)) or ((custom2ImageId is not null) and ");
            sb.append("(custom2ImageId != 0))");
            try (PreparedStatement ps = this.connection.prepareStatement(sb.toString());){
                rs = ps.executeQuery();
                throwable = null;
                try {
                    while (rs.next()) {
                        long fileEntryId = rs.getLong("fileEntryId");
                        long companyId = rs.getLong("companyId");
                        long groupId = rs.getLong("groupId");
                        long folderId = rs.getLong("folderId");
                        String name = rs.getString("name");
                        long smallImageId = rs.getLong("smallImageId");
                        long largeImageId = rs.getLong("largeImageId");
                        long custom1ImageId = rs.getLong("custom1ImageId");
                        long custom2ImageId = rs.getLong("custom2ImageId");
                        this.migrateImage(fileEntryId, companyId, groupId, folderId, name, smallImageId, largeImageId, custom1ImageId, custom2ImageId);
                    }
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            if (this._sourceHookClassName.equals(DLHook.class.getName())) {
                return;
            }
            ps = this.connection.prepareStatement("select imageId from Image");
            var5_8 = null;
            try {
                rs = ps.executeQuery();
                throwable = null;
                try {
                    while (rs.next()) {
                        long imageId = rs.getLong("imageId");
                        this.migrateImage(imageId);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (rs != null) {
                        if (throwable != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            rs.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                var5_8 = throwable3;
                throw throwable3;
            }
            finally {
                if (ps != null) {
                    if (var5_8 != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable x2) {
                            var5_8.addSuppressed(x2);
                        }
                    } else {
                        ps.close();
                    }
                }
            }
            if (this._sourceHookClassName.equals(DatabaseHook.class.getName())) {
                this.runSQL("update Image set text_ = ''");
            }
        }
    }

    protected void migrateThumbnail(long companyId, long groupId, long fileEntryId, long fileVersionId, long largeImageId, long thumbnailImageId, long custom1ImageId, long custom2ImageId) throws Exception {
        block3: {
            Image thumbnailImage = null;
            try {
                thumbnailImage = this.getImage(thumbnailImageId);
                InputStream is = this.getHookImageAsStream(thumbnailImage);
                ImageProcessorUtil.storeThumbnail((long)companyId, (long)groupId, (long)fileEntryId, (long)fileVersionId, (long)custom1ImageId, (long)custom2ImageId, (InputStream)is, (String)thumbnailImage.getType());
                if (largeImageId != thumbnailImageId) {
                    this._sourceHook.deleteImage(thumbnailImage);
                    this.runSQL("delete from Image where imageId = " + thumbnailImageId);
                }
            }
            catch (Exception e) {
                if (!_log.isWarnEnabled()) break block3;
                _log.warn((Object)("Ignoring exception for image " + thumbnailImageId), (Throwable)e);
            }
        }
    }

    protected void updateIGFolderEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select * from IGFolder order by folderId asc");
             ResultSet rs = ps.executeQuery();){
            HashMap<Long, Long> folderIds = new HashMap<Long, Long>();
            while (rs.next()) {
                boolean update;
                String uuid = rs.getString("uuid_");
                long folderId = rs.getLong("folderId");
                long groupId = rs.getLong("groupId");
                long companyId = rs.getLong("companyId");
                long userId = rs.getLong("userId");
                String userName = rs.getString("userName");
                Timestamp createDate = rs.getTimestamp("createDate");
                Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                long parentFolderId = rs.getLong("parentFolderId");
                String name = rs.getString("name");
                String description = rs.getString("description");
                if (folderIds.containsKey(parentFolderId)) {
                    parentFolderId = (Long)folderIds.get(parentFolderId);
                }
                if (update = this.updateIGImageFolderId(groupId, name, parentFolderId, folderId, folderIds)) continue;
                this.addDLFolderEntry(uuid, folderId, groupId, companyId, userId, userName, createDate, modifiedDate, groupId, parentFolderId, name, description, modifiedDate);
            }
            this.runSQL("drop table IGFolder");
        }
    }

    protected void updateIGFolderPermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.deleteConflictingIGPermissions(_IG_FOLDER_CLASS_NAME, "com.liferay.portlet.documentlibrary.model.DLFolder");
            this.updateIGtoDLPermissions(_IG_FOLDER_CLASS_NAME, "com.liferay.portlet.documentlibrary.model.DLFolder");
        }
    }

    protected void updateIGImageEntries() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();
             PreparedStatement ps = this.connection.prepareStatement("select fileEntryTypeId, companyId from DLFileEntryType where name = ?");){
            ps.setString(1, "image-gallery-image");
            try (ResultSet rs = ps.executeQuery();){
                boolean hasIGImageFileEntryType = false;
                while (rs.next()) {
                    long fileEntryTypeId = rs.getLong("fileEntryTypeId");
                    long companyId = rs.getLong("companyId");
                    this.updateIGImageEntries(companyId, fileEntryTypeId);
                    hasIGImageFileEntryType = true;
                }
                if (!hasIGImageFileEntryType) {
                    this.updateIGImageEntries(0L, 0L);
                }
                this.runSQL("drop table IGImage");
            }
        }
    }

    protected void updateIGImageEntries(long companyId, long fileEntryTypeId) throws Exception {
        String sql = "select * from IGImage";
        if (companyId != 0L) {
            sql = "select * from IGImage where companyId = ?";
        }
        try (PreparedStatement ps = this.connection.prepareStatement(sql);){
            if (companyId != 0L) {
                ps.setLong(1, companyId);
            }
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String uuid = rs.getString("uuid_");
                    long imageId = rs.getLong("imageId");
                    long groupId = rs.getLong("groupId");
                    companyId = rs.getLong("companyId");
                    long userId = rs.getLong("userId");
                    String userName = rs.getString("userName");
                    Timestamp createDate = rs.getTimestamp("createDate");
                    Timestamp modifiedDate = rs.getTimestamp("modifiedDate");
                    long folderId = rs.getLong("folderId");
                    String title = rs.getString("name");
                    String description = rs.getString("description");
                    long smallImageId = rs.getLong("smallImageId");
                    long largeImageId = rs.getLong("largeImageId");
                    long custom1ImageId = rs.getLong("custom1ImageId");
                    long custom2ImageId = rs.getLong("custom2ImageId");
                    Image image = this.getImage(largeImageId);
                    if (image == null) continue;
                    String extension = image.getType();
                    String mimeType = MimeTypesUtil.getExtensionContentType((String)extension);
                    String name = String.valueOf(this.increment("com.liferay.portlet.documentlibrary.model.DLFileEntry"));
                    long size = image.getSize();
                    try {
                        this.addDLFileEntry(uuid, imageId, groupId, companyId, userId, userName, userId, userName, createDate, modifiedDate, groupId, folderId, name, extension, mimeType, title, description, "", fileEntryTypeId, "1.0", size, 0, smallImageId, largeImageId, custom1ImageId, custom2ImageId);
                    }
                    catch (Exception e) {
                        title = title.concat(" ").concat(String.valueOf(imageId));
                        this.addDLFileEntry(uuid, imageId, groupId, companyId, userId, userName, userId, userName, createDate, modifiedDate, groupId, folderId, name, extension, mimeType, title, description, "", fileEntryTypeId, "1.0", size, 0, smallImageId, largeImageId, custom1ImageId, custom2ImageId);
                    }
                    this.addDLFileVersion(this.increment(), groupId, companyId, userId, userName, createDate, groupId, folderId, imageId, extension, mimeType, title, description, "", "", fileEntryTypeId, "1.0", size, 0, userId, userName, modifiedDate);
                }
            }
        }
    }

    protected boolean updateIGImageFolderId(long groupId, String name, long parentFolderId, long folderId, Map<Long, Long> folderIds) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement("select folderId from DLFolder where groupId = " + groupId + " and parentFolderId = " + parentFolderId + " and name = ?");){
            ps.setString(1, name);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    long newFolderId = rs.getLong("folderId");
                    this.runSQL("update IGImage set folderId = " + newFolderId + " where folderId = " + folderId);
                    folderIds.put(folderId, newFolderId);
                    boolean bl = true;
                    return bl;
                }
            }
        }
        return false;
    }

    protected void updateIGImagePermissions() throws Exception {
        try (LoggingTimer loggingTimer = new LoggingTimer();){
            this.deleteConflictingIGPermissions(_IG_IMAGE_CLASS_NAME, "com.liferay.portlet.documentlibrary.model.DLFileEntry");
            this.updateIGtoDLPermissions(_IG_IMAGE_CLASS_NAME, "com.liferay.portlet.documentlibrary.model.DLFileEntry");
        }
    }

    protected void updateIGtoDLPermissions(String igResourceName, String dlResourceName) throws Exception {
        Map<String, Long> igBitwiseValues = this.getBitwiseValues(igResourceName);
        if (igBitwiseValues.isEmpty()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Resource actions do not exist for " + igResourceName));
            }
            return;
        }
        Map<String, Long> dlBitwiseValues = this.getBitwiseValues(dlResourceName);
        if (dlBitwiseValues.isEmpty()) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Resource actions do not exist for " + dlResourceName));
            }
            return;
        }
        int i = 0;
        while ((double)i < Math.pow(2.0, igBitwiseValues.size())) {
            List<String> igActionIds = this.getResourceActionIds(igBitwiseValues, i);
            if (igResourceName.equals(_IG_FOLDER_CLASS_NAME)) {
                Collections.replaceAll(igActionIds, "ADD_IMAGE", "ADD_DOCUMENT");
            }
            long dlActionIdsLong = this.getBitwiseValue(dlBitwiseValues, igActionIds);
            this.runSQL("update ResourcePermission set name = '" + dlResourceName + "', actionIds = " + dlActionIdsLong + " where name = '" + igResourceName + "'" + " and actionIds = " + i);
            ++i;
        }
    }
}

