/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.template;

import com.liferay.portal.kernel.security.pacl.NotPrivileged;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.template.BaseTemplateManager;
import com.liferay.portal.template.PrivilegedTemplateWrapper;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.util.List;
import java.util.Map;

public abstract class BaseSingleTemplateManager
extends BaseTemplateManager {
    @NotPrivileged
    public Template getTemplate(List<TemplateResource> templateResources, boolean restricted) {
        return this.getTemplate(templateResources, null, restricted);
    }

    @NotPrivileged
    public Template getTemplate(List<TemplateResource> templateResources, TemplateResource errorTemplateResource, boolean restricted) {
        throw new UnsupportedOperationException("Template type does not support multi templates");
    }

    @NotPrivileged
    public Template getTemplate(TemplateResource templateResource, boolean restricted) {
        return this.getTemplate(templateResource, null, restricted);
    }

    @NotPrivileged
    public Template getTemplate(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted) {
        AccessControlContext accessControlContext = this.getAccessControlContext();
        if (accessControlContext == null) {
            return this.doGetTemplate(templateResource, errorTemplateResource, restricted, this.getHelperUtilities(restricted), false);
        }
        Map<String, Object> helperUtilities = AccessController.doPrivileged(new BaseTemplateManager.DoGetHelperUtilitiesPrivilegedAction(this, this.templateContextHelper, this.getTemplateControlContextClassLoader(), restricted), accessControlContext);
        Template template = AccessController.doPrivileged(new DoGetSingleTemplatePrivilegedAction(templateResource, errorTemplateResource, restricted, helperUtilities));
        return new PrivilegedTemplateWrapper(accessControlContext, template);
    }

    protected abstract Template doGetTemplate(TemplateResource var1, TemplateResource var2, boolean var3, Map<String, Object> var4, boolean var5);

    protected class DoGetSingleTemplatePrivilegedAction
    extends BaseTemplateManager.DoGetAbstractTemplatePrivilegedAction {
        private final TemplateResource _templateResource;

        public DoGetSingleTemplatePrivilegedAction(TemplateResource templateResource, TemplateResource errorTemplateResource, boolean restricted, Map<String, Object> helperUtilities) {
            super(BaseSingleTemplateManager.this, errorTemplateResource, restricted, helperUtilities);
            this._templateResource = templateResource;
        }

        @Override
        public Template run() {
            return BaseSingleTemplateManager.this.doGetTemplate(this._templateResource, this.errorTemplateResource, this.restricted, this.helperUtilities, true);
        }
    }
}

