/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.nio.intraband.proxy;

import com.liferay.portal.kernel.nio.intraband.RegistrationReference;
import com.liferay.portal.kernel.resiliency.spi.SPI;
import com.liferay.portal.kernel.resiliency.spi.SPIRegistryUtil;
import com.liferay.portal.nio.intraband.proxy.StubHolder;
import com.liferay.portal.nio.intraband.proxy.StubMap;
import java.rmi.RemoteException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class StubMapImpl<T>
extends ConcurrentHashMap<String, T>
implements StubMap<T> {
    private final StubHolder.StubCreator<T> _stubCreator;
    private final ConcurrentMap<String, StubHolder<T>> _stubHolders = new ConcurrentHashMap<String, StubHolder<T>>();

    public StubMapImpl(StubHolder.StubCreator<T> stubCreator) {
        this._stubCreator = stubCreator;
    }

    @Override
    public T get(Object key) {
        String portletId = String.valueOf(key);
        StubHolder stubHolder = (StubHolder)this._stubHolders.get(portletId);
        if (stubHolder != null) {
            return stubHolder.getStub();
        }
        Object originalValue = super.get(key);
        if (originalValue == null) {
            return null;
        }
        RegistrationReference registrationReference = this._getRegistrationReference(portletId);
        if (registrationReference == null) {
            return (T)originalValue;
        }
        stubHolder = new StubHolder(originalValue, portletId, registrationReference, this._stubCreator);
        StubHolder previousStubHolder = this._stubHolders.putIfAbsent(portletId, stubHolder);
        if (previousStubHolder != null) {
            stubHolder = previousStubHolder;
        }
        return (T)stubHolder.getStub();
    }

    @Override
    public boolean removeStubHolder(String portletId, T stub) {
        return this._stubHolders.remove(portletId, stub);
    }

    private RegistrationReference _getRegistrationReference(String portletId) {
        SPI spi = SPIRegistryUtil.getPortletSPI((String)portletId);
        if (spi == null) {
            return null;
        }
        try {
            return spi.getRegistrationReference();
        }
        catch (RemoteException re) {
            throw new RuntimeException(re);
        }
    }
}

