/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.interval;

import com.liferay.portal.kernel.exception.PortalException;

public class IntervalActionProcessor<T> {
    public static final int INTERVAL_DEFAULT = 100;
    private final int _interval;
    private PerformIntervalActionMethod<T> _performIntervalActionMethod;
    private int _start;
    private final int _total;

    public IntervalActionProcessor(int total) {
        if (total < 0) {
            throw new IllegalArgumentException("Total " + total + " is less than zero");
        }
        this._total = total;
        this._interval = 100;
    }

    public IntervalActionProcessor(int total, int interval) {
        if (total < 0) {
            throw new IllegalArgumentException("Total " + total + " is less than zero");
        }
        if (interval <= 0) {
            throw new IllegalArgumentException("Interval " + interval + " is less than or equal to zero");
        }
        this._total = total;
        this._interval = interval;
    }

    public void incrementStart() {
        ++this._start;
    }

    public void incrementStart(int increment) {
        if (increment < 0) {
            throw new IllegalArgumentException("Increment " + increment + " is less than zero");
        }
        this._start += increment;
    }

    public T performIntervalActions() throws PortalException {
        if (this._total == 0) {
            return null;
        }
        int pages = this._total / this._interval;
        for (int i = 0; i <= pages; ++i) {
            T result;
            int end = this._start + this._interval;
            if (end > this._total) {
                end = this._total;
            }
            if ((result = this.performIntervalActions(this._start, end)) == null) continue;
            return result;
        }
        return null;
    }

    public void setPerformIntervalActionMethod(PerformIntervalActionMethod<T> performIntervalActionMethod) {
        this._performIntervalActionMethod = performIntervalActionMethod;
    }

    protected T performIntervalActions(int start, int end) throws PortalException {
        if (this._performIntervalActionMethod != null) {
            return this._performIntervalActionMethod.performIntervalAction(start, end);
        }
        return null;
    }

    public static interface PerformIntervalActionMethod<T> {
        public T performIntervalAction(int var1, int var2) throws PortalException;
    }
}

