/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.wsdd.builder;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.xml.SAXReaderFactory;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;

public class WSDDMerger {
    public static void main(String[] args) {
        new WSDDMerger(args[0], args[1]);
    }

    public static void merge(String source, String destination) throws DocumentException, IOException {
        String name;
        File sourceFile = new File(source);
        SAXReader saxReader = WSDDMerger._getSAXReader();
        Document document = saxReader.read(sourceFile);
        Element rootElement = document.getRootElement();
        List sourceServiceElements = rootElement.elements("service");
        if (sourceServiceElements.isEmpty()) {
            return;
        }
        File destinationFile = new File(destination);
        document = saxReader.read(destinationFile);
        String oldContent = Dom4jUtil.toString((Node)document);
        rootElement = document.getRootElement();
        TreeMap<String, Element> servicesMap = new TreeMap<String, Element>();
        List serviceElements = rootElement.elements("service");
        for (Element element : serviceElements) {
            name = element.attributeValue("name");
            servicesMap.put(name, element);
            element.detach();
        }
        for (Element element : sourceServiceElements) {
            name = element.attributeValue("name");
            servicesMap.put(name, element);
            element.detach();
        }
        for (Map.Entry entry : servicesMap.entrySet()) {
            Element serviceElement = (Element)entry.getValue();
            rootElement.add(serviceElement);
        }
        String content = Dom4jUtil.toString((Node)document);
        if (!content.equals(oldContent)) {
            content = StringUtil.replace(content, "\"/>", "\" />");
            Files.write(destinationFile.toPath(), content.getBytes("UTF-8"), new OpenOption[0]);
        }
    }

    public WSDDMerger(String source, String destination) {
        try {
            WSDDMerger.merge(source, destination);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static SAXReader _getSAXReader() {
        return SAXReaderFactory.getSAXReader(null, false, false);
    }
}

