/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogSanitizerException;
import com.liferay.portal.kernel.log.LogWrapper;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemProperties;
import java.util.ArrayList;

public class SanitizerLogWrapper
extends LogWrapper {
    protected static final String CRLF_WARNING = "SanitizerLogWrapper warning: Following message contains CRLF characters\n";
    private static final String _LESS_THAN_ESCAPED = "&lt;";
    private static final boolean _LOG_SANITIZER_ENABLED = GetterUtil.getBoolean(SystemProperties.get("log.sanitizer.enabled"));
    private static final String _SANITIZED = " [Sanitized]";
    private static boolean _logSanitizerEscapeHTMLEnabled;
    private static char _logSanitizerReplacementCharacter;
    private static final int[] _whitelistCharacters;
    private boolean _allowCRLF;

    public static Log allowCRLF(Log log) {
        if (!(log instanceof SanitizerLogWrapper)) {
            return log;
        }
        SanitizerLogWrapper sanitizerLogWrapper = (SanitizerLogWrapper)log;
        sanitizerLogWrapper = new SanitizerLogWrapper(sanitizerLogWrapper.getWrappedLog());
        sanitizerLogWrapper._allowCRLF = true;
        return sanitizerLogWrapper;
    }

    public static void init() {
        int[] whitelistCharacters;
        if (!_LOG_SANITIZER_ENABLED) {
            return;
        }
        _logSanitizerEscapeHTMLEnabled = GetterUtil.getBoolean(SystemProperties.get("log.sanitizer.escape.html.enabled"));
        _logSanitizerReplacementCharacter = (char)GetterUtil.getInteger(SystemProperties.get("log.sanitizer.replacement.character"));
        for (int i = 0; i < _whitelistCharacters.length; ++i) {
            SanitizerLogWrapper._whitelistCharacters[i] = 1;
        }
        for (int whitelistCharacter : whitelistCharacters = GetterUtil.getIntegerValues(StringUtil.split(SystemProperties.get("log.sanitizer.whitelist.characters")))) {
            if (whitelistCharacter >= 0 && whitelistCharacter < _whitelistCharacters.length) {
                SanitizerLogWrapper._whitelistCharacters[whitelistCharacter] = 0;
                continue;
            }
            System.err.println("Unable to register log whitelist character " + whitelistCharacter);
        }
    }

    public static boolean isEnabled() {
        return _LOG_SANITIZER_ENABLED;
    }

    public SanitizerLogWrapper(Log log) {
        super(log);
        this.setLogWrapperClassName(SanitizerLogWrapper.class.getName());
    }

    @Override
    public void debug(Object msg) {
        super.debug(this.sanitize(msg));
    }

    @Override
    public void debug(Object msg, Throwable t) {
        super.debug(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void debug(Throwable t) {
        super.debug(this.sanitize(t));
    }

    @Override
    public void error(Object msg) {
        super.error(this.sanitize(msg));
    }

    @Override
    public void error(Object msg, Throwable t) {
        super.error(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void error(Throwable t) {
        super.error(this.sanitize(t));
    }

    @Override
    public void fatal(Object msg) {
        super.fatal(this.sanitize(msg));
    }

    @Override
    public void fatal(Object msg, Throwable t) {
        super.fatal(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void fatal(Throwable t) {
        super.fatal(this.sanitize(t));
    }

    @Override
    public void info(Object msg) {
        super.info(this.sanitize(msg));
    }

    @Override
    public void info(Object msg, Throwable t) {
        super.info(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void info(Throwable t) {
        super.info(this.sanitize(t));
    }

    @Override
    public void trace(Object msg) {
        super.trace(this.sanitize(msg));
    }

    @Override
    public void trace(Object msg, Throwable t) {
        super.trace(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void trace(Throwable t) {
        super.trace(this.sanitize(t));
    }

    @Override
    public void warn(Object msg) {
        super.warn(this.sanitize(msg));
    }

    @Override
    public void warn(Object msg, Throwable t) {
        super.warn(this.sanitize(msg), this.sanitize(t));
    }

    @Override
    public void warn(Throwable t) {
        super.warn(this.sanitize(t));
    }

    protected String sanitize(Object obj) {
        if (obj == null) {
            return null;
        }
        String message = obj.toString();
        return this.sanitize(message, message);
    }

    protected String sanitize(String message, String defaultResult) {
        if (message == null) {
            return null;
        }
        char[] chars = message.toCharArray();
        boolean hasCRLF = false;
        boolean hasLessThanCharacter = false;
        boolean sanitized = false;
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (this._allowCRLF && (c == '\n' || c == '\r')) {
                hasCRLF = true;
                continue;
            }
            if (c >= '\u0000' && c < _whitelistCharacters.length && _whitelistCharacters[c] != 0) {
                chars[i] = _logSanitizerReplacementCharacter;
                sanitized = true;
            }
            if (c != '<') continue;
            hasLessThanCharacter = true;
        }
        boolean escapeHTML = false;
        if (_logSanitizerEscapeHTMLEnabled && hasLessThanCharacter) {
            escapeHTML = true;
        }
        if (sanitized || escapeHTML || hasCRLF) {
            String sanitizedMessage = new String(chars);
            if (escapeHTML) {
                sanitizedMessage = StringUtil.replace(sanitizedMessage, '<', _LESS_THAN_ESCAPED);
            }
            if (sanitized) {
                sanitizedMessage = sanitizedMessage.concat(_SANITIZED);
            }
            if (hasCRLF) {
                sanitizedMessage = CRLF_WARNING.concat(sanitizedMessage);
            }
            return sanitizedMessage;
        }
        return defaultResult;
    }

    protected Throwable sanitize(Throwable throwable) {
        ArrayList<Throwable> throwables = new ArrayList<Throwable>();
        for (Throwable tempThrowable = throwable; tempThrowable != null; tempThrowable = tempThrowable.getCause()) {
            throwables.add(tempThrowable);
        }
        Throwable resultThrowable = null;
        boolean sanitized = false;
        for (int i = throwables.size() - 1; i > -1; --i) {
            Throwable curThrowable = (Throwable)throwables.get(i);
            String message = curThrowable.toString();
            String sanitizedMessage = this.sanitize(message, null);
            if (!sanitized && sanitizedMessage == null) {
                resultThrowable = curThrowable;
                continue;
            }
            if (sanitizedMessage == null) {
                sanitizedMessage = message;
            }
            sanitized = true;
            resultThrowable = new LogSanitizerException(sanitizedMessage, curThrowable.getStackTrace(), resultThrowable);
        }
        return resultThrowable;
    }

    static {
        _logSanitizerReplacementCharacter = (char)95;
        _whitelistCharacters = new int[128];
    }
}

