/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.wsdd.builder;

import com.liferay.petra.string.CharPool;
import com.liferay.portal.kernel.util.StringUtil;

import java.io.File;

/**
 * @author Andrea Di Giorgi
 */
public class WSDDBuilderInvoker {

	public static WSDDBuilder invoke(
			File baseDir, WSDDBuilderArgs wsddBuilderArgs)
		throws Exception {

		WSDDBuilder wsddBuilder = new WSDDBuilder();

		wsddBuilder.setClassPath(wsddBuilderArgs.getClassPath());
		wsddBuilder.setFileName(
			_getAbsolutePath(baseDir, wsddBuilderArgs.getFileName()));
		wsddBuilder.setOutputPath(
			_getAbsolutePath(baseDir, wsddBuilderArgs.getOutputPath()) + "/");
		wsddBuilder.setServerConfigFileName(
			_getAbsolutePath(
				baseDir, wsddBuilderArgs.getServerConfigFileName()));
		wsddBuilder.setServiceNamespace(wsddBuilderArgs.getServiceNamespace());

		wsddBuilder.build();

		return wsddBuilder;
	}

	private static String _getAbsolutePath(File baseDir, String fileName) {
		File file = new File(baseDir, fileName);

		return StringUtil.replace(
			file.getAbsolutePath(), CharPool.BACK_SLASH, CharPool.SLASH);
	}

}