/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.soy.builder;

import com.beust.jcommander.IUsageFormatter;
import com.beust.jcommander.JCommander;
import com.beust.jcommander.ParameterException;
import com.liferay.portal.tools.soy.builder.commands.Command;
import com.liferay.portal.tools.soy.builder.internal.SoyBuilderArgs;
import java.io.File;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class SoyBuilder {
    public static void main(String[] args) throws Exception {
        SoyBuilderArgs soyBuilderArgs = new SoyBuilderArgs();
        JCommander jCommander = new JCommander(soyBuilderArgs);
        for (Command command : ServiceLoader.load(Command.class)) {
            jCommander.addCommand(command);
        }
        File jarFile = SoyBuilder._getJarFile();
        if (jarFile.isFile()) {
            jCommander.setProgramName("java -jar " + jarFile.getName());
        } else {
            jCommander.setProgramName(SoyBuilder.class.getName());
        }
        try {
            jCommander.parse(args);
            String commandName = jCommander.getParsedCommand();
            if (soyBuilderArgs.isHelp() || commandName == null) {
                SoyBuilder._printHelp(jCommander);
            } else {
                Map<String, JCommander> commandJCommanders = jCommander.getCommands();
                JCommander commandJCommander = commandJCommanders.get(commandName);
                List<Object> commandObjects = commandJCommander.getObjects();
                Command command = (Command)commandObjects.get(0);
                command.execute();
            }
        }
        catch (ParameterException parameterException) {
            if (!soyBuilderArgs.isHelp()) {
                System.err.println(parameterException.getMessage());
            }
            SoyBuilder._printHelp(jCommander);
        }
    }

    private static File _getJarFile() throws Exception {
        ProtectionDomain protectionDomain = SoyBuilder.class.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URL url = codeSource.getLocation();
        return new File(url.toURI());
    }

    private static void _printHelp(JCommander jCommander) {
        String commandName = jCommander.getParsedCommand();
        if (commandName == null) {
            jCommander.usage();
        } else {
            IUsageFormatter iUsageFormatter = jCommander.getUsageFormatter();
            iUsageFormatter.usage(commandName);
        }
    }
}

