/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.petra.lang;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class ClassLoaderPool {
    private static final Map<String, ClassLoader> _classLoaders = new ConcurrentHashMap<String, ClassLoader>();
    private static final Map<ClassLoader, String> _contextNames = new ConcurrentHashMap<ClassLoader, String>();
    private static final Map<String, ConcurrentNavigableMap<Version, ClassLoader>> _fallbackClassLoaders = new ConcurrentHashMap<String, ConcurrentNavigableMap<Version, ClassLoader>>();

    public static ClassLoader getClassLoader(String contextName) {
        Map.Entry entry;
        ConcurrentNavigableMap<Version, ClassLoader> classLoaders;
        int index;
        ClassLoader classLoader = null;
        if (contextName != null && !contextName.equals("null") && (classLoader = _classLoaders.get(contextName)) == null && (index = contextName.lastIndexOf(95)) > 0 && (classLoaders = _fallbackClassLoaders.get(contextName.substring(0, index))) != null && (entry = classLoaders.lastEntry()) != null) {
            classLoader = (ClassLoader)entry.getValue();
        }
        if (classLoader == null) {
            Thread currentThread = Thread.currentThread();
            classLoader = currentThread.getContextClassLoader();
        }
        return classLoader;
    }

    public static String getContextName(ClassLoader classLoader) {
        if (classLoader == null) {
            return "null";
        }
        String contextName = _contextNames.get(classLoader);
        if (contextName == null) {
            contextName = "null";
        }
        return contextName;
    }

    public static void register(String contextName, ClassLoader classLoader) {
        _classLoaders.put(contextName, classLoader);
        _contextNames.put(classLoader, contextName);
        Map.Entry<String, Version> entry = ClassLoaderPool._parseContextName(contextName);
        if (entry == null) {
            return;
        }
        _fallbackClassLoaders.compute(entry.getKey(), (key, classLoaders) -> {
            if (classLoaders == null) {
                classLoaders = new ConcurrentSkipListMap();
            }
            classLoaders.put(entry.getValue(), classLoader);
            return classLoaders;
        });
    }

    public static void unregister(ClassLoader classLoader) {
        String contextName = _contextNames.remove(classLoader);
        if (contextName != null) {
            _classLoaders.remove(contextName);
            ClassLoaderPool._unregisterFallback(contextName);
        }
    }

    public static void unregister(String contextName) {
        ClassLoader classLoader = _classLoaders.remove(contextName);
        if (classLoader != null) {
            _contextNames.remove(classLoader);
            ClassLoaderPool._unregisterFallback(contextName);
        }
    }

    private static Map.Entry<String, Version> _parseContextName(String contextName) {
        Version version;
        int index = contextName.lastIndexOf(95);
        if (index > 0 && index < contextName.length() - 1 && (version = ClassLoaderPool._parseVersion(contextName.substring(index + 1))) != null) {
            return new AbstractMap.SimpleImmutableEntry<String, Version>(contextName.substring(0, index), version);
        }
        return null;
    }

    private static Version _parseVersion(String version) {
        int major = 0;
        int minor = 0;
        int micro = 0;
        String qualifier = "";
        List<String> parts = ClassLoaderPool._split(version);
        int size = parts.size();
        try {
            if (size >= 1) {
                major = Integer.parseInt(parts.get(0));
            }
            if (size >= 2) {
                minor = Integer.parseInt(parts.get(1));
            }
            if (size >= 3) {
                micro = Integer.parseInt(parts.get(2));
            }
            if (size >= 4) {
                qualifier = parts.get(3);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return new Version(major, minor, micro, qualifier);
    }

    private static List<String> _split(String s) {
        int pos;
        ArrayList<String> values = new ArrayList<String>();
        int offset = 0;
        while ((pos = s.indexOf(46, offset)) != -1) {
            if (offset < pos) {
                values.add(s.substring(offset, pos));
            }
            offset = pos + 1;
        }
        if (offset < s.length()) {
            values.add(s.substring(offset));
        }
        return values;
    }

    private static void _unregisterFallback(String contextName) {
        Map.Entry<String, Version> entry = ClassLoaderPool._parseContextName(contextName);
        if (entry == null) {
            return;
        }
        _fallbackClassLoaders.computeIfPresent(entry.getKey(), (key, classLoaders) -> {
            classLoaders.remove(entry.getValue());
            if (classLoaders.isEmpty()) {
                return null;
            }
            return classLoaders;
        });
    }

    static {
        ClassLoaderPool.register("GlobalClassLoader", ClassLoaderPool.class.getClassLoader());
        ClassLoaderPool.register("SystemClassLoader", ClassLoader.getSystemClassLoader());
    }

    private static class Version
    implements Comparable<Version> {
        private final int _major;
        private final int _micro;
        private final int _minor;
        private final String _qualifier;

        @Override
        public int compareTo(Version version) {
            if (version == this) {
                return 0;
            }
            int result = this._major - version._major;
            if (result != 0) {
                return result;
            }
            result = this._minor - version._minor;
            if (result != 0) {
                return result;
            }
            result = this._micro - version._micro;
            if (result != 0) {
                return result;
            }
            return this._qualifier.compareTo(version._qualifier);
        }

        private Version(int major, int minor, int micro, String qualifier) {
            this._major = major;
            this._minor = minor;
            this._micro = micro;
            this._qualifier = qualifier;
        }
    }
}

