<#setting number_format = "0">

<#assign parentPKColumn = "" />

<#if entity.isHierarchicalTree()>
	<#assign
		pkEntityColumn = entity.PKEntityColumns?first

		parentPKColumn = entity.getEntityColumn("parent" + pkEntityColumn.methodName)
	/>
</#if>

package ${packagePath}.model.impl;

import ${serviceBuilder.getCompatJavaClassName("StringBundler")};

<#if entity.hasCompoundPK()>
	import ${apiPackagePath}.service.persistence.${entity.name}PK;
</#if>

import ${apiPackagePath}.model.${entity.name};
import ${apiPackagePath}.model.${entity.name}Model;
import ${apiPackagePath}.model.${entity.name}Soap;

<#assign hasLazy = false />

<#list entity.blobEntityColumns as entityColumn>
	<#if entityColumn.lazy>
		import ${apiPackagePath}.model.${entity.name}${entityColumn.methodName}BlobModel;

		<#assign hasLazy = true />
	</#if>
</#list>

<#if entity.localizedEntity??>
	<#assign localizedEntity = entity.localizedEntity />

	import ${apiPackagePath}.model.${localizedEntity.name};
</#if>

<#if entity.versionEntity??>
	<#assign versionEntity = entity.versionEntity />

	import ${apiPackagePath}.model.${versionEntity.name};

<#elseif entity.versionedEntity??>
	<#assign versionedEntity = entity.versionedEntity />

	import ${apiPackagePath}.model.${versionedEntity.name};
</#if>

import ${apiPackagePath}.service.${entity.name}LocalServiceUtil;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.ModelWrapper;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Function;

/**
 * The base model implementation for the ${entity.name} service. Represents a row in the &quot;${entity.table}&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface <code>${apiPackagePath}.model.${entity.name}Model</code> exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ${entity.name}Impl}.
 * </p>
 *
 * @author ${author}
 * @see ${entity.name}Impl
<#if classDeprecated>
 * @deprecated ${classDeprecatedComment}
</#if>
 * @generated
 */

<#if classDeprecated>
	@Deprecated
</#if>

<#if entity.jsonEnabled>
	@JSON(strict = true)
</#if>
public class ${entity.name}ModelImpl extends BaseModelImpl<${entity.name}> implements ${entity.name}Model {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ${entity.humanName} model instance should use the <code>${apiPackagePath}.model.${entity.name}</code> interface instead.
	 */

	public static final String TABLE_NAME = "${entity.table}";

	<#compress>
		public static final Object[][] TABLE_COLUMNS = {
			<#list entity.databaseRegularEntityColumns as entityColumn>
				<#assign sqlType = serviceBuilder.getSqlType(entity.getName(), entityColumn) />

				{"${entityColumn.DBName}", Types.${sqlType}}

				<#if entityColumn_has_next>
					,
				</#if>
			</#list>
		};

		public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

		static {
			<#list entity.databaseRegularEntityColumns as entityColumn>
				<#assign sqlType = serviceBuilder.getSqlType(entity.getName(), entityColumn) />

				TABLE_COLUMNS_MAP.put("${entityColumn.DBName}", Types.${sqlType});
			</#list>
		}
	</#compress>

	public static final String TABLE_SQL_CREATE = "${serviceBuilder.getCreateTableSQL(entity)}";

	public static final String TABLE_SQL_DROP = "drop table ${entity.table}";

	<#if entity.entityOrder??>
		<#assign orderList = entity.entityOrder.entityColumns />
	<#else>
		<#assign orderList = entity.PKEntityColumns />
	</#if>

	<#assign orderByJPQL = "" />

	<#list orderList as order>
		<#if entity.hasCompoundPK() && order.isPrimary()>
			<#assign orderByJPQL = orderByJPQL + entity.alias + ".id." + order.name />
		<#else>
			<#assign orderByJPQL = orderByJPQL + entity.alias + "." + order.name />
		</#if>

		<#if order.isOrderByAscending()>
			<#assign orderByJPQL = orderByJPQL + " ASC" />
		<#else>
			<#assign orderByJPQL = orderByJPQL + " DESC" />
		</#if>

		<#if order_has_next>
			<#assign orderByJPQL = orderByJPQL + ", " />
		</#if>
	</#list>

	public static final String ORDER_BY_JPQL = " ORDER BY ${orderByJPQL}";

	<#assign orderBySQL = "" />

	<#list orderList as order>
		<#assign orderBySQL = orderBySQL + entity.table + "." + order.DBName />

		<#if order.isOrderByAscending()>
			<#assign orderBySQL = orderBySQL + " ASC" />
		<#else>
			<#assign orderBySQL = orderBySQL + " DESC" />
		</#if>

		<#if order_has_next>
			<#assign orderBySQL = orderBySQL + ", " />
		</#if>
	</#list>

	public static final String ORDER_BY_SQL = " ORDER BY ${orderBySQL}";

	<#if entity.isPermissionCheckEnabled() && serviceBuilder.isVersionGTE_7_4_0()>
		<#assign orderBySQLInlineDistinct = "" />

		<#list orderList as order>
			<#assign orderBySQLInlineDistinct = orderBySQLInlineDistinct + entity.alias + "." + order.DBName />

			<#if order.isOrderByAscending()>
				<#assign orderBySQLInlineDistinct = orderBySQLInlineDistinct + " ASC" />
			<#else>
				<#assign orderBySQLInlineDistinct = orderBySQLInlineDistinct + " DESC" />
			</#if>

			<#if order_has_next>
				<#assign orderBySQLInlineDistinct = orderBySQLInlineDistinct + ", " />
			</#if>
		</#list>

		public static final String ORDER_BY_SQL_INLINE_DISTINCT = " ORDER BY ${orderBySQLInlineDistinct}";
	</#if>

	public static final String DATA_SOURCE = "${entity.dataSource}";

	public static final String SESSION_FACTORY = "${entity.sessionFactory}";

	public static final String TX_MANAGER = "${entity.getTXManager()}";

	<#if serviceBuilder.isVersionGTE_7_3_0()>
		<#assign columnBitmaskEnabled = (entity.databaseRegularEntityColumns?size &lt; 64) && !entity.hasEagerBlobColumn() />
	<#else>
		<#assign columnBitmaskEnabled = (entity.finderEntityColumns?size &gt; 0) && (entity.finderEntityColumns?size &lt; 64) && !entity.hasEagerBlobColumn() />
	</#if>

	<#if !dependencyInjectorDS>
		<#if serviceBuilder.isVersionGTE_7_3_0()>
			/**
			* @deprecated As of Athanasius (7.3.x), with no direct replacement
			*/
			@Deprecated
		</#if>
		public static final boolean ENTITY_CACHE_ENABLED =
		<#if entity.hasEagerBlobColumn()>
			false;
		<#elseif serviceBuilder.isVersionGTE_7_3_0()>
			true;
		<#else>
			GetterUtil.getBoolean(${propsUtil}.get("value.object.entity.cache.enabled.${apiPackagePath}.model.${entity.name}"),
			<#if entity.isCacheEnabled()>
				true
			<#else>
				false
			</#if>

			);
		</#if>

		<#if serviceBuilder.isVersionGTE_7_3_0()>
			/**
			* @deprecated As of Athanasius (7.3.x), with no direct replacement
			*/
			@Deprecated
		</#if>
		public static final boolean FINDER_CACHE_ENABLED =
		<#if entity.hasEagerBlobColumn()>
			false;
		<#elseif serviceBuilder.isVersionGTE_7_3_0()>
			true;
		<#else>
			GetterUtil.getBoolean(${propsUtil}.get("value.object.finder.cache.enabled.${apiPackagePath}.model.${entity.name}"),

			<#if entity.isCacheEnabled()>
				true
			<#else>
				false
			</#if>

			);
		</#if>
		<#if !entity.hasEagerBlobColumn()>
			<#if serviceBuilder.isVersionGTE_7_3_0()>
				/**
				* @deprecated As of Athanasius (7.3.x), with no direct replacement
				*/
				@Deprecated
			</#if>
			public static final boolean COLUMN_BITMASK_ENABLED =
			<#if columnBitmaskEnabled && serviceBuilder.isVersionGTE_7_3_0()>
				true;
			<#elseif (entity.finderEntityColumns?size == 0) || (entity.finderEntityColumns?size &gt; 64)>
				false;
			<#else>
				GetterUtil.getBoolean(${propsUtil}.get("value.object.column.bitmask.enabled.${apiPackagePath}.model.${entity.name}"), true);
			</#if>
		</#if>
	</#if>

	<#if columnBitmaskEnabled>
		<#assign columnBitmask = 1 />

		<#list entity.finderEntityColumns as entityColumn>
			<#if serviceBuilder.isVersionGTE_7_3_0()>
				/**
				 * @deprecated As of Athanasius (7.3.x), replaced by {@link #getColumnBitmask(String)}
				 */
				@Deprecated
			</#if>
			public static final long ${entityColumn.name?upper_case}_COLUMN_BITMASK = ${columnBitmask}L;

			<#assign columnBitmask = columnBitmask * 2 />
		</#list>

		<#list orderList as order>
			<#if !entity.finderEntityColumns?seq_contains(order)>
				<#if serviceBuilder.isVersionGTE_7_3_0()>
					/**
					* @deprecated As of Athanasius (7.3.x), replaced by {@link
					*		#getColumnBitmask(String)}
					*/
					@Deprecated
				</#if>
				public static final long ${order.name?upper_case}_COLUMN_BITMASK = ${columnBitmask}L;

				<#assign columnBitmask = columnBitmask * 2 />
			</#if>
		</#list>
	</#if>

	<#if dependencyInjectorDS>
		<#if serviceBuilder.isVersionGTE_7_3_0()>
			/**
			* @deprecated As of Athanasius (7.3.x), with no direct replacement
			*/
			@Deprecated
		</#if>
		public static void setEntityCacheEnabled(boolean entityCacheEnabled) {
			<#if serviceBuilder.isVersionLTE_7_2_0() && !entity.hasEagerBlobColumn()>
				_entityCacheEnabled = entityCacheEnabled;
			</#if>
		}

		<#if serviceBuilder.isVersionGTE_7_3_0()>
			/**
			* @deprecated As of Athanasius (7.3.x), with no direct replacement
			*/
			@Deprecated
		</#if>
		public static void setFinderCacheEnabled(boolean finderCacheEnabled) {
			<#if serviceBuilder.isVersionLTE_7_2_0() && !entity.hasEagerBlobColumn()>
				_finderCacheEnabled = finderCacheEnabled;
			</#if>
		}
	</#if>

	<#if entity.hasRemoteService() && serviceBuilder.isVersionLTE_7_3_0()>
		/**
		 * Converts the soap model instance into a normal model instance.
		 *
		 * @param soapModel the soap model instance to convert
		 * @return the normal model instance
		<#if serviceBuilder.isVersionGTE_7_3_0()>
		 * @deprecated As of Athanasius (7.3.x), with no direct replacement
		 */
		@Deprecated
		<#else>
		 */
		</#if>
		public static ${entity.name} toModel(${entity.name}Soap soapModel) {
			if (soapModel == null) {
				return null;
			}

			${entity.name} model = new ${entity.name}Impl();

			<#list entity.regularEntityColumns as entityColumn>
				<#if stringUtil.equals(entityColumn.type, "boolean")>
					model.set${entityColumn.methodName}(soapModel.is${entityColumn.methodName}());
				<#else>
					model.set${entityColumn.methodName}(soapModel.get${entityColumn.methodName}());
				</#if>
			</#list>

			return model;
		}

		/**
		 * Converts the soap model instances into normal model instances.
		 *
		 * @param soapModels the soap model instances to convert
		 * @return the normal model instances
		<#if serviceBuilder.isVersionGTE_7_3_0()>
		 * @deprecated As of Athanasius (7.3.x), with no direct replacement
		 */
		@Deprecated
		<#else>
		 */
		</#if>
		public static List<${entity.name}> toModels(${entity.name}Soap[] soapModels) {
			if (soapModels == null) {
				return null;
			}

			List<${entity.name}> models = new ArrayList<${entity.name}>(soapModels.length);

			for (${entity.name}Soap soapModel : soapModels) {
				models.add(toModel(soapModel));
			}

			return models;
		}
	</#if>

	<#list entity.entityColumns as entityColumn>
		<#if entityColumn.mappingTableName??>
			<#assign entityShortName = stringUtil.shorten(entity.name, 9, "") />

			public static final String MAPPING_TABLE_${stringUtil.upperCase(entityColumn.mappingTableName)}_NAME = "${entityColumn.mappingTableName}";

			<#compress>
				public static final Object[][] MAPPING_TABLE_${stringUtil.upperCase(entityColumn.mappingTableName)}_COLUMNS = {
					<#assign mappingEntities = serviceBuilder.getMappingEntities(entityColumn.mappingTableName) />

					<#list mappingEntities?keys as mapEntityName>
						<#list mappingEntities[mapEntityName] as mapColumn>
							<#assign sqlType = serviceBuilder.getSqlType(mapEntityName, mapColumn) />

							{"${mapColumn.DBName}", Types.${sqlType}}

							<#if mapEntityName_has_next || mapColumn_has_next>
								,
							</#if>
						</#list>
					</#list>
				};
			</#compress>

			public static final String MAPPING_TABLE_${stringUtil.upperCase(entityColumn.mappingTableName)}_SQL_CREATE = "${serviceBuilder.getCreateMappingTableSQL(serviceBuilder.getEntityMapping(entityColumn.mappingTableName))}";

			<#if !dependencyInjectorDS>
				<#if serviceBuilder.isVersionGTE_7_3_0()>
					/**
					* @deprecated As of Athanasius (7.3.x), with no direct replacement
					*/
					@Deprecated
				</#if>
				public static final boolean FINDER_CACHE_ENABLED_${stringUtil.upperCase(entityColumn.mappingTableName)} =
				  	<#if serviceBuilder.isVersionGTE_7_3_0()>
						true;
					<#else>
						GetterUtil.getBoolean(${propsUtil}.get("value.object.finder.cache.enabled.${entityColumn.mappingTableName}"), true);
					</#if>
			</#if>
		</#if>
	</#list>

	<#if !dependencyInjectorDS>
		public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(${propsUtil}.get("lock.expiration.time.${apiPackagePath}.model.${entity.name}"));
	</#if>

	public ${entity.name}ModelImpl() {
	}

	@Override
	public ${entity.PKClassName} getPrimaryKey() {
		<#if entity.hasCompoundPK()>
			return new ${entity.PKClassName}(

			<#list entity.PKEntityColumns as entityColumn>
				_${entityColumn.name}

				<#if entityColumn_has_next>
					,
				</#if>
			</#list>

			);
		<#else>
			return _${entity.PKEntityColumns[0].name};
		</#if>
	}

	@Override
	public void setPrimaryKey(${entity.PKClassName} primaryKey) {
		<#if entity.hasCompoundPK()>
			<#list entity.PKEntityColumns as entityColumn>
				set${entityColumn.methodName}(primaryKey.${entityColumn.name});
			</#list>
		<#else>
			set${entity.PKEntityColumns[0].methodName}(primaryKey);
		</#if>
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		<#if entity.hasCompoundPK()>
			return new ${entity.PKClassName}(

			<#list entity.PKEntityColumns as entityColumn>
				_${entityColumn.name}

				<#if entityColumn_has_next>
					,
				</#if>
			</#list>

			);
		<#else>
			return _${entity.PKEntityColumns[0].name};
		</#if>
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(

		<#if entity.hasPrimitivePK()>
			((${serviceBuilder.getPrimitiveObj("${entity.PKClassName}")})
		<#else>
			(${entity.PKClassName})
		</#if>

		primaryKeyObj

		<#if entity.hasPrimitivePK()>
			)${serviceBuilder.getPrimitiveObjValue(serviceBuilder.getPrimitiveObj("${entity.PKClassName}"))}
		</#if>

		);
	}

	@Override
	public Class<?> getModelClass() {
		return ${entity.name}.class;
	}

	@Override
	public String getModelClassName() {
		return ${entity.name}.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		Map<String, Function<${entity.name}, Object>> attributeGetterFunctions = getAttributeGetterFunctions();

		for (Map.Entry<String, Function<${entity.name}, Object>> entry : attributeGetterFunctions.entrySet()) {
			String attributeName = entry.getKey();
			Function<${entity.name}, Object> attributeGetterFunction = entry.getValue();

			attributes.put(attributeName, attributeGetterFunction.apply((${entity.name})this));
		}

		<#if serviceBuilder.isVersionLTE_7_2_0()>
			attributes.put("entityCacheEnabled", isEntityCacheEnabled());
			attributes.put("finderCacheEnabled", isFinderCacheEnabled());
		</#if>

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		Map<String, BiConsumer<${entity.name}, Object>> attributeSetterBiConsumers = getAttributeSetterBiConsumers();

		for (Map.Entry<String, Object> entry : attributes.entrySet()) {
			String attributeName = entry.getKey();

			BiConsumer<${entity.name}, Object> attributeSetterBiConsumer =
				attributeSetterBiConsumers.get(attributeName);

			if (attributeSetterBiConsumer != null) {
				attributeSetterBiConsumer.accept((${entity.name})this, entry.getValue());
			}
		}
	}

	public Map<String, Function<${entity.name}, Object>> getAttributeGetterFunctions() {
		return

		<#if serviceBuilder.isVersionGTE_7_4_0()>
			AttributeGetterFunctionsHolder.
		</#if>

		_attributeGetterFunctions;
	}

	public Map<String, BiConsumer<${entity.name}, Object>> getAttributeSetterBiConsumers() {
		return

		<#if serviceBuilder.isVersionGTE_7_4_0()>
			AttributeSetterBiConsumersHolder.
		</#if>

		_attributeSetterBiConsumers;
	}

	<#if serviceBuilder.isVersionLTE_7_1_0()>
		private static Function<InvocationHandler, ${entity.name}> _getProxyProviderFunction() {
			Class<?> proxyClass = ProxyUtil.getProxyClass(${entity.name}.class.getClassLoader(), ${entity.name}.class, ModelWrapper.class);

			try {
				Constructor<${entity.name}> constructor = (Constructor<${entity.name}>)proxyClass.getConstructor(InvocationHandler.class);

				return invocationHandler -> {
					try {
						return constructor.newInstance(invocationHandler);
					}
					catch (ReflectiveOperationException reflectiveOperationException) {
						throw new InternalError(reflectiveOperationException);
					}
				};
			}
			catch (NoSuchMethodException noSuchMethodException) {
				throw new InternalError(noSuchMethodException);
			}
		}
	</#if>

	<#if serviceBuilder.isVersionGTE_7_4_0()>
		private static class AttributeGetterFunctionsHolder {
	</#if>

	private static final Map<String, Function<${entity.name}, Object>> _attributeGetterFunctions;

	static {
		Map<String, Function<${entity.name}, Object>> attributeGetterFunctions = new LinkedHashMap<String, Function<${entity.name}, Object>>();

		<#list entity.regularEntityColumns as entityColumn>
			<#if serviceBuilder.isVersionLTE_7_1_0()>
				attributeGetterFunctions.put(
					"${entityColumn.name}",
					new Function<${entity.name}, Object>() {

						@Override
						public Object apply(${entity.name} ${entity.variableName}) {
							return ${entity.variableName}.get${entityColumn.methodName}();
						}

					});
			<#else>
				attributeGetterFunctions.put("${entityColumn.name}", ${entity.name}::get${entityColumn.methodName});
			</#if>
		</#list>

		_attributeGetterFunctions = Collections.unmodifiableMap(attributeGetterFunctions);
	}

	<#if serviceBuilder.isVersionGTE_7_4_0()>
		}
	</#if>

	<#if serviceBuilder.isVersionGTE_7_4_0()>
		private static class AttributeSetterBiConsumersHolder {
	</#if>

	private static final Map<String, BiConsumer<${entity.name}, Object>> _attributeSetterBiConsumers;

	static {
		Map<String, BiConsumer<${entity.name}, ?>> attributeSetterBiConsumers = new LinkedHashMap<String, BiConsumer<${entity.name}, ?>>();

		<#list entity.regularEntityColumns as entityColumn>
			<#if entityColumn.isPrimitiveType()>
				<#assign entityColumnType = serviceBuilder.getPrimitiveObj(entityColumn.type) />
			<#else>
				<#assign entityColumnType = entityColumn.genericizedType />
			</#if>
			<#if serviceBuilder.isVersionLTE_7_1_0()>
				attributeSetterBiConsumers.put(
					"${entityColumn.name}",
					new BiConsumer<${entity.name}, Object>() {

						@Override
						public void accept(${entity.name} ${entity.variableName}, Object ${entityColumn.name}Object) {
							${entity.variableName}.set${entityColumn.methodName}((${entityColumnType})${entityColumn.name}Object);
						}

					});
			<#else>
				attributeSetterBiConsumers.put("${entityColumn.name}", (BiConsumer<${entity.name}, ${entityColumnType}>)${entity.name}::set${entityColumn.methodName});
			</#if>
		</#list>

		_attributeSetterBiConsumers = Collections.unmodifiableMap((Map)attributeSetterBiConsumers);
	}

	<#if serviceBuilder.isVersionGTE_7_4_0()>
		}
	</#if>

	<#if entity.localizedEntity??>
		<#assign localizedEntity = entity.localizedEntity />

		@Override
		public String[] getAvailableLanguageIds() {
			List<${localizedEntity.name}> ${localizedEntity.pluralVariableName} = ${entity.name}LocalServiceUtil.get${localizedEntity.pluralName}(getPrimaryKey());

			String[] availableLanguageIds = new String[${localizedEntity.pluralVariableName}.size()];

			for (int i = 0; i < availableLanguageIds.length; i++) {
				${localizedEntity.name} ${localizedEntity.variableName} = ${localizedEntity.pluralVariableName}.get(i);

				availableLanguageIds[i] = ${localizedEntity.variableName}.getLanguageId();
			}

			return availableLanguageIds;
		}

		<#list entity.localizedEntityColumns as entityColumn>
			@Override
			public String get${entityColumn.methodName}() {
				return get${entityColumn.methodName}(getDefaultLanguageId(), false);
			}

			@Override
			public String get${entityColumn.methodName}(String languageId) {
				return get${entityColumn.methodName}(languageId, true);
			}

			@Override
			public String get${entityColumn.methodName}(String languageId, boolean useDefault) {
				if (useDefault) {
					return LocalizationUtil.getLocalization(
						new Function<String, String> () {

							@Override
							public String apply(String languageId) {
								return _get${entityColumn.methodName}(languageId);
							}

						},
						languageId, getDefaultLanguageId());
				}

				return _get${entityColumn.methodName}(languageId);
			}

			@Override
			public String get${entityColumn.methodName}MapAsXML() {
				return LocalizationUtil.getXml(getLanguageIdTo${entityColumn.methodName}Map(), getDefaultLanguageId(), "${entityColumn.methodName}");
			}

			@Override
			public Map<String, String> getLanguageIdTo${entityColumn.methodName}Map() {
				Map<String, String> languageIdTo${entityColumn.methodName}Map = new HashMap<String, String>();

				List<${localizedEntity.name}> ${localizedEntity.pluralVariableName} = ${entity.name}LocalServiceUtil.get${localizedEntity.pluralName}(getPrimaryKey());

				for (${localizedEntity.name} ${localizedEntity.variableName} : ${localizedEntity.pluralVariableName}) {
					languageIdTo${entityColumn.methodName}Map.put(${localizedEntity.variableName}.getLanguageId(), ${localizedEntity.variableName}.get${entityColumn.methodName}());
				}

				return languageIdTo${entityColumn.methodName}Map;
			}

			private String _get${entityColumn.methodName}(String languageId) {
				${localizedEntity.name} ${localizedEntity.variableName} = ${entity.name}LocalServiceUtil.fetch${localizedEntity.name}(getPrimaryKey(), languageId);

				if (${localizedEntity.variableName} == null) {
					return "";
				}

				return ${localizedEntity.variableName}.get${entityColumn.methodName}();
			}
		</#list>
	</#if>

	<#if entity.versionEntity??>
		<#assign versionEntity = entity.versionEntity />

		@Override
		public void populateVersionModel(${versionEntity.name} ${versionEntity.variableName}) {
			<#list entity.entityColumns as entityColumn>
				<#if !entityColumn.isPrimary() && !stringUtil.equals(entityColumn.methodName, "HeadId") && !stringUtil.equals(entityColumn.methodName, "MvccVersion") && !entityColumn.isMappingManyToMany()>
					${versionEntity.variableName}.set${entityColumn.methodName}(get${entityColumn.methodName}());
				</#if>
			</#list>
		}
	<#elseif entity.versionedEntity??>
		<#assign
			versionedEntity = entity.versionedEntity
			pkEntityColumn = versionedEntity.PKEntityColumns?first
		/>

		@Override
		public long getVersionedModelId() {
			return get${pkEntityColumn.methodName}();
		}

		@Override
		public void populateVersionedModel(${versionedEntity.name} ${versionedEntity.variableName}) {
			<#list versionedEntity.entityColumns as entityColumn>
				<#if !entityColumn.isPrimary() && !stringUtil.equals(entityColumn.methodName, "HeadId") && !stringUtil.equals(entityColumn.methodName, "MvccVersion") && !entityColumn.isMappingManyToMany()>
					${versionedEntity.variableName}.set${entityColumn.methodName}(get${entityColumn.methodName}());
				</#if>
			</#list>
		}

		@Override
		public void setVersionedModelId(long ${versionedEntity.getPKVariableName()}) {
			set${pkEntityColumn.methodName}(${versionedEntity.getPKVariableName()});
		}

		@Override
		public ${versionedEntity.name} toVersionedModel() {
			${versionedEntity.name} ${versionedEntity.variableName} = new ${versionedEntity.name}Impl();

			${versionedEntity.variableName}.setPrimaryKey(getVersionedModelId());
			${versionedEntity.variableName}.setHeadId(-getVersionedModelId());

			populateVersionedModel(${versionedEntity.variableName});

			return ${versionedEntity.variableName};
		}
	</#if>

	<#list entity.databaseRegularEntityColumns as entityColumn>
		<#if stringUtil.equals(entityColumn.name, "classNameId") && !hasClassNameCacheField>
			@Override
			public String getClassName() {
				if (getClassNameId() <= 0) {
					return "";
				}

				return PortalUtil.getClassName(getClassNameId());
			}

			@Override
			public void setClassName(String className) {
				long classNameId = 0;

				if (Validator.isNotNull(className)) {
					classNameId = PortalUtil.getClassNameId(className);
				}

				setClassNameId(classNameId);
			}
		</#if>

		<#if entityColumn.jsonEnabled>
			@JSON
		<#elseif entity.jsonEnabled>
			@JSON(include = false)
		</#if>

		<#if !entity.versionEntity?? || !stringUtil.equals(entityColumn.name, "head")>
			@Override
		</#if>
		public ${entityColumn.genericizedType} get${entityColumn.methodName}() {
			<#if stringUtil.equals(entityColumn.type, "String") && entityColumn.isConvertNull()>
				if (_${entityColumn.name} == null) {
					return "";
				}
				else {
					return _${entityColumn.name};
				}
			<#else>
				<#if stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy>
					if (_${entityColumn.name}BlobModel == null) {
						try {
							_${entityColumn.name}BlobModel = ${entity.name}LocalServiceUtil.get${entityColumn.methodName}BlobModel(getPrimaryKey());
						}
						catch (Exception exception) {
						}
					}

					Blob blob = null;

					if (_${entityColumn.name}BlobModel != null) {
						blob = _${entityColumn.name}BlobModel.get${entityColumn.methodName}Blob();
					}

					return blob;
				<#else>
					return _${entityColumn.name};
				</#if>
			</#if>
		}

		<#if entityColumn.localized>
			@Override
			public String get${entityColumn.methodName}(Locale locale) {
				String languageId = LocaleUtil.toLanguageId(locale);

				return get${entityColumn.methodName}(languageId);
			}

			@Override
			public String get${entityColumn.methodName}(Locale locale, boolean useDefault) {
				String languageId = LocaleUtil.toLanguageId(locale);

				return get${entityColumn.methodName}(languageId, useDefault);
			}

			@Override
			public String get${entityColumn.methodName}(String languageId) {
				return LocalizationUtil.getLocalization(get${entityColumn.methodName}(), languageId);
			}

			@Override
			public String get${entityColumn.methodName}(String languageId, boolean useDefault) {
				return LocalizationUtil.getLocalization(get${entityColumn.methodName}(), languageId, useDefault);
			}

			@Override
			public String get${entityColumn.methodName}CurrentLanguageId() {
				return _${entityColumn.name}CurrentLanguageId;
			}

			@JSON
			@Override
			public String get${entityColumn.methodName}CurrentValue() {
				Locale locale = getLocale(_${entityColumn.name}CurrentLanguageId);

				return get${entityColumn.methodName}(locale);
			}

			@Override
			public Map<Locale, String> get${entityColumn.methodName}Map() {
				return LocalizationUtil.getLocalizationMap(get${entityColumn.methodName}());
			}
		</#if>

		<#if entityColumn.type== "boolean">
			<#if entityColumn.jsonEnabled>
				@JSON
			</#if>

			@Override
			public ${entityColumn.type} is${entityColumn.methodName}() {
				return _${entityColumn.name};
			}
		</#if>

		<#if entity.hasEntityColumn("modifiedDate", "Date") && stringUtil.equals(entityColumn.name, "modifiedDate")>
			public boolean hasSetModifiedDate() {
				return _setModifiedDate;
			}
		</#if>

		<#if !entity.versionEntity?? || !stringUtil.equals(entityColumn.name, "head")>
			@Override
		</#if>
		public void set${entityColumn.methodName}(${entityColumn.genericizedType} ${entityColumn.name}) {
			<#if entity.hasEntityColumn("modifiedDate", "Date") && stringUtil.equals(entityColumn.name, "modifiedDate")>
				_setModifiedDate = true;
			</#if>

			<#if serviceBuilder.isVersionGTE_7_3_0()>
				if (_columnOriginalValues == Collections.EMPTY_MAP) {
					_setColumnOriginalValues();
				}
			<#else>
				<#if entityColumn.isOrderColumn() && columnBitmaskEnabled>
					_columnBitmask = -1L;
				</#if>

				<#if entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name))>
					<#if !entityColumn.isOrderColumn() && columnBitmaskEnabled>
						_columnBitmask |= ${entityColumn.name?upper_case}_COLUMN_BITMASK;
					</#if>

					<#if entityColumn.isPrimitiveType()>
						if (!_setOriginal${entityColumn.methodName}) {
						_setOriginal${entityColumn.methodName} = true;
					<#else>
						if (_original${entityColumn.methodName} == null) {
					</#if>

					_original${entityColumn.methodName} = _${entityColumn.name};
					}
				</#if>
			</#if>

			<#if entity.versionEntity?? && stringUtil.equals(entityColumn.name, "headId")>
				if (headId >= 0) {
					setHead(false);
				}
				else {
					setHead(true);
				}
			</#if>

			<#if stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy>
				if (_${entityColumn.name}BlobModel == null) {
					_${entityColumn.name}BlobModel = new ${entity.name}${entityColumn.methodName}BlobModel(getPrimaryKey(), ${entityColumn.name});
				}
				else {
					_${entityColumn.name}BlobModel.set${entityColumn.methodName}Blob(${entityColumn.name});
				}
			<#else>
				_${entityColumn.name} = ${entityColumn.name};
			</#if>
		}

		<#if entityColumn.localized>
			@Override
			public void set${entityColumn.methodName}(String ${entityColumn.name}, Locale locale) {
				<#if entity.isGroupedModel()>
					set${entityColumn.methodName}(${entityColumn.name}, locale, LocaleUtil.getSiteDefault());
				<#else>
					set${entityColumn.methodName}(${entityColumn.name}, locale, LocaleUtil.getDefault());
				</#if>
			}

			@Override
			public void set${entityColumn.methodName}(String ${entityColumn.name}, Locale locale, Locale defaultLocale) {
				String languageId = LocaleUtil.toLanguageId(locale);
				String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

				if (Validator.isNotNull(${entityColumn.name})) {
					set${entityColumn.methodName}(LocalizationUtil.updateLocalization(get${entityColumn.methodName}(), "${entityColumn.methodName}", ${entityColumn.name}, languageId, defaultLanguageId));
				}
				else {
					set${entityColumn.methodName}(LocalizationUtil.removeLocalization(get${entityColumn.methodName}(), "${entityColumn.methodName}", languageId));
				}
			}

			@Override
			public void set${entityColumn.methodName}CurrentLanguageId(String languageId) {
				_${entityColumn.name}CurrentLanguageId = languageId;
			}

			@Override
			public void set${entityColumn.methodName}Map(Map<Locale, String> ${entityColumn.name}Map) {
				<#if entity.isGroupedModel()>
					set${entityColumn.methodName}Map(${entityColumn.name}Map, LocaleUtil.getSiteDefault());
				<#else>
					set${entityColumn.methodName}Map(${entityColumn.name}Map, LocaleUtil.getDefault());
				</#if>
			}

			@Override
			public void set${entityColumn.methodName}Map(Map<Locale, String> ${entityColumn.name}Map, Locale defaultLocale) {
				if (${entityColumn.name}Map == null) {
					return;
				}

				set${entityColumn.methodName}(LocalizationUtil.updateLocalization(${entityColumn.name}Map, get${entityColumn.methodName}(), "${entityColumn.methodName}", LocaleUtil.toLanguageId(defaultLocale)));
			}
		</#if>

		<#if stringUtil.equals(entityColumn.name, "resourcePrimKey") && entity.isResourcedModel()>
			@Override
			public boolean isResourceMain() {
				return true;
			}
		</#if>

		<#if entityColumn.userUuid>
			@Override
			public String get${entityColumn.methodUserUuidName}() {
				try {
					User user = UserLocalServiceUtil.getUserById(get${entityColumn.methodName}());

					return user.getUuid();
				}
				catch (PortalException portalException) {
					return "";
				}
			}

			@Override
			public void set${entityColumn.methodUserUuidName}(String ${entityColumn.userUuidName}) {
			}
		</#if>

		<#if entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name))>
			<#if serviceBuilder.isVersionGTE_7_3_0()>
				/**
				* @deprecated As of Athanasius (7.3.x), replaced by {@link
				*             #getColumnOriginalValue(String)}
				*/
				@Deprecated
			</#if>
			public ${entityColumn.type} getOriginal${entityColumn.methodName}() {
				<#if serviceBuilder.isVersionGTE_7_3_0()>
					<#if entityColumn.isPrimitiveType()>
						return GetterUtil.get${serviceBuilder.getPrimitiveObj(entityColumn.type)}(this.<${serviceBuilder.getPrimitiveObj(entityColumn.type)}>getColumnOriginalValue("${entityColumn.DBName}"));
					<#else>
						return getColumnOriginalValue("${entityColumn.DBName}");
					</#if>
				<#elseif stringUtil.equals(entityColumn.type, "String") && entityColumn.isConvertNull()>
					return GetterUtil.getString(_original${entityColumn.methodName});
				<#else>
					return _original${entityColumn.methodName};
				</#if>
			}
		</#if>
	</#list>

	<#list cacheFields as cacheField>
		<#assign
			variableName = serviceBuilder.getVariableName(cacheField)
			methodName = serviceBuilder.getCacheFieldMethodName(cacheField)
			typeGenericsName = serviceBuilder.getTypeGenericsName(cacheField.getType())
		/>

		<#if !stringUtil.equals(methodName, "DefaultLanguageId")>
			public ${typeGenericsName} get${methodName}() {
				<#if cacheField.getType().isPrimitive()>
					<#if stringUtil.equals(typeGenericsName, "boolean")>
						return false;
					<#else>
						return 0;
					</#if>
				<#else>
					return null;
				</#if>
			}
		</#if>

		public void set${methodName}(${typeGenericsName} ${variableName}) {
		}
	</#list>

	<#if entity.isContainerModel()>
		<#assign hasParentContainerModelId = entity.hasEntityColumn("parentContainerModelId") />

		<#list entity.entityColumns as entityColumn>
			<#if entityColumn.isContainerModel() && !stringUtil.equals(entityColumn.name, "containerModelId")>
				@Override
				public long getContainerModelId() {
					return get${entityColumn.methodName}();
				}

				@Override
				public void setContainerModelId(long containerModelId) {
					_${entityColumn.name} = containerModelId;
				}
			</#if>

			<#if entityColumn.isParentContainerModel() && !stringUtil.equals(entityColumn.name, "parentContainerModelId")>
				<#assign hasParentContainerModelId = true />

				@Override
				public long getParentContainerModelId() {
					return get${entityColumn.methodName}();
				}

				@Override
				public void setParentContainerModelId(long parentContainerModelId) {
					_${entityColumn.name} = parentContainerModelId;
				}
			</#if>
		</#list>

		@Override
		public String getContainerModelName() {
			<#if entity.hasEntityColumn("name")>
				return String.valueOf(getName());
			<#elseif entity.hasEntityColumn("title")>
				<#assign titleColumn = entity.getEntityColumn("title") />

				return String.valueOf(getTitle(<#if titleColumn.isLocalized()>LocaleThreadLocal.getThemeDisplayLocale()</#if>));
			<#else>
				return String.valueOf(getContainerModelId());
			</#if>
		}

		<#if !hasParentContainerModelId>
			@Override
			public long getParentContainerModelId() {
				return 0;
			}

			@Override
			public void setParentContainerModelId(long parentContainerModelId) {
			}
		</#if>
	</#if>

	<#if entity.isHierarchicalTree()>
		public long getNestedSetsTreeNodeLeft() {
			return _left${pkEntityColumn.methodName};
		}

		public long getNestedSetsTreeNodeRight() {
			return _right${pkEntityColumn.methodName};
		}

		public long getNestedSetsTreeNodeScopeId() {
			<#if entity.hasEntityColumn("groupId")>
				<#assign scopeEntityColumn = entity.getEntityColumn("groupId") />
			<#else>
				<#assign scopeEntityColumn = entity.getEntityColumn("companyId") />
			</#if>

			return _${scopeEntityColumn.name};
		}

		public void setNestedSetsTreeNodeLeft(long nestedSetsTreeNodeLeft) {
			_left${pkEntityColumn.methodName} = nestedSetsTreeNodeLeft;
		}

		public void setNestedSetsTreeNodeRight(long nestedSetsTreeNodeRight) {
			_right${pkEntityColumn.methodName} = nestedSetsTreeNodeRight;
		}
	</#if>

	<#if entity.isStagedModel()>
		@Override
		public StagedModelType getStagedModelType() {
			<#if entity.isTypedModel()>
				return new StagedModelType(PortalUtil.getClassNameId(${entity.name}.class.getName()), getClassNameId());
			<#else>
				return new StagedModelType(PortalUtil.getClassNameId(${entity.name}.class.getName()));
			</#if>
		}
	</#if>

	<#if entity.isTrashEnabled()>
		<#if !entity.isWorkflowEnabled()>
			@Override
			public int getStatus() {
				return 0;
			}
		</#if>

		<#if serviceBuilder.isVersionLTE_7_3_0()>
			@Override
			public com.liferay.trash.kernel.model.TrashEntry getTrashEntry() throws PortalException {
				if (!isInTrash()) {
					return null;
				}

				com.liferay.trash.kernel.model.TrashEntry trashEntry = com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.fetchEntry(getModelClassName(), getTrashEntryClassPK());

				if (trashEntry != null) {
					return trashEntry;
				}

				com.liferay.portal.kernel.trash.TrashHandler trashHandler = getTrashHandler();

				if (Validator.isNotNull(trashHandler.getContainerModelClassName(getPrimaryKey()))) {
					ContainerModel containerModel = null;

					try {
						containerModel = trashHandler.getParentContainerModel(this);
					}
					catch (NoSuchModelException noSuchModelException) {
						return null;
					}

					while (containerModel != null) {
						if (containerModel instanceof TrashedModel) {
							TrashedModel trashedModel = (TrashedModel)containerModel;

							return trashedModel.getTrashEntry();
						}

						trashHandler = com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.getTrashHandler(trashHandler.getContainerModelClassName(containerModel.getContainerModelId()));

						if (trashHandler == null) {
							return null;
						}

						containerModel = trashHandler.getContainerModel(containerModel.getParentContainerModelId());
					}
				}

				return null;
			}
		</#if>

		@Override
		public long getTrashEntryClassPK() {
			return getPrimaryKey();
		}

		<#if serviceBuilder.isVersionLTE_7_3_0()>
			/**
			* @deprecated As of Judson (7.1.x), with no direct replacement
			*/
			@Deprecated
			@Override
			public com.liferay.portal.kernel.trash.TrashHandler getTrashHandler() {
				return com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.getTrashHandler(getModelClassName());
			}
		</#if>

		@Override
		public boolean isInTrash() {
			if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
				return true;
			}
			else {
				return false;
			}
		}

		<#if serviceBuilder.isVersionLTE_7_3_0()>
			@Override
			public boolean isInTrashContainer() {
				com.liferay.portal.kernel.trash.TrashHandler trashHandler = getTrashHandler();

				if ((trashHandler == null) || Validator.isNull(trashHandler.getContainerModelClassName(getPrimaryKey()))) {
					return false;
				}

				try {
					ContainerModel containerModel = trashHandler.getParentContainerModel(this);

					if (containerModel == null) {
						return false;
					}

					if (containerModel instanceof TrashedModel) {
						return ((TrashedModel)containerModel).isInTrash();
					}
				}
				catch (Exception exception) {
				}

				return false;
			}

			@Override
			public boolean isInTrashExplicitly() {
				if (!isInTrash()) {
					return false;
				}

				com.liferay.trash.kernel.model.TrashEntry trashEntry = com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.fetchEntry(getModelClassName(), getTrashEntryClassPK());

				if (trashEntry != null) {
					return true;
				}

				return false;
			}

			@Override
			public boolean isInTrashImplicitly() {
				if (!isInTrash()) {
					return false;
				}

				com.liferay.trash.kernel.model.TrashEntry trashEntry = com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.fetchEntry(getModelClassName(), getTrashEntryClassPK());

				if (trashEntry != null) {
					return false;
				}

				return true;
			}
		</#if>
	</#if>

	<#if entity.isWorkflowEnabled()>
		@Override
		public boolean isApproved() {
			if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isDenied() {
			if (getStatus() == WorkflowConstants.STATUS_DENIED) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isDraft() {
			if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isExpired() {
			if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isInactive() {
			if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isIncomplete() {
			if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isPending() {
			if (getStatus() == WorkflowConstants.STATUS_PENDING) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isScheduled() {
			if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
				return true;
			}
			else {
				return false;
			}
		}
	</#if>

	<#if columnBitmaskEnabled>
		public long getColumnBitmask() {
			<#if serviceBuilder.isVersionGTE_7_3_0()>
				if (_columnBitmask > 0) {
					return _columnBitmask;
				}

				if ((_columnOriginalValues == null) || (_columnOriginalValues == Collections.EMPTY_MAP)) {
					return 0;
				}

				for (Map.Entry<String, Object> entry : _columnOriginalValues.entrySet()) {
					if (!Objects.equals(entry.getValue(), getColumnValue(entry.getKey()))) {
						_columnBitmask |= _columnBitmasks.get(entry.getKey());
					}
				}
			</#if>

			return _columnBitmask;
		}
	</#if>

	<#if stringUtil.equals(entity.PKClassName, "long") && !stringUtil.startsWith(entity.name, "Expando")>
		@Override
		public ExpandoBridge getExpandoBridge() {
			return ExpandoBridgeFactoryUtil.getExpandoBridge(

				<#if entity.hasEntityColumn("companyId")>
					getCompanyId(),
				<#else>
					0,
				</#if>

				${entity.name}.class.getName(), getPrimaryKey());
		}

		@Override
		public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
			ExpandoBridge expandoBridge = getExpandoBridge();

			expandoBridge.setAttributes(serviceContext);
		}
	</#if>

	<#if entity.isLocalizedModel()>
		@Override
		public String[] getAvailableLanguageIds() {
			Set<String> availableLanguageIds = new TreeSet<String>();

			<#list entity.regularEntityColumns as entityColumn>
				<#if entityColumn.localized>
					Map<Locale, String> ${entityColumn.name}Map = get${entityColumn.methodName}Map();

					for (Map.Entry<Locale, String> entry : ${entityColumn.name}Map.entrySet()) {
						Locale locale = entry.getKey();
						String value = entry.getValue();

						if (Validator.isNotNull(value)) {
							availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
						}
					}
				</#if>
			</#list>

			return availableLanguageIds.toArray(new String[availableLanguageIds.size()]);
		}

		@Override
		public String getDefaultLanguageId() {
			<#list entity.regularEntityColumns as entityColumn>
				<#if entityColumn.localized>
					String xml = get${entityColumn.methodName}();

					if (xml == null) {
						return "";
					}

					<#if entity.isGroupedModel()>
						Locale defaultLocale = LocaleUtil.getSiteDefault();
					<#else>
						Locale defaultLocale = LocaleUtil.getDefault();
					</#if>

					return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
					<#break>
				</#if>
			</#list>
		}

		@Override
		public void prepareLocalizedFieldsForImport() throws LocaleException {
			Locale defaultLocale = LocaleUtil.fromLanguageId(getDefaultLanguageId());

			Locale[] availableLocales = LocaleUtil.fromLanguageIds(getAvailableLanguageIds());

			Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(${entity.name}.class.getName(), getPrimaryKey(), defaultLocale, availableLocales);

			prepareLocalizedFieldsForImport(defaultImportLocale);
		}

		@Override
		@SuppressWarnings("unused")
		public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
			<#if entity.isGroupedModel()>
				Locale defaultLocale = LocaleUtil.getSiteDefault();
			<#else>
				Locale defaultLocale = LocaleUtil.getDefault();
			</#if>

			String modelDefaultLanguageId = getDefaultLanguageId();

			<#list entity.regularEntityColumns as entityColumn>
				<#if entityColumn.localized>
					String ${entityColumn.name} = get${entityColumn.methodName}(defaultLocale);

					if (Validator.isNull(${entityColumn.name})) {
						set${entityColumn.methodName}(get${entityColumn.methodName}(modelDefaultLanguageId), defaultLocale);
					}
					else {
					  set${entityColumn.methodName}(get${entityColumn.methodName}(defaultLocale), defaultLocale, defaultLocale);
					}
				</#if>
			</#list>
		}
	</#if>

	@Override
	public ${entity.name} toEscapedModel() {
		if (_escapedModel == null) {
			Function<InvocationHandler, ${entity.name}> escapedModelProxyProviderFunction = EscapedModelProxyProviderFunctionHolder._escapedModelProxyProviderFunction;

			_escapedModel = escapedModelProxyProviderFunction.apply(new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		${entity.name}Impl ${entity.variableName}Impl = new ${entity.name}Impl();

		<#list entity.regularEntityColumns as entityColumn>
			<#if !stringUtil.equals(entityColumn.type, "Blob")>
				${entity.variableName}Impl.set${entityColumn.methodName}(

				<#if entityColumn.entityName??>
					(${entityColumn.entityName})get${entityColumn.methodName}().clone()
				<#elseif stringUtil.equals(entityColumn.type, "boolean")>
					is${entityColumn.methodName}()
				<#else>
					get${entityColumn.methodName}()
				</#if>

				);
			</#if>
		</#list>

		${entity.variableName}Impl.resetOriginalValues();

		return ${entity.variableName}Impl;
	}

	<#if serviceBuilder.isVersionGTE_7_4_0()>
		@Override
		public ${entity.name} cloneWithOriginalValues() {
			${entity.name}Impl ${entity.variableName}Impl = new ${entity.name}Impl();

			<#list entity.regularEntityColumns as entityColumn>
				<#if !stringUtil.equals(entityColumn.type, "Blob")>
					${entity.variableName}Impl.set${entityColumn.methodName}(this.<${serviceBuilder.getPrimitiveObj(entityColumn.type)}>getColumnOriginalValue("${entityColumn.DBName}"));
				</#if>
			</#list>

			return ${entity.variableName}Impl;
		}
	</#if>

	@Override
	public int compareTo(${entity.name} ${entity.variableName}) {
		<#if entity.isOrdered()>
			int value = 0;

			<#list entity.entityOrder.entityColumns as entityColumn>
				<#if entityColumn.isPrimitiveType()>
					<#if stringUtil.equals(entityColumn.type, "boolean")>
						value = Boolean.compare(is${entityColumn.methodName}(), ${entity.variableName}.is${entityColumn.methodName}());
					<#else>
						if (get${entityColumn.methodName}() < ${entity.variableName}.get${entityColumn.methodName}()) {
							value = -1;
						}
						else if (get${entityColumn.methodName}() > ${entity.variableName}.get${entityColumn.methodName}()) {
							value = 1;
						}
						else {
							value = 0;
						}
					</#if>
				<#else>
					<#if stringUtil.equals(entityColumn.type, "Date")>
						value = DateUtil.compareTo(get${entityColumn.methodName}(), ${entity.variableName}.get${entityColumn.methodName}());
					<#else>
						<#if entityColumn.isCaseSensitive()>
							value = get${entityColumn.methodName}().compareTo(${entity.variableName}.get${entityColumn.methodName}());
						<#else>
							value = get${entityColumn.methodName}().compareToIgnoreCase(${entity.variableName}.get${entityColumn.methodName}());
						</#if>
					</#if>
				</#if>

				<#if !entityColumn.isOrderByAscending()>
					value = value * -1;
				</#if>

				if (value != 0) {
					return value;
				}
			</#list>

			return 0;
		<#else>
			${entity.PKClassName} primaryKey = ${entity.variableName}.getPrimaryKey();

			<#if entity.hasPrimitivePK()>
				if (getPrimaryKey() < primaryKey) {
					return -1;
				}
				else if (getPrimaryKey() > primaryKey) {
					return 1;
				}
				else {
					return 0;
				}
			<#else>
				return getPrimaryKey().compareTo(primaryKey);
			</#if>
		</#if>
	}

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof ${entity.name})) {
			return false;
		}

		${entity.name} ${entity.variableName} = (${entity.name})object;

		${entity.PKClassName} primaryKey = ${entity.variableName}.getPrimaryKey();

		<#if entity.hasPrimitivePK()>
			if (getPrimaryKey() == primaryKey) {
		<#else>
			if (getPrimaryKey().equals(primaryKey)) {
		</#if>

			return true;
		}
		else{
			return false;
		}
	}

	@Override
	public int hashCode() {
		<#if entity.hasPrimitivePK(false)>
			<#if stringUtil.equals(entity.PKClassName, "int")>
				return getPrimaryKey();
			<#else>
				return (int)getPrimaryKey();
			</#if>
		<#else>
			return getPrimaryKey().hashCode();
		</#if>
	}

	<#if serviceBuilder.isVersionGTE_7_3_0()>
		/**
		* @deprecated As of Athanasius (7.3.x), with no direct replacement
		*/
		@Deprecated
	</#if>
	@Override
	public boolean isEntityCacheEnabled() {
		<#if dependencyInjectorDS>
			<#if serviceBuilder.isVersionGTE_7_3_0()>
				return true;
			<#else>
				return _entityCacheEnabled;
			</#if>
		<#else>
			return ENTITY_CACHE_ENABLED;
		</#if>
	}

	<#if serviceBuilder.isVersionGTE_7_3_0()>
		/**
		* @deprecated As of Athanasius (7.3.x), with no direct replacement
		*/
		@Deprecated
	</#if>
	@Override
	public boolean isFinderCacheEnabled() {
		<#if dependencyInjectorDS>
			<#if serviceBuilder.isVersionGTE_7_3_0()>
				return true;
			<#else>
				return _finderCacheEnabled;
			</#if>
		<#else>
			return FINDER_CACHE_ENABLED;
		</#if>
	}

	@Override
	public void resetOriginalValues() {
		<#if serviceBuilder.isVersionGTE_7_3_0()>
			_columnOriginalValues = Collections.emptyMap();
		</#if>

		<#list entity.databaseRegularEntityColumns as entityColumn>
			<#if stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy>
				_${entityColumn.name}BlobModel = null;
			<#elseif serviceBuilder.isVersionLTE_7_2_0() && (entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name)))>
				_original${entityColumn.methodName} = _${entityColumn.name};

				<#if entityColumn.isPrimitiveType()>
					_setOriginal${entityColumn.methodName} = false;
				</#if>
			</#if>

			<#if entity.hasEntityColumn("modifiedDate", "Date") && stringUtil.equals(entityColumn.name, "modifiedDate")>
				_setModifiedDate = false;
			</#if>
		</#list>

		<#list cacheFields as cacheField>
			<#assign
				variableName = serviceBuilder.getVariableName(cacheField)
				methodName = serviceBuilder.getCacheFieldMethodName(cacheField)
			/>

			set${methodName}(null);
		</#list>

		<#if columnBitmaskEnabled>
			_columnBitmask = 0;
		</#if>
	}

	@Override
	public CacheModel<${entity.name}> toCacheModel() {
		${entity.name}CacheModel ${entity.variableName}CacheModel = new ${entity.name}CacheModel();

		<#if entity.hasCompoundPK()>
			${entity.variableName}CacheModel.${entity.PKVariableName} = getPrimaryKey();
		</#if>

		<#list entity.databaseRegularEntityColumns as entityColumn>
			<#if !stringUtil.equals(entityColumn.type, "Blob")>
				<#if stringUtil.equals(entityColumn.type, "Date")>
					Date ${entityColumn.name} = get${entityColumn.methodName}();

					if (${entityColumn.name} != null) {
						${entity.variableName}CacheModel.${entityColumn.name} = ${entityColumn.name}.getTime();
					}
					else {
						${entity.variableName}CacheModel.${entityColumn.name} = Long.MIN_VALUE;
					}
				<#else>
					<#if entityColumn.isPrimitiveTypeWrapper()>
						${entityColumn.type} ${entityColumn.name} = get${entityColumn.methodName}();

						if (${entityColumn.name} != null) {
							${entity.variableName}CacheModel.${entityColumn.name} = ${entityColumn.name};
						}
					<#elseif stringUtil.equals(entityColumn.type, "boolean")>
						${entity.variableName}CacheModel.${entityColumn.name} = is${entityColumn.methodName}();
					<#else>
						${entity.variableName}CacheModel.${entityColumn.name} = get${entityColumn.methodName}();
					</#if>

					<#if stringUtil.equals(entityColumn.type, "String")>
						String ${entityColumn.name} = ${entity.variableName}CacheModel.${entityColumn.name};

						if ((${entityColumn.name} != null) && (${entityColumn.name}.length() == 0)) {
							${entity.variableName}CacheModel.${entityColumn.name} = null;
						}
					</#if>
				</#if>
			</#if>
		</#list>

		<#list cacheFields as cacheField>
			<#assign methodName = serviceBuilder.getCacheFieldMethodName(cacheField) />

			set${methodName}(null);

			${entity.variableName}CacheModel.${cacheField.name} = get${methodName}();
		</#list>

		return ${entity.variableName}CacheModel;
	}

	<#if hasLazy>
		@Override
		public String toString() {
			StringBundler sb = new StringBundler(${entity.regularEntityColumns?size * 2 + 1});

			<#list entity.regularEntityColumns as entityColumn>
				<#if !stringUtil.equals(entityColumn.type, "Blob") || !entityColumn.lazy>
					<#if entityColumn_index == 0>
						sb.append("{\"${entityColumn.name}\": ");
					<#else>
						sb.append(", \"${entityColumn.name}\": ");
					</#if>

					<#if stringUtil.equals(entityColumn.type, "boolean")>
						sb.append(is${entityColumn.methodName}());
					<#elseif stringUtil.equals(entityColumn.type, "Blob") || stringUtil.equals(entityColumn.type, "Date") || stringUtil.equals(entityColumn.type, "Map") || stringUtil.equals(entityColumn.type, "String")>
						sb.append("\"" + get${entityColumn.methodName}() + "\"");
					<#else>
						sb.append(get${entityColumn.methodName}());
					</#if>

					<#if !entityColumn_has_next>
						sb.append("}");
					</#if>
				</#if>
			</#list>

			return sb.toString();
		}

		<#if serviceBuilder.isVersionLTE_7_3_0()>
			@Override
			public String toXmlString() {
				StringBundler sb = new StringBundler(${entity.regularEntityColumns?size * 3 + 4});

				sb.append("<model><model-name>");
				sb.append("${apiPackagePath}.model.${entity.name}");
				sb.append("</model-name>");

				<#list entity.regularEntityColumns as entityColumn>
					<#if !stringUtil.equals(entityColumn.type, "Blob") || !entityColumn.lazy>
						sb.append("<column><column-name>${entityColumn.name}</column-name><column-value><![CDATA[");

						<#if stringUtil.equals(entityColumn.type, "boolean")>
							sb.append(is${entityColumn.methodName}());
						<#else>
							sb.append(get${entityColumn.methodName}());
						</#if>

						sb.append("]]></column-value></column>");
					</#if>
				</#list>

				sb.append("</model>");

				return sb.toString();
			}
		</#if>
	<#else>
		@Override
		public String toString() {
			Map<String, Function<${entity.name}, Object>> attributeGetterFunctions = getAttributeGetterFunctions();

			StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 2);

			sb.append("{");

			for (Map.Entry<String, Function<${entity.name}, Object>> entry : attributeGetterFunctions.entrySet()) {
				String attributeName = entry.getKey();
				Function<${entity.name}, Object> attributeGetterFunction = entry.getValue();

				sb.append("\"");
				sb.append(attributeName);
				sb.append("\": ");

				Object value = attributeGetterFunction.apply((${entity.name})this);

				if (value == null) {
					sb.append("null");
				}
				else if ((value instanceof Blob) ||
						 (value instanceof Date) ||
						 (value instanceof Map) ||
						 (value instanceof String)) {

					sb.append("\"" + StringUtil.replace(value.toString(), "\"", "'") + "\"");
				}
				else {
					sb.append(value);
				}

				sb.append(", ");
			}

			if (sb.index() > 1) {
				sb.setIndex(sb.index() - 1);
			}

			sb.append("}");

			return sb.toString();
		}

		<#if serviceBuilder.isVersionLTE_7_3_0()>
			@Override
			public String toXmlString() {
				Map<String, Function<${entity.name}, Object>> attributeGetterFunctions = getAttributeGetterFunctions();

				StringBundler sb = new StringBundler(5 * attributeGetterFunctions.size() + 4);

				sb.append("<model><model-name>");
				sb.append(getModelClassName());
				sb.append("</model-name>");

				for (Map.Entry<String, Function<${entity.name}, Object>> entry : attributeGetterFunctions.entrySet()) {
					String attributeName = entry.getKey();
					Function<${entity.name}, Object> attributeGetterFunction = entry.getValue();

					sb.append("<column><column-name>");
					sb.append(attributeName);
					sb.append("</column-name><column-value><![CDATA[");
					sb.append(attributeGetterFunction.apply((${entity.name})this));
					sb.append("]]></column-value></column>");
				}

				sb.append("</model>");

				return sb.toString();
			}
		</#if>
	</#if>

	private static class EscapedModelProxyProviderFunctionHolder {
		<#if serviceBuilder.isVersionLTE_7_1_0()>
			private static final Function<InvocationHandler, ${entity.name}> _escapedModelProxyProviderFunction = _getProxyProviderFunction();
		<#else>
			private static final Function<InvocationHandler, ${entity.name}>
			_escapedModelProxyProviderFunction = ProxyUtil
			.getProxyProviderFunction(${entity.name}.class, ModelWrapper.class);
		</#if>
	}

	<#if serviceBuilder.isVersionLTE_7_2_0() && dependencyInjectorDS>
		<#if entity.hasEagerBlobColumn()>
			private static final boolean _entityCacheEnabled = false;
			private static final boolean _finderCacheEnabled = false;
		<#else>
			private static boolean _entityCacheEnabled;
			private static boolean _finderCacheEnabled;
		</#if>
	</#if>

	<#list entity.databaseRegularEntityColumns as entityColumn>
		<#if stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy>
			private ${entity.name}${entityColumn.methodName}BlobModel _${entityColumn.name}BlobModel;
		<#else>
			private ${entityColumn.genericizedType} _${entityColumn.name};

			<#if entityColumn.localized>
				private String _${entityColumn.name}CurrentLanguageId;
			</#if>

			<#if serviceBuilder.isVersionLTE_7_2_0() && (entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name)))>
				private ${entityColumn.type} _original${entityColumn.methodName};

				<#if entityColumn.isPrimitiveType()>
					private boolean _setOriginal${entityColumn.methodName};
				</#if>
			</#if>

			<#if entity.hasEntityColumn("modifiedDate", "Date") && stringUtil.equals(entityColumn.name, "modifiedDate")>
				private boolean _setModifiedDate;
			</#if>
		</#if>
	</#list>

	<#if serviceBuilder.isVersionGTE_7_3_0()>
		public <T> T getColumnValue(String columnName) {
			<#if entity.versionEntity??>
				if (columnName.equals("head")) {
					return (T)(Object)getHead();
				}
			</#if>

			<#if entity.badEntityColumns?size != 0>
				columnName = _attributeNames.getOrDefault(columnName, columnName);
			</#if>

			Function<${entity.name}, Object> function =
				<#if serviceBuilder.isVersionGTE_7_4_0()>
					AttributeGetterFunctionsHolder.
				</#if>

				_attributeGetterFunctions.get(columnName);

			if (function == null) {
				throw new IllegalArgumentException(
					"No attribute getter function found for " + columnName);
			}

			return (T)function.apply((${entity.name})this);
		}

		public <T> T getColumnOriginalValue(String columnName) {
			if (_columnOriginalValues == null) {
				return null;
			}

			if (_columnOriginalValues == Collections.EMPTY_MAP) {
				_setColumnOriginalValues();
			}

			return (T)_columnOriginalValues.get(columnName);
		}

		private void _setColumnOriginalValues() {
			_columnOriginalValues = new HashMap<String, Object>();

			<#list entity.databaseRegularEntityColumns as entityColumn>
				<#if !stringUtil.equals(entityColumn.type, "Blob") || !entityColumn.lazy>
					_columnOriginalValues.put("${entityColumn.DBName}", _${entityColumn.name});
				</#if>
			</#list>
		}

		<#if entity.badEntityColumns?size != 0>
			private static final Map<String, String> _attributeNames;

			static {
				Map<String, String> attributeNames = new HashMap<>();

				<#list entity.badEntityColumns as entityColumn>
					attributeNames.put("${entityColumn.DBName}", "${entityColumn.name}");
				</#list>

				_attributeNames = Collections.unmodifiableMap(attributeNames);
			}
		</#if>

		private transient Map<String, Object> _columnOriginalValues;
	</#if>

	<#if columnBitmaskEnabled>
		<#if serviceBuilder.isVersionGTE_7_3_0()>
			public static long getColumnBitmask(String columnName) {
				return _columnBitmasks.get(columnName);
			}

			private static final Map<String, Long> _columnBitmasks;

			static {
				Map<String, Long> columnBitmasks = new HashMap<>();

				<#assign columnBitmask = 1 />

				<#list entity.databaseRegularEntityColumns as entityColumn>
					columnBitmasks.put("${entityColumn.DBName}", ${columnBitmask}L);

					<#assign columnBitmask = columnBitmask * 2 />
				</#list>

				_columnBitmasks = Collections.unmodifiableMap(columnBitmasks);
			}
		</#if>

		private long _columnBitmask;
	</#if>

	private ${entity.name} _escapedModel;

}