/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.service.builder;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.util.Accessor;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.service.builder.EntityColumn;
import com.liferay.portal.tools.service.builder.EntityFinder;
import com.liferay.portal.tools.service.builder.EntityOrder;
import com.liferay.portal.tools.service.builder.ServiceBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class Entity
implements Comparable<Entity> {
    public static final Accessor<Entity, String> NAME_ACCESSOR = new Accessor<Entity, String>(){

        @Override
        public String get(Entity entity) {
            return entity.getName();
        }

        @Override
        public Class<String> getAttributeClass() {
            return String.class;
        }

        @Override
        public Class<Entity> getTypeClass() {
            return Entity.class;
        }
    };
    private static final String _DATA_SOURCE_DEFAULT = "liferayDataSource";
    private static final String _SESSION_FACTORY_DEFAULT = "liferaySessionFactory";
    private static final String _TX_MANAGER_DEFAULT = "liferayTransactionManager";
    private final String _alias;
    private String _apiPackagePath;
    private List<EntityColumn> _blobEntityColumns;
    private final boolean _cacheEnabled;
    private boolean _changeTrackingEnabled;
    private final List<EntityColumn> _collectionEntityColumns;
    private final boolean _containerModel;
    private final List<EntityColumn> _databaseRegularEntityColumns;
    private final String _dataSource;
    private final boolean _deprecated;
    private final boolean _dynamicUpdateEnabled;
    private final List<EntityColumn> _entityColumns;
    private final List<EntityFinder> _entityFinders;
    private final EntityOrder _entityOrder;
    private final String _externalReferenceCode;
    private final String _finderClassName;
    private final List<EntityColumn> _finderEntityColumns;
    private final String _humanName;
    private final boolean _jsonEnabled;
    private Entity _localizedEntity;
    private List<EntityColumn> _localizedEntityColumns;
    private final boolean _localService;
    private final boolean _mvccEnabled;
    private final String _name;
    private final String _packagePath;
    private List<String> _parentTransients;
    private final boolean _persistence;
    private final String _persistenceClassName;
    private final List<EntityColumn> _pkEntityColumns;
    private final String _pluralName;
    private final String _pluralVariableName;
    private boolean _portalReference;
    private final String _portletShortName;
    private final List<Entity> _referenceEntities;
    private final List<EntityColumn> _regularEntityColumns;
    private final boolean _remoteService;
    private final boolean _resourceActionModel;
    private ServiceBuilder _serviceBuilder;
    private final String _sessionFactory;
    private final String _table;
    private List<String> _transients;
    private final boolean _trashEnabled;
    private final String _txManager;
    private final List<String> _txRequiredMethodNames;
    private final String _uadApplicationName;
    private final boolean _uadAutoDelete;
    private final String _uadOutputPath;
    private final String _uadPackagePath;
    private List<String> _unresolvedReferenceEntityNames;
    private final boolean _uuid;
    private final boolean _uuidAccessor;
    private final String _variableName;
    private Entity _versionedEntity;
    private Entity _versionEntity;

    public static EntityColumn getEntityColumn(String name, List<EntityColumn> entityColumns) {
        for (EntityColumn entityColumn : entityColumns) {
            if (!name.equals(entityColumn.getName())) continue;
            return entityColumn;
        }
        throw new RuntimeException("Entity column " + name + " not found");
    }

    public static boolean hasEntityColumn(ServiceBuilder serviceBuilder, String name, List<EntityColumn> entityColumns) {
        return Entity.hasEntityColumn(serviceBuilder, name, null, entityColumns);
    }

    public static boolean hasEntityColumn(ServiceBuilder serviceBuilder, String name, String type, List<EntityColumn> entityColumns) {
        int index = entityColumns.indexOf(new EntityColumn(serviceBuilder, name));
        if (index != -1) {
            EntityColumn entityColumn = entityColumns.get(index);
            if (type == null || type.equals(entityColumn.getType())) {
                return true;
            }
        }
        return false;
    }

    public Entity(ServiceBuilder serviceBuilder, String name) {
        this(serviceBuilder, null, null, null, name, null, null, null, null, null, null, false, false, null, false, true, true, null, null, null, null, null, true, false, false, false, false, false, null, false, null, null, false, null, null, null, null, null, null, null, null, null, null, false);
    }

    public Entity(ServiceBuilder serviceBuilder, String packagePath, String apiPackagePath, String portletShortName, String name, String variableName, String pluralName, String pluralVariableName, String humanName, String table, String alias, boolean uuid, boolean uuidAccessor, String externalReferenceCode, boolean localService, boolean remoteService, boolean persistence, String persistenceClassName, String finderClassName, String dataSource, String sessionFactory, String txManager, boolean cacheEnabled, boolean changeTrackingEnabled, boolean dynamicUpdateEnabled, boolean jsonEnabled, boolean mvccEnabled, boolean trashEnabled, String uadApplicationName, boolean uadAutoDelete, String uadOutputPath, String uadPackagePath, boolean deprecated, List<EntityColumn> pkEntityColumns, List<EntityColumn> regularEntityColumns, List<EntityColumn> blobEntityColumns, List<EntityColumn> collectionEntityColumns, List<EntityColumn> entityColumns, EntityOrder entityOrder, List<EntityFinder> entityFinders, List<Entity> referenceEntities, List<String> unresolvedReferenceEntityNames, List<String> txRequiredMethodNames, boolean resourceActionModel) {
        this._serviceBuilder = serviceBuilder;
        this._packagePath = packagePath;
        this._apiPackagePath = apiPackagePath;
        this._portletShortName = portletShortName;
        this._name = name;
        this._variableName = GetterUtil.getString(variableName, TextFormatter.format(name, 8));
        this._pluralName = GetterUtil.getString(pluralName, serviceBuilder.formatPlural(name));
        this._pluralVariableName = Validator.isNotNull(pluralVariableName) ? pluralVariableName : (Validator.isNotNull(pluralName) ? TextFormatter.format(pluralName, 8) : serviceBuilder.formatPlural(this._variableName));
        this._humanName = GetterUtil.getString(humanName, ServiceBuilder.toHumanName(name));
        this._table = table;
        this._alias = alias;
        this._uuid = uuid;
        this._uuidAccessor = uuidAccessor;
        this._externalReferenceCode = externalReferenceCode;
        this._localService = localService;
        this._remoteService = remoteService;
        this._persistence = persistence;
        this._persistenceClassName = persistenceClassName;
        this._finderClassName = finderClassName;
        this._changeTrackingEnabled = changeTrackingEnabled;
        this._dynamicUpdateEnabled = dynamicUpdateEnabled;
        this._jsonEnabled = jsonEnabled;
        this._mvccEnabled = mvccEnabled;
        this._trashEnabled = trashEnabled;
        this._uadApplicationName = uadApplicationName;
        this._uadAutoDelete = uadAutoDelete;
        this._uadOutputPath = uadOutputPath;
        this._uadPackagePath = uadPackagePath;
        this._deprecated = deprecated;
        this._pkEntityColumns = pkEntityColumns;
        this._regularEntityColumns = regularEntityColumns;
        this._blobEntityColumns = blobEntityColumns;
        this._collectionEntityColumns = collectionEntityColumns;
        this._entityColumns = entityColumns;
        this._entityOrder = entityOrder;
        this._entityFinders = entityFinders;
        this._referenceEntities = referenceEntities;
        this._unresolvedReferenceEntityNames = unresolvedReferenceEntityNames;
        this._txRequiredMethodNames = txRequiredMethodNames;
        this._resourceActionModel = resourceActionModel;
        this._dataSource = GetterUtil.getString(dataSource, _DATA_SOURCE_DEFAULT);
        this._sessionFactory = GetterUtil.getString(sessionFactory, _SESSION_FACTORY_DEFAULT);
        this._txManager = GetterUtil.getString(txManager, _TX_MANAGER_DEFAULT);
        this._databaseRegularEntityColumns = this._entityColumns == null ? null : new ArrayList<EntityColumn>(regularEntityColumns);
        if (this._entityFinders != null) {
            HashSet finderEntityColumns = new HashSet();
            for (EntityFinder entityFinder : this._entityFinders) {
                finderEntityColumns.addAll(entityFinder.getEntityColumns());
            }
            this._finderEntityColumns = new ArrayList<EntityColumn>(finderEntityColumns);
            Collections.sort(this._finderEntityColumns);
        } else {
            this._finderEntityColumns = Collections.emptyList();
        }
        if (this._blobEntityColumns != null && !this._blobEntityColumns.isEmpty()) {
            for (EntityColumn entityColumn : this._blobEntityColumns) {
                if (entityColumn.isLazy()) continue;
                cacheEnabled = false;
                break;
            }
        }
        this._cacheEnabled = cacheEnabled;
        boolean containerModel = false;
        if (this._entityColumns != null && !this._entityColumns.isEmpty()) {
            for (EntityColumn entityColumn : this._entityColumns) {
                if (!entityColumn.isContainerModel() && !entityColumn.isParentContainerModel()) continue;
                containerModel = true;
                break;
            }
        }
        this._containerModel = containerModel;
    }

    public void addReferenceEntity(Entity referenceEntity) {
        this._referenceEntities.add(referenceEntity);
    }

    @Override
    public int compareTo(Entity entity) {
        return this._name.compareToIgnoreCase(entity._name);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Entity)) {
            return false;
        }
        Entity entity = (Entity)object;
        return this._name.equals(entity.getName());
    }

    public String getAlias() {
        return this._alias;
    }

    public String getApiPackagePath() {
        return this._apiPackagePath;
    }

    public List<EntityColumn> getBadEntityColumns() {
        List<EntityColumn> entityColumns = ListUtil.copy(this._entityColumns);
        Iterator<EntityColumn> iterator = entityColumns.iterator();
        while (iterator.hasNext()) {
            EntityColumn entityColumn = iterator.next();
            String name = entityColumn.getName();
            if (!name.equals(entityColumn.getDBName())) continue;
            iterator.remove();
        }
        return entityColumns;
    }

    public List<EntityColumn> getBlobEntityColumns() {
        return this._blobEntityColumns;
    }

    public List<EntityColumn> getCollectionEntityColumns() {
        return this._collectionEntityColumns;
    }

    public List<EntityFinder> getCollectionEntityFinders() {
        ArrayList<EntityFinder> entityFinders = new ArrayList<EntityFinder>(this._entityFinders.size());
        for (EntityFinder entityFinder : this._entityFinders) {
            if (!entityFinder.isCollection() || entityFinder.hasCustomComparator()) continue;
            entityFinders.add(entityFinder);
        }
        return entityFinders;
    }

    public String getConstantName() {
        return TextFormatter.format(TextFormatter.format(this._name, 7), 0);
    }

    public Set<String> getCTColumnResolutionTypeNames() {
        TreeSet<String> ctColumnResolutionTypeNames = new TreeSet<String>();
        for (EntityColumn entityColumn : this.getEntityColumns()) {
            ctColumnResolutionTypeNames.add(entityColumn.getCTColumnResolutionTypeName());
        }
        return ctColumnResolutionTypeNames;
    }

    public List<EntityColumn> getDatabaseRegularEntityColumns() {
        return this._databaseRegularEntityColumns;
    }

    public String getDataSource() {
        return this._dataSource;
    }

    public EntityColumn getEntityColumn(String name) {
        return Entity.getEntityColumn(name, this._entityColumns);
    }

    public List<EntityColumn> getEntityColumns() {
        return this._entityColumns;
    }

    public List<EntityFinder> getEntityFinders() {
        return this._entityFinders;
    }

    public EntityOrder getEntityOrder() {
        return this._entityOrder;
    }

    public String getExternalReferenceCode() {
        return this._externalReferenceCode;
    }

    public EntityColumn getFilterPKEntityColumn() {
        for (EntityColumn entityColumn : this._entityColumns) {
            if (!entityColumn.isFilterPrimary()) continue;
            return entityColumn;
        }
        return this._getPKEntityColumn();
    }

    public String getFinderClassName() {
        return this._finderClassName;
    }

    public List<EntityColumn> getFinderEntityColumns() {
        return this._finderEntityColumns;
    }

    public String getHumanName() {
        return this._humanName;
    }

    public Entity getLocalizedEntity() {
        return this._localizedEntity;
    }

    public List<EntityColumn> getLocalizedEntityColumns() {
        return this._localizedEntityColumns;
    }

    public String getModelBaseInterfaceNames() {
        ArrayList<String> interfaceNames = new ArrayList<String>();
        if (this.isAttachedModel()) {
            interfaceNames.add("AttachedModel");
        } else if (this.isTypedModel()) {
            interfaceNames.add("TypedModel");
        }
        interfaceNames.add("BaseModel<" + this._name + ">");
        if (this.isChangeTrackingEnabled()) {
            interfaceNames.add("CTModel<" + this._name + ">");
        }
        if (this.isContainerModel()) {
            interfaceNames.add("ContainerModel");
        }
        if (this.isLocalizedModel()) {
            interfaceNames.add("LocalizedModel");
        }
        if (this.isMvccEnabled()) {
            interfaceNames.add("MVCCModel");
        }
        if (this.isResourcedModel()) {
            interfaceNames.add("ResourcedModel");
        }
        if (this.isShardedModel()) {
            interfaceNames.add("ShardedModel");
        }
        if (this.isStagedGroupedModel()) {
            interfaceNames.add("StagedGroupedModel");
        } else {
            if (this.isGroupedModel()) {
                interfaceNames.add("GroupedModel");
            }
            if (this.isStagedAuditedModel()) {
                interfaceNames.add("StagedAuditedModel");
            } else {
                if (this.isStagedModel()) {
                    interfaceNames.add("StagedModel");
                }
                if (this.isAuditedModel() && !this.isGroupedModel()) {
                    interfaceNames.add("AuditedModel");
                }
            }
        }
        if (this.isTrashEnabled()) {
            interfaceNames.add("TrashedModel");
        }
        if (this._versionEntity != null) {
            interfaceNames.add("VersionedModel<" + this._name + "Version>");
        } else if (this._versionedEntity != null) {
            interfaceNames.add("VersionModel<" + this._versionedEntity._name + ">");
        }
        if (this.isWorkflowEnabled()) {
            interfaceNames.add("WorkflowedModel");
        }
        interfaceNames.sort(null);
        StringBundler sb = new StringBundler(2 * interfaceNames.size());
        for (String interfaceName : interfaceNames) {
            sb.append(interfaceName);
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public Set<String> getOverrideColumnNames() {
        HashSet<String> overrideColumnName = new HashSet<String>();
        if (this.isAttachedModel()) {
            overrideColumnName.add("classPK");
        }
        if (this.isAuditedModel()) {
            overrideColumnName.add("companyId");
            overrideColumnName.add("createDate");
            overrideColumnName.add("modifiedDate");
            overrideColumnName.add("userId");
            overrideColumnName.add("userName");
            overrideColumnName.add("userUuid");
        }
        if (this.isChangeTrackingEnabled()) {
            overrideColumnName.add("ctCollectionId");
            overrideColumnName.add("primaryKey");
        }
        if (this.isGroupedModel()) {
            overrideColumnName.add("groupId");
        }
        if (this.isMvccEnabled()) {
            overrideColumnName.add("mvccVersion");
        }
        if (this.isShardedModel()) {
            overrideColumnName.add("companyId");
        }
        if (this.isStagedGroupedModel()) {
            overrideColumnName.add("lastPublishDate");
        }
        if (this.isStagedModel()) {
            overrideColumnName.add("companyId");
            overrideColumnName.add("createDate");
            overrideColumnName.add("modifiedDate");
            overrideColumnName.add("stagedModelType");
            overrideColumnName.add("uuid");
        }
        if (this.isResourcedModel()) {
            overrideColumnName.add("resourcePrimKey");
        }
        if (this.isTrashEnabled()) {
            overrideColumnName.add("status");
        }
        if (this.isTypedModel()) {
            overrideColumnName.add("className");
            overrideColumnName.add("classNameId");
        }
        if (this._versionEntity != null) {
            overrideColumnName.add("headId");
            overrideColumnName.add("primaryKey");
        } else if (this._versionedEntity != null) {
            overrideColumnName.add("primaryKey");
            overrideColumnName.add("version");
        }
        if (this.isWorkflowEnabled()) {
            overrideColumnName.add("status");
            overrideColumnName.add("statusByUserId");
            overrideColumnName.add("statusByUserName");
            overrideColumnName.add("statusByUserUuid");
            overrideColumnName.add("statusDate");
        }
        return overrideColumnName;
    }

    public String getPackagePath() {
        return this._packagePath;
    }

    public List<String> getParentTransients() {
        return this._parentTransients;
    }

    public String getPersistenceClassName() {
        return this._persistenceClassName;
    }

    public String getPKClassName() {
        if (this.hasCompoundPK()) {
            return this._name + "PK";
        }
        EntityColumn entityColumn = this._getPKEntityColumn();
        return entityColumn.getType();
    }

    public String getPKDBName() {
        if (this.hasCompoundPK()) {
            return this.getVariableName() + "PK";
        }
        EntityColumn entityColumn = this._getPKEntityColumn();
        return entityColumn.getDBName();
    }

    public List<String> getPKEntityColumnDBNames() {
        ArrayList<String> pkEntityColumnDBNames = new ArrayList<String>(this._pkEntityColumns.size());
        for (EntityColumn entityColumn : this._pkEntityColumns) {
            pkEntityColumnDBNames.add(entityColumn.getDBName());
        }
        return pkEntityColumnDBNames;
    }

    public List<EntityColumn> getPKEntityColumns() {
        return this._pkEntityColumns;
    }

    public String getPKMethodName() {
        EntityColumn entityColumn = this._getPKEntityColumn();
        return entityColumn.getMethodName();
    }

    public String getPKVariableName() {
        if (this.hasCompoundPK()) {
            return this.getVariableName() + "PK";
        }
        EntityColumn entityColumn = this._getPKEntityColumn();
        return entityColumn.getName();
    }

    public String getPluralHumanName() {
        return this._serviceBuilder.formatPlural(this._humanName);
    }

    public String getPluralName() {
        return this._pluralName;
    }

    public String getPluralPKVariableName() {
        if (this.hasCompoundPK()) {
            return this.getVariableName() + "PKs";
        }
        EntityColumn entityColumn = this._getPKEntityColumn();
        return entityColumn.getPluralName();
    }

    public String getPluralVariableName() {
        return this._pluralVariableName;
    }

    public String getPortletShortName() {
        return this._portletShortName;
    }

    public List<Entity> getReferenceEntities() {
        return this._referenceEntities;
    }

    public List<EntityColumn> getRegularEntityColumns() {
        return this._regularEntityColumns;
    }

    public String getSessionFactory() {
        return this._sessionFactory;
    }

    public String getShortName() {
        if (this._name.startsWith(this._portletShortName)) {
            return this._name.substring(this._portletShortName.length());
        }
        return this._name;
    }

    public String getSpringPropertyName() {
        return TextFormatter.format(this._name, 11);
    }

    public String getTable() {
        return this._table;
    }

    public List<String> getTransients() {
        return this._transients;
    }

    public String getTXManager() {
        return this._txManager;
    }

    public List<String> getTxRequiredMethodNames() {
        return this._txRequiredMethodNames;
    }

    public Map<String, List<EntityColumn>> getUADAnonymizableEntityColumnsMap() {
        HashMap<String, List<EntityColumn>> uadAnonymizableEntityColumnsMap = new HashMap<String, List<EntityColumn>>();
        for (EntityColumn entityColumn : this._entityColumns) {
            if (!entityColumn.isUADUserId()) continue;
            uadAnonymizableEntityColumnsMap.put(entityColumn.getName(), ListUtil.fromArray(entityColumn));
        }
        for (EntityColumn entityColumn : this._entityColumns) {
            List uadAnonymizableEntityColumns;
            if (!entityColumn.isUADUserName() || (uadAnonymizableEntityColumns = (List)uadAnonymizableEntityColumnsMap.get(entityColumn.getUADUserIdColumnName())) == null) continue;
            uadAnonymizableEntityColumns.add(entityColumn);
        }
        return uadAnonymizableEntityColumnsMap;
    }

    public String getUADApplicationName() {
        return this._uadApplicationName;
    }

    public boolean getUADAutoDelete() {
        return this._uadAutoDelete;
    }

    public List<EntityColumn> getUADEntityColumns() {
        ArrayList<EntityColumn> uadEntityColumns = new ArrayList<EntityColumn>();
        uadEntityColumns.add(this._getPKEntityColumn());
        Map<String, List<EntityColumn>> uadAnonymizableEntityColumnsMap = this.getUADAnonymizableEntityColumnsMap();
        for (Map.Entry<String, List<EntityColumn>> entry : uadAnonymizableEntityColumnsMap.entrySet()) {
            uadEntityColumns.addAll((Collection<EntityColumn>)entry.getValue());
        }
        uadEntityColumns.addAll(this.getUADNonanonymizableEntityColumns());
        return uadEntityColumns;
    }

    public List<EntityColumn> getUADNonanonymizableEntityColumns() {
        ArrayList<EntityColumn> uadNonanonymizableEntityColumns = new ArrayList<EntityColumn>();
        for (EntityColumn entityColumn : this._entityColumns) {
            if (!entityColumn.isUADNonanonymizable()) continue;
            uadNonanonymizableEntityColumns.add(entityColumn);
        }
        return uadNonanonymizableEntityColumns;
    }

    public String getUADOutputPath() {
        return this._uadOutputPath;
    }

    public String getUADPackagePath() {
        return this._uadPackagePath;
    }

    public String getUADTestIntegrationOutputPath() {
        return StringUtil.replace(this.getUADOutputPath(), new String[]{"-uad/", "/main/"}, new String[]{"-uad-test/", "/testIntegration/"});
    }

    public List<String> getUADUserIdColumnNames() {
        ArrayList<String> uadUserIdColumnNames = new ArrayList<String>();
        for (EntityColumn entityColumn : this._entityColumns) {
            if (!entityColumn.isUADUserId()) continue;
            uadUserIdColumnNames.add(entityColumn.getName());
        }
        return uadUserIdColumnNames;
    }

    public List<EntityFinder> getUniqueEntityFinders() {
        List<EntityFinder> entityFinders = ListUtil.copy(this._entityFinders);
        Iterator<EntityFinder> iterator = entityFinders.iterator();
        while (iterator.hasNext()) {
            EntityFinder entityFinder = iterator.next();
            if (!entityFinder.isCollection() || entityFinder.isUnique()) continue;
            iterator.remove();
        }
        return entityFinders;
    }

    public List<String> getUnresolvedResolvedReferenceEntityNames() {
        if (this._unresolvedReferenceEntityNames == null) {
            return new ArrayList<String>();
        }
        return this._unresolvedReferenceEntityNames;
    }

    public String getVariableName() {
        return this._variableName;
    }

    public Entity getVersionedEntity() {
        return this._versionedEntity;
    }

    public Entity getVersionEntity() {
        return this._versionEntity;
    }

    public boolean hasActionableDynamicQuery() {
        if (this.hasEntityColumns() && this.hasLocalService()) {
            if (this.hasCompoundPK()) {
                EntityColumn entityColumn = this._pkEntityColumns.get(0);
                return entityColumn.isPrimitiveType();
            }
            return this.hasPrimitivePK();
        }
        return false;
    }

    public boolean hasArrayableOperator() {
        for (EntityFinder finder : this._entityFinders) {
            if (!finder.hasArrayableOperator()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCompoundPK() {
        return this._pkEntityColumns.size() > 1;
    }

    public boolean hasEagerBlobColumn() {
        if (ListUtil.isEmpty(this._blobEntityColumns)) {
            return false;
        }
        for (EntityColumn blobEntityColumns : this._blobEntityColumns) {
            if (blobEntityColumns.isLazy()) continue;
            return true;
        }
        return false;
    }

    public boolean hasEntityColumn(String name) {
        return Entity.hasEntityColumn(this._serviceBuilder, name, this._entityColumns);
    }

    public boolean hasEntityColumn(String name, String type) {
        return Entity.hasEntityColumn(this._serviceBuilder, name, type, this._entityColumns);
    }

    public boolean hasEntityColumns() {
        return !ListUtil.isEmpty(this._entityColumns);
    }

    public boolean hasExternalReferenceCode() {
        return !StringUtil.equals(this._externalReferenceCode, "none");
    }

    public boolean hasFinderClassName() {
        return !Validator.isNull(this._finderClassName);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean hasLazyBlobEntityColumn() {
        if (ListUtil.isEmpty(this._blobEntityColumns)) {
            return false;
        }
        for (EntityColumn blobEntityColumns : this._blobEntityColumns) {
            if (!blobEntityColumns.isLazy()) continue;
            return true;
        }
        return false;
    }

    public boolean hasLocalService() {
        return this._localService;
    }

    public boolean hasPersistence() {
        return this._persistence;
    }

    public boolean hasPrimitivePK() {
        return this.hasPrimitivePK(true);
    }

    public boolean hasPrimitivePK(boolean includeWrappers) {
        if (this._pkEntityColumns.size() != 1) {
            return false;
        }
        EntityColumn entityColumn = this._getPKEntityColumn();
        return entityColumn.isPrimitiveType(includeWrappers);
    }

    public boolean hasRemoteService() {
        return this._remoteService;
    }

    public boolean hasUuid() {
        return this._uuid;
    }

    public boolean hasUuidAccessor() {
        return this._uuidAccessor;
    }

    public boolean isAttachedModel() {
        EntityColumn classPKEntityColumn;
        String classPKColType;
        if (!this.isTypedModel()) {
            return false;
        }
        return this.hasEntityColumn("classPK") && (classPKColType = (classPKEntityColumn = this.getEntityColumn("classPK")).getType()).equals("long");
    }

    public boolean isAuditedModel() {
        return this.hasEntityColumn("companyId") && this.hasEntityColumn("createDate", "Date") && this.hasEntityColumn("modifiedDate", "Date") && this.hasEntityColumn("userId") && this.hasEntityColumn("userName");
    }

    public boolean isCacheEnabled() {
        return this._cacheEnabled;
    }

    public boolean isChangeTrackingEnabled() {
        return this._changeTrackingEnabled;
    }

    public boolean isContainerModel() {
        return this._containerModel;
    }

    public boolean isDefaultDataSource() {
        return this._dataSource.equals(_DATA_SOURCE_DEFAULT);
    }

    public boolean isDefaultSessionFactory() {
        return this._sessionFactory.equals(_SESSION_FACTORY_DEFAULT);
    }

    public boolean isDefaultTXManager() {
        return this._txManager.equals(_TX_MANAGER_DEFAULT);
    }

    public boolean isDeprecated() {
        return this._deprecated;
    }

    public boolean isDynamicUpdateEnabled() {
        return this._dynamicUpdateEnabled;
    }

    public boolean isGroupedModel() {
        String pkVariableName = this.getPKVariableName();
        return this.isAuditedModel() && this.hasEntityColumn("groupId") && !pkVariableName.equals("groupId");
    }

    public boolean isHierarchicalTree() {
        if (!this.hasPrimitivePK()) {
            return false;
        }
        EntityColumn entityColumn = this._getPKEntityColumn();
        String methodName = entityColumn.getMethodName();
        return this._entityColumns.contains(new EntityColumn(this._serviceBuilder, "parent" + methodName)) && this._entityColumns.contains(new EntityColumn(this._serviceBuilder, "left" + methodName)) && this._entityColumns.contains(new EntityColumn(this._serviceBuilder, "right" + methodName));
    }

    public boolean isJsonEnabled() {
        return this._jsonEnabled;
    }

    public boolean isLocalizedModel() {
        for (EntityColumn entityColumn : this._entityColumns) {
            if (!entityColumn.isLocalized()) continue;
            return true;
        }
        return false;
    }

    public boolean isMvccEnabled() {
        return this._mvccEnabled;
    }

    public boolean isOrdered() {
        return this._entityOrder != null;
    }

    public boolean isPermissionCheckEnabled() {
        for (EntityFinder entityFinder : this._entityFinders) {
            if (!this.isPermissionCheckEnabled(entityFinder)) continue;
            return true;
        }
        return false;
    }

    public boolean isPermissionCheckEnabled(EntityFinder entityFinder) {
        boolean resourceActionModel = this._resourceActionModel;
        if (this._serviceBuilder.isVersionLTE_7_1_0() && this._packagePath.equals("com.liferay.portlet.asset") && this._name.equals("AssetTag")) {
            resourceActionModel = true;
        }
        String entityFinderName = entityFinder.getName();
        if (this._name.equals("Group") || this._name.equals("User") || entityFinderName.equals("UUID_G") || !entityFinder.isCollection() || !this.hasPrimitivePK() || !resourceActionModel) {
            return false;
        }
        if (this.hasEntityColumn("groupId") && !entityFinder.hasEntityColumn("groupId")) {
            return false;
        }
        EntityColumn entityColumn = this._getPKEntityColumn();
        return StringUtil.equalsIgnoreCase("long", entityColumn.getType());
    }

    public boolean isPermissionedModel() {
        return this._serviceBuilder.isVersionLTE_7_2_0() && this.hasEntityColumn("resourceBlockId");
    }

    public boolean isPortalReference() {
        return this._portalReference;
    }

    public boolean isResolved() {
        return this._unresolvedReferenceEntityNames != null && this._unresolvedReferenceEntityNames.isEmpty();
    }

    public boolean isResourcedModel() {
        String pkVariableName = this.getPKVariableName();
        return this.hasEntityColumn("resourcePrimKey") && !pkVariableName.equals("resourcePrimKey");
    }

    public boolean isShardedModel() {
        if (this._packagePath.equals("com.liferay.portal") && (this._name.equals("Company") || this._serviceBuilder.isVersionGTE_7_4_0() && this._name.equals("VirtualHost"))) {
            return false;
        }
        return this.hasEntityColumn("companyId");
    }

    public boolean isStagedAuditedModel() {
        return this.isAuditedModel() && this.isStagedModel();
    }

    public boolean isStagedGroupedModel() {
        return this.isGroupedModel() && this.isStagedModel() && this.hasEntityColumn("lastPublishDate", "Date");
    }

    public boolean isStagedModel() {
        return this.hasUuid() && this.hasEntityColumn("companyId") && this.hasEntityColumn("createDate", "Date") && this.hasEntityColumn("modifiedDate", "Date");
    }

    public boolean isTrashEnabled() {
        return this._trashEnabled;
    }

    public boolean isTreeModel() {
        return this.hasEntityColumn("treePath");
    }

    public boolean isTypedModel() {
        EntityColumn classNameIdEntityColumn;
        String classNameIdColType;
        return this.hasEntityColumn("classNameId") && (classNameIdColType = (classNameIdEntityColumn = this.getEntityColumn("classNameId")).getType()).equals("long");
    }

    public boolean isUADEnabled() {
        for (EntityColumn entityColumn : this._entityColumns) {
            if (!entityColumn.isUADEnabled()) continue;
            return true;
        }
        return false;
    }

    public boolean isWorkflowEnabled() {
        return this.hasEntityColumn("status") && this.hasEntityColumn("statusByUserId") && this.hasEntityColumn("statusByUserName") && this.hasEntityColumn("statusDate");
    }

    public void setApiPackagePath(String apiPackagePath) {
        this._apiPackagePath = apiPackagePath;
    }

    public void setLocalizedEntity(Entity localizedEntity) {
        this._localizedEntity = localizedEntity;
        this._referenceEntities.add(localizedEntity);
    }

    public void setLocalizedEntityColumns(List<EntityColumn> localizedEntityColumns) {
        this._localizedEntityColumns = localizedEntityColumns;
    }

    public void setParentTransients(List<String> transients) {
        this._parentTransients = transients;
    }

    public void setPortalReference(boolean portalReference) {
        this._portalReference = portalReference;
    }

    public void setResolved() {
        this._unresolvedReferenceEntityNames = null;
    }

    public void setTransients(List<String> transients) {
        this._transients = transients;
    }

    public void setVersionedEntity(Entity versionedEntity) {
        this._versionedEntity = versionedEntity;
    }

    public void setVersionEntity(Entity versionEntity) {
        this._versionEntity = versionEntity;
        this._referenceEntities.add(versionEntity);
    }

    private EntityColumn _getPKEntityColumn() {
        if (this._pkEntityColumns.isEmpty()) {
            throw new RuntimeException("There is no primary key for entity " + this._name);
        }
        return this._pkEntityColumns.get(0);
    }
}

