/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.log;

import com.liferay.portal.kernel.log.LogContext;
import com.liferay.portal.kernel.module.util.SystemBundleUtil;
import com.liferay.portal.kernel.util.BasePortalLifecycle;
import com.liferay.portal.kernel.util.PortalLifecycleUtil;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class LogContextRegistryUtil {
    private static final Set<LogContext> _logContexts = Collections.newSetFromMap(new ConcurrentHashMap());

    public static Set<LogContext> getLogContexts() {
        return _logContexts;
    }

    public static void registerLogContext(LogContext logContext) {
        _logContexts.add(logContext);
    }

    public static void unregisterLogContext(LogContext logContext) {
        _logContexts.remove(logContext);
    }

    static {
        PortalLifecycleUtil.register(new BasePortalLifecycle(){
            private volatile ServiceTracker<LogContext, LogContext> _serviceTracker;

            @Override
            protected void doPortalDestroy() {
                if (this._serviceTracker != null) {
                    this._serviceTracker.close();
                }
            }

            @Override
            protected void doPortalInit() {
                this._serviceTracker = new ServiceTracker(SystemBundleUtil.getBundleContext(), LogContext.class, (ServiceTrackerCustomizer)new LogContextTrackerCustomizer());
                this._serviceTracker.open();
            }
        }, 0);
    }

    private static class LogContextTrackerCustomizer
    implements ServiceTrackerCustomizer<LogContext, LogContext> {
        private LogContextTrackerCustomizer() {
        }

        public LogContext addingService(ServiceReference<LogContext> serviceReference) {
            BundleContext bundleContext = SystemBundleUtil.getBundleContext();
            LogContext logContext = (LogContext)bundleContext.getService(serviceReference);
            _logContexts.add(logContext);
            return logContext;
        }

        public void modifiedService(ServiceReference<LogContext> serviceReference, LogContext logContext) {
        }

        public void removedService(ServiceReference<LogContext> serviceReference, LogContext logContext) {
            _logContexts.remove(logContext);
            BundleContext bundleContext = SystemBundleUtil.getBundleContext();
            bundleContext.ungetService(serviceReference);
        }
    }
}

