/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.EnvPropertiesUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.SystemEnv;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;

public class SystemProperties {
    public static final String SYSTEM_ENV_OVERRIDE_PREFIX = "SYSTEM_LIFERAY_";
    public static final String SYSTEM_PROPERTIES_QUIET = "system.properties.quiet";
    public static final String SYSTEM_PROPERTIES_SET = "system.properties.set";
    public static final String SYSTEM_PROPERTIES_SET_OVERRIDE = "system.properties.set.override";
    public static final String TMP_DIR = "java.io.tmpdir";
    private static final Map<String, String> _properties = new ConcurrentHashMap<String, String>();

    public static void clear(String key) {
        System.clearProperty(key);
        _properties.remove(key);
    }

    public static String get(String key) {
        return SystemProperties.get(key, null);
    }

    public static String get(String key, String defaultValue) {
        String value = _properties.get(key);
        if (value == null) {
            value = System.getProperty(key, defaultValue);
        }
        return SystemProperties._resolveReference(value);
    }

    public static String[] getArray(String key) {
        return StringUtil.split(SystemProperties.get(key));
    }

    public static Properties getProperties() {
        return PropertiesUtil.fromMap(_properties);
    }

    public static Map<String, String> getProperties(String prefix, boolean removePrefix) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : _properties.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            if (removePrefix) {
                key = key.substring(prefix.length());
            }
            properties.put(key, SystemProperties._resolveReference(entry.getValue()));
        }
        return properties;
    }

    public static void load(ClassLoader classLoader) {
        Enumeration<URL> enumeration;
        Properties properties = new Properties();
        ArrayList<URL> urls = null;
        if (!GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_QUIET))) {
            urls = new ArrayList<URL>();
        }
        try {
            enumeration = classLoader.getResources("system.properties");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                SystemProperties._load(uRL, properties);
                if (urls == null) continue;
                urls.add(uRL);
            }
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
        try {
            enumeration = classLoader.getResources("system-ext.properties");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                SystemProperties._load(uRL, properties);
                if (urls == null) continue;
                urls.add(uRL);
            }
        }
        catch (IOException ioException) {
            throw new ExceptionInInitializerError(ioException);
        }
        SystemEnv.setProperties(properties);
        if (GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_SET), true)) {
            boolean systemPropertiesSetOverride = GetterUtil.getBoolean(System.getProperty(SYSTEM_PROPERTIES_SET_OVERRIDE), true);
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                String key = String.valueOf(entry.getKey());
                if (!systemPropertiesSetOverride && !Validator.isNull(System.getProperty(key))) continue;
                System.setProperty(key, String.valueOf(entry.getValue()));
            }
            if (!systemPropertiesSetOverride) {
                Properties properties2 = System.getProperties();
                for (Map.Entry<Object, Object> entry : properties2.entrySet()) {
                    String key = String.valueOf(entry.getKey());
                    if (!Validator.isNotNull(properties.get(key))) continue;
                    properties.put(key, entry.getValue());
                }
            }
        }
        PropertiesUtil.fromProperties(properties, _properties);
        EnvPropertiesUtil.loadEnvOverrides(SYSTEM_ENV_OVERRIDE_PREFIX, 0L, SystemProperties::set);
        if (urls != null) {
            for (URL uRL : urls) {
                System.out.println("Loading " + uRL);
            }
        }
    }

    public static void set(String key, String value) {
        System.setProperty(key, value);
        _properties.put(key, value);
    }

    private static void _load(URL url, Properties properties) throws IOException {
        block49: {
            try (InputStream inputStream = url.openStream();
                 InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                 UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(inputStreamReader);){
                String line = null;
                StringBundler sb = new StringBundler();
                while ((line = unsyncBufferedReader.readLine()) != null) {
                    if ((line = line.trim()).isEmpty() || line.charAt(0) == '#' || line.equals("\\")) continue;
                    sb.append(line);
                    sb.append("\n");
                }
                if (sb.index() == 0) break block49;
                try (UnsyncStringReader unsyncStringReader = new UnsyncStringReader(sb.toString());){
                    properties.load(unsyncStringReader);
                }
            }
        }
    }

    private static String _resolveReference(String value) {
        int endIndex;
        if (value == null) {
            return null;
        }
        StringBundler sb = new StringBundler();
        int startIndex = 0;
        while ((startIndex = value.indexOf("${")) != -1 && (endIndex = value.indexOf("}", startIndex)) != -1) {
            String placeholderKey = value.substring(startIndex + "${".length(), endIndex);
            if ("".equals(placeholderKey)) {
                sb.append(value.substring(0, endIndex + 1));
            } else {
                String placeholderValue = SystemProperties.get(placeholderKey);
                if (placeholderValue == null) {
                    sb.append(value.substring(0, endIndex + 1));
                } else {
                    sb.append(value.substring(0, startIndex));
                    sb.append(placeholderValue);
                }
            }
            value = value.substring(endIndex + 1);
        }
        if (sb.index() > 0) {
            sb.append(value);
            return sb.toString();
        }
        return value;
    }

    static {
        Thread currentThread = Thread.currentThread();
        ClassLoader classLoader = currentThread.getContextClassLoader();
        SystemProperties.load(classLoader);
    }
}

