/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.concurrent.ConcurrentReferenceKeyHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.language.LanguageBuilderUtil;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.language.UTF8Control;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.resource.bundle.ResourceBundleLoaderUtil;
import com.liferay.portal.kernel.util.AggregateResourceBundle;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ClassResourceBundleLoader;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PortalClassLoaderUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ResourceBundleLoader;
import com.liferay.registry.Registry;
import com.liferay.registry.RegistryUtil;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;

public class ResourceBundleUtil {
    public static final ResourceBundle EMPTY_RESOURCE_BUNDLE = new ResourceBundle(){

        @Override
        public Enumeration<String> getKeys() {
            return Collections.emptyEnumeration();
        }

        @Override
        protected Object handleGetObject(String key) {
            return key;
        }
    };
    private static final Log _log = LogFactoryUtil.getLog(ResourceBundleUtil.class);
    private static final Set<ClassLoader> _portalResourceBundleClassLoaders = Collections.newSetFromMap(new ConcurrentReferenceKeyHashMap(FinalizeManager.WEAK_REFERENCE_FACTORY));

    public static ResourceBundle getBundle(Locale locale, Class<?> clazz) {
        return ResourceBundleUtil.getBundle("content.Language", locale, clazz);
    }

    public static ResourceBundle getBundle(Locale locale, ClassLoader classLoader) {
        return ResourceBundleUtil.getBundle("content.Language", locale, classLoader);
    }

    public static ResourceBundle getBundle(Locale locale, String symbolicName) {
        return ResourceBundleUtil._getBundle("content.Language", locale, ResourceBundleUtil.class.getClassLoader(), symbolicName);
    }

    public static ResourceBundle getBundle(String baseName, Class<?> clazz) {
        return ResourceBundleUtil.getBundle(baseName, clazz.getClassLoader());
    }

    public static ResourceBundle getBundle(String baseName, ClassLoader classLoader) {
        return ResourceBundleUtil.getBundle(baseName, LocaleUtil.getDefault(), classLoader);
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, Class<?> clazz) {
        return ResourceBundleUtil.getBundle(baseName, locale, clazz.getClassLoader());
    }

    public static ResourceBundle getBundle(String baseName, Locale locale, ClassLoader classLoader) {
        Registry registry = RegistryUtil.getRegistry();
        return ResourceBundleUtil._getBundle(baseName, locale, classLoader, registry.getSymbolicName(classLoader));
    }

    @Deprecated
    public static Map<Locale, String> getLocalizationMap(final ResourceBundleLoader resourceBundleLoader, String key) {
        return ResourceBundleUtil.getLocalizationMap(new com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader(){

            public ResourceBundle loadResourceBundle(Locale locale) {
                return resourceBundleLoader.loadResourceBundle(locale);
            }
        }, key);
    }

    public static Map<Locale, String> getLocalizationMap(com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader resourceBundleLoader, String key) {
        HashMap<Locale, String> map = new HashMap<Locale, String>();
        for (Locale locale : LanguageUtil.getAvailableLocales()) {
            ResourceBundle resourceBundle = resourceBundleLoader.loadResourceBundle(locale);
            map.put(locale, ResourceBundleUtil.getString(resourceBundle, key));
        }
        return map;
    }

    public static ResourceBundle getModuleAndPortalResourceBundle(Locale locale, Class<?> clazz) {
        return new AggregateResourceBundle(ResourceBundleUtil.getBundle(locale, clazz), PortalUtil.getResourceBundle(locale));
    }

    @Deprecated
    public static ResourceBundleLoader getResourceBundleLoader(String baseName, ClassLoader classLoader) {
        return new ClassResourceBundleLoader(baseName, classLoader);
    }

    public static String getString(ResourceBundle resourceBundle, String key) {
        if (!resourceBundle.containsKey(key)) {
            return null;
        }
        try {
            return LanguageBuilderUtil.fixValue((String)resourceBundle.getString(key));
        }
        catch (MissingResourceException missingResourceException) {
            if (_log.isDebugEnabled()) {
                _log.debug(missingResourceException, missingResourceException);
            }
            return null;
        }
    }

    public static String getString(ResourceBundle resourceBundle, String key, Object ... arguments) {
        String value = ResourceBundleUtil.getString(resourceBundle, key);
        if (value == null) {
            return null;
        }
        if (ArrayUtil.isNotEmpty(arguments)) {
            MessageFormat messageFormat = new MessageFormat(value, resourceBundle.getLocale());
            value = messageFormat.format(arguments);
        }
        return value;
    }

    private static ResourceBundle _getBundle(String baseName, Locale locale, ClassLoader classLoader, String symbolicName) {
        com.liferay.portal.kernel.resource.bundle.ResourceBundleLoader resourceBundleLoader = null;
        if (symbolicName == null) {
            ClassLoader portalClassLoader = PortalClassLoaderUtil.getClassLoader();
            if (classLoader == portalClassLoader) {
                resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
            }
        } else {
            resourceBundleLoader = ResourceBundleLoaderUtil.getResourceBundleLoaderByBundleSymbolicName((String)symbolicName);
        }
        if (resourceBundleLoader == null) {
            if (!_portalResourceBundleClassLoaders.contains(classLoader)) {
                try {
                    return ResourceBundle.getBundle(baseName, locale, classLoader, (ResourceBundle.Control)UTF8Control.INSTANCE);
                }
                catch (MissingResourceException missingResourceException) {
                    if (_log.isDebugEnabled()) {
                        _log.debug(missingResourceException, missingResourceException);
                    }
                    _portalResourceBundleClassLoaders.add(classLoader);
                }
            }
            resourceBundleLoader = ResourceBundleLoaderUtil.getPortalResourceBundleLoader();
        }
        return resourceBundleLoader.loadResourceBundle(locale);
    }
}

