/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.service.builder;

import com.liferay.portal.kernel.model.ModelHintsCallback;
import com.liferay.portal.model.BaseModelHintsImpl;
import com.liferay.portal.xml.SAXReaderFactory;

import org.dom4j.io.SAXReader;

/**
 * @author Raymond Augé
 */
public class ModelHintsImpl extends BaseModelHintsImpl {

	@Override
	public ModelHintsCallback getModelHintsCallback() {
		return _modelHintsCallback;
	}

	@Override
	public String[] getModelHintsConfigs() {
		return _modelHintsConfigs;
	}

	@Override
	public SAXReader getSAXReader() {
		return SAXReaderFactory.getSAXReader(null, true, true);
	}

	public void setModelHintsConfigs(String[] modelHintsConfigs) {
		_modelHintsConfigs = modelHintsConfigs;
	}

	private final ModelHintsCallback _modelHintsCallback =
		new CompileTimeModelHintsCallback();
	private String[] _modelHintsConfigs;

	private static class CompileTimeModelHintsCallback
		implements ModelHintsCallback {

		@Override
		public void execute(ClassLoader classLoader, String name) {
		}

	}

}