/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.petra.nio.CharsetDecoderUtil;
import com.liferay.petra.nio.CharsetEncoderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.UnicodeFormatter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;

public class URLCodec {
    private static final char[][] _ENCODING_REPLACEMENTS;
    private static final boolean[] _VALID_CHARS;
    private static final Log _log;

    public static String decodeURL(String encodedURLString) {
        return URLCodec.decodeURL(encodedURLString, "UTF-8");
    }

    public static String decodeURL(String encodedURLString, String charsetName) {
        if (encodedURLString == null) {
            return null;
        }
        if (encodedURLString.length() == 0) {
            return "";
        }
        StringBuilder sb = null;
        CharsetDecoder charsetDecoder = null;
        for (int i = 0; i < encodedURLString.length(); ++i) {
            char c = encodedURLString.charAt(i);
            if (c == '%') {
                ByteBuffer byteBuffer = URLCodec._getEncodedByteBuffer(encodedURLString, i);
                if (charsetDecoder == null) {
                    charsetDecoder = CharsetDecoderUtil.getCharsetDecoder((String)charsetName);
                }
                CharBuffer charBuffer = null;
                try {
                    charBuffer = charsetDecoder.decode(byteBuffer);
                }
                catch (CharacterCodingException characterCodingException) {
                    _log.error(characterCodingException, characterCodingException);
                    return "";
                }
                if (sb == null) {
                    sb = new StringBuilder(encodedURLString.length());
                    if (i > 0) {
                        sb.append(encodedURLString, 0, i);
                    }
                }
                sb.append(charBuffer);
                i += byteBuffer.capacity() * 3 - 1;
                continue;
            }
            if (c == '+') {
                if (sb == null) {
                    sb = new StringBuilder(encodedURLString.length());
                    if (i > 0) {
                        sb.append(encodedURLString, 0, i);
                    }
                }
                sb.append(' ');
                continue;
            }
            if (sb == null) continue;
            sb.append(c);
        }
        if (sb == null) {
            return encodedURLString;
        }
        return sb.toString();
    }

    public static String encodeURL(String rawURLString) {
        return URLCodec.encodeURL(rawURLString, "UTF-8", false);
    }

    public static String encodeURL(String rawURLString, boolean escapeSpaces) {
        return URLCodec.encodeURL(rawURLString, "UTF-8", escapeSpaces);
    }

    public static String encodeURL(String rawURLString, String charsetName, boolean escapeSpaces) {
        if (rawURLString == null) {
            return null;
        }
        if (rawURLString.isEmpty()) {
            return "";
        }
        CharsetEncoder charsetEncoder = null;
        char[] hexes = new char[2];
        int lastReplacementIndex = 0;
        StringBuilder sb = null;
        for (int i = 0; i < rawURLString.length(); ++i) {
            char[] encodingReplacement;
            char c = rawURLString.charAt(i);
            if (c < '\u0080' && _VALID_CHARS[c]) continue;
            if (sb == null) {
                sb = new StringBuilder(rawURLString.length() + 64);
                sb.append(rawURLString, 0, i);
            } else if (i > lastReplacementIndex) {
                sb.append(rawURLString, lastReplacementIndex, i);
            }
            if (c < '\u0080' && (encodingReplacement = _ENCODING_REPLACEMENTS[c]) != null) {
                if (!escapeSpaces && c == ' ') {
                    sb.append('+');
                } else {
                    sb.append(encodingReplacement);
                }
                lastReplacementIndex = i + 1;
                continue;
            }
            CharBuffer charBuffer = URLCodec._getRawCharBuffer(rawURLString, i, escapeSpaces);
            if (charsetEncoder == null) {
                charsetEncoder = CharsetEncoderUtil.getCharsetEncoder((String)charsetName);
            }
            lastReplacementIndex = (i += charBuffer.length() - 1) + 1;
            ByteBuffer byteBuffer = null;
            try {
                byteBuffer = charsetEncoder.encode(charBuffer);
            }
            catch (CharacterCodingException characterCodingException) {
                _log.error(characterCodingException, characterCodingException);
                return "";
            }
            for (int j = byteBuffer.position(); j < byteBuffer.limit(); ++j) {
                sb.append('%');
                sb.append(UnicodeFormatter.byteToHex(byteBuffer.get(), hexes, true));
            }
        }
        if (sb == null) {
            return rawURLString;
        }
        if (lastReplacementIndex < rawURLString.length()) {
            sb.append(rawURLString, lastReplacementIndex, rawURLString.length());
        }
        return sb.toString();
    }

    private static int _charToHex(char c) {
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        throw new IllegalArgumentException(c + " is not a hex char");
    }

    private static ByteBuffer _getEncodedByteBuffer(String encodedString, int start) {
        int count = 1;
        for (int i = start + 3; i < encodedString.length() && encodedString.charAt(i) == '%'; i += 3) {
            ++count;
        }
        if (encodedString.length() < start + count * 3) {
            throw new IllegalArgumentException("Invalid URL encoding " + encodedString);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(count);
        for (int i = start; i < start + count * 3; i += 3) {
            int high = URLCodec._charToHex(encodedString.charAt(i + 1));
            int low = URLCodec._charToHex(encodedString.charAt(i + 2));
            byteBuffer.put((byte)((high << 4) + low));
        }
        byteBuffer.flip();
        return byteBuffer;
    }

    private static CharBuffer _getRawCharBuffer(String rawString, int start, boolean escapeSpaces) {
        char rawChar;
        int count = 0;
        for (int i = start; !(i >= rawString.length() || (rawChar = rawString.charAt(i)) < '\u0080' && _VALID_CHARS[rawChar] || !escapeSpaces && rawChar == ' '); ++i) {
            ++count;
            if (!Character.isHighSurrogate(rawChar) || i + 1 >= rawString.length() || !Character.isLowSurrogate(rawString.charAt(i + 1))) continue;
            ++i;
            ++count;
        }
        return CharBuffer.wrap(rawString, start, start + count);
    }

    static {
        int i;
        _ENCODING_REPLACEMENTS = new char[128][];
        _VALID_CHARS = new boolean[128];
        _log = LogFactoryUtil.getLog(URLCodec.class);
        URLCodec._ENCODING_REPLACEMENTS[38] = "%26".toCharArray();
        URLCodec._ENCODING_REPLACEMENTS[58] = "%3A".toCharArray();
        URLCodec._ENCODING_REPLACEMENTS[61] = "%3D".toCharArray();
        URLCodec._ENCODING_REPLACEMENTS[37] = "%25".toCharArray();
        URLCodec._ENCODING_REPLACEMENTS[43] = "%2B".toCharArray();
        URLCodec._ENCODING_REPLACEMENTS[63] = "%3F".toCharArray();
        URLCodec._ENCODING_REPLACEMENTS[47] = "%2F".toCharArray();
        URLCodec._ENCODING_REPLACEMENTS[32] = "%20".toCharArray();
        for (i = 97; i <= 122; ++i) {
            URLCodec._VALID_CHARS[i] = true;
        }
        for (i = 65; i <= 90; ++i) {
            URLCodec._VALID_CHARS[i] = true;
        }
        for (i = 48; i <= 57; ++i) {
            URLCodec._VALID_CHARS[i] = true;
        }
        URLCodec._VALID_CHARS[45] = true;
        URLCodec._VALID_CHARS[95] = true;
        URLCodec._VALID_CHARS[46] = true;
        URLCodec._VALID_CHARS[42] = true;
    }
}

