/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Stack;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Actor;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;

public class AttributeSet
extends Actor {
    StructuredQName attributeSetName;
    private boolean declaredStreamable;

    public SymbolicName getSymbolicName() {
        return new SymbolicName(136, this.attributeSetName);
    }

    public void setName(StructuredQName attributeSetName) {
        this.attributeSetName = attributeSetName;
    }

    public void setDeclaredStreamable(boolean value) {
        this.declaredStreamable = value;
    }

    public boolean isDeclaredStreamable() {
        return this.declaredStreamable;
    }

    public void setStackFrameMap(SlotManager stackFrameMap) {
        if (stackFrameMap != null) {
            super.setStackFrameMap(stackFrameMap);
        }
    }

    public int getFocusDependencies() {
        return this.body.getDependencies() & 0x1E;
    }

    public void expand(XPathContext context) throws XPathException {
        Stack<AttributeSet> stack = context.getController().getAttributeSetEvaluationStack();
        if (stack.contains(this)) {
            throw new XPathException("Attribute set " + this.getObjectName().getEQName() + " invokes itself recursively", "XTDE0640");
        }
        stack.push(this);
        this.getBody().process(context);
        stack.pop();
        if (stack.isEmpty()) {
            context.getController().releaseAttributeSetEvaluationStack();
        }
    }

    public int getConstructType() {
        return 136;
    }

    public StructuredQName getObjectName() {
        return this.attributeSetName;
    }

    public int getComponentKind() {
        return 136;
    }

    public void export(ExpressionPresenter presenter) throws XPathException {
        presenter.startElement("attributeSet");
        presenter.emitAttribute("name", this.getObjectName().getEQName());
        presenter.emitAttribute("line", this.getLineNumber() + "");
        presenter.emitAttribute("module", this.getSystemId());
        presenter.emitAttribute("slots", this.getStackFrameMap().getNumberOfVariables() + "");
        presenter.emitAttribute("binds", this.getDeclaringComponent().getComponentBindings().size() + "");
        if (this.isDeclaredStreamable()) {
            presenter.emitAttribute("flags", "s");
        }
        this.getBody().export(presenter);
        presenter.endElement();
    }
}

