/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.service.builder;

import com.liferay.petra.xml.Dom4jUtil;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.db.IndexMetadata;
import com.liferay.portal.kernel.dao.db.IndexMetadataFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.cache.CacheField;
import com.liferay.portal.kernel.plugin.Version;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.BaseMapBuilder;
import com.liferay.portal.kernel.util.ClearThreadLocalUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropertiesUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.StringUtil_IW;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.Validator_IW;
import com.liferay.portal.tools.ArgumentsUtil;
import com.liferay.portal.tools.ToolsUtil;
import com.liferay.portal.tools.java.parser.JavaParser;
import com.liferay.portal.tools.service.builder.Entity;
import com.liferay.portal.tools.service.builder.EntityColumn;
import com.liferay.portal.tools.service.builder.EntityFinder;
import com.liferay.portal.tools.service.builder.EntityMapping;
import com.liferay.portal.tools.service.builder.EntityOrder;
import com.liferay.portal.tools.service.builder.ModelHintsImpl;
import com.liferay.portal.tools.service.builder.ServiceBuilderArgs;
import com.liferay.portal.tools.service.builder.ServiceBuilderException;
import com.liferay.portal.xml.SAXReaderFactory;
import com.liferay.util.xml.XMLSafeReader;
import com.thoughtworks.qdox.JavaProjectBuilder;
import com.thoughtworks.qdox.library.ClassLibraryBuilder;
import com.thoughtworks.qdox.library.SortedClassLibraryBuilder;
import com.thoughtworks.qdox.model.DocletTag;
import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.impl.AbstractBaseJavaEntity;
import com.thoughtworks.qdox.model.impl.DefaultJavaMethod;
import com.thoughtworks.qdox.model.impl.DefaultJavaParameterizedType;
import freemarker.cache.ClassTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.ext.beans.BeansWrapper;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateHashModel;
import freemarker.template.TemplateModelException;
import java.beans.Introspector;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.XPath;
import org.dom4j.io.SAXReader;

public class ServiceBuilder {
    public static final String AUTHOR = "Brian Wing Shun Chan";
    private static final int _DEFAULT_COLUMN_MAX_LENGTH = 75;
    private static final int _MAX_LINE_LENGTH = 80;
    private static final int _SESSION_TYPE_LOCAL = 1;
    private static final int _SESSION_TYPE_REMOTE = 0;
    private static final String _SPRING_NAMESPACE_BEANS = "beans";
    private static final String _SQL_CREATE_TABLE = "create table ";
    private static final String _TMP_DIR_NAME = System.getProperty("java.io.tmpdir");
    private static final String _TPL_ROOT = "com/liferay/portal/tools/service/builder/dependencies/";
    private static Pattern _beansAttributePattern = Pattern.compile("\\s+([^=]*)=\\s*\"([^\"]*)\"");
    private static Pattern _beansPattern = Pattern.compile("<beans[^>]*>");
    private static Configuration _configuration;
    private static final Pattern _dtdVersionPattern;
    private static Pattern _getterPattern;
    private static Pattern _setterPattern;
    private String _apiDirName;
    private String _apiPackagePath;
    private String _author;
    private boolean _autoImportDefaultReferences;
    private boolean _autoNamespaceTables;
    private Set<String> _badAliasNames;
    private Set<String> _badColumnNames;
    private Set<String> _badTableNames;
    private String _beanLocatorUtil;
    private boolean _build;
    private long _buildNumber;
    private boolean _buildNumberIncrement;
    private boolean _changeTrackingEnabled;
    private boolean _commercialPlugin;
    private Properties _compatProperties;
    private String _currentTplName;
    private int _databaseNameMaxLength = 30;
    private boolean _dependencyInjectorDS;
    private Version _dtdVersion;
    private List<Entity> _entities;
    private Map<String, EntityMapping> _entityMappings;
    private Map<String, Entity> _entityPool = new HashMap<String, Entity>();
    private String _hbmFileName;
    private String _implDirName;
    private Map<String, JavaClass> _javaClasses = new HashMap<String, JavaClass>();
    private String _modelHintsFileName;
    private Set<String> _modifiedFileNames = new HashSet<String>();
    private boolean _mvccEnabled;
    private String _oldServiceOutputPath;
    private boolean _osgiModule;
    private String _outputPath;
    private String _packagePath;
    private String _pluginName;
    private String _portletShortName = "";
    private String _propsUtil;
    private String[] _readOnlyPrefixes;
    private Set<String> _resourceActionModels = new HashSet<String>();
    private String _resourcesDirName;
    private String _serviceOutputPath;
    private String _springFileName;
    private String[] _springNamespaces;
    private String _sqlDirName;
    private String _sqlFileName;
    private String _sqlIndexesFileName;
    private String _sqlSequencesFileName;
    private String _targetEntityName;
    private String _testDirName;
    private String _testOutputPath;
    private String _tplBadAliasNames = "com/liferay/portal/tools/service/builder/dependencies/bad_alias_names.txt";
    private String _tplBadColumnNames = "com/liferay/portal/tools/service/builder/dependencies/bad_column_names.txt";
    private String _tplBadTableNames = "com/liferay/portal/tools/service/builder/dependencies/bad_table_names.txt";
    private String _tplBaseUADAnonymizer = "com/liferay/portal/tools/service/builder/dependencies/base_uad_anonymizer.ftl";
    private String _tplBaseUADDisplay = "com/liferay/portal/tools/service/builder/dependencies/base_uad_display.ftl";
    private String _tplBaseUADExporter = "com/liferay/portal/tools/service/builder/dependencies/base_uad_exporter.ftl";
    private String _tplBlobModel = "com/liferay/portal/tools/service/builder/dependencies/blob_model.ftl";
    private String _tplCTServiceImpl = "com/liferay/portal/tools/service/builder/dependencies/ct_service_impl.ftl";
    private String _tplEjbPK = "com/liferay/portal/tools/service/builder/dependencies/ejb_pk.ftl";
    private String _tplException = "com/liferay/portal/tools/service/builder/dependencies/exception.ftl";
    private String _tplExtendedModel = "com/liferay/portal/tools/service/builder/dependencies/extended_model.ftl";
    private String _tplExtendedModelBaseImpl = "com/liferay/portal/tools/service/builder/dependencies/extended_model_base_impl.ftl";
    private String _tplExtendedModelImpl = "com/liferay/portal/tools/service/builder/dependencies/extended_model_impl.ftl";
    private String _tplFinder = "com/liferay/portal/tools/service/builder/dependencies/finder.ftl";
    private String _tplFinderBaseImpl = "com/liferay/portal/tools/service/builder/dependencies/finder_base_impl.ftl";
    private String _tplFinderUtil = "com/liferay/portal/tools/service/builder/dependencies/finder_util.ftl";
    private String _tplHbmXml = "com/liferay/portal/tools/service/builder/dependencies/hbm_xml.ftl";
    private String _tplJsonJs = "com/liferay/portal/tools/service/builder/dependencies/json_js.ftl";
    private String _tplJsonJsMethod = "com/liferay/portal/tools/service/builder/dependencies/json_js_method.ftl";
    private String _tplModel = "com/liferay/portal/tools/service/builder/dependencies/model.ftl";
    private String _tplModelCache = "com/liferay/portal/tools/service/builder/dependencies/model_cache.ftl";
    private String _tplModelHintsXml = "com/liferay/portal/tools/service/builder/dependencies/model_hints_xml.ftl";
    private String _tplModelImpl = "com/liferay/portal/tools/service/builder/dependencies/model_impl.ftl";
    private String _tplModelSoap = "com/liferay/portal/tools/service/builder/dependencies/model_soap.ftl";
    private String _tplModelWrapper = "com/liferay/portal/tools/service/builder/dependencies/model_wrapper.ftl";
    private String _tplPersistence = "com/liferay/portal/tools/service/builder/dependencies/persistence.ftl";
    private String _tplPersistenceConstants = "com/liferay/portal/tools/service/builder/dependencies/persistence_constants.ftl";
    private String _tplPersistenceImpl = "com/liferay/portal/tools/service/builder/dependencies/persistence_impl.ftl";
    private String _tplPersistenceTest = "com/liferay/portal/tools/service/builder/dependencies/persistence_test.ftl";
    private String _tplPersistenceUtil = "com/liferay/portal/tools/service/builder/dependencies/persistence_util.ftl";
    private String _tplProps = "com/liferay/portal/tools/service/builder/dependencies/props.ftl";
    private String _tplService = "com/liferay/portal/tools/service/builder/dependencies/service.ftl";
    private String _tplServiceBaseImpl = "com/liferay/portal/tools/service/builder/dependencies/service_base_impl.ftl";
    private String _tplServiceHttp = "com/liferay/portal/tools/service/builder/dependencies/service_http.ftl";
    private String _tplServiceImpl = "com/liferay/portal/tools/service/builder/dependencies/service_impl.ftl";
    private String _tplServicePropsUtil = "com/liferay/portal/tools/service/builder/dependencies/service_props_util.ftl";
    private String _tplServiceSoap = "com/liferay/portal/tools/service/builder/dependencies/service_soap.ftl";
    private String _tplServiceUtil = "com/liferay/portal/tools/service/builder/dependencies/service_util.ftl";
    private String _tplServiceWrapper = "com/liferay/portal/tools/service/builder/dependencies/service_wrapper.ftl";
    private String _tplServletContextUtil = "com/liferay/portal/tools/service/builder/dependencies/servlet_context_util.ftl";
    private String _tplSpringXml = "com/liferay/portal/tools/service/builder/dependencies/spring_xml.ftl";
    private String _tplUADAnonymizer = "com/liferay/portal/tools/service/builder/dependencies/uad_anonymizer.ftl";
    private String _tplUADBnd = "com/liferay/portal/tools/service/builder/dependencies/uad_bnd.ftl";
    private String _tplUADConstants = "com/liferay/portal/tools/service/builder/dependencies/uad_constants.ftl";
    private String _tplUADDisplay = "com/liferay/portal/tools/service/builder/dependencies/uad_display.ftl";
    private String _tplUADExporter = "com/liferay/portal/tools/service/builder/dependencies/uad_exporter.ftl";
    private Map<String, List<Entity>> _uadApplicationEntities = new HashMap<String, List<Entity>>();
    private String _uadDirName;

    public static boolean hasAnnotation(AbstractBaseJavaEntity abstractBaseJavaEntity, String annotationName) {
        List javaAnnotations = abstractBaseJavaEntity.getAnnotations();
        if (javaAnnotations == null) {
            return false;
        }
        for (JavaAnnotation javaAnnotation : javaAnnotations) {
            JavaClass javaClass = javaAnnotation.getType();
            if (!annotationName.equals(javaClass.getName())) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        Map<String, String> arguments = ArgumentsUtil.parseArguments(args);
        String apiDirName = arguments.get("service.api.dir");
        boolean autoImportDefaultReferences = GetterUtil.getBoolean(arguments.get("service.auto.import.default.references"), true);
        boolean autoNamespaceTables = GetterUtil.getBoolean(arguments.get("service.auto.namespace.tables"));
        String beanLocatorUtil = arguments.get("service.bean.locator.util");
        long buildNumber = GetterUtil.getLong(arguments.get("service.build.number"), 1L);
        boolean buildNumberIncrement = GetterUtil.getBoolean(arguments.get("service.build.number.increment"), true);
        int databaseNameMaxLength = GetterUtil.getInteger(arguments.get("service.database.name.max.length"), 30);
        String hbmFileName = arguments.get("service.hbm.file");
        String implDirName = arguments.get("service.impl.dir");
        String inputFileName = arguments.get("service.input.file");
        String[] modelHintsConfigs = StringUtil.split(GetterUtil.getString(arguments.get("service.model.hints.configs"), StringUtil.merge(ServiceBuilderArgs.MODEL_HINTS_CONFIGS)));
        String modelHintsFileName = arguments.get("service.model.hints.file");
        boolean osgiModule = GetterUtil.getBoolean(arguments.get("service.osgi.module"));
        String pluginName = arguments.get("service.plugin.name");
        String propsUtil = arguments.get("service.props.util");
        String[] readOnlyPrefixes = StringUtil.split(GetterUtil.getString(arguments.get("service.read.only.prefixes"), StringUtil.merge(ServiceBuilderArgs.READ_ONLY_PREFIXES)));
        String[] resourceActionsConfigs = StringUtil.split(GetterUtil.getString(arguments.get("service.resource.actions.configs"), StringUtil.merge(ServiceBuilderArgs.RESOURCE_ACTION_CONFIGS)));
        String resourcesDirName = arguments.get("service.resources.dir");
        String springFileName = arguments.get("service.spring.file");
        String[] springNamespaces = StringUtil.split(arguments.get("service.spring.namespaces"));
        String sqlDirName = arguments.get("service.sql.dir");
        String sqlFileName = arguments.get("service.sql.file");
        String sqlIndexesFileName = arguments.get("service.sql.indexes.file");
        String sqlSequencesFileName = arguments.get("service.sql.sequences.file");
        String targetEntityName = arguments.get("service.target.entity.name");
        String testDirName = arguments.get("service.test.dir");
        String uadDirName = arguments.get("service.uad.dir");
        Set<String> resourceActionModels = ServiceBuilder.readResourceActionModels(implDirName, resourcesDirName, resourceActionsConfigs);
        ModelHintsUtil modelHintsUtil = new ModelHintsUtil();
        ModelHintsImpl modelHintsImpl = new ModelHintsImpl();
        modelHintsImpl.setModelHintsConfigs(modelHintsConfigs);
        modelHintsImpl.afterPropertiesSet();
        modelHintsUtil.setModelHints(modelHintsImpl);
        try {
            ServiceBuilder serviceBuilder = new ServiceBuilder(apiDirName, autoImportDefaultReferences, autoNamespaceTables, beanLocatorUtil, buildNumber, buildNumberIncrement, databaseNameMaxLength, hbmFileName, implDirName, inputFileName, modelHintsFileName, osgiModule, pluginName, propsUtil, readOnlyPrefixes, resourceActionModels, resourcesDirName, springFileName, springNamespaces, sqlDirName, sqlFileName, sqlIndexesFileName, sqlSequencesFileName, targetEntityName, testDirName, uadDirName, true);
            String modifiedFileNames = StringUtil.merge(serviceBuilder.getModifiedFileNames());
            System.setProperty("service.builder.modified.files", modifiedFileNames);
        }
        catch (Exception e) {
            if (e instanceof ServiceBuilderException) {
                System.err.println(e.getMessage());
            } else {
                String message = StringBundler.concat("Please set these arguments. Sample values are:\n\n", "\tservice.api.dir=${basedir}/../portal-kernel/src\n", "\tservice.auto.import.default.references=true\n", "\tservice.auto.namespace.tables=false\n", "\tservice.bean.locator.util=com.liferay.portal.kernel.", "bean.PortalBeanLocatorUtil\n", "\tservice.build.number=1\n", "\tservice.build.number.increment=true\n", "\tservice.hbm.file=", "${basedir}/src/META-INF/portal-hbm.xml\n", "\tservice.impl.dir=${basedir}/src\n", "\tservice.input.file=${service.file}\n", "\tservice.model.hints.configs=", StringUtil.merge(ServiceBuilderArgs.MODEL_HINTS_CONFIGS), "\n", "\tservice.model.hints.file=", "${basedir}/src/META-INF/portal-model-hints.xml\n", "\tservice.osgi.module=false\n", "\tservice.plugin.name=\n", "\tservice.props.util=com.liferay.portal.util.PropsUtil\n", "\tservice.read.only.prefixes=", StringUtil.merge(ServiceBuilderArgs.READ_ONLY_PREFIXES), "\n", "\tservice.resource.actions.configs=", StringUtil.merge(ServiceBuilderArgs.RESOURCE_ACTION_CONFIGS), "\n", "\tservice.resources.dir=${basedir}/src\n", "\tservice.spring.file=", "${basedir}/src/META-INF/portal-spring.xml\n", "\tservice.spring.namespaces=beans\n", "\tservice.sql.dir=${basedir}/../sql\n", "\tservice.sql.file=portal-tables.sql\n", "\tservice.sql.indexes.file=indexes.sql\n", "\tservice.sql.sequences.file=sequences.sql\n", "\tservice.target.entity.name=", "${service.target.entity.name}\n", "\tservice.test.dir=${basedir}/test/integration\n\n", "You can also customize the generated code by overriding ", "the default templates with these optional system ", "properties:\n\n", "\t-Dservice.tpl.bad_alias_names=", _TPL_ROOT, "bad_alias_names.txt\n", "\t-Dservice.tpl.bad_column_names=", _TPL_ROOT, "bad_column_names.txt\n", "\t-Dservice.tpl.bad_json_types=", _TPL_ROOT, "bad_json_types.txt\n", "\t-Dservice.tpl.bad_table_names=", _TPL_ROOT, "bad_table_names.txt\n", "\t-Dservice.tpl.base_mode_impl=", _TPL_ROOT, "base_mode_impl.ftl\n", "\t-Dservice.tpl.blob_model=", _TPL_ROOT, "blob_model.ftl\n", "\t-Dservice.tpl.copyright.txt=copyright.txt\n", "\t-Dservice.tpl.ejb_pk=", _TPL_ROOT, "ejb_pk.ftl\n", "\t-Dservice.tpl.exception=", _TPL_ROOT, "exception.ftl\n", "\t-Dservice.tpl.extended_model=", _TPL_ROOT, "extended_model.ftl\n", "\t-Dservice.tpl.extended_model_base_impl=", _TPL_ROOT, "extended_model_base_impl.ftl\n", "\t-Dservice.tpl.extended_model_impl=", _TPL_ROOT, "extended_model_impl.ftl\n", "\t-Dservice.tpl.finder=", _TPL_ROOT, "finder.ftl\n", "\t-Dservice.tpl.finder_base_impl=", _TPL_ROOT, "finder_base_impl.ftl\n", "\t-Dservice.tpl.finder_util=", _TPL_ROOT, "finder_util.ftl\n", "\t-Dservice.tpl.hbm_xml=", _TPL_ROOT, "hbm_xml.ftl\n", "\t-Dservice.tpl.json_js=", _TPL_ROOT, "json_js.ftl\n", "\t-Dservice.tpl.json_js_method=", _TPL_ROOT, "json_js_method.ftl\n", "\t-Dservice.tpl.model=", _TPL_ROOT, "model.ftl\n", "\t-Dservice.tpl.model_cache=", _TPL_ROOT, "model_cache.ftl\n", "\t-Dservice.tpl.model_hints_xml=", _TPL_ROOT, "model_hints_xml.ftl\n", "\t-Dservice.tpl.model_impl=", _TPL_ROOT, "model_impl.ftl\n", "\t-Dservice.tpl.model_soap=", _TPL_ROOT, "model_soap.ftl\n", "\t-Dservice.tpl.model_wrapper=", _TPL_ROOT, "model_wrapper.ftl\n", "\t-Dservice.tpl.persistence=", _TPL_ROOT, "persistence.ftl\n", "\t-Dservice.tpl.persistence_impl=", _TPL_ROOT, "persistence_impl.ftl\n", "\t-Dservice.tpl.persistence_util=", _TPL_ROOT, "persistence_util.ftl\n", "\t-Dservice.tpl.props=", _TPL_ROOT, "props.ftl\n", "\t-Dservice.tpl.service=", _TPL_ROOT, "service.ftl\n", "\t-Dservice.tpl.service_base_impl=", _TPL_ROOT, "service_base_impl.ftl\n", "\t-Dservice.tpl.service_clp=", _TPL_ROOT, "service_clp.ftl\n", "\t-Dservice.tpl.service_clp_invoker=", _TPL_ROOT, "service_clp_invoker.ftl\n", "\t-Dservice.tpl.service_clp_message_listener=", _TPL_ROOT, "service_clp_message_listener.ftl\n", "\t-Dservice.tpl.service_clp_serializer=", _TPL_ROOT, "service_clp_serializer.ftl\n", "\t-Dservice.tpl.service_http=", _TPL_ROOT, "service_http.ftl\n", "\t-Dservice.tpl.service_impl=", _TPL_ROOT, "service_impl.ftl\n", "\t-Dservice.tpl.service_props_util=", _TPL_ROOT, "service_props_util.ftl\n", "\t-Dservice.tpl.service_soap=", _TPL_ROOT, "service_soap.ftl\n", "\t-Dservice.tpl.service_util=", _TPL_ROOT, "service_util.ftl\n", "\t-Dservice.tpl.service_wrapper=", _TPL_ROOT, "service_wrapper.ftl\n", "\t-Dservice.tpl.spring_xml=", _TPL_ROOT, "spring_xml.ftl\n", "\t-Dservice.tpl.spring_xml_session=", _TPL_ROOT, "spring_xml_session.ftl");
                System.out.println(message);
            }
            ArgumentsUtil.processMainException(arguments, e);
        }
        try {
            ClearThreadLocalUtil.clearThreadLocal();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Introspector.flushCaches();
    }

    public static Set<String> readResourceActionModels(String implDirName, String resourcesDirName, String[] resourceActionsConfigs) throws Exception {
        HashSet<String> resourceActionModels = new HashSet<String>();
        ClassLoader classLoader = ServiceBuilder.class.getClassLoader();
        for (String config : resourceActionsConfigs) {
            Throwable throwable;
            InputStream inputStream;
            if (config.startsWith("classpath*:")) {
                String name = config.substring("classpath*:".length());
                Enumeration<URL> enu = classLoader.getResources(name);
                while (enu.hasMoreElements()) {
                    URL url = enu.nextElement();
                    InputStream inputStream2 = url.openStream();
                    ServiceBuilder._readResourceActionModels(implDirName, resourcesDirName, inputStream2, resourceActionModels);
                }
                continue;
            }
            Enumeration<URL> urls = classLoader.getResources(config);
            if (urls.hasMoreElements()) {
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    inputStream = url.openStream();
                    throwable = null;
                    try {
                        ServiceBuilder._readResourceActionModels(implDirName, resourcesDirName, inputStream, resourceActionModels);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (inputStream == null) continue;
                        if (throwable != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        inputStream.close();
                    }
                }
                continue;
            }
            File file = new File(config);
            if (!file.exists()) {
                file = new File(implDirName, config);
            }
            if (!file.exists() && Validator.isNotNull(resourcesDirName)) {
                file = new File(resourcesDirName, config);
            }
            if (!file.exists()) continue;
            inputStream = new FileInputStream(file);
            throwable = null;
            try {
                ServiceBuilder._readResourceActionModels(implDirName, resourcesDirName, inputStream, resourceActionModels);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        return resourceActionModels;
    }

    public static String toHumanName(String name) {
        if (name == null) {
            return null;
        }
        String humanName = TextFormatter.format(name, 7);
        if (humanName.equals("id")) {
            humanName = "ID";
        } else if (humanName.equals("ids")) {
            humanName = "IDs";
        }
        if (humanName.endsWith(" id")) {
            humanName = humanName.substring(0, humanName.length() - 3) + " ID";
        } else if (humanName.endsWith(" ids")) {
            humanName = humanName.substring(0, humanName.length() - 4) + " IDs";
        }
        if (humanName.contains(" id ")) {
            humanName = StringUtil.replace(humanName, " id ", " ID ");
        } else if (humanName.contains(" ids ")) {
            humanName = StringUtil.replace(humanName, " ids ", " IDs ");
        }
        return humanName;
    }

    public ServiceBuilder(String apiDirName, boolean autoImportDefaultReferences, boolean autoNamespaceTables, String beanLocatorUtil, int databaseNameMaxLength, String hbmFileName, String implDirName, String inputFileName, String modelHintsFileName, boolean osgiModule, String pluginName, String propsUtil, String[] readOnlyPrefixes, Set<String> resourceActionModels, String resourcesDirName, String springFileName, String[] springNamespaces, String sqlDirName, String sqlFileName, String sqlIndexesFileName, String sqlSequencesFileName, String targetEntityName, String testDirName, String uadDirName) throws Exception {
        this(apiDirName, autoImportDefaultReferences, autoNamespaceTables, beanLocatorUtil, 1L, true, databaseNameMaxLength, hbmFileName, implDirName, inputFileName, modelHintsFileName, osgiModule, pluginName, propsUtil, readOnlyPrefixes, resourceActionModels, resourcesDirName, springFileName, springNamespaces, sqlDirName, sqlFileName, sqlIndexesFileName, sqlSequencesFileName, targetEntityName, testDirName, uadDirName, true);
    }

    public ServiceBuilder(String apiDirName, boolean autoImportDefaultReferences, boolean autoNamespaceTables, String beanLocatorUtil, long buildNumber, boolean buildNumberIncrement, int databaseNameMaxLength, String hbmFileName, String implDirName, String inputFileName, String modelHintsFileName, boolean osgiModule, String pluginName, String propsUtil, String[] readOnlyPrefixes, Set<String> resourceActionModels, String resourcesDirName, String springFileName, String[] springNamespaces, String sqlDirName, String sqlFileName, String sqlIndexesFileName, String sqlSequencesFileName, String targetEntityName, String testDirName, String uadDirName, boolean build) throws Exception {
        this._tplBadAliasNames = this._getTplProperty("bad_alias_names", this._tplBadAliasNames);
        this._tplBadColumnNames = this._getTplProperty("bad_column_names", this._tplBadColumnNames);
        this._tplBadTableNames = this._getTplProperty("bad_table_names", this._tplBadTableNames);
        this._tplBlobModel = this._getTplProperty("blob_model", this._tplBlobModel);
        this._tplEjbPK = this._getTplProperty("ejb_pk", this._tplEjbPK);
        this._tplException = this._getTplProperty("exception", this._tplException);
        this._tplExtendedModel = this._getTplProperty("extended_model", this._tplExtendedModel);
        this._tplExtendedModelBaseImpl = this._getTplProperty("extended_model_base_impl", this._tplExtendedModelBaseImpl);
        this._tplExtendedModelImpl = this._getTplProperty("extended_model_impl", this._tplExtendedModelImpl);
        this._tplFinder = this._getTplProperty("finder", this._tplFinder);
        this._tplFinderBaseImpl = this._getTplProperty("finder_base_impl", this._tplFinderBaseImpl);
        this._tplFinderUtil = this._getTplProperty("finder_util", this._tplFinderUtil);
        this._tplHbmXml = this._getTplProperty("hbm_xml", this._tplHbmXml);
        this._tplJsonJs = this._getTplProperty("json_js", this._tplJsonJs);
        this._tplJsonJsMethod = this._getTplProperty("json_js_method", this._tplJsonJsMethod);
        this._tplModel = this._getTplProperty("model", this._tplModel);
        this._tplModelCache = this._getTplProperty("model_cache", this._tplModelCache);
        this._tplModelHintsXml = this._getTplProperty("model_hints_xml", this._tplModelHintsXml);
        this._tplModelImpl = this._getTplProperty("model_impl", this._tplModelImpl);
        this._tplModelSoap = this._getTplProperty("model_soap", this._tplModelSoap);
        this._tplModelWrapper = this._getTplProperty("model_wrapper", this._tplModelWrapper);
        this._tplPersistence = this._getTplProperty("persistence", this._tplPersistence);
        this._tplPersistenceImpl = this._getTplProperty("persistence_impl", this._tplPersistenceImpl);
        this._tplPersistenceUtil = this._getTplProperty("persistence_util", this._tplPersistenceUtil);
        this._tplProps = this._getTplProperty("props", this._tplProps);
        this._tplService = this._getTplProperty("service", this._tplService);
        this._tplServiceBaseImpl = this._getTplProperty("service_base_impl", this._tplServiceBaseImpl);
        this._tplServiceHttp = this._getTplProperty("service_http", this._tplServiceHttp);
        this._tplServiceImpl = this._getTplProperty("service_impl", this._tplServiceImpl);
        this._tplServicePropsUtil = this._getTplProperty("service_props_util", this._tplServicePropsUtil);
        this._tplServiceSoap = this._getTplProperty("service_soap", this._tplServiceSoap);
        this._tplServiceUtil = this._getTplProperty("service_util", this._tplServiceUtil);
        this._tplServiceWrapper = this._getTplProperty("service_wrapper", this._tplServiceWrapper);
        this._tplSpringXml = this._getTplProperty("spring_xml", this._tplSpringXml);
        try {
            this._apiDirName = ServiceBuilder._normalize(apiDirName);
            this._autoImportDefaultReferences = autoImportDefaultReferences;
            this._autoNamespaceTables = autoNamespaceTables;
            this._beanLocatorUtil = beanLocatorUtil;
            this._buildNumber = buildNumber;
            this._buildNumberIncrement = buildNumberIncrement;
            this._hbmFileName = ServiceBuilder._normalize(hbmFileName);
            this._implDirName = ServiceBuilder._normalize(implDirName);
            this._modelHintsFileName = ServiceBuilder._normalize(modelHintsFileName);
            this._osgiModule = osgiModule;
            this._pluginName = GetterUtil.getString(pluginName);
            this._propsUtil = propsUtil;
            this._readOnlyPrefixes = readOnlyPrefixes;
            this._resourceActionModels = resourceActionModels;
            this._resourcesDirName = ServiceBuilder._normalize(resourcesDirName);
            this._springFileName = ServiceBuilder._normalize(springFileName);
            this._springNamespaces = springNamespaces;
            if (!ArrayUtil.contains(this._springNamespaces, _SPRING_NAMESPACE_BEANS)) {
                this._springNamespaces = ArrayUtil.append(this._springNamespaces, _SPRING_NAMESPACE_BEANS);
            }
            this._sqlDirName = ServiceBuilder._normalize(sqlDirName);
            this._sqlFileName = sqlFileName;
            this._sqlIndexesFileName = sqlIndexesFileName;
            this._sqlSequencesFileName = sqlSequencesFileName;
            this._targetEntityName = targetEntityName;
            this._testDirName = ServiceBuilder._normalize(testDirName);
            this._uadDirName = ServiceBuilder._normalize(uadDirName);
            this._build = build;
            this._badAliasNames = this._readLines(this._tplBadAliasNames);
            this._badColumnNames = this._readLines(this._tplBadColumnNames);
            this._badTableNames = this._readLines(this._tplBadTableNames);
            this._commercialPlugin = this._isCommercialPlugin(Paths.get(".", new String[0]));
            SAXReader saxReader = ServiceBuilder._getSAXReader();
            Document document = saxReader.read((Reader)new XMLSafeReader(ToolsUtil.getContent(ServiceBuilder._normalize(inputFileName))));
            DocumentType documentType = document.getDocType();
            Matcher matcher = _dtdVersionPattern.matcher(documentType.getSystemID());
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Unable to parse DTD version for " + inputFileName);
            }
            this._dtdVersion = Version.getInstance(StringUtil.replace(matcher.group(1), '_', '.'));
            this._compatProperties = this._getCompatProperties(matcher.group(1));
            Collections.addAll(this._badAliasNames, StringUtil.split(this._compatProperties.getProperty("bad.alias.names.extra")));
            Collections.addAll(this._badColumnNames, StringUtil.split(this._compatProperties.getProperty("bad.column.names.extra")));
            Collections.addAll(this._badTableNames, StringUtil.split(this._compatProperties.getProperty("bad.table.names.extra")));
            Element rootElement = document.getRootElement();
            String packagePath = rootElement.attributeValue("package-path");
            if (Validator.isNull(packagePath)) {
                throw new IllegalArgumentException("The package-path attribute is required");
            }
            this._apiPackagePath = GetterUtil.getString(rootElement.attributeValue("api-package-path"), packagePath);
            this._databaseNameMaxLength = GetterUtil.getInteger(rootElement.attributeValue("database-name-max-length"), databaseNameMaxLength);
            this._oldServiceOutputPath = this._apiDirName + "/" + StringUtil.replace(packagePath, '.', '/');
            this._outputPath = this._implDirName + "/" + StringUtil.replace(packagePath, '.', '/');
            if (Validator.isNotNull(this._testDirName)) {
                this._testOutputPath = this._testDirName + "/" + StringUtil.replace(packagePath, '.', '/');
            }
            this._serviceOutputPath = this._apiDirName + "/" + StringUtil.replace(this._apiPackagePath, '.', '/');
            this._packagePath = packagePath;
            if (Validator.isNull(this._uadDirName)) {
                this._uadDirName = StringUtil.replace(this._apiDirName, "-api/", "-uad/");
            }
            this._autoImportDefaultReferences = GetterUtil.getBoolean(rootElement.attributeValue("auto-import-default-references"), this._autoImportDefaultReferences);
            this._autoNamespaceTables = GetterUtil.getBoolean(rootElement.attributeValue("auto-namespace-tables"), this._autoNamespaceTables);
            this._changeTrackingEnabled = GetterUtil.getBoolean(rootElement.attributeValue("change-tracking-enabled"));
            String dependencyInjector = rootElement.attributeValue("dependency-injector");
            File springFile = new File(this._springFileName);
            this._dependencyInjectorDS = dependencyInjector != null || !this._osgiModule || this.isVersionLTE_7_1_0() || springFile.exists() ? StringUtil.equalsIgnoreCase(dependencyInjector, "ds") : true;
            if (this._dependencyInjectorDS) {
                if (this.isVersionLTE_7_1_0()) {
                    throw new IllegalArgumentException("Cannot use dependency-injector=\"ds\" without using at least DTD version 7.2.0");
                }
                if (!this._osgiModule) {
                    throw new IllegalArgumentException("Cannot use dependency-injector=\"ds\" with a WAR");
                }
            }
            this._mvccEnabled = GetterUtil.getBoolean(rootElement.attributeValue("mvcc-enabled"));
            Element authorElement = rootElement.element("author");
            this._author = authorElement != null ? authorElement.getText() : AUTHOR;
            Element portletElement = rootElement.element("portlet");
            if (portletElement != null) {
                this._portletShortName = portletElement.attributeValue("short-name");
                String string = TextFormatter.format(portletElement.attributeValue("name"), 1);
                this._apiPackagePath = this._apiPackagePath + "." + string;
                this._outputPath = this._outputPath + "/" + string;
                this._packagePath = this._packagePath + "." + string;
                this._serviceOutputPath = this._serviceOutputPath + "/" + string;
                this._testOutputPath = this._testOutputPath + "/" + string;
            } else {
                Element element = rootElement.element("namespace");
                this._portletShortName = element.getText();
            }
            this._portletShortName = this._portletShortName.trim();
            for (char c : this._portletShortName.toCharArray()) {
                if (Validator.isChar(c) || c == '_') continue;
                throw new RuntimeException("The namespace element must be a valid keyword");
            }
            this._entities = new ArrayList<Entity>();
            this._entityMappings = new HashMap<String, EntityMapping>();
            List list = rootElement.elements("entity");
            for (Element entityElement : list) {
                this._parseEntity(entityElement);
            }
            ArrayList<String> exceptionList = new ArrayList<String>();
            Element exceptionsElement = rootElement.element("exceptions");
            if (exceptionsElement != null) {
                List exceptionElements = exceptionsElement.elements("exception");
                for (Element exceptionElement : exceptionElements) {
                    exceptionList.add(exceptionElement.getText());
                }
            }
            if (build) {
                Collections.sort(this._entities);
                for (Entity entity : this._entities) {
                    if (this._isTargetEntity(entity)) {
                        System.out.println("Building " + entity.getName());
                        this._resolveEntity(entity);
                        this._removeOldServices(entity);
                        this._removeActionableDynamicQuery(entity);
                        this._removeExportActionableDynamicQuery(entity);
                        if (entity.hasEntityColumns()) {
                            this._createHbm(entity);
                            this._createHbmUtil(entity);
                            this._createPersistenceImpl(entity);
                            this._createPersistence(entity);
                            this._createPersistenceUtil(entity);
                            if (Validator.isNotNull(this._testDirName)) {
                                this._createPersistenceTest(entity);
                            }
                            this._createModelImpl(entity);
                            this._createExtendedModelBaseImpl(entity);
                            this._createExtendedModelImpl(entity);
                            entity.setTransients(this._getTransients(entity, false));
                            entity.setParentTransients(this._getTransients(entity, true));
                            this._createModel(entity);
                            this._createExtendedModel(entity);
                            this._createModelCache(entity);
                            this._createModelWrapper(entity);
                            this._createModelSoap(entity);
                            this._createBlobModels(entity);
                            this._createPool(entity);
                            this._createEJBPK(entity);
                        }
                        this._createFinder(entity);
                        this._createFinderBaseImpl(entity);
                        this._createFinderUtil(entity);
                        if (entity.hasLocalService()) {
                            this._createServiceImpl(entity, 1);
                            this._createServiceBaseImpl(entity, 1);
                            this._createService(entity, 1);
                            this._createServiceFactory(entity, 1);
                            this._createServiceUtil(entity, 1);
                            this._createServiceWrapper(entity, 1);
                        } else {
                            this._removeServiceImpl(entity, 1);
                            this._removeServiceBaseImpl(entity, 1);
                            this._removeService(entity, 1, this._serviceOutputPath);
                            this._removeServiceUtil(entity, 1, this._serviceOutputPath);
                            this._removeServiceWrapper(entity, 1, this._serviceOutputPath);
                        }
                        if (entity.hasRemoteService()) {
                            this._createServiceImpl(entity, 0);
                            this._createServiceBaseImpl(entity, 0);
                            this._createService(entity, 0);
                            this._createServiceFactory(entity, 0);
                            this._createServiceUtil(entity, 0);
                            this._createServiceWrapper(entity, 0);
                            this._createServiceHttp(entity);
                            this._removeServiceJson(entity);
                            if (entity.hasEntityColumns()) {
                                this._removeServiceJsonSerializer(entity);
                            }
                            this._createServiceSoap(entity);
                        } else {
                            this._removeServiceImpl(entity, 0);
                            this._removeServiceBaseImpl(entity, 0);
                            this._removeService(entity, 0, this._serviceOutputPath);
                            this._removeServiceUtil(entity, 0, this._serviceOutputPath);
                            this._removeServiceWrapper(entity, 0, this._serviceOutputPath);
                            this._removeServiceHttp(entity);
                            this._removeServiceSoap(entity);
                        }
                        this._createCTServiceImpl(entity);
                        if (!entity.isUADEnabled()) continue;
                        this._createBaseUADAnonymizer(entity);
                        this._createBaseUADExporter(entity);
                        this._createUADAnonymizer(entity);
                        this._createUADExporter(entity);
                        if (ListUtil.isEmpty(entity.getUADNonanonymizableEntityColumns())) {
                            this._removeBaseUADDisplay(entity);
                            this._removeUADDisplay(entity);
                            this._removeUADDisplayTest(entity);
                            continue;
                        }
                        this._createBaseUADDisplay(entity);
                        this._createUADDisplay(entity);
                        continue;
                    }
                    if (!entity.hasEntityColumns()) continue;
                    entity.setTransients(this._getTransients(entity, false));
                    entity.setParentTransients(this._getTransients(entity, true));
                }
                this._createHbmXml();
                this._createModelHintsXml();
                this._createSpringXml();
                this._createExceptions(exceptionList);
                this._createPersistenceConstants();
                this._createServicePropsUtil();
                this._createServletContextUtil();
                this._createSQLIndexes();
                this._createSQLTables();
                this._createSQLSequences();
                this._createProps();
                for (String uadApplicationName : this._uadApplicationEntities.keySet()) {
                    this._createUADBnd(uadApplicationName);
                    this._createUADConstants(uadApplicationName);
                }
                this._deleteOrmXml();
                this._deleteSpringLegacyXml();
            }
        }
        catch (FileNotFoundException fnfe) {
            System.out.println(fnfe.getMessage());
        }
    }

    public String getCacheFieldMethodName(JavaField javaField) {
        List javaAnnotations = javaField.getAnnotations();
        for (JavaAnnotation javaAnnotation : javaAnnotations) {
            JavaClass type = javaAnnotation.getType();
            String className = type.getFullyQualifiedName();
            if (!className.equals(CacheField.class.getName())) continue;
            String methodName = null;
            Object namedParameter = javaAnnotation.getNamedParameter("methodName");
            if (namedParameter != null) {
                methodName = StringUtil.unquote(StringUtil.trim(namedParameter.toString()));
            }
            if (Validator.isNull(methodName)) {
                methodName = TextFormatter.format(this.getVariableName(javaField), 6);
            }
            return methodName;
        }
        throw new IllegalArgumentException(javaField + " is not a cache field");
    }

    public String getClassName(DefaultJavaParameterizedType defaultJavaParameterizedType) {
        int dimensions = defaultJavaParameterizedType.getDimensions();
        String name = defaultJavaParameterizedType.getFullyQualifiedName();
        if (dimensions == 0) {
            return name;
        }
        StringBundler sb = new StringBundler();
        for (int i = 0; i < dimensions; ++i) {
            sb.append("[");
        }
        if (name.equals("boolean")) {
            sb.append("Z");
        } else if (name.equals("byte")) {
            sb.append("B");
        } else if (name.equals("char")) {
            sb.append("C");
        } else if (name.equals("double")) {
            sb.append("D");
        } else if (name.equals("float")) {
            sb.append("F");
        } else if (name.equals("int")) {
            sb.append("I");
        } else if (name.equals("long")) {
            sb.append("J");
        } else if (name.equals("short")) {
            sb.append("S");
        } else {
            sb.append("L");
            sb.append(name);
            sb.append(";");
        }
        return sb.toString();
    }

    public String getCompatJavaClassName(String key) {
        return this._compatProperties.getProperty(StringBundler.concat("java.class.name", "[", key, "]"));
    }

    public String getCreateMappingTableSQL(EntityMapping entityMapping) throws Exception {
        String createMappingTableSQL = this._getCreateMappingTableSQL(entityMapping);
        createMappingTableSQL = StringUtil.replace(createMappingTableSQL, '\n', "");
        createMappingTableSQL = StringUtil.replace(createMappingTableSQL, '\t', "");
        createMappingTableSQL = createMappingTableSQL.substring(0, createMappingTableSQL.length() - 1);
        return createMappingTableSQL;
    }

    public String getCreateTableSQL(Entity entity) {
        String createTableSQL = this._getCreateTableSQL(entity);
        createTableSQL = StringUtil.replace(createTableSQL, '\n', "");
        createTableSQL = StringUtil.replace(createTableSQL, '\t', "");
        createTableSQL = createTableSQL.substring(0, createTableSQL.length() - 1);
        return createTableSQL;
    }

    public String getDimensions(int dims) {
        String dimensions = "";
        for (int i = 0; i < dims; ++i) {
            dimensions = dimensions + "[]";
        }
        return dimensions;
    }

    public String getDimensions(String dims) {
        return this.getDimensions(GetterUtil.getInteger(dims));
    }

    public Entity getEntity(String name) throws Exception {
        Entity entity = this._entityPool.get(name);
        if (entity != null) {
            return entity;
        }
        int pos = name.lastIndexOf(".");
        if (pos == -1) {
            pos = this._entities.indexOf(new Entity(this, name));
            if (pos == -1) {
                throw new ServiceBuilderException(StringBundler.concat("Unable to find ", name, " in ", ListUtil.toString(this._entities, Entity.NAME_ACCESSOR)));
            }
            entity = this._entities.get(pos);
            this._entityPool.put(name, entity);
            return entity;
        }
        String refPackage = name.substring(0, pos);
        String refEntity = name.substring(pos + 1);
        if (refPackage.equals(this._packagePath)) {
            pos = this._entities.indexOf(new Entity(this, refEntity));
            if (pos == -1) {
                throw new ServiceBuilderException(StringBundler.concat("Unable to find ", refEntity, " in ", ListUtil.toString(this._entities, Entity.NAME_ACCESSOR)));
            }
            entity = this._entities.get(pos);
            this._entityPool.put(name, entity);
            return entity;
        }
        HashSet<Entity> entities = new HashSet<Entity>(this._entities);
        entities.addAll(this._entityPool.values());
        for (Entity curEntity : entities) {
            if (!refPackage.equals(curEntity.getApiPackagePath())) continue;
            refPackage = curEntity.getPackagePath();
            break;
        }
        String refPackageDirName = StringUtil.replace(refPackage, '.', '/');
        String refFileName = StringBundler.concat(this._implDirName, "/", refPackageDirName, "/service.xml");
        File refFile = new File(refFileName);
        boolean useTempFile = false;
        if (!refFile.exists()) {
            refFileName = String.valueOf(System.currentTimeMillis());
            refFile = new File(_TMP_DIR_NAME, refFileName);
            Class<?> clazz = this.getClass();
            ClassLoader classLoader = clazz.getClassLoader();
            String refContent = null;
            try {
                refContent = StringUtil.read(classLoader, refPackageDirName + "/service.xml");
            }
            catch (IOException ioe) {
                throw new ServiceBuilderException(StringBundler.concat("Unable to find ", refEntity, " in ", ListUtil.toString(this._entities, Entity.NAME_ACCESSOR)), ioe);
            }
            ServiceBuilder._write(refFile, refContent);
            useTempFile = true;
        }
        ServiceBuilder serviceBuilder = new ServiceBuilder(this._apiDirName, this._autoImportDefaultReferences, this._autoNamespaceTables, this._beanLocatorUtil, this._buildNumber, this._buildNumberIncrement, this._databaseNameMaxLength, this._hbmFileName, this._implDirName, refFile.getAbsolutePath(), this._modelHintsFileName, this._osgiModule, this._pluginName, this._propsUtil, this._readOnlyPrefixes, this._resourceActionModels, this._resourcesDirName, this._springFileName, this._springNamespaces, this._sqlDirName, this._sqlFileName, this._sqlIndexesFileName, this._sqlSequencesFileName, this._targetEntityName, this._testDirName, this._uadDirName, false);
        entity = serviceBuilder.getEntity(refEntity);
        entity.setPortalReference(useTempFile);
        this._entityPool.put(name, entity);
        this._modifiedFileNames.addAll(serviceBuilder.getModifiedFileNames());
        if (useTempFile) {
            refFile.deleteOnExit();
        }
        return entity;
    }

    public Entity getEntityByGenericsName(String genericsName) {
        try {
            String name = genericsName;
            if (name.startsWith("<")) {
                name = name.substring(1, name.length() - 1);
            }
            name = StringUtil.replace(name, ".model.", ".");
            return this.getEntity(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Entity getEntityByParameterTypeValue(String parameterTypeValue) {
        try {
            String name = parameterTypeValue;
            name = StringUtil.replace(name, ".model.", ".");
            return this.getEntity(name);
        }
        catch (Exception e) {
            return null;
        }
    }

    public EntityMapping getEntityMapping(String mappingTable) {
        return this._entityMappings.get(mappingTable);
    }

    public String getGeneratorClass(String idType) {
        if (Validator.isNull(idType)) {
            idType = "assigned";
        }
        return idType;
    }

    public String getGenericValue(JavaClass javaClass) {
        return StringUtil.replace(javaClass.getFullyQualifiedName(), '$', '.');
    }

    public String getJavadocComment(JavaClass javaClass) {
        return this._formatComment(javaClass.getComment(), javaClass.getTags(), "");
    }

    public String getJavadocComment(JavaMethod javaMethod) {
        return this._formatComment(javaMethod.getComment(), javaMethod.getTags(), "\t");
    }

    public String getListActualTypeArguments(DefaultJavaParameterizedType defaultJavaParameterizedType) {
        List types;
        String typeName = defaultJavaParameterizedType.getFullyQualifiedName();
        if (typeName.equals("java.util.List") && (types = defaultJavaParameterizedType.getActualTypeArguments()) != null) {
            return this.getTypeGenericsName((JavaType)types.get(0));
        }
        return this.getTypeGenericsName((JavaType)defaultJavaParameterizedType);
    }

    public String getLiteralClass(DefaultJavaParameterizedType defaultJavaParameterizedType) {
        StringBundler sb = new StringBundler(defaultJavaParameterizedType.getDimensions() + 2);
        sb.append(defaultJavaParameterizedType.getFullyQualifiedName());
        sb.append(".class");
        return sb.toString();
    }

    public Map<String, List<EntityColumn>> getMappingEntities(String mappingTable) throws Exception {
        LinkedHashMap<String, List<EntityColumn>> mappingEntities = new LinkedHashMap<String, List<EntityColumn>>();
        EntityMapping entityMapping = this._entityMappings.get(mappingTable);
        for (int i = 0; i < 3; ++i) {
            Entity entity = this.getEntity(entityMapping.getEntityName(i));
            if (entity == null) {
                return null;
            }
            mappingEntities.put(entity.getName(), entity.getPKEntityColumns());
        }
        return mappingEntities;
    }

    public int getMaxLength(String model, String field) {
        Map<String, String> hints = ModelHintsUtil.getHints(this._apiPackagePath + ".model." + model, field);
        if (hints == null) {
            return 75;
        }
        return GetterUtil.getInteger(hints.get("max-length"), 75);
    }

    public Set<String> getModifiedFileNames() {
        return this._modifiedFileNames;
    }

    public String getNoSuchEntityException(Entity entity) {
        String noSuchEntityException = entity.getName();
        String portletShortName = entity.getPortletShortName();
        if (Validator.isNull(portletShortName) || noSuchEntityException.startsWith(portletShortName) && !noSuchEntityException.equals(portletShortName)) {
            noSuchEntityException = noSuchEntityException.substring(portletShortName.length());
        }
        noSuchEntityException = "NoSuch" + noSuchEntityException;
        return noSuchEntityException;
    }

    public String getParameterType(JavaParameter parameter) {
        JavaType returnType = parameter.getType();
        return this.getTypeGenericsName(returnType);
    }

    public String getPrimitiveObj(String type) {
        if (type.equals("boolean")) {
            return "Boolean";
        }
        if (type.equals("double")) {
            return "Double";
        }
        if (type.equals("float")) {
            return "Float";
        }
        if (type.equals("int")) {
            return "Integer";
        }
        if (type.equals("long")) {
            return "Long";
        }
        if (type.equals("short")) {
            return "Short";
        }
        return type;
    }

    public String getPrimitiveObjValue(String colType) {
        if (colType.equals("Boolean")) {
            return ".booleanValue()";
        }
        if (colType.equals("Double")) {
            return ".doubleValue()";
        }
        if (colType.equals("Float")) {
            return ".floatValue()";
        }
        if (colType.equals("Integer")) {
            return ".intValue()";
        }
        if (colType.equals("Long")) {
            return ".longValue()";
        }
        if (colType.equals("Short")) {
            return ".shortValue()";
        }
        return "";
    }

    public String getPrimitiveType(String type) {
        if (type.equals("Boolean")) {
            return "boolean";
        }
        if (type.equals("Double")) {
            return "double";
        }
        if (type.equals("Float")) {
            return "float";
        }
        if (type.equals("Integer")) {
            return "int";
        }
        if (type.equals("Long")) {
            return "long";
        }
        if (type.equals("Short")) {
            return "short";
        }
        return type;
    }

    public String getReturnType(JavaMethod method) {
        return this.getTypeGenericsName(method.getReturnType());
    }

    public List<String> getServiceBaseExceptions(List<JavaMethod> methods, String methodName, List<String> args, List<String> exceptions) {
        boolean foundMethod = false;
        for (JavaMethod method : methods) {
            List parameters = method.getParameters();
            String curMethodName = method.getName();
            if (curMethodName.equals(methodName) && parameters.size() == args.size()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    JavaParameter parameter = (JavaParameter)parameters.get(i);
                    if (!Objects.equals(this.getParameterType(parameter), args.get(i))) continue;
                    exceptions = ListUtil.copy(exceptions);
                    List methodExceptions = method.getExceptions();
                    for (JavaClass methodException : methodExceptions) {
                        String exception = methodException.getValue();
                        if (exception.equals(PortalException.class.getName())) {
                            exception = "PortalException";
                        }
                        if (exception.equals(SystemException.class.getName())) {
                            exception = "SystemException";
                        }
                        if (exceptions.contains(exception)) continue;
                        exceptions.add(exception);
                    }
                    Collections.sort(exceptions);
                    foundMethod = true;
                    break;
                }
            }
            if (!foundMethod) continue;
            break;
        }
        if (!exceptions.isEmpty()) {
            return exceptions;
        }
        return Collections.emptyList();
    }

    public String getSqlType(String type) {
        if (type.equals("boolean") || type.equals("Boolean")) {
            return "BOOLEAN";
        }
        if (type.equals("double") || type.equals("Double")) {
            return "DOUBLE";
        }
        if (type.equals("float") || type.equals("Float")) {
            return "FLOAT";
        }
        if (type.equals("int") || type.equals("Integer")) {
            return "INTEGER";
        }
        if (type.equals("long") || type.equals("Long")) {
            return "BIGINT";
        }
        if (type.equals("short") || type.equals("Short")) {
            return "INTEGER";
        }
        if (type.equals("BigDecimal")) {
            return "DECIMAL";
        }
        if (type.equals("Date")) {
            return "TIMESTAMP";
        }
        if (type.equals("String")) {
            return "VARCHAR";
        }
        return null;
    }

    public String getSqlType(String model, String field, String type) {
        if (type.equals("boolean") || type.equals("Boolean")) {
            return "BOOLEAN";
        }
        if (type.equals("double") || type.equals("Double")) {
            return "DOUBLE";
        }
        if (type.equals("float") || type.equals("Float")) {
            return "FLOAT";
        }
        if (type.equals("int") || type.equals("Integer")) {
            return "INTEGER";
        }
        if (type.equals("long") || type.equals("Long")) {
            return "BIGINT";
        }
        if (type.equals("short") || type.equals("Short")) {
            return "INTEGER";
        }
        if (type.equals("BigDecimal")) {
            return "DECIMAL";
        }
        if (type.equals("Blob")) {
            return "BLOB";
        }
        if (type.equals("Date")) {
            return "TIMESTAMP";
        }
        if (type.equals("Map")) {
            return "CLOB";
        }
        if (type.equals("String")) {
            int maxLength = this.getMaxLength(model, field);
            if (maxLength == 2000000) {
                return "CLOB";
            }
            return "VARCHAR";
        }
        return null;
    }

    public String getTypeGenericsName(JavaType javaType) {
        if (!(javaType instanceof DefaultJavaParameterizedType)) {
            return javaType.getFullyQualifiedName();
        }
        DefaultJavaParameterizedType defaultJavaParameterizedType = (DefaultJavaParameterizedType)javaType;
        List actualTypeArguments = defaultJavaParameterizedType.getActualTypeArguments();
        if (ListUtil.isEmpty(actualTypeArguments)) {
            return javaType.getFullyQualifiedName();
        }
        StringBundler sb = new StringBundler();
        sb.append(javaType.getFullyQualifiedName());
        sb.append("<");
        for (JavaType actualTypeArgument : actualTypeArguments) {
            sb.append(this.getTypeGenericsName(actualTypeArgument));
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(">");
        sb.append(this.getDimensions(defaultJavaParameterizedType.getDimensions()));
        return sb.toString();
    }

    public String getVariableName(JavaField field) {
        String fieldName = field.getName();
        if (fieldName.length() > 0 && fieldName.charAt(0) == '_') {
            fieldName = fieldName.substring(1);
        }
        return fieldName;
    }

    public boolean hasEntityByGenericsName(String genericsName) {
        if (Validator.isNull(genericsName)) {
            return false;
        }
        if (!genericsName.contains(".model.")) {
            return false;
        }
        return this.getEntityByGenericsName(genericsName) != null;
    }

    public boolean hasEntityByParameterTypeValue(String parameterTypeValue) {
        if (Validator.isNull(parameterTypeValue)) {
            return false;
        }
        if (!parameterTypeValue.contains(".model.")) {
            return false;
        }
        return this.getEntityByParameterTypeValue(parameterTypeValue) != null;
    }

    public boolean isBasePersistenceMethod(JavaMethod method) {
        String methodName = method.getName();
        if (methodName.equals("clearCache") || methodName.equals("fetchByPrimaryKeys") || methodName.equals("findWithDynamicQuery") || methodName.equals("setConfiguration") || methodName.equals("setDataSource") || methodName.equals("setSessionFactory")) {
            return true;
        }
        if (methodName.equals("getBadColumnNames")) {
            return !this.isVersionLTE_7_1_0();
        }
        if (methodName.equals("findByPrimaryKey") || methodName.equals("fetchByPrimaryKey") || methodName.equals("remove")) {
            JavaParameter parameter;
            String parameterName;
            List parameters = method.getParameters();
            if (parameters.size() == 1 && (parameterName = (parameter = (JavaParameter)parameters.get(0)).getName()).equals("primaryKey")) {
                return true;
            }
            if (methodName.equals("remove")) {
                List methodExceptions = method.getExceptions();
                for (JavaClass methodException : methodExceptions) {
                    String exception = methodException.getValue();
                    if (!exception.contains("NoSuch")) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isCustomMethod(JavaMethod method) {
        List parameters;
        String methodName = method.getName();
        if (methodName.equals("activate") || methodName.equals("afterPropertiesSet") || methodName.equals("clearService") || methodName.equals("deactivate") || methodName.equals("destroy") || methodName.equals("equals") || methodName.equals("getAopInterfaces") || methodName.equals("getCTColumnNames") || methodName.equals("getCTPersistence") || methodName.equals("getClass") || methodName.equals("getModelClass") || methodName.equals("getService") || methodName.equals("getTableColumnsMap") || methodName.equals("getTableName") || methodName.equals("getUniqueIndexColumnNames") || methodName.equals("getWrappedService") || methodName.equals("hashCode") || methodName.equals("notify") || methodName.equals("notifyAll") || methodName.equals("setAopProxy") || methodName.equals("setWrappedService") || methodName.equals("toString") || methodName.equals("updateWithUnsafeFunction") || methodName.equals("wait")) {
            return false;
        }
        if (methodName.equals("getPermissionChecker")) {
            return false;
        }
        if ((methodName.equals("getUser") || methodName.equals("getUserId")) && (parameters = method.getParameters()).isEmpty()) {
            return false;
        }
        JavaClass javaClass = method.getDeclaringClass();
        String packageName = javaClass.getPackageName();
        if (!packageName.endsWith(".service.base")) {
            return true;
        }
        if (!(methodName.endsWith("Finder") || methodName.endsWith("Persistence") || methodName.endsWith("Service"))) {
            return true;
        }
        JavaType javaType = null;
        List parameterTypes = method.getParameterTypes(true);
        if (methodName.startsWith("get")) {
            if (ListUtil.isEmpty(parameterTypes)) {
                javaType = method.getReturnType(true);
            }
        } else if (methodName.startsWith("set") && parameterTypes != null && parameterTypes.size() == 1) {
            javaType = (JavaType)parameterTypes.get(0);
        }
        if (javaType == null) {
            return true;
        }
        String typeClassName = javaType.getFullyQualifiedName();
        int index = typeClassName.lastIndexOf(46);
        if (index == -1) {
            return true;
        }
        String typePackageName = typeClassName.substring(0, index);
        return !typePackageName.endsWith(".persistence") && !typePackageName.endsWith(".service");
    }

    public boolean isHBMCamelCasePropertyAccessor(String propertyName) {
        if (propertyName.length() < 3) {
            return false;
        }
        char[] chars = propertyName.toCharArray();
        char c0 = chars[0];
        char c1 = chars[1];
        char c2 = chars[2];
        return Character.isLowerCase(c0) && Character.isUpperCase(c1) && Character.isLowerCase(c2);
    }

    public boolean isReadOnlyMethod(JavaMethod javaMethod, List<String> txRequiredMethodNames, String[] prefixes) {
        List javaAnnotations = javaMethod.getAnnotations();
        if (javaAnnotations != null) {
            for (JavaAnnotation javaAnnotation : javaAnnotations) {
                JavaClass type = javaAnnotation.getType();
                String className = type.getFullyQualifiedName();
                if (!className.equals(Transactional.class.getName())) continue;
                return false;
            }
        }
        String methodName = javaMethod.getName();
        if (this.isTxRequiredMethod(javaMethod, txRequiredMethodNames)) {
            return false;
        }
        for (String prefix : prefixes) {
            if (!methodName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public boolean isServiceReadOnlyMethod(JavaMethod method, List<String> txRequiredMethodNames) {
        return this.isReadOnlyMethod(method, txRequiredMethodNames, this._readOnlyPrefixes);
    }

    public boolean isSoapMethod(JavaMethod method) {
        JavaType returnType = method.getReturnType();
        String returnTypeGenericsName = this.getTypeGenericsName(returnType);
        String returnValueName = returnType.getFullyQualifiedName();
        if (returnTypeGenericsName.contains("com.liferay.portal.kernel.search.") || returnTypeGenericsName.contains("com.liferay.portal.kernel.model.Theme") || returnTypeGenericsName.contains("com.liferay.social.kernel.model.SocialActivityDefinition") || returnTypeGenericsName.equals("java.util.List<java.lang.Object>") || returnValueName.equals("com.liferay.portal.kernel.lock.model.Lock") || returnValueName.equals("com.liferay.message.boards.kernel.model.MBMessageDisplay") || returnValueName.equals("com.liferay.message.boards.model.MBMessageDisplay") || returnValueName.startsWith("java.io") || returnValueName.equals("java.util.Map") || returnValueName.equals("java.util.Properties") || returnValueName.startsWith("javax")) {
            return false;
        }
        if (!returnTypeGenericsName.contains("com.liferay.portal.kernel.repository.model.FileEntry") && !returnTypeGenericsName.contains("com.liferay.portal.kernel.repository.model.Folder") && returnTypeGenericsName.contains("com.liferay.portal.kernel.repository.")) {
            return false;
        }
        List parameters = method.getParameters();
        for (JavaParameter javaParameter : parameters) {
            JavaType type = javaParameter.getType();
            String parameterTypeName = type.getFullyQualifiedName();
            if (!parameterTypeName.equals("com.liferay.portal.kernel.util.UnicodeProperties") && !parameterTypeName.equals("com.liferay.portal.kernel.theme.ThemeDisplay") && !parameterTypeName.equals("com.liferay.portlet.PortletPreferencesImpl") && !parameterTypeName.equals("com.liferay.portlet.dynamicdatamapping.Fields") && !parameterTypeName.startsWith("java.io") && !parameterTypeName.startsWith("java.util.LinkedHashMap") && (!parameterTypeName.startsWith("java.util.Map") || this._isStringLocaleMap(javaParameter)) && !parameterTypeName.startsWith("java.util.Properties") && !parameterTypeName.startsWith("javax")) continue;
            return false;
        }
        return true;
    }

    public boolean isTxRequiredMethod(JavaMethod javaMethod, List<String> txRequiredMethodNames) {
        if (txRequiredMethodNames == null) {
            return false;
        }
        return txRequiredMethodNames.contains(javaMethod.getName());
    }

    public boolean isVersionGTE_7_1_0() {
        return this._dtdVersion.isLaterVersionThan("7.1.0") || this._dtdVersion.isSameVersionAs("7.1.0");
    }

    public boolean isVersionGTE_7_2_0() {
        return this._dtdVersion.isLaterVersionThan("7.2.0") || this._dtdVersion.isSameVersionAs("7.2.0");
    }

    public boolean isVersionGTE_7_3_0() {
        return this._dtdVersion.isLaterVersionThan("7.3.0") || this._dtdVersion.isSameVersionAs("7.3.0");
    }

    public boolean isVersionLTE_7_1_0() {
        return this._dtdVersion.isPreviousVersionThan("7.1.0") || this._dtdVersion.isSameVersionAs("7.1.0");
    }

    public String javaAnnotationToString(JavaAnnotation javaAnnotation) {
        StringBundler sb = new StringBundler();
        sb.append("@");
        JavaClass type = javaAnnotation.getType();
        sb.append(type.getFullyQualifiedName());
        Map namedParameters = javaAnnotation.getNamedParameterMap();
        if (namedParameters.isEmpty()) {
            return sb.toString();
        }
        sb.append("(");
        for (Map.Entry entry : namedParameters.entrySet()) {
            sb.append((String)entry.getKey());
            sb.append("=");
            Object value = entry.getValue();
            if (value instanceof List) {
                List values = (List)value;
                sb.append("{");
                for (Object object : values) {
                    if (object instanceof JavaAnnotation) {
                        sb.append(this.javaAnnotationToString((JavaAnnotation)object));
                    } else {
                        sb.append(object);
                    }
                    sb.append(", ");
                }
                if (!values.isEmpty()) {
                    sb.setIndex(sb.index() - 1);
                }
                sb.append("}");
            } else {
                sb.append(value);
            }
            sb.append(", ");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        return sb.toString();
    }

    private static Configuration _getConfiguration() {
        if (_configuration != null) {
            return _configuration;
        }
        _configuration = new Configuration(Configuration.getVersion());
        _configuration.setNumberFormat("computer");
        DefaultObjectWrapperBuilder defaultObjectWrapperBuilder = new DefaultObjectWrapperBuilder(Configuration.getVersion());
        _configuration.setObjectWrapper((ObjectWrapper)defaultObjectWrapperBuilder.build());
        _configuration.setTemplateLoader((TemplateLoader)new ClassTemplateLoader(ServiceBuilder.class, "/"));
        _configuration.setTemplateUpdateDelayMilliseconds(Long.MAX_VALUE);
        return _configuration;
    }

    private static SAXReader _getSAXReader() {
        return SAXReaderFactory.getSAXReader(null, false, false);
    }

    private static void _mkdir(File dir) throws IOException {
        Files.createDirectories(dir.toPath(), new FileAttribute[0]);
    }

    private static void _move(File sourceFile, File destinationFile) throws IOException {
        File parentFile = destinationFile.getParentFile();
        Path parentPath = parentFile.toPath();
        if (!Files.exists(parentPath, new LinkOption[0])) {
            Files.createDirectories(parentPath, new FileAttribute[0]);
        }
        Files.move(sourceFile.toPath(), destinationFile.toPath(), new CopyOption[0]);
    }

    private static String _normalize(String fileName) {
        return StringUtil.replace(fileName, '\\', '/');
    }

    private static String _read(File file) throws IOException {
        String s = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        return StringUtil.replace(s, "\r\n", "\n");
    }

    private static void _readResourceActionModels(String implDirName, String resourcesDirName, InputStream inputStream, Set<String> resourceActionModels) throws Exception {
        SAXReader saxReader = ServiceBuilder._getSAXReader();
        Document document = saxReader.read(inputStream);
        Element rootElement = document.getRootElement();
        List resourceElements = rootElement.elements("resource");
        for (Element resourceElement : resourceElements) {
            resourceActionModels.addAll(ServiceBuilder.readResourceActionModels(implDirName, resourcesDirName, new String[]{resourceElement.attributeValue("file")}));
        }
        XPath xPath = document.createXPath("//model-resource/model-name");
        List elements = xPath.selectNodes((Object)rootElement);
        for (Element element : elements) {
            resourceActionModels.add(StringUtil.trim(element.getText()));
        }
    }

    private static void _touch(File file) throws IOException {
        ServiceBuilder._mkdir(file.getParentFile());
        Files.createFile(file.toPath(), new FileAttribute[0]);
    }

    private static void _write(File file, String s) throws IOException {
        Path path = file.toPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, s.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    private void _addIndexMetadata(Map<String, List<IndexMetadata>> indexMetadatasMap, String tableName, List<String> pkEntityColumnDBNames, IndexMetadata indexMetadata) {
        List<IndexMetadata> indexMetadatas;
        String[] columnNames;
        if (pkEntityColumnDBNames != null && pkEntityColumnDBNames.size() > 1 && (columnNames = indexMetadata.getColumnNames()).length <= pkEntityColumnDBNames.size()) {
            boolean redundant = true;
            for (int i = 0; i < columnNames.length; ++i) {
                if (columnNames[i].equals(pkEntityColumnDBNames.get(i))) continue;
                redundant = false;
                break;
            }
            if (redundant) {
                return;
            }
        }
        if ((indexMetadatas = indexMetadatasMap.get(tableName)) == null) {
            indexMetadatas = new ArrayList<IndexMetadata>();
            indexMetadatasMap.put(tableName, indexMetadatas);
        }
        Iterator<IndexMetadata> iterator = indexMetadatas.iterator();
        while (iterator.hasNext()) {
            IndexMetadata currentIndexMetadata = iterator.next();
            Boolean redundant = currentIndexMetadata.redundantTo(indexMetadata);
            if (redundant == null) continue;
            if (redundant.booleanValue()) {
                iterator.remove();
                continue;
            }
            indexMetadata = null;
            break;
        }
        if (indexMetadata != null) {
            indexMetadatas.add(indexMetadata);
        }
    }

    private void _createBaseUADAnonymizer(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/impl/", entity.getName(), this._getSessionTypeName(1), "ServiceImpl.java"));
        String deleteUADEntityMethodName = this._getDeleteUADEntityMethodName(javaClass, entity.getName());
        context.put("deleteUADEntityMethodName", deleteUADEntityMethodName);
        context.put("entity", entity);
        boolean hasAssetEntry = false;
        for (Entity referenceEntity : this._mergeReferenceEntities(entity)) {
            if (!Objects.equals(referenceEntity.getName(), "AssetEntry")) continue;
            hasAssetEntry = true;
        }
        context.put("hasAssetEntry", hasAssetEntry);
        String content = this._processTemplate(this._tplBaseUADAnonymizer, context);
        File file = new File(StringBundler.concat(entity.getUADOutputPath(), "/uad/anonymizer/Base", entity.getName(), "UADAnonymizer.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createBaseUADDisplay(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplBaseUADDisplay, context);
        File file = new File(StringBundler.concat(entity.getUADOutputPath(), "/uad/display/Base", entity.getName(), "UADDisplay.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createBaseUADExporter(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplBaseUADExporter, context);
        File file = new File(StringBundler.concat(entity.getUADOutputPath(), "/uad/exporter/Base", entity.getName(), "UADExporter.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createBlobModels(Entity entity) throws Exception {
        List<EntityColumn> blobEntityColumns = this._getBlobEntityColumns(entity);
        if (blobEntityColumns.isEmpty()) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        for (EntityColumn blobEntityColumn : blobEntityColumns) {
            context.put("column", blobEntityColumn);
            String content = this._processTemplate(this._tplBlobModel, context);
            File blobModelFile = new File(StringBundler.concat(this._serviceOutputPath, "/model/", entity.getName(), blobEntityColumn.getMethodName(), "BlobModel.java"));
            this._write(blobModelFile, content, this._modifiedFileNames);
        }
    }

    private void _createCTServiceImpl(Entity entity) throws Exception {
        File file = new File(StringBundler.concat(this._outputPath, "/service/impl/", entity.getName(), "CTServiceImpl.java"));
        if (!entity.isChangeTrackingEnabled() || entity.hasLocalService()) {
            if (file.exists()) {
                System.out.println("Removing " + file);
                file.delete();
            }
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplCTServiceImpl, context);
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createEJBPK(Entity entity) throws Exception {
        List<EntityColumn> pkEntityColumns = entity.getPKEntityColumns();
        if (pkEntityColumns.size() <= 1) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplEjbPK, context);
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/persistence/", entity.getPKClassName(), ".java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createExceptions(List<String> exceptions) throws Exception {
        for (Entity entity : this._entities) {
            if (!this._isTargetEntity(entity) || !entity.hasEntityColumns()) continue;
            exceptions.add(this.getNoSuchEntityException(entity));
        }
        for (String exception : exceptions) {
            String content;
            File oldExceptionFile = new File(StringBundler.concat(this._oldServiceOutputPath, "/", exception, "Exception.java"));
            if (!oldExceptionFile.exists()) {
                oldExceptionFile = new File(StringBundler.concat(this._oldServiceOutputPath, "/exception/", exception, "Exception.java"));
            }
            if (!oldExceptionFile.exists()) {
                oldExceptionFile = new File(StringBundler.concat(this._serviceOutputPath, "/", exception, "Exception.java"));
            }
            File exceptionFile = new File(StringBundler.concat(this._serviceOutputPath, "/exception/", exception, "Exception.java"));
            if (oldExceptionFile.exists() && !oldExceptionFile.equals(exceptionFile)) {
                exceptionFile.delete();
                Files.createDirectories(Paths.get(this._serviceOutputPath, "exception"), new FileAttribute[0]);
                Files.move(oldExceptionFile.toPath(), exceptionFile.toPath(), new CopyOption[0]);
                content = ServiceBuilder._read(exceptionFile);
                content = StringUtil.replace(content, new String[]{"package " + this._packagePath + ";", "package " + this._packagePath + ".exception;", "package " + this._apiPackagePath + ";", "com.liferay.portal.NoSuchModelException"}, new String[]{"package " + this._apiPackagePath + ".exception;", "package " + this._apiPackagePath + ".exception;", "package " + this._apiPackagePath + ".exception;", "com.liferay.portal.kernel.exception.NoSuchModelException"});
                ServiceBuilder._write(exceptionFile, content);
            }
            if (!exceptionFile.exists()) {
                Map<String, Object> context = this._getContext();
                context.put("exception", exception);
                String content2 = this._processTemplate(this._tplException, context);
                if (exception.startsWith("NoSuch")) {
                    content2 = StringUtil.replace(content2, "PortalException", "NoSuchModelException");
                }
                content2 = StringUtil.replace(content2, "\r\n", "\n");
                ToolsUtil.writeFileRaw(exceptionFile, content2, this._modifiedFileNames);
            }
            if (!exception.startsWith("NoSuch")) continue;
            content = ServiceBuilder._read(exceptionFile);
            if (!content.contains("NoSuchModelException")) {
                content = StringUtil.replace(content, "PortalException", "NoSuchModelException");
                content = StringUtil.replace(content, "portal.exception.NoSuchModelException", "portal.kernel.exception.NoSuchModelException");
                ToolsUtil.writeFileRaw(exceptionFile, content, this._modifiedFileNames);
                continue;
            }
            if (!content.contains("portal.exception.NoSuchModelException")) continue;
            content = StringUtil.replace(content, "portal.exception.NoSuchModelException", "portal.kernel.exception.NoSuchModelException");
            ToolsUtil.writeFileRaw(exceptionFile, content, this._modifiedFileNames);
        }
    }

    private void _createExtendedModel(Entity entity) throws Exception {
        JavaClass modelImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
        LinkedHashMap<String, JavaMethod> methods = new LinkedHashMap<String, JavaMethod>();
        for (JavaMethod method : this._getMethods(modelImplJavaClass)) {
            String methodSignature = this._getMethodSignature(method, false);
            methods.put(methodSignature, method);
        }
        Set entrySet = methods.entrySet();
        Iterator iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            JavaMethod method = (JavaMethod)entry.getValue();
            String methodName = method.getName();
            if (!methodName.equals("getStagedModelType")) continue;
            iterator.remove();
        }
        JavaClass modelJavaClass = this._getJavaClass(StringBundler.concat(this._serviceOutputPath, "/model/", entity.getName(), "Model.java"));
        for (JavaMethod method : this._getMethods(modelJavaClass)) {
            String methodSignature = this._getMethodSignature(method, false);
            methods.remove(methodSignature);
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods.values());
        context = this._putDeprecatedKeys(context, modelJavaClass);
        String content = this._processTemplate(this._tplExtendedModel, context);
        File modelFile = new File(StringBundler.concat(this._serviceOutputPath, "/model/", entity.getName(), ".java"));
        this._write(modelFile, content, this._modifiedFileNames);
    }

    private void _createExtendedModelBaseImpl(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        JavaClass modelImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
        context = this._putDeprecatedKeys(context, modelImplJavaClass);
        String content = this._processTemplate(this._tplExtendedModelBaseImpl, context);
        File modelFile = new File(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "BaseImpl.java"));
        this._write(modelFile, content, this._modifiedFileNames);
    }

    private void _createExtendedModelImpl(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplExtendedModelImpl, context);
        File modelFile = new File(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
        if (modelFile.exists()) {
            content = ServiceBuilder._read(modelFile);
            content = content.replaceAll(StringBundler.concat("extends\\s+", entity.getName(), "ModelImpl\\s+implements\\s+", entity.getName()), "extends " + entity.getName() + "BaseImpl");
            ToolsUtil.writeFileRaw(modelFile, content, this._modifiedFileNames);
        } else {
            this._write(modelFile, content, this._modifiedFileNames);
        }
    }

    private void _createFinder(Entity entity) throws Exception {
        if (!entity.hasFinderClassName()) {
            this._removeFinder(entity, this._serviceOutputPath);
            return;
        }
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entity.getName(), "FinderImpl.java"));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplFinder, context);
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/persistence/", entity.getName(), "Finder.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createFinderBaseImpl(Entity entity) throws Exception {
        if (!entity.hasFinderClassName() || this._packagePath.equals("com.liferay.counter")) {
            this._removeFinderBaseImpl(entity);
            return;
        }
        File finderImplFile = new File(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entity.getName(), "FinderImpl.java"));
        if (finderImplFile.exists()) {
            String content = ServiceBuilder._read(finderImplFile);
            content = StringUtil.replace(content, "import com.liferay.portal.service.persistence.impl.BasePersistenceImpl;\n", "");
            content = StringUtil.replace(content, "BasePersistenceImpl<" + entity.getName() + ">", entity.getName() + "FinderBaseImpl");
            ToolsUtil.writeFileRaw(finderImplFile, content, this._modifiedFileNames);
        }
        JavaClass javaClass = this._getJavaClass(finderImplFile.getPath());
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("persistence", Boolean.FALSE);
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplFinderBaseImpl, context);
        File file = new File(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entity.getName(), "FinderBaseImpl.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createFinderUtil(Entity entity) throws Exception {
        if (!entity.hasFinderClassName() || this._osgiModule) {
            this._removeFinderUtil(entity, this._serviceOutputPath);
            return;
        }
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entity.getName(), "FinderImpl.java"));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplFinderUtil, context);
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/persistence/", entity.getName(), "FinderUtil.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createHbm(Entity entity) {
        File file = new File(StringBundler.concat(this._outputPath, "/service/persistence/", entity.getName(), "HBM.java"));
        if (file.exists()) {
            System.out.println("Removing deprecated " + file);
            file.delete();
        }
    }

    private void _createHbmUtil(Entity entity) {
        File file = new File(StringBundler.concat(this._outputPath, "/service/persistence/", entity.getName(), "HBMUtil.java"));
        if (file.exists()) {
            System.out.println("Removing deprecated " + file);
            file.delete();
        }
    }

    private void _createHbmXml() throws Exception {
        File xmlFile = new File(this._hbmFileName);
        ArrayList<Entity> entities = new ArrayList<Entity>();
        boolean hasDeprecated = false;
        for (Entity entity : this._entities) {
            if (!entity.hasEntityColumns() || !entity.hasFinderClassName() && !entity.hasPersistence()) continue;
            if (entity.isDeprecated()) {
                hasDeprecated = true;
                continue;
            }
            entities.add(entity);
        }
        if (entities.isEmpty()) {
            if (!hasDeprecated) {
                System.out.println("Removing " + xmlFile);
                xmlFile.delete();
            }
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entities", entities);
        String content = this._processTemplate(this._tplHbmXml, context);
        int lastImportStart = content.lastIndexOf("<import class=");
        int lastImportEnd = content.indexOf("/>", lastImportStart) + 3;
        String imports = content.substring(0, lastImportEnd);
        content = content.substring(lastImportEnd + 1);
        if (!xmlFile.exists()) {
            String xml = StringBundler.concat("<?xml version=\"1.0\"?>\n", "<!DOCTYPE hibernate-mapping PUBLIC \"-//Hibernate/Hibernate ", "Mapping DTD 3.0//EN\" \"http://hibernate.sourceforge.net", "/hibernate-mapping-3.0.dtd\">\n\n", "<hibernate-mapping auto-import=\"false\" default-lazy=", "\"false\">\n", "</hibernate-mapping>");
            ServiceBuilder._write(xmlFile, xml);
        }
        String oldContent = ServiceBuilder._read(xmlFile);
        String newContent = this._fixHbmXml(oldContent);
        int firstImport = newContent.indexOf("<import class=\"" + this._packagePath + ".model.");
        int lastImport = newContent.lastIndexOf("<import class=\"" + this._packagePath + ".model.");
        if (firstImport == -1) {
            firstImport = newContent.indexOf("<import class=\"" + this._apiPackagePath + ".model.");
            lastImport = newContent.lastIndexOf("<import class=\"" + this._apiPackagePath + ".model.");
        }
        if (firstImport == -1) {
            int x = newContent.indexOf("<class");
            if (x != -1) {
                newContent = newContent.substring(0, x) + imports + newContent.substring(x);
            } else {
                content = imports + content;
            }
        } else {
            firstImport = newContent.indexOf("<import", firstImport) - 1;
            lastImport = newContent.indexOf("/>", lastImport) + 3;
            newContent = newContent.substring(0, firstImport) + imports + newContent.substring(lastImport);
        }
        int firstClass = newContent.lastIndexOf("<class ", newContent.indexOf(" name=\"" + this._packagePath + ".model.") - 6);
        int lastClass = newContent.lastIndexOf("<class ", newContent.lastIndexOf(" name=\"" + this._packagePath + ".model.") - 6);
        if (firstClass == -1) {
            int x = newContent.indexOf("</hibernate-mapping>");
            if (x != -1) {
                newContent = newContent.substring(0, x) + content + newContent.substring(x);
            }
        } else {
            firstClass = newContent.lastIndexOf("<class", firstClass) - 1;
            lastClass = newContent.indexOf("</class>", lastClass) + 9;
            newContent = newContent.substring(0, firstClass) + content + newContent.substring(lastClass);
        }
        ToolsUtil.writeFileRaw(xmlFile, this._formatXml(newContent), this._modifiedFileNames);
    }

    private void _createModel(Entity entity) throws Exception {
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        JavaClass modelImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
        context = this._putDeprecatedKeys(context, modelImplJavaClass);
        String content = this._processTemplate(this._tplModel, context);
        File modelFile = new File(StringBundler.concat(this._serviceOutputPath, "/model/", entity.getName(), "Model.java"));
        this._write(modelFile, content, this._modifiedFileNames);
    }

    private void _createModelCache(Entity entity) throws Exception {
        JavaClass modelImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
        Map<String, Object> context = this._getContext();
        context.put("cacheFields", this._getCacheFields(modelImplJavaClass));
        context.put("entity", entity);
        context = this._putDeprecatedKeys(context, modelImplJavaClass);
        String content = this._processTemplate(this._tplModelCache, context);
        File modelFile = new File(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "CacheModel.java"));
        this._write(modelFile, content, this._modifiedFileNames);
    }

    private void _createModelHintsXml() throws Exception {
        String oldContent;
        Map<String, Object> context = this._getContext();
        context.put("entities", this._entities);
        String content = this._processTemplate(this._tplModelHintsXml, context);
        File xmlFile = new File(this._modelHintsFileName);
        if (!xmlFile.exists()) {
            ServiceBuilder._write(xmlFile, "<?xml version=\"1.0\"?>\n\n<model-hints>\n</model-hints>");
        }
        String newContent = oldContent = ServiceBuilder._read(xmlFile);
        int firstModel = newContent.indexOf("<model name=\"" + this._packagePath + ".model.");
        int lastModel = newContent.lastIndexOf("<model name=\"" + this._packagePath + ".model.");
        if (firstModel == -1) {
            firstModel = newContent.indexOf("<model name=\"" + this._apiPackagePath + ".model.");
            lastModel = newContent.lastIndexOf("<model name=\"" + this._apiPackagePath + ".model.");
        }
        if (firstModel == -1) {
            int x = newContent.indexOf("</model-hints>");
            newContent = newContent.substring(0, x) + content + newContent.substring(x);
        } else {
            firstModel = newContent.lastIndexOf("<model", firstModel) - 1;
            lastModel = newContent.indexOf("</model>", lastModel) + 9;
            newContent = newContent.substring(0, firstModel) + content + newContent.substring(lastModel);
        }
        ToolsUtil.writeFileRaw(xmlFile, this._formatXml(newContent), this._modifiedFileNames);
    }

    private void _createModelImpl(Entity entity) throws Exception {
        JavaField[] cacheFields;
        JavaClass modelImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
        Map<String, Object> context = this._getContext();
        boolean hasClassNameCacheField = false;
        for (JavaField javaField : cacheFields = this._getCacheFields(modelImplJavaClass)) {
            if (!Objects.equals(javaField.getName(), "_className")) continue;
            hasClassNameCacheField = true;
            break;
        }
        context.put("cacheFields", this._getCacheFields(modelImplJavaClass));
        context.put("entity", entity);
        context.put("hasClassNameCacheField", hasClassNameCacheField);
        context = this._putDeprecatedKeys(context, modelImplJavaClass);
        String content = this._processTemplate(this._tplModelImpl, context);
        File modelFile = new File(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "ModelImpl.java"));
        this._write(modelFile, content, this._modifiedFileNames);
    }

    private void _createModelSoap(Entity entity) throws Exception {
        File modelFile = new File(StringBundler.concat(this._serviceOutputPath, "/model/", entity.getName(), "Soap.java"));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        JavaClass modelImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
        context = this._putDeprecatedKeys(context, modelImplJavaClass);
        String content = this._processTemplate(this._tplModelSoap, context);
        this._write(modelFile, content, this._modifiedFileNames);
    }

    private void _createModelWrapper(Entity entity) throws Exception {
        JavaClass modelJavaClass = this._getJavaClass(StringBundler.concat(this._serviceOutputPath, "/model/", entity.getName(), "Model.java"));
        List<JavaMethod> methods = this._getMethods(modelJavaClass);
        JavaClass extendedModelBaseImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "BaseImpl.java"));
        methods = this._mergeMethods(methods, this._getMethods(extendedModelBaseImplJavaClass), false);
        JavaClass extendedModelJavaClass = this._getJavaClass(StringBundler.concat(this._serviceOutputPath, "/model/", entity.getName(), ".java"));
        methods = this._mergeMethods(methods, this._getMethods(extendedModelJavaClass), false);
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods);
        context = this._putDeprecatedKeys(context, modelJavaClass);
        String content = this._processTemplate(this._tplModelWrapper, context);
        File modelFile = new File(StringBundler.concat(this._serviceOutputPath, "/model/", entity.getName(), "Wrapper.java"));
        this._write(modelFile, content, this._modifiedFileNames);
    }

    private void _createPersistence(Entity entity) throws Exception {
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/persistence/", entity.getName(), "Persistence.java"));
        if (entity.hasPersistence()) {
            JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entity.getName(), "PersistenceImpl.java"));
            Map<String, Object> context = this._getContext();
            context.put("entity", entity);
            context.put("methods", this._getMethods(javaClass));
            context = this._putDeprecatedKeys(context, javaClass);
            String content = this._processTemplate(this._tplPersistence, context);
            this._write(file, content, this._modifiedFileNames);
        } else {
            System.out.println("Removing " + file);
            if (file.exists()) {
                file.delete();
            }
        }
    }

    private void _createPersistenceConstants() throws Exception {
        if (!this._dependencyInjectorDS) {
            return;
        }
        File file = new File(StringBundler.concat(this._outputPath, "/service/persistence/impl/constants/", this._portletShortName, "PersistenceConstants.java"));
        String content = this._processTemplate(this._tplPersistenceConstants, this._getContext());
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createPersistenceImpl(Entity entity) throws Exception {
        File file = new File(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entity.getName(), "PersistenceImpl.java"));
        if (entity.hasPersistence()) {
            Map<String, Object> context = this._getContext();
            context.put("entity", entity);
            context.put("persistence", Boolean.TRUE);
            context.put("referenceEntities", this._mergeReferenceEntities(entity));
            JavaClass modelImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
            context = this._putDeprecatedKeys(context, modelImplJavaClass);
            String content = this._processTemplate(this._tplPersistenceImpl, context);
            this._write(file, content, this._modifiedFileNames);
        } else {
            System.out.println("Removing " + file);
            if (file.exists()) {
                file.delete();
            }
        }
        file = new File(StringBundler.concat(this._outputPath, "/service/persistence/", entity.getName(), "PersistenceImpl.java"));
        if (file.exists()) {
            System.out.println("Relocating " + file);
            file.delete();
        }
    }

    private void _createPersistenceTest(Entity entity) throws Exception {
        File file = new File(StringBundler.concat(this._testOutputPath, "/service/persistence/test/", entity.getName(), "PersistenceTest.java"));
        if (entity.isDeprecated() || !entity.hasPersistence()) {
            System.out.println("Removing " + file);
            file.delete();
        } else {
            Map<String, Object> context = this._getContext();
            context.put("entity", entity);
            JavaClass modelImplJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
            context = this._putDeprecatedKeys(context, modelImplJavaClass);
            String content = this._processTemplate(this._tplPersistenceTest, context);
            this._write(file, content, this._modifiedFileNames);
        }
        file = new File(StringBundler.concat(this._testOutputPath, "/service/persistence/", entity.getName(), "PersistenceTest.java"));
        if (file.exists()) {
            System.out.println("Relocating " + file);
            file.delete();
        }
    }

    private void _createPersistenceUtil(Entity entity) throws Exception {
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/persistence/", entity.getName(), "Util.java"));
        if (entity.hasPersistence()) {
            JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entity.getName(), "PersistenceImpl.java"));
            Map<String, Object> context = this._getContext();
            context.put("entity", entity);
            context.put("methods", this._getMethods(javaClass));
            context = this._putDeprecatedKeys(context, javaClass);
            String content = this._processTemplate(this._tplPersistenceUtil, context);
            this._write(file, content, this._modifiedFileNames);
        } else {
            System.out.println("Removing " + file);
            if (file.exists()) {
                file.delete();
            }
        }
    }

    private void _createPool(Entity entity) {
        File file = new File(StringBundler.concat(this._outputPath, "/service/persistence/", entity.getName(), "Pool.java"));
        if (file.exists()) {
            System.out.println("Removing deprecated " + file);
            file.delete();
        }
    }

    private void _createProps() throws Exception {
        if (Validator.isNull(this._pluginName) && !this._osgiModule) {
            return;
        }
        File propsFile = null;
        propsFile = Validator.isNotNull(this._resourcesDirName) ? new File(this._resourcesDirName + "/service.properties") : new File(this._implDirName + "/service.properties");
        long buildNumber = 1L;
        long buildDate = System.currentTimeMillis();
        if (propsFile.exists()) {
            Properties properties = PropertiesUtil.load(ServiceBuilder._read(propsFile));
            if (!this._buildNumberIncrement) {
                buildDate = GetterUtil.getLong(properties.getProperty("build.date"));
                buildNumber = GetterUtil.getLong(properties.getProperty("build.number"));
            } else {
                buildNumber = GetterUtil.getLong(properties.getProperty("build.number")) + 1L;
            }
        }
        if (!this._buildNumberIncrement && buildNumber < this._buildNumber) {
            buildNumber = this._buildNumber;
            buildDate = System.currentTimeMillis();
        }
        Map<String, Object> context = this._getContext();
        context.put("buildNumber", buildNumber);
        context.put("currentTimeMillis", buildDate);
        String content = this._processTemplate(this._tplProps, context);
        ToolsUtil.writeFileRaw(propsFile, content, this._modifiedFileNames);
    }

    private void _createService(Entity entity, int sessionType) throws Exception {
        HashSet imports = new HashSet();
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/impl/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceImpl.java"));
        JavaSource javaSource = javaClass.getSource();
        imports.addAll(javaSource.getImports());
        List<JavaMethod> methods = this._getMethods(javaClass);
        JavaType superClass = javaClass.getSuperClass();
        String superClassValue = superClass.getValue();
        if (superClassValue.endsWith(entity.getName() + this._getSessionTypeName(sessionType) + "ServiceBaseImpl")) {
            JavaClass parentJavaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/base/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceBaseImpl.java"));
            JavaSource parentJavaSource = parentJavaClass.getSource();
            imports.addAll(parentJavaSource.getImports());
            methods = this._mergeMethods(methods, parentJavaClass.getMethods(), true);
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("imports", imports);
        context.put("methods", methods);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplService, context);
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "Service.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createServiceBaseImpl(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/impl/", entity.getName(), sessionType != 0 ? "Local" : "", "ServiceImpl.java"));
        List<JavaMethod> methods = this._getMethods(javaClass);
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", methods);
        context.put("referenceEntities", this._mergeReferenceEntities(entity));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceBaseImpl, context);
        File file = new File(StringBundler.concat(this._outputPath, "/service/base/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceBaseImpl.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createServiceFactory(Entity entity, int sessionType) {
        File file = new File(StringBundler.concat(this._oldServiceOutputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceFactory.java"));
        if (file.exists()) {
            System.out.println("Removing deprecated " + file);
            file.delete();
        }
        if ((file = new File(StringBundler.concat(this._outputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceFactory.java"))).exists()) {
            System.out.println("Removing deprecated " + file);
            file.delete();
        }
    }

    private void _createServiceHttp(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/impl/", entity.getName(), "ServiceImpl.java"));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("hasHttpMethods", this._hasHttpMethods(javaClass));
        context.put("methods", this._getMethods(javaClass));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceHttp, context);
        File file = new File(StringBundler.concat(this._outputPath, "/service/http/", entity.getName(), "ServiceHttp.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createServiceImpl(Entity entity, int sessionType) throws Exception {
        File file = new File(StringBundler.concat(this._outputPath, "/service/impl/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceImpl.java"));
        if (file.exists()) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        String content = this._processTemplate(this._tplServiceImpl, context);
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createServicePropsUtil() throws Exception {
        if (!this._osgiModule) {
            return;
        }
        File file = new File(StringBundler.concat(this._implDirName, "/", StringUtil.replace(this._propsUtil, '.', '/'), ".java"));
        if (this._dependencyInjectorDS) {
            if (file.exists()) {
                file.delete();
                System.out.println("Removing " + file);
            }
            return;
        }
        Map<String, Object> context = this._getContext();
        int index = this._propsUtil.lastIndexOf(".");
        context.put("servicePropsUtilClassName", this._propsUtil.substring(index + 1));
        context.put("servicePropsUtilPackagePath", this._propsUtil.substring(0, index));
        String content = this._processTemplate(this._tplServicePropsUtil, context);
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createServiceSoap(Entity entity) throws Exception {
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._outputPath, "/service/impl/", entity.getName(), "ServiceImpl.java"));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceSoap, context);
        File file = new File(StringBundler.concat(this._outputPath, "/service/http/", entity.getName(), "ServiceSoap.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createServiceUtil(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._serviceOutputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "Service.java"));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceUtil, context);
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceUtil.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createServiceWrapper(Entity entity, int sessionType) throws Exception {
        JavaClass javaClass = this._getJavaClass(StringBundler.concat(this._serviceOutputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "Service.java"));
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        context.put("methods", this._getMethods(javaClass));
        context.put("sessionTypeName", this._getSessionTypeName(sessionType));
        context = this._putDeprecatedKeys(context, javaClass);
        String content = this._processTemplate(this._tplServiceWrapper, context);
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceWrapper.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createServletContextUtil() throws Exception {
        if (Validator.isNull(this._pluginName)) {
            return;
        }
        Map<String, Object> context = this._getContext();
        String content = this._processTemplate(this._tplServletContextUtil, context);
        File file = new File(this._serviceOutputPath + "/service/ServletContextUtil.java");
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createSpringXml() throws Exception {
        if (this._packagePath.equals("com.liferay.counter")) {
            return;
        }
        File xmlFile = new File(this._springFileName);
        if (this._dependencyInjectorDS) {
            if (xmlFile.exists()) {
                xmlFile.delete();
                System.out.println("Removing " + xmlFile);
            }
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entities", this._entities);
        String content = this._processTemplate(this._tplSpringXml, context);
        StringBundler sb = new StringBundler(11);
        sb.append("<?xml version=\"1.0\"?>\n\n");
        sb.append("<beans\n");
        sb.append("\tdefault-destroy-method=\"destroy\"\n");
        sb.append("\tdefault-init-method=\"afterPropertiesSet\"\n");
        sb.append(this._getSpringNamespacesDeclarations());
        sb.append("\txmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append("\n");
        sb.append("\txsi:schemaLocation=\"");
        sb.append(StringUtil.trim(this._getSpringSchemaLocations()));
        sb.append("\">\n");
        sb.append("</beans>");
        String xml = sb.toString();
        if (!xmlFile.exists()) {
            ServiceBuilder._write(xmlFile, xml);
        }
        String oldContent = ServiceBuilder._read(xmlFile);
        if (Validator.isNotNull(this._pluginName) && oldContent.contains("DOCTYPE beans PUBLIC")) {
            oldContent = xml;
        }
        String newContent = this._fixSpringXml(oldContent);
        int x = oldContent.indexOf("<beans");
        int y = oldContent.lastIndexOf("</beans>");
        int firstSession = newContent.indexOf("<bean class=\"" + this._packagePath + ".service.", x);
        int lastSession = newContent.lastIndexOf("<bean class=\"" + this._packagePath + ".service.", y);
        if (firstSession == -1) {
            firstSession = newContent.indexOf("<bean class=\"" + this._apiPackagePath + ".service.", x);
            lastSession = newContent.lastIndexOf("<bean class=\"" + this._apiPackagePath + ".service.", y);
        }
        if (firstSession == -1 || firstSession > y) {
            x = newContent.indexOf("</beans>");
            newContent = newContent.substring(0, x) + content + newContent.substring(x);
        } else {
            firstSession = newContent.lastIndexOf("<bean", firstSession) - 1;
            int tempLastSession = newContent.indexOf("<bean class=\"", lastSession + 1);
            if (tempLastSession == -1) {
                tempLastSession = newContent.indexOf("</beans>", lastSession);
            }
            lastSession = tempLastSession;
            newContent = newContent.substring(0, firstSession) + content + newContent.substring(lastSession);
        }
        newContent = this._formatXml(newContent);
        Matcher matcher = _beansPattern.matcher(newContent);
        if (matcher.find()) {
            String beans = matcher.group();
            TreeMap<String, String> beansAttributes = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
            matcher = _beansAttributePattern.matcher(beans);
            while (matcher.find()) {
                String beanAttribute = StringBundler.concat(StringUtil.trim(matcher.group(1)), "=\"", StringUtil.trim(matcher.group(2)), "\"");
                beansAttributes.put(StringUtil.trim(matcher.group(1)), beanAttribute);
            }
            sb.setIndex(0);
            for (Map.Entry beanAttribute : beansAttributes.entrySet()) {
                sb.append("\n\t");
                sb.append((String)beanAttribute.getValue());
            }
            newContent = StringUtil.replaceFirst(newContent, beans, "<beans" + sb.toString() + "\n>");
        }
        ToolsUtil.writeFileRaw(xmlFile, newContent, this._modifiedFileNames);
    }

    private void _createSQLIndexes() throws Exception {
        File sqlFile;
        File sqlDir = new File(this._sqlDirName);
        if (!sqlDir.exists()) {
            ServiceBuilder._mkdir(sqlDir);
        }
        if (!(sqlFile = new File(this._sqlDirName + "/" + this._sqlIndexesFileName)).exists()) {
            ServiceBuilder._touch(sqlFile);
        }
        TreeMap<String, List<IndexMetadata>> indexMetadatasMap = new TreeMap<String, List<IndexMetadata>>();
        Throwable throwable = null;
        try (Iterator<Map.Entry<String, EntityMapping>> unsyncBufferedReader = new UnsyncBufferedReader(new FileReader(sqlFile));){
            String indexSQL;
            block9: while ((indexSQL = ((UnsyncBufferedReader)((Object)unsyncBufferedReader)).readLine()) != null) {
                if (Validator.isNull(indexSQL = indexSQL.trim())) continue;
                IndexMetadata indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata(indexSQL);
                List<String> pkEntityColumnDBNames = null;
                Entity entity = this._getEntityByTableName(indexMetadata.getTableName());
                if (entity != null) {
                    indexMetadata = new IndexMetadata(indexMetadata.getIndexName(), indexMetadata.getTableName(), indexMetadata.isUnique(), indexMetadata.getColumnNames());
                    for (String columnName : indexMetadata.getColumnNames()) {
                        EntityColumn entityColumn = this._fetchEntityColumnByColumnDBName(entity, columnName);
                        if (entityColumn != null) continue;
                        System.out.println(StringBundler.concat("Removing index ", indexMetadata.getIndexName(), " because column \"", columnName, "\" does not exist"));
                        continue block9;
                    }
                    pkEntityColumnDBNames = entity.getPKEntityColumnDBNames();
                } else {
                    EntityMapping entityMapping = this._entityMappings.get(indexMetadata.getTableName());
                    pkEntityColumnDBNames = this._getEntityMappingPKEntityColumnDBNames(entityMapping);
                }
                this._addIndexMetadata(indexMetadatasMap, indexMetadata.getTableName(), pkEntityColumnDBNames, indexMetadata);
            }
        }
        catch (Throwable indexSQL) {
            Throwable throwable2 = indexSQL;
            throw indexSQL;
        }
        for (Entity entity : this._entities) {
            if (!this._isTargetEntity(entity) || !entity.isDefaultDataSource() || entity.isDeprecated() || !entity.hasFinderClassName() && !entity.hasPersistence()) continue;
            List indexMetadatas = (List)indexMetadatasMap.get(entity.getTable());
            List<EntityFinder> entityFinders = entity.getEntityFinders();
            for (EntityFinder entityFinder : entityFinders) {
                List<EntityColumn> entityColumns;
                if (!entityFinder.isDBIndex() || (entityColumns = entityFinder.getEntityColumns()).equals(entity.getPKEntityColumns())) continue;
                ArrayList<String> dbNames = new ArrayList<String>();
                for (EntityColumn entityColumn : entityColumns) {
                    dbNames.add(entityColumn.getDBName());
                }
                if (dbNames.isEmpty()) continue;
                if (entity.isChangeTrackingEnabled() && !dbNames.contains("ctCollectionId")) {
                    if (indexMetadatas != null) {
                        Iterator iterator = indexMetadatas.iterator();
                        while (iterator.hasNext()) {
                            IndexMetadata indexMetadata = (IndexMetadata)iterator.next();
                            if (!indexMetadata.isUnique() || !dbNames.equals(Arrays.asList(indexMetadata.getColumnNames()))) continue;
                            iterator.remove();
                            break;
                        }
                    }
                    dbNames.add("ctCollectionId");
                }
                IndexMetadata indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata(entityFinder.isUnique(), entity.getTable(), dbNames.toArray(new String[0]));
                this._addIndexMetadata(indexMetadatasMap, indexMetadata.getTableName(), entity.getPKEntityColumnDBNames(), indexMetadata);
            }
        }
        for (Map.Entry<String, EntityMapping> entry : this._entityMappings.entrySet()) {
            EntityMapping entityMapping = entry.getValue();
            this._getCreateMappingTableIndex(entityMapping, indexMetadatasMap);
        }
        StringBundler sb = new StringBundler();
        for (List indexMetadatas : indexMetadatasMap.values()) {
            Collections.sort(indexMetadatas);
            for (IndexMetadata indexMetadata : indexMetadatas) {
                sb.append(indexMetadata.getCreateSQL(this._getColumnLengths(indexMetadata)));
                sb.append("\n");
            }
            sb.append("\n");
        }
        if (!indexMetadatasMap.isEmpty()) {
            sb.setIndex(sb.index() - 2);
        }
        ToolsUtil.writeFileRaw(sqlFile, sb.toString(), this._modifiedFileNames);
        File file = new File(this._sqlDirName, "indexes.properties");
        file.delete();
    }

    private void _createSQLMappingTables(File sqlFile, String newCreateTableString, EntityMapping entityMapping, boolean addMissingTables) throws IOException {
        if (!sqlFile.exists()) {
            ServiceBuilder._touch(sqlFile);
        }
        String content = ServiceBuilder._read(sqlFile);
        int x = content.indexOf(_SQL_CREATE_TABLE + entityMapping.getTableName() + " (");
        int y = content.indexOf(");", x);
        if (x != -1) {
            String oldCreateTableString = content.substring(x + 1, y);
            if (!oldCreateTableString.equals(newCreateTableString)) {
                content = content.substring(0, x) + newCreateTableString + content.substring(y + 2);
                ToolsUtil.writeFileRaw(sqlFile, content, this._modifiedFileNames);
            }
        } else if (addMissingTables) {
            try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
                StringBundler sb = new StringBundler();
                String line = null;
                boolean appendNewTable = true;
                while ((line = unsyncBufferedReader.readLine()) != null) {
                    String tableName;
                    if (appendNewTable && line.startsWith(_SQL_CREATE_TABLE) && (tableName = line.substring(x = _SQL_CREATE_TABLE.length(), y = line.indexOf(" ", x))).compareTo(entityMapping.getTableName()) > 0) {
                        sb.append(newCreateTableString);
                        sb.append("\n\n");
                        appendNewTable = false;
                    }
                    sb.append(line);
                    sb.append("\n");
                }
                if (appendNewTable) {
                    sb.append("\n");
                    sb.append(newCreateTableString);
                }
                ToolsUtil.writeFileRaw(sqlFile, sb.toString(), this._modifiedFileNames);
            }
        }
    }

    private void _createSQLSequences() throws IOException {
        File sqlFile;
        File sqlDir = new File(this._sqlDirName);
        if (!sqlDir.exists()) {
            ServiceBuilder._mkdir(sqlDir);
        }
        if (!(sqlFile = new File(this._sqlDirName + "/" + this._sqlSequencesFileName)).exists()) {
            ServiceBuilder._touch(sqlFile);
        }
        TreeSet<String> sequenceSQLs = new TreeSet<String>();
        UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new FileReader(sqlFile));
        Object object = null;
        try {
            String sequenceSQL;
            while ((sequenceSQL = unsyncBufferedReader.readLine()) != null) {
                if (!Validator.isNotNull(sequenceSQL)) continue;
                sequenceSQLs.add(sequenceSQL);
            }
        }
        catch (Throwable sequenceSQL) {
            object = sequenceSQL;
            throw sequenceSQL;
        }
        finally {
            if (unsyncBufferedReader != null) {
                if (object != null) {
                    try {
                        unsyncBufferedReader.close();
                    }
                    catch (Throwable sequenceSQL) {
                        ((Throwable)object).addSuppressed(sequenceSQL);
                    }
                } else {
                    unsyncBufferedReader.close();
                }
            }
        }
        for (Entity entity : this._entities) {
            if (!this._isTargetEntity(entity) || !entity.isDefaultDataSource() || !entity.hasFinderClassName() && !entity.hasPersistence()) continue;
            List<EntityColumn> entityColumns = entity.getEntityColumns();
            for (EntityColumn entityColumn : entityColumns) {
                if (!Objects.equals(entityColumn.getIdType(), "sequence")) continue;
                StringBundler sb = new StringBundler(3);
                String sequenceName = entityColumn.getIdParam();
                if (sequenceName.length() > 30) {
                    sequenceName = sequenceName.substring(0, 30);
                }
                sb.append("create sequence ");
                sb.append(sequenceName);
                sb.append(";");
                String sequenceSQL = sb.toString();
                if (sequenceSQLs.contains(sequenceSQL)) continue;
                sequenceSQLs.add(sequenceSQL);
            }
        }
        StringBundler sb = new StringBundler(sequenceSQLs.size() * 2);
        for (String sequenceSQL : sequenceSQLs) {
            sb.append(sequenceSQL);
            sb.append("\n");
        }
        if (!sequenceSQLs.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        ToolsUtil.writeFileRaw(sqlFile, sb.toString(), this._modifiedFileNames);
    }

    private void _createSQLTables() throws Exception {
        File sqlFile;
        File sqlDir = new File(this._sqlDirName);
        if (!sqlDir.exists()) {
            ServiceBuilder._mkdir(sqlDir);
        }
        if (!(sqlFile = new File(this._sqlDirName + "/" + this._sqlFileName)).exists()) {
            ServiceBuilder._touch(sqlFile);
        }
        for (Entity entity : this._entities) {
            String createTableSQL;
            if (!this._isTargetEntity(entity) || !entity.isDefaultDataSource() || entity.isDeprecated() || !entity.hasFinderClassName() && !entity.hasPersistence() || !Validator.isNotNull(createTableSQL = this._getCreateTableSQL(entity))) continue;
            this._createSQLTables(sqlFile, createTableSQL, entity, true);
            if (!GetterUtil.getBoolean(this._compatProperties.getProperty("update.sql.file.auto.update"))) continue;
            List<Path> updateSQLFilePaths = this._getUpdateSQLFilePaths();
            for (Path updateSQLFilePath : updateSQLFilePaths) {
                if (updateSQLFilePath == null || !Files.exists(updateSQLFilePath, new LinkOption[0])) continue;
                this._createSQLTables(updateSQLFilePath.toFile(), createTableSQL, entity, false);
            }
        }
        for (Map.Entry entry : this._entityMappings.entrySet()) {
            EntityMapping entityMapping = (EntityMapping)entry.getValue();
            String createMappingTableSQL = this._getCreateMappingTableSQL(entityMapping);
            if (!Validator.isNotNull(createMappingTableSQL)) continue;
            this._createSQLMappingTables(sqlFile, createMappingTableSQL, entityMapping, true);
        }
        String content = ServiceBuilder._read(sqlFile);
        ToolsUtil.writeFileRaw(sqlFile, content.trim(), this._modifiedFileNames);
    }

    private void _createSQLTables(File sqlFile, String newCreateTableString, Entity entity, boolean addMissingTables) throws IOException {
        if (!sqlFile.exists()) {
            ServiceBuilder._touch(sqlFile);
        }
        String content = ServiceBuilder._read(sqlFile);
        int x = content.indexOf(_SQL_CREATE_TABLE + entity.getTable() + " (");
        int y = content.indexOf(");", x);
        if (x != -1) {
            String oldCreateTableString = content.substring(x, y + 2);
            if (!oldCreateTableString.equals(newCreateTableString)) {
                content = content.substring(0, x) + newCreateTableString + content.substring(y + 2);
                ServiceBuilder._write(sqlFile, content);
            }
        } else if (addMissingTables) {
            try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
                StringBundler sb = new StringBundler();
                String line = null;
                boolean appendNewTable = true;
                while ((line = unsyncBufferedReader.readLine()) != null) {
                    String tableName;
                    if (appendNewTable && line.startsWith(_SQL_CREATE_TABLE) && (tableName = line.substring(x = _SQL_CREATE_TABLE.length(), y = line.indexOf(" ", x))).compareTo(entity.getTable()) > 0) {
                        sb.append(newCreateTableString);
                        sb.append("\n\n");
                        appendNewTable = false;
                    }
                    sb.append(line);
                    sb.append("\n");
                }
                if (appendNewTable) {
                    sb.append("\n");
                    sb.append(newCreateTableString);
                }
                ToolsUtil.writeFileRaw(sqlFile, sb.toString(), this._modifiedFileNames);
            }
        }
    }

    private void _createUADAnonymizer(Entity entity) throws Exception {
        File file = new File(StringBundler.concat(entity.getUADOutputPath(), "/uad/anonymizer/", entity.getName(), "UADAnonymizer.java"));
        if (file.exists()) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplUADAnonymizer, context);
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createUADBnd(String uadApplicationName) throws Exception {
        int index;
        List<Entity> entities = this._uadApplicationEntities.get(uadApplicationName);
        Entity entity = entities.get(0);
        String uadOutputPath = entity.getUADOutputPath();
        String uadDirName = uadOutputPath.substring(0, index = uadOutputPath.indexOf("/src/"));
        File file = new File(uadDirName + "/bnd.bnd");
        if (file.exists()) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("uadBundleName", StringBundler.concat("Liferay ", TextFormatter.format(TextFormatter.format(uadApplicationName, 10), 9), " UAD"));
        context.put("uadPackagePath", entity.getUADPackagePath());
        String content = this._processTemplate(this._tplUADBnd, context);
        ToolsUtil.writeFileRaw(file, content, this._modifiedFileNames);
    }

    private void _createUADConstants(String uadApplicationName) throws Exception {
        Map<String, Object> context = this._getContext();
        List<Entity> entities = this._uadApplicationEntities.get(uadApplicationName);
        context.put("entities", entities);
        Entity entity = entities.get(0);
        context.put("uadApplicationName", uadApplicationName);
        context.put("uadPackagePath", entity.getUADPackagePath());
        String content = this._processTemplate(this._tplUADConstants, context);
        File file = new File(StringBundler.concat(entity.getUADOutputPath(), "/uad/constants/", uadApplicationName, "UADConstants.java"));
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createUADDisplay(Entity entity) throws Exception {
        File file = new File(StringBundler.concat(entity.getUADOutputPath(), "/uad/display/", entity.getName(), "UADDisplay.java"));
        if (file.exists()) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplUADDisplay, context);
        this._write(file, content, this._modifiedFileNames);
    }

    private void _createUADExporter(Entity entity) throws Exception {
        File file = new File(StringBundler.concat(entity.getUADOutputPath(), "/uad/exporter/", entity.getName(), "UADExporter.java"));
        if (file.exists()) {
            return;
        }
        Map<String, Object> context = this._getContext();
        context.put("entity", entity);
        String content = this._processTemplate(this._tplUADExporter, context);
        this._write(file, content, this._modifiedFileNames);
    }

    private void _deleteFile(String fileName) {
        File file = new File(fileName);
        file.delete();
    }

    private void _deleteOrmXml() throws Exception {
        if (Validator.isNull(this._pluginName)) {
            return;
        }
        this._deleteFile("docroot/WEB-INF/src/META-INF/portlet-orm.xml");
    }

    private void _deleteSpringLegacyXml() throws Exception {
        if (Validator.isNull(this._pluginName)) {
            return;
        }
        this._deleteFile("docroot/WEB-INF/src/META-INF/base-spring.xml");
        this._deleteFile("docroot/WEB-INF/src/META-INF/cluster-spring.xml");
        this._deleteFile("docroot/WEB-INF/src/META-INF/data-source-spring.xml");
        this._deleteFile("docroot/WEB-INF/src/META-INF/dynamic-data-source-spring.xml");
        this._deleteFile("docroot/WEB-INF/src/META-INF/hibernate-spring.xml");
        this._deleteFile("docroot/WEB-INF/src/META-INF/infrastructure-spring.xml");
        this._deleteFile("docroot/WEB-INF/src/META-INF/misc-spring.xml");
    }

    private EntityColumn _fetchEntityColumnByColumnDBName(Entity entity, String columnDBName) {
        for (EntityColumn entityColumn : entity.getFinderEntityColumns()) {
            if (!columnDBName.equals(entityColumn.getDBName())) continue;
            return entityColumn;
        }
        for (EntityColumn entityColumn : entity.getEntityColumns()) {
            if (!columnDBName.equals(entityColumn.getDBName())) continue;
            return entityColumn;
        }
        return null;
    }

    private String _fixHbmXml(String content) throws IOException {
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(content));){
            StringBundler sb = new StringBundler();
            String line = null;
            while ((line = unsyncBufferedReader.readLine()) != null) {
                if (line.startsWith("\t<class name=\"") && !(line = StringUtil.replace(line, new String[]{".service.persistence.", "HBM\" table=\""}, new String[]{".model.", "\" table=\""})).contains(".model.impl.") && !line.contains("BlobModel")) {
                    line = StringUtil.replace(line, new String[]{".model.", "\" table=\""}, new String[]{".model.impl.", "Impl\" table=\""});
                }
                sb.append(line);
                sb.append('\n');
            }
            String string = StringUtil.trim(sb.toString());
            return string;
        }
    }

    private String _fixSpringXml(String content) {
        return StringUtil.replace(content, ".service.spring.", ".service.");
    }

    private String _formatComment(String comment, List<DocletTag> tags, String indentation) {
        StringBundler sb = new StringBundler();
        if (Validator.isNull(comment) && tags.isEmpty()) {
            return sb.toString();
        }
        sb.append(indentation);
        sb.append("/**\n");
        if (Validator.isNotNull(comment)) {
            comment = comment.replaceAll("(?m)^", indentation + " * ");
            sb.append(comment);
            sb.append("\n");
            if (!tags.isEmpty()) {
                sb.append(indentation);
                sb.append(" *\n");
            }
        }
        for (DocletTag tag : tags) {
            String tagValue = tag.getValue();
            sb.append(indentation);
            sb.append(" * @");
            sb.append(tag.getName());
            sb.append(" ");
            if (this._currentTplName.equals(this._tplServiceSoap)) {
                if (tagValue.startsWith(PortalException.class.getName())) {
                    tagValue = tagValue.replaceFirst(PortalException.class.getName(), "RemoteException");
                } else if (tagValue.startsWith(PrincipalException.class.getName())) {
                    tagValue = tagValue.replaceFirst(PrincipalException.class.getName(), "RemoteException");
                }
            }
            sb.append(tagValue);
            sb.append("\n");
        }
        sb.append(indentation);
        sb.append(" */\n");
        return sb.toString();
    }

    private String _formatXml(String xml) throws DocumentException, IOException {
        String doctype = null;
        int x = xml.indexOf("<!DOCTYPE");
        if (x != -1) {
            int y = xml.indexOf(">", x) + 1;
            doctype = xml.substring(x, y);
            xml = xml.substring(0, x) + "\n" + xml.substring(y);
        }
        xml = StringUtil.replace(xml, '\r', "");
        xml = Dom4jUtil.toString(xml);
        xml = StringUtil.replace(xml, "\"/>", "\" />");
        if (Validator.isNotNull(doctype)) {
            x = xml.indexOf("?>") + 2;
            xml = StringBundler.concat(xml.substring(0, x), "\n", doctype, xml.substring(x));
        }
        return xml;
    }

    private List<EntityColumn> _getBlobEntityColumns(Entity entity) {
        ArrayList<EntityColumn> blobEntityColumns = new ArrayList<EntityColumn>(entity.getBlobEntityColumns());
        Iterator iterator = blobEntityColumns.iterator();
        while (iterator.hasNext()) {
            EntityColumn entityColumn = (EntityColumn)iterator.next();
            if (entityColumn.isLazy()) continue;
            iterator.remove();
        }
        return blobEntityColumns;
    }

    private JavaField[] _getCacheFields(JavaClass javaClass) {
        if (javaClass == null) {
            return new JavaField[0];
        }
        ArrayList<JavaField> javaFields = new ArrayList<JavaField>();
        block0: for (JavaField javaField : javaClass.getFields()) {
            List javaAnnotations = javaField.getAnnotations();
            for (JavaAnnotation javaAnnotation : javaAnnotations) {
                JavaClass javaAnnotationClass = javaAnnotation.getType();
                String className = javaAnnotationClass.getFullyQualifiedName();
                if (!className.equals(CacheField.class.getName())) continue;
                javaFields.add(javaField);
                continue block0;
            }
        }
        return javaFields.toArray(new JavaField[0]);
    }

    private int[] _getColumnLengths(IndexMetadata indexMetadata) {
        Entity entity = this._getEntityByTableName(indexMetadata.getTableName());
        if (entity == null) {
            return null;
        }
        String[] columnNames = indexMetadata.getColumnNames();
        int[] columnLengths = new int[columnNames.length];
        for (int i = 0; i < columnNames.length; ++i) {
            EntityColumn entityColumn = this._getEntityColumnByColumnDBName(entity, columnNames[i]);
            String colType = entityColumn.getType();
            if (!colType.equals("String")) continue;
            columnLengths[i] = this.getMaxLength(entity.getName(), entityColumn.getName());
        }
        return columnLengths;
    }

    private Properties _getCompatProperties(String version) throws IOException {
        Properties properties = new Properties();
        try (InputStream is = ServiceBuilder.class.getResourceAsStream("dependencies/" + version + "/compatibility.properties");){
            properties.load(is);
        }
        return properties;
    }

    private Map<String, Object> _getContext() throws TemplateModelException {
        HashMap<String, Object> context = HashMapBuilder.put("apiPackagePath", this._apiPackagePath).put("author", this._author).put("beanLocatorUtil", this._beanLocatorUtil).put("dependencyInjectorDS", (String)((Object)Boolean.valueOf(this._dependencyInjectorDS))).put("modelHintsUtil", (String)((Object)ModelHintsUtil.getModelHints())).put("osgiModule", (String)((Object)Boolean.valueOf(this._osgiModule))).put("packagePath", this._packagePath).put("pluginName", this._pluginName).put("portletShortName", this._portletShortName).put("propsUtil", this._propsUtil).put("serviceBuilder", (String)((Object)this)).put("stringUtil", (String)((Object)StringUtil_IW.getInstance())).put("textFormatter", (String)((Object)((BaseMapBuilder.UnsafeSupplier)() -> {
            BeansWrapper beansWrapper = BeansWrapper.getDefaultInstance();
            TemplateHashModel staticModels = beansWrapper.getStaticModels();
            return staticModels.get(TextFormatter.class.getName());
        }))).put("validator", Validator_IW.getInstance()).build();
        return context;
    }

    private void _getCreateMappingTableIndex(EntityMapping entityMapping, Map<String, List<IndexMetadata>> indexMetadatasMap) throws Exception {
        Entity[] entities = new Entity[3];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = this.getEntity(entityMapping.getEntityName(i));
            if (entities[i] != null) continue;
            return;
        }
        List<String> mappingPKEntityColumnDBNames = this._getEntityMappingPKEntityColumnDBNames(entityMapping);
        String tableName = entityMapping.getTableName();
        for (Entity entity : entities) {
            for (String dbName : entity.getPKEntityColumnDBNames()) {
                IndexMetadata indexMetadata = IndexMetadataFactoryUtil.createIndexMetadata(false, tableName, dbName);
                this._addIndexMetadata(indexMetadatasMap, tableName, mappingPKEntityColumnDBNames, indexMetadata);
            }
        }
    }

    private String _getCreateMappingTableSQL(EntityMapping entityMapping) throws Exception {
        Entity[] entities = new Entity[3];
        for (int i = 0; i < entities.length; ++i) {
            entities[i] = this.getEntity(entityMapping.getEntityName(i));
            if (entities[i] != null) continue;
            return null;
        }
        Arrays.sort(entities, new Comparator<Entity>(){

            @Override
            public int compare(Entity entity1, Entity entity2) {
                String name1 = entity1.getName();
                if (Objects.equals(entity1.getPackagePath(), "com.liferay.portal") && name1.equals("Company")) {
                    return -1;
                }
                String name2 = entity2.getName();
                if (Objects.equals(entity2.getPackagePath(), "com.liferay.portal") && name2.equals("Company")) {
                    return 1;
                }
                return name1.compareTo(name2);
            }
        });
        StringBundler sb = new StringBundler();
        sb.append(_SQL_CREATE_TABLE);
        String tableName = entityMapping.getTableName();
        if (this._databaseNameMaxLength > 0 && tableName.length() > this._databaseNameMaxLength) {
            throw new ServiceBuilderException(StringBundler.concat("Unable to create entity mapping \"", tableName, "\" because table name exceeds ", String.valueOf(this._databaseNameMaxLength), " characters. ", "Some databases do not allow table names longer than 30 ", "characters. To disable this warning set the ", "\"service-builder\" attribute ", "\"database-name-max-length\" to the max length that your ", "database supports."));
        }
        sb.append(tableName);
        sb.append(" (\n");
        for (Entity entity : entities) {
            List<EntityColumn> pkEntityColumns = entity.getPKEntityColumns();
            for (EntityColumn entityColumn : pkEntityColumns) {
                String dbName = entityColumn.getDBName();
                if (this._databaseNameMaxLength > 0 && dbName.length() > this._databaseNameMaxLength) {
                    throw new ServiceBuilderException(StringBundler.concat("Unable to create entity mapping \"", tableName, "\" because column name \"", dbName, "\" exceeds ", String.valueOf(this._databaseNameMaxLength), " characters. Some databases do not allow column ", "names longer than 30 characters. To disable this ", "warning set the \"service-builder\" attribute ", "\"database-name-max-length\" to the max length ", "that your database supports."));
                }
                String type = entityColumn.getType();
                sb.append("\t");
                sb.append(dbName);
                sb.append(" ");
                if (StringUtil.equalsIgnoreCase(type, "boolean")) {
                    sb.append("BOOLEAN");
                } else if (StringUtil.equalsIgnoreCase(type, "double") || StringUtil.equalsIgnoreCase(type, "float")) {
                    sb.append("DOUBLE");
                } else if (type.equals("int") || type.equals("Integer") || StringUtil.equalsIgnoreCase(type, "short")) {
                    sb.append("INTEGER");
                } else if (StringUtil.equalsIgnoreCase(type, "long")) {
                    sb.append("LONG");
                } else if (type.equals("Map")) {
                    sb.append("TEXT");
                } else if (type.equals("String")) {
                    int maxLength = this.getMaxLength(entity.getName(), entityColumn.getName());
                    if (entityColumn.isLocalized()) {
                        maxLength = 4000;
                    }
                    if (maxLength < 4000) {
                        sb.append("VARCHAR(");
                        sb.append(maxLength);
                        sb.append(")");
                    } else if (maxLength == 4000) {
                        sb.append("STRING");
                    } else if (maxLength > 4000) {
                        sb.append("TEXT");
                    }
                } else if (type.equals("Date")) {
                    sb.append("DATE");
                } else {
                    sb.append("invalid");
                }
                if (entityColumn.isPrimary()) {
                    sb.append(" not null");
                } else if (type.equals("Date") || type.equals("Map") || type.equals("String")) {
                    sb.append(" null");
                }
                sb.append(",\n");
            }
        }
        sb.append("\tprimary key (");
        for (int i = 1; i < entities.length; ++i) {
            Entity entity = entities[i];
            List<EntityColumn> pkEntityColumns = entity.getPKEntityColumns();
            for (int j = 0; j < pkEntityColumns.size(); ++j) {
                EntityColumn entityColumn = pkEntityColumns.get(j);
                if (i != 1 || j != 0) {
                    sb.append(", ");
                }
                sb.append(entityColumn.getDBName());
            }
        }
        sb.append(")\n");
        sb.append(");");
        return sb.toString();
    }

    private String _getCreateTableSQL(Entity entity) {
        List<EntityColumn> databaseRegularEntityColumns = entity.getDatabaseRegularEntityColumns();
        if (databaseRegularEntityColumns.isEmpty()) {
            return null;
        }
        StringBundler sb = new StringBundler();
        sb.append(_SQL_CREATE_TABLE);
        String tableName = entity.getTable();
        if (this._databaseNameMaxLength > 0 && tableName.length() > this._databaseNameMaxLength) {
            throw new ServiceBuilderException(StringBundler.concat("Unable to create entity \"", tableName, "\" because table name exceeds ", String.valueOf(this._databaseNameMaxLength), " characters. ", "Some databases do not allow table names longer than 30 ", "characters. To disable this warning set the ", "\"service-builder\" attribute ", "\"database-name-max-length\" to the max length that your ", "database supports."));
        }
        sb.append(tableName);
        sb.append(" (\n");
        for (int i = 0; i < databaseRegularEntityColumns.size(); ++i) {
            EntityColumn entityColumn = databaseRegularEntityColumns.get(i);
            String dbName = entityColumn.getDBName();
            if (this._databaseNameMaxLength > 0 && dbName.length() > this._databaseNameMaxLength) {
                throw new ServiceBuilderException(StringBundler.concat("Unable to create entity \"", tableName, "\" because column name \"", dbName, "\" exceeds ", String.valueOf(this._databaseNameMaxLength), " characters. ", "Some databases do not allow column names longer than ", "30 characters. To disable this warning set the ", "\"service-builder\" attribute ", "\"database-name-max-length\" to the max length that ", "your database supports"));
            }
            String type = entityColumn.getType();
            String idType = entityColumn.getIdType();
            sb.append("\t");
            sb.append(dbName);
            sb.append(" ");
            if (StringUtil.equalsIgnoreCase(type, "boolean")) {
                sb.append("BOOLEAN");
            } else if (StringUtil.equalsIgnoreCase(type, "double") || StringUtil.equalsIgnoreCase(type, "float")) {
                sb.append("DOUBLE");
            } else if (type.equals("int") || type.equals("Integer") || StringUtil.equalsIgnoreCase(type, "short")) {
                sb.append("INTEGER");
            } else if (StringUtil.equalsIgnoreCase(type, "long")) {
                sb.append("LONG");
            } else if (type.equals("BigDecimal")) {
                Map<String, String> hints = ModelHintsUtil.getHints(this._apiPackagePath + ".model." + entity.getName(), entityColumn.getName());
                String precision = "30";
                String scale = "16";
                if (hints != null) {
                    precision = hints.getOrDefault("precision", precision);
                    scale = hints.getOrDefault("scale", scale);
                }
                sb.append("DECIMAL(");
                sb.append(precision);
                sb.append(", ");
                sb.append(scale);
                sb.append(")");
            } else if (type.equals("Blob")) {
                sb.append("BLOB");
            } else if (type.equals("Date")) {
                sb.append("DATE");
            } else if (type.equals("Map")) {
                sb.append("TEXT");
            } else if (type.equals("String")) {
                int maxLength = this.getMaxLength(entity.getName(), entityColumn.getName());
                if (entityColumn.isLocalized() && maxLength < 4000) {
                    maxLength = 4000;
                }
                if (maxLength < 4000) {
                    sb.append("VARCHAR(");
                    sb.append(maxLength);
                    sb.append(")");
                } else if (maxLength == 4000) {
                    sb.append("STRING");
                } else if (maxLength > 4000) {
                    sb.append("TEXT");
                }
            } else {
                sb.append("invalid");
            }
            if (entityColumn.isPrimary()) {
                sb.append(" not null");
                if (!entity.hasCompoundPK() && !entity.isChangeTrackingEnabled()) {
                    sb.append(" primary key");
                }
            } else if (type.equals("BigDecimal") || type.equals("Date") || type.equals("Map") || type.equals("String")) {
                sb.append(" null");
            }
            if (Validator.isNotNull(idType) && idType.equals("identity")) {
                sb.append(" IDENTITY");
            }
            if (entity.isChangeTrackingEnabled() && Objects.equals(entityColumn.getName(), "ctCollectionId")) {
                sb.append(" default 0 not null");
            }
            if (Objects.equals(entityColumn.getName(), "mvccVersion")) {
                sb.append(" default 0 not null");
            }
            if (i + 1 != databaseRegularEntityColumns.size() || entity.hasCompoundPK() || entity.isChangeTrackingEnabled()) {
                sb.append(",");
            }
            sb.append("\n");
        }
        if (entity.hasCompoundPK() || entity.isChangeTrackingEnabled()) {
            sb.append("\tprimary key (");
            List<EntityColumn> pkEntityColumns = entity.getPKEntityColumns();
            for (int j = 0; j < pkEntityColumns.size(); ++j) {
                EntityColumn pk = pkEntityColumns.get(j);
                sb.append(pk.getDBName());
                if (j + 1 == pkEntityColumns.size()) continue;
                sb.append(", ");
            }
            if (entity.isChangeTrackingEnabled()) {
                sb.append(", ctCollectionId");
            }
            sb.append(")\n");
        }
        sb.append(");");
        return sb.toString();
    }

    private String _getDeleteUADEntityMethodName(JavaClass javaClass, String entityName) {
        ArrayList<String> methodNames = new ArrayList<String>();
        for (JavaMethod javaMethod : javaClass.getMethods(false)) {
            JavaType parameterType;
            List javaTypes;
            String javaMethodName = javaMethod.getName();
            if (!javaMethodName.startsWith("delete") || (javaTypes = javaMethod.getParameterTypes()).size() != 1 || !StringUtil.equals((parameterType = (JavaType)javaTypes.get(0)).getValue(), entityName)) continue;
            methodNames.add(javaMethodName);
        }
        String deleteEntityMethodName = "delete" + entityName;
        if (methodNames.isEmpty() || methodNames.contains(deleteEntityMethodName)) {
            return deleteEntityMethodName;
        }
        methodNames.sort(null);
        return (String)methodNames.get(0);
    }

    private Entity _getEntityByTableName(String tableName) {
        for (Entity entity : this._entities) {
            if (!tableName.equals(entity.getTable())) continue;
            return entity;
        }
        return null;
    }

    private EntityColumn _getEntityColumnByColumnDBName(Entity entity, String columnDBName) {
        EntityColumn entityColumn = this._fetchEntityColumnByColumnDBName(entity, columnDBName);
        if (entityColumn != null) {
            return entityColumn;
        }
        throw new IllegalArgumentException(StringBundler.concat("No entity column exist with column database name ", columnDBName, " for entity ", entity.getName()));
    }

    private List<String> _getEntityMappingPKEntityColumnDBNames(EntityMapping entityMapping) throws Exception {
        if (entityMapping == null) {
            return null;
        }
        ArrayList<String> mappingPKEntityColumnDBNames = new ArrayList<String>();
        for (int i = 0; i < 3; ++i) {
            Entity entity = this.getEntity(entityMapping.getEntityName(i));
            if (entity == null) {
                return null;
            }
            String entityName = entity.getName();
            if (entityName.equals("Company")) continue;
            mappingPKEntityColumnDBNames.addAll(entity.getPKEntityColumnDBNames());
        }
        return mappingPKEntityColumnDBNames;
    }

    private JavaClass _getJavaClass(String fileName) throws IOException {
        fileName = ServiceBuilder._normalize(fileName);
        int pos = 0;
        if (fileName.startsWith(this._implDirName)) {
            pos = this._implDirName.length() + 1;
        } else if (fileName.startsWith(this._apiDirName)) {
            pos = this._apiDirName.length() + 1;
        } else {
            return null;
        }
        String fullyQualifiedClassName = StringUtil.replace(fileName.substring(pos, fileName.length() - 5), '/', '.');
        JavaClass javaClass = this._javaClasses.get(fullyQualifiedClassName);
        if (javaClass == null) {
            File file = new File(fileName);
            if (!file.exists()) {
                return null;
            }
            SortedClassLibraryBuilder classLibraryBuilder = new SortedClassLibraryBuilder();
            Class<?> clazz = this.getClass();
            classLibraryBuilder.appendClassLoader(clazz.getClassLoader());
            JavaProjectBuilder builder = new JavaProjectBuilder((ClassLibraryBuilder)classLibraryBuilder);
            builder.addSource(file);
            javaClass = builder.getClassByName(fullyQualifiedClassName);
            this._javaClasses.put(fullyQualifiedClassName, javaClass);
        }
        return javaClass;
    }

    private String _getMethodKey(JavaMethod javaMethod) {
        StringBundler sb = new StringBundler();
        sb.append(this.getTypeGenericsName(javaMethod.getReturnType()));
        sb.append(" ");
        sb.append(javaMethod.getName());
        sb.append("(");
        List javaParameters = javaMethod.getParameters();
        for (JavaParameter javaParameter : javaParameters) {
            JavaType type = javaParameter.getType();
            sb.append(type.getGenericValue());
            sb.append(",");
        }
        if (!javaParameters.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    private List<JavaMethod> _getMethods(JavaClass javaClass) {
        return this._getMethods(javaClass, false);
    }

    private List<JavaMethod> _getMethods(JavaClass javaClass, boolean superclasses) {
        ArrayList<String> cacheFieldMethods = new ArrayList<String>();
        block0: for (JavaField javaField : javaClass.getFields()) {
            List javaAnnotations = javaField.getAnnotations();
            for (JavaAnnotation javaAnnotation : javaAnnotations) {
                JavaClass javaAnnotationClass = javaAnnotation.getType();
                String className = javaAnnotationClass.getFullyQualifiedName();
                if (!className.equals(CacheField.class.getName())) continue;
                if (GetterUtil.getBoolean(javaAnnotation.getNamedParameter("propagateToInterface"))) continue block0;
                String methodName = null;
                Object namedParameter = javaAnnotation.getNamedParameter("methodName");
                if (namedParameter != null) {
                    methodName = StringUtil.unquote(StringUtil.trim(namedParameter.toString()));
                }
                if (Validator.isNull(methodName)) {
                    methodName = TextFormatter.format(this.getVariableName(javaField), 6);
                }
                cacheFieldMethods.add("get".concat(methodName));
                cacheFieldMethods.add("set".concat(methodName));
                continue block0;
            }
        }
        ArrayList<JavaMethod> methods = new ArrayList<JavaMethod>();
        for (JavaMethod javaMethod : javaClass.getMethods(superclasses)) {
            if (cacheFieldMethods.contains(javaMethod.getName())) continue;
            methods.add(javaMethod);
        }
        return methods;
    }

    private String _getMethodSignature(JavaMethod method, boolean useFullyQualifiedNames) {
        StringBundler sb = new StringBundler();
        sb.append(method.getName());
        sb.append("(");
        for (JavaParameter parameter : method.getParameters()) {
            int pos;
            JavaType type = parameter.getType();
            String parameterValue = type.getFullyQualifiedName();
            if (!useFullyQualifiedNames && (pos = parameterValue.lastIndexOf(46)) != -1) {
                parameterValue = parameterValue.substring(pos + 1);
            }
            sb.append(parameterValue);
            sb.append(",");
        }
        if (sb.index() > 2) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    private String _getSessionTypeName(int sessionType) {
        if (sessionType == 1) {
            return "Local";
        }
        return "";
    }

    private String _getSpringNamespacesDeclarations() {
        StringBundler sb = new StringBundler(this._springNamespaces.length * 6);
        for (String namespace : this._springNamespaces) {
            sb.append("\txmlns");
            if (!_SPRING_NAMESPACE_BEANS.equals(namespace)) {
                sb.append(":");
                sb.append(namespace);
            }
            sb.append("=\"http://www.springframework.org/schema/");
            sb.append(namespace);
            sb.append("\"\n");
        }
        return sb.toString();
    }

    private String _getSpringSchemaLocations() {
        StringBundler sb = new StringBundler(this._springNamespaces.length * 7);
        for (String namespace : this._springNamespaces) {
            sb.append(" http://www.springframework.org/schema/");
            sb.append(namespace);
            sb.append(" http://www.springframework.org/schema/");
            sb.append(namespace);
            sb.append("/spring-");
            sb.append(namespace);
            sb.append(".xsd");
        }
        return sb.toString();
    }

    private String _getTplProperty(String key, String defaultValue) {
        return System.getProperty("service.tpl." + key, defaultValue);
    }

    private List<String> _getTransients(Entity entity, boolean parent) throws Exception {
        File modelFile = null;
        modelFile = parent ? new File(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "ModelImpl.java")) : new File(StringBundler.concat(this._outputPath, "/model/impl/", entity.getName(), "Impl.java"));
        String content = ServiceBuilder._read(modelFile);
        Matcher matcher = _getterPattern.matcher(content);
        HashSet<String> getters = new HashSet<String>();
        while (!matcher.hitEnd()) {
            String property;
            boolean found = matcher.find();
            if (!found || entity.hasEntityColumn(property = (property = matcher.group()).contains("get") ? property.substring(property.indexOf("get") + 3, property.length() - 1) : property.substring(property.indexOf("is") + 2, property.length() - 1)) || entity.hasEntityColumn(Introspector.decapitalize(property))) continue;
            property = Introspector.decapitalize(property);
            getters.add(property);
        }
        matcher = _setterPattern.matcher(content);
        HashSet<String> setters = new HashSet<String>();
        while (!matcher.hitEnd()) {
            boolean found = matcher.find();
            if (!found) continue;
            String property = matcher.group();
            if (entity.hasEntityColumn(property = property.substring(property.indexOf("set") + 3, property.length() - 1)) || entity.hasEntityColumn(Introspector.decapitalize(property))) continue;
            property = Introspector.decapitalize(property);
            setters.add(property);
        }
        getters.retainAll(setters);
        ArrayList<String> transients = new ArrayList<String>(getters);
        Collections.sort(transients);
        return transients;
    }

    private List<Path> _getUpdateSQLFilePaths() throws IOException {
        if (!this._osgiModule) {
            ArrayList<Path> updateSQLFilePaths = new ArrayList<Path>();
            try (DirectoryStream<Path> paths = Files.newDirectoryStream(Paths.get(this._sqlDirName, new String[0]), "update-7.0.0-7.0.1*.sql");){
                for (Path path : paths) {
                    updateSQLFilePaths.add(path);
                }
            }
            return updateSQLFilePaths;
        }
        final AtomicReference atomicReference = new AtomicReference();
        FileSystem fileSystem = FileSystems.getDefault();
        final PathMatcher pathMatcher = fileSystem.getPathMatcher("glob:**/dependencies/update.sql");
        Files.walkFileTree(Paths.get(this._resourcesDirName, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                if (!pathMatcher.matches(path)) {
                    return FileVisitResult.CONTINUE;
                }
                Path updateSQLFilePath = (Path)atomicReference.get();
                if (updateSQLFilePath == null) {
                    atomicReference.set(path);
                } else {
                    Version version;
                    Version updateSQLFileVersion = ServiceBuilder.this._getUpdateSQLFileVersion(updateSQLFilePath);
                    if (updateSQLFileVersion.compareTo(version = ServiceBuilder.this._getUpdateSQLFileVersion(path)) < 0) {
                        atomicReference.set(path);
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return Arrays.asList((Path)atomicReference.get());
    }

    private Version _getUpdateSQLFileVersion(Path path) {
        path = path.getName(path.getNameCount() - 3);
        String version = path.toString();
        version = StringUtil.replace(version, '_', '.');
        version = version.substring(1);
        return Version.getInstance(version);
    }

    private boolean _hasHttpMethods(JavaClass javaClass) {
        for (JavaMethod javaMethod : this._getMethods(javaClass)) {
            if (!javaMethod.isPublic() || !this.isCustomMethod(javaMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean _isCommercialPlugin(Path pluginPath) throws IOException {
        if (pluginPath == null) {
            return false;
        }
        Path absolutePath = pluginPath.toAbsolutePath();
        String absoluteFileName = ServiceBuilder._normalize((absolutePath = absolutePath.normalize()).toString());
        if (absoluteFileName.contains("/modules/dxp/apps/") || absoluteFileName.contains("/modules/private/apps/")) {
            return true;
        }
        for (File dir = absolutePath.toFile(); dir != null; dir = dir.getParentFile()) {
            File file = new File(dir, "gradle.properties");
            if (!file.exists()) continue;
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            if (!properties.containsKey("project.path.prefix")) continue;
            String s = properties.getProperty("project.path.prefix");
            return s.startsWith(":dxp:apps") || s.startsWith(":private:apps");
        }
        return false;
    }

    private boolean _isStringLocaleMap(JavaParameter javaParameter) {
        JavaType type = javaParameter.getType();
        if (!(type instanceof DefaultJavaParameterizedType)) {
            return false;
        }
        DefaultJavaParameterizedType defaultJavaParameterizedType = (DefaultJavaParameterizedType)type;
        List actualArgumentTypes = defaultJavaParameterizedType.getActualTypeArguments();
        if (actualArgumentTypes.size() != 2) {
            return false;
        }
        return this._isTypeValue((JavaType)actualArgumentTypes.get(0), Locale.class.getName()) && this._isTypeValue((JavaType)actualArgumentTypes.get(1), String.class.getName());
    }

    private boolean _isTargetEntity(Entity entity) {
        if (this._targetEntityName == null || this._targetEntityName.startsWith("$")) {
            return true;
        }
        return this._targetEntityName.equals(entity.getName());
    }

    private boolean _isTypeValue(JavaType type, String value) {
        return value.equals(type.getFullyQualifiedName());
    }

    private List<JavaAnnotation> _mergeAnnotations(List<JavaAnnotation> javaAnnotations1, List<JavaAnnotation> javaAnnotations2) {
        HashMap<JavaClass, JavaAnnotation> javaAnnotationsMap = new HashMap<JavaClass, JavaAnnotation>();
        for (JavaAnnotation javaAnnotation : javaAnnotations2) {
            javaAnnotationsMap.put(javaAnnotation.getType(), javaAnnotation);
        }
        for (JavaAnnotation javaAnnotation : javaAnnotations1) {
            javaAnnotationsMap.put(javaAnnotation.getType(), javaAnnotation);
        }
        ArrayList<JavaAnnotation> javaAnnotations = new ArrayList<JavaAnnotation>(javaAnnotationsMap.values());
        Comparator<JavaAnnotation> comparator = new Comparator<JavaAnnotation>(){

            @Override
            public int compare(JavaAnnotation javaAnnotation1, JavaAnnotation javaAnnotation2) {
                String javaAnnotationString1 = javaAnnotation1.toString();
                String javaAnnotationString2 = javaAnnotation2.toString();
                return javaAnnotationString1.compareTo(javaAnnotationString2);
            }
        };
        Collections.sort(javaAnnotations, comparator);
        return javaAnnotations;
    }

    private List<JavaMethod> _mergeMethods(List<JavaMethod> javaMethods1, List<JavaMethod> javaMethods2, boolean mergeAnnotations) {
        HashMap<String, Object> javaMethodMap = new HashMap<String, Object>();
        for (JavaMethod javaMethod : javaMethods2) {
            javaMethodMap.put(this._getMethodKey(javaMethod), javaMethod);
        }
        for (JavaMethod javaMethod : javaMethods1) {
            String javaMethodKey = this._getMethodKey(javaMethod);
            JavaMethod existingJavaMethod = (JavaMethod)javaMethodMap.get(javaMethodKey);
            if (existingJavaMethod == null) {
                javaMethodMap.put(javaMethodKey, javaMethod);
                continue;
            }
            if (!mergeAnnotations || !(existingJavaMethod instanceof DefaultJavaMethod)) continue;
            DefaultJavaMethod newJavaMethod = (DefaultJavaMethod)existingJavaMethod;
            List<JavaAnnotation> javaAnnotations = this._mergeAnnotations(javaMethod.getAnnotations(), existingJavaMethod.getAnnotations());
            newJavaMethod.setAnnotations(javaAnnotations);
            javaMethodMap.put(javaMethodKey, newJavaMethod);
        }
        ArrayList<JavaMethod> javaMethods = new ArrayList<JavaMethod>(javaMethodMap.values());
        Comparator<JavaMethod> comparator = new Comparator<JavaMethod>(){

            @Override
            public int compare(JavaMethod javaMethod1, JavaMethod javaMethod2) {
                String methodSignature2;
                String methodSignature1 = ServiceBuilder.this._getMethodSignature(javaMethod1, false);
                if (methodSignature1.equals(methodSignature2 = ServiceBuilder.this._getMethodSignature(javaMethod2, false))) {
                    methodSignature1 = ServiceBuilder.this._getMethodSignature(javaMethod1, true);
                    methodSignature2 = ServiceBuilder.this._getMethodSignature(javaMethod2, true);
                }
                return methodSignature1.compareToIgnoreCase(methodSignature2);
            }
        };
        Collections.sort(javaMethods, comparator);
        return javaMethods;
    }

    private List<Entity> _mergeReferenceEntities(Entity entity) {
        List<Entity> referenceEntities = entity.getReferenceEntities();
        LinkedHashSet<Entity> set = new LinkedHashSet<Entity>();
        if (this._autoImportDefaultReferences) {
            set.addAll(this._entities);
        } else {
            set.add(entity);
        }
        set.addAll(referenceEntities);
        return new ArrayList<Entity>(set);
    }

    private Entity _parseEntity(Element entityElement) throws Exception {
        String alias;
        Element finderElement;
        EntityColumn entityColumn;
        Element localizedEntityElement;
        Element columnElement;
        String entityName = entityElement.attributeValue("name");
        String humanName = entityElement.attributeValue("human-name");
        String tableName = entityElement.attributeValue("table");
        if (Validator.isNull(tableName)) {
            tableName = entityName;
            if (this._badTableNames.contains(entityName)) {
                tableName = tableName + "_";
            }
            if (this._autoNamespaceTables) {
                tableName = this._portletShortName + "_" + entityName;
            }
        }
        boolean uuid = GetterUtil.getBoolean(entityElement.attributeValue("uuid"));
        boolean uuidAccessor = GetterUtil.getBoolean(entityElement.attributeValue("uuid-accessor"));
        boolean externalReferenceCode = GetterUtil.getBoolean(entityElement.attributeValue("external-reference-code"));
        boolean localService = GetterUtil.getBoolean(entityElement.attributeValue("local-service"));
        boolean remoteService = GetterUtil.getBoolean(entityElement.attributeValue("remote-service"), true);
        boolean persistence = GetterUtil.getBoolean(entityElement.attributeValue("persistence"), true);
        String persistenceClassName = GetterUtil.getString(entityElement.attributeValue("persistence-class"), StringBundler.concat(this._packagePath, ".service.persistence.impl.", entityName, "PersistenceImpl"));
        String finderClassName = "";
        File originalFinderImplFile = new File(StringBundler.concat(this._outputPath, "/service/persistence/", entityName, "FinderImpl.java"));
        File newFinderImplFile = new File(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entityName, "FinderImpl.java"));
        if (originalFinderImplFile.exists()) {
            ServiceBuilder._move(originalFinderImplFile, newFinderImplFile);
            String content = ServiceBuilder._read(newFinderImplFile);
            StringBundler sb = new StringBundler(13);
            sb.append("package ");
            sb.append(this._packagePath);
            sb.append(".service.persistence.impl;\n\n");
            sb.append("import ");
            sb.append(this._apiPackagePath);
            sb.append(".service.persistence.");
            sb.append(entityName);
            sb.append("Finder;\n");
            sb.append("import ");
            sb.append(this._apiPackagePath);
            sb.append(".service.persistence.");
            sb.append(entityName);
            sb.append("Util;");
            content = StringUtil.replace(content, "package " + this._packagePath + ".service.persistence;", sb.toString());
            ToolsUtil.writeFileRaw(newFinderImplFile, content, this._modifiedFileNames);
        }
        if (newFinderImplFile.exists()) {
            finderClassName = StringBundler.concat(this._packagePath, ".service.persistence.impl.", entityName, "FinderImpl");
        }
        String dataSource = entityElement.attributeValue("data-source");
        String sessionFactory = entityElement.attributeValue("session-factory");
        String txManager = entityElement.attributeValue("tx-manager");
        boolean cacheEnabled = GetterUtil.getBoolean(entityElement.attributeValue("cache-enabled"), true);
        boolean changeTrackingEnabled = GetterUtil.getBoolean(entityElement.attributeValue("change-tracking-enabled"), this._changeTrackingEnabled);
        boolean mvccEnabled = GetterUtil.getBoolean(entityElement.attributeValue("mvcc-enabled"), this._mvccEnabled);
        boolean dynamicUpdateEnabled = GetterUtil.getBoolean(entityElement.attributeValue("dynamic-update-enabled"), mvccEnabled);
        boolean jsonEnabled = GetterUtil.getBoolean(entityElement.attributeValue("json-enabled"), remoteService);
        boolean trashEnabled = GetterUtil.getBoolean(entityElement.attributeValue("trash-enabled"));
        String uadApplicationName = GetterUtil.getString(entityElement.attributeValue("uad-application-name"), this._portletShortName);
        uadApplicationName = TextFormatter.format(uadApplicationName, 3);
        boolean uadAutoDelete = GetterUtil.getBoolean(entityElement.attributeValue("uad-auto-delete"));
        String uadDirPath = GetterUtil.getString(entityElement.attributeValue("uad-dir-path"), this._uadDirName);
        String uadPackagePath = GetterUtil.getString(entityElement.attributeValue("uad-package-path"), this._packagePath);
        String uadOutputPath = uadDirPath + "/" + StringUtil.replace(uadPackagePath, '.', '/');
        boolean versioned = GetterUtil.getBoolean(entityElement.attributeValue("versioned"));
        if (versioned) {
            mvccEnabled = GetterUtil.getBoolean(entityElement.attributeValue("mvcc-enabled"), true);
            if (!mvccEnabled) {
                throw new IllegalArgumentException("Cannot use versioned entity with mvccEnabled disabled for " + entityName);
            }
            if (!persistence) {
                throw new IllegalArgumentException("Cannot use versioned entity with persistence disabled for " + entityName);
            }
        }
        boolean deprecated = GetterUtil.getBoolean(entityElement.attributeValue("deprecated"));
        ArrayList<EntityColumn> pkEntityColumns = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> regularEntityColumns = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> blobEntityColumns = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> collectionEntityColumns = new ArrayList<EntityColumn>();
        ArrayList<EntityColumn> entityColumns = new ArrayList<EntityColumn>();
        boolean permissionedModel = false;
        boolean resourcedModel = false;
        List columnElements = entityElement.elements("column");
        ArrayList<Object> derivedColumnElements = new ArrayList<Object>();
        if (mvccEnabled && !columnElements.isEmpty()) {
            columnElement = DocumentHelper.createElement((String)"column");
            columnElement.addAttribute("change-tracking-resolution-type", "CONTROL");
            columnElement.addAttribute("name", "mvccVersion");
            columnElement.addAttribute("type", "long");
            derivedColumnElements.add(columnElement);
        }
        if (changeTrackingEnabled) {
            columnElement = DocumentHelper.createElement((String)"column");
            columnElement.addAttribute("change-tracking-resolution-type", "CONTROL");
            columnElement.addAttribute("name", "ctCollectionId");
            columnElement.addAttribute("type", "long");
            derivedColumnElements.add(columnElement);
        }
        if (uuid) {
            columnElement = DocumentHelper.createElement((String)"column");
            columnElement.addAttribute("name", "uuid");
            columnElement.addAttribute("type", "String");
            derivedColumnElements.add(columnElement);
        }
        if (externalReferenceCode) {
            columnElement = DocumentHelper.createElement((String)"column");
            columnElement.addAttribute("name", "externalReferenceCode");
            columnElement.addAttribute("type", "String");
            derivedColumnElements.add(columnElement);
        }
        if (versioned) {
            columnElement = DocumentHelper.createElement((String)"column");
            columnElement.addAttribute("name", "headId");
            columnElement.addAttribute("type", "long");
            derivedColumnElements.add(columnElement);
        }
        if ((localizedEntityElement = entityElement.element("localized-entity")) != null) {
            Element columnElement2 = DocumentHelper.createElement((String)"column");
            columnElement2.addAttribute("name", "defaultLanguageId");
            columnElement2.addAttribute("type", "String");
            derivedColumnElements.add(columnElement2);
            if (!persistence) {
                throw new IllegalArgumentException("Cannot use localized-entity with persistence disabled for " + entityName);
            }
        }
        columnElements.addAll(0, derivedColumnElements);
        for (Element columnElement3 : columnElements) {
            String columnName = columnElement3.attributeValue("name");
            String columnDBName = columnElement3.attributeValue("db-name");
            if (Validator.isNull(columnDBName)) {
                columnDBName = columnName;
                if (this._badColumnNames.contains(columnName)) {
                    columnDBName = columnDBName + "_";
                }
            }
            String columnType = columnElement3.attributeValue("type");
            boolean primary = GetterUtil.getBoolean(columnElement3.attributeValue("primary"));
            boolean accessor = GetterUtil.getBoolean(columnElement3.attributeValue("accessor"));
            boolean filterPrimary = GetterUtil.getBoolean(columnElement3.attributeValue("filter-primary"));
            String columnEntityName = columnElement3.attributeValue("entity");
            String mappingTableName = columnElement3.attributeValue("mapping-table");
            if (Validator.isNotNull(mappingTableName)) {
                if (!persistence) {
                    throw new IllegalArgumentException("Cannot have mapping-table without persistence for entity " + entityName);
                }
                if (this._badTableNames.contains(mappingTableName)) {
                    mappingTableName = mappingTableName + "_";
                }
                if (this._autoNamespaceTables) {
                    mappingTableName = this._portletShortName + "_" + mappingTableName;
                }
            }
            String idType = columnElement3.attributeValue("id-type");
            String idParam = columnElement3.attributeValue("id-param");
            boolean convertNull = GetterUtil.getBoolean(columnElement3.attributeValue("convert-null"), true);
            boolean lazy = GetterUtil.getBoolean(columnElement3.attributeValue("lazy"), true);
            boolean localized = GetterUtil.getBoolean(columnElement3.attributeValue("localized"));
            boolean colJsonEnabled = GetterUtil.getBoolean(columnElement3.attributeValue("json-enabled"), jsonEnabled);
            String changeTrackingResolutionType = "STRICT";
            if (primary) {
                changeTrackingResolutionType = "PK";
            } else if (columnName.equals("modifiedDate") && columnType.equals("Date")) {
                changeTrackingResolutionType = "IGNORE";
            }
            changeTrackingResolutionType = StringUtil.toUpperCase(GetterUtil.getString(columnElement3.attributeValue("change-tracking-resolution-type"), changeTrackingResolutionType));
            CTColumnResolutionType ctColumnResolutionType = CTColumnResolutionType.valueOf(changeTrackingResolutionType);
            boolean containerModel = GetterUtil.getBoolean(columnElement3.attributeValue("container-model"));
            boolean parentContainerModel = GetterUtil.getBoolean(columnElement3.attributeValue("parent-container-model"));
            String uadAnonymizeFieldName = GetterUtil.getString(columnElement3.attributeValue("uad-anonymize-field-name"));
            boolean uadNonanonymizable = GetterUtil.getBoolean(columnElement3.attributeValue("uad-nonanonymizable"));
            if (columnName.equals("resourceBlockId") && !entityName.equals("ResourceBlock")) {
                permissionedModel = true;
            }
            if (columnName.equals("resourcePrimKey") && !primary) {
                resourcedModel = true;
            }
            entityColumn = new EntityColumn(columnName, columnDBName, columnType, primary, accessor, filterPrimary, columnEntityName, mappingTableName, idType, idParam, convertNull, lazy, localized, colJsonEnabled, ctColumnResolutionType, containerModel, parentContainerModel, uadAnonymizeFieldName, uadNonanonymizable);
            if (primary) {
                if (!(columnType.equals("int") || columnType.equals("long") || columnType.equals("String"))) {
                    throw new IllegalArgumentException(StringBundler.concat("Primary key ", columnName, " of entity ", entityName, " must be an int, long, or String"));
                }
                pkEntityColumns.add(entityColumn);
            }
            if (columnType.equals("Collection")) {
                collectionEntityColumns.add(entityColumn);
            } else {
                regularEntityColumns.add(entityColumn);
                if (columnType.equals("Blob")) {
                    blobEntityColumns.add(entityColumn);
                }
            }
            entityColumns.add(entityColumn);
            if (!Validator.isNotNull(columnEntityName) || !Validator.isNotNull(mappingTableName)) continue;
            EntityMapping entityMapping = new EntityMapping(mappingTableName, entityName, columnEntityName);
            if (this._entityMappings.containsKey(mappingTableName)) continue;
            this._entityMappings.put(mappingTableName, entityMapping);
        }
        if (uuid && pkEntityColumns.isEmpty()) {
            throw new ServiceBuilderException("Unable to create entity \"" + entityName + "\" with a UUID without a primary key");
        }
        EntityOrder entityOrder = null;
        Element orderElement = entityElement.element("order");
        if (orderElement != null) {
            boolean asc = true;
            if (orderElement.attribute("by") != null && Objects.equals(orderElement.attributeValue("by"), "desc")) {
                asc = false;
            }
            ArrayList<EntityColumn> orderEntityColumns = new ArrayList<EntityColumn>();
            entityOrder = new EntityOrder(asc, orderEntityColumns);
            List orderColumnElements = orderElement.elements("order-column");
            for (Element orderColumnElement : orderColumnElements) {
                String orderColName = orderColumnElement.attributeValue("name");
                boolean orderColCaseSensitive = GetterUtil.getBoolean(orderColumnElement.attributeValue("case-sensitive"), true);
                boolean orderColByAscending = asc;
                String orderColBy = GetterUtil.getString(orderColumnElement.attributeValue("order-by"));
                if (orderColBy.equals("asc")) {
                    orderColByAscending = true;
                } else if (orderColBy.equals("desc")) {
                    orderColByAscending = false;
                }
                int index = entityColumns.indexOf(new EntityColumn(orderColName));
                if (index < 0) {
                    throw new IllegalArgumentException("Invalid order by column " + orderColName);
                }
                EntityColumn entityColumn2 = (EntityColumn)entityColumns.get(index);
                entityColumn2.setOrderColumn(true);
                entityColumn2 = (EntityColumn)entityColumn2.clone();
                entityColumn2.setCaseSensitive(orderColCaseSensitive);
                entityColumn2.setOrderByAscending(orderColByAscending);
                orderEntityColumns.add(entityColumn2);
            }
        }
        ArrayList<EntityFinder> entityFinders = new ArrayList<EntityFinder>();
        List finderElements = entityElement.elements("finder");
        if (uuid) {
            if (entityColumns.contains(new EntityColumn("companyId"))) {
                finderElement = DocumentHelper.createElement((String)"finder");
                finderElement.addAttribute("name", "Uuid_C");
                finderElement.addAttribute("return-type", "Collection");
                Element finderColumnElement = finderElement.addElement("finder-column");
                finderColumnElement.addAttribute("name", "uuid");
                finderColumnElement = finderElement.addElement("finder-column");
                finderColumnElement.addAttribute("name", "companyId");
                finderElements.add(0, finderElement);
            }
            if (entityColumns.contains(new EntityColumn("groupId"))) {
                finderElement = DocumentHelper.createElement((String)"finder");
                if (entityName.equals("Layout")) {
                    finderElement.addAttribute("name", "UUID_G_P");
                } else {
                    finderElement.addAttribute("name", "UUID_G");
                }
                finderElement.addAttribute("return-type", entityName);
                finderElement.addAttribute("unique", "true");
                Element finderColumnElement = finderElement.addElement("finder-column");
                finderColumnElement.addAttribute("name", "uuid");
                finderColumnElement = finderElement.addElement("finder-column");
                finderColumnElement.addAttribute("name", "groupId");
                if (entityName.equals("Layout")) {
                    finderColumnElement = finderElement.addElement("finder-column");
                    finderColumnElement.addAttribute("name", "privateLayout");
                }
                finderElements.add(0, finderElement);
            }
            finderElement = DocumentHelper.createElement((String)"finder");
            finderElement.addAttribute("name", "Uuid");
            finderElement.addAttribute("return-type", "Collection");
            Element finderColumnElement = finderElement.addElement("finder-column");
            finderColumnElement.addAttribute("name", "uuid");
            finderElements.add(0, finderElement);
        }
        if (externalReferenceCode && entityColumns.contains(new EntityColumn("companyId"))) {
            finderElement = DocumentHelper.createElement((String)"finder");
            finderElement.addAttribute("name", "C_ERC");
            finderElement.addAttribute("return-type", entityName);
            Element finderColumnElement = finderElement.addElement("finder-column");
            finderColumnElement.addAttribute("name", "companyId");
            finderColumnElement = finderElement.addElement("finder-column");
            finderColumnElement.addAttribute("name", "externalReferenceCode");
            finderElements.add(finderElement);
        }
        if (permissionedModel) {
            finderElement = DocumentHelper.createElement((String)"finder");
            finderElement.addAttribute("name", "ResourceBlockId");
            finderElement.addAttribute("return-type", "Collection");
            Element finderColumnElement = finderElement.addElement("finder-column");
            finderColumnElement.addAttribute("name", "resourceBlockId");
            finderElements.add(0, finderElement);
        }
        if (resourcedModel) {
            finderElement = DocumentHelper.createElement((String)"finder");
            finderElement.addAttribute("name", "ResourcePrimKey");
            finderElement.addAttribute("return-type", "Collection");
            Element finderColumnElement = finderElement.addElement("finder-column");
            finderColumnElement.addAttribute("name", "resourcePrimKey");
            finderElements.add(0, finderElement);
        }
        if (versioned) {
            finderElement = DocumentHelper.createElement((String)"finder");
            finderElement.addAttribute("name", "HeadId");
            finderElement.addAttribute("return-type", entityName);
            finderElement.addAttribute("unique", "true");
            Element finderColumnElement = finderElement.addElement("finder-column");
            finderColumnElement.addAttribute("name", "headId");
            finderElements.add(finderElement);
        }
        if (this._badAliasNames.contains(StringUtil.toLowerCase(alias = TextFormatter.format(entityName, 8)))) {
            alias = alias + "_";
        }
        for (Element finderElement2 : finderElements) {
            String finderWhere;
            String finderName = finderElement2.attributeValue("name");
            String finderReturn = finderElement2.attributeValue("return-type");
            boolean finderUnique = GetterUtil.getBoolean(finderElement2.attributeValue("unique"));
            String finderDBWhere = finderWhere = finderElement2.attributeValue("where");
            if (Validator.isNotNull(finderWhere)) {
                for (EntityColumn column : entityColumns) {
                    String name = column.getName();
                    finderWhere = StringUtil.replace(finderWhere, name, alias + "." + name);
                    finderDBWhere = StringUtil.replace(finderDBWhere, name, alias + "." + column.getDBName());
                }
            }
            boolean finderDBIndex = GetterUtil.getBoolean(finderElement2.attributeValue("db-index"), true);
            ArrayList<EntityColumn> finderEntityColumns = new ArrayList<EntityColumn>();
            List finderColumnElements = finderElement2.elements("finder-column");
            for (Element finderColumnElement : finderColumnElements) {
                String finderColumnName = finderColumnElement.attributeValue("name");
                boolean finderColCaseSensitive = GetterUtil.getBoolean(finderColumnElement.attributeValue("case-sensitive"), true);
                String finderColComparator = GetterUtil.getString(finderColumnElement.attributeValue("comparator"), "=");
                String finderColArrayableOperator = GetterUtil.getString(finderColumnElement.attributeValue("arrayable-operator"));
                boolean finderColArrayablePagination = GetterUtil.getBoolean(finderColumnElement.attributeValue("arrayable-pagination"));
                entityColumn = Entity.getEntityColumn(finderColumnName, entityColumns);
                if (!entityColumn.isFinderPath()) {
                    entityColumn.setFinderPath(true);
                }
                entityColumn = (EntityColumn)entityColumn.clone();
                entityColumn.setCaseSensitive(finderColCaseSensitive);
                entityColumn.setComparator(finderColComparator);
                entityColumn.setArrayableOperator(finderColArrayableOperator);
                entityColumn.setArrayablePagination(finderColArrayablePagination);
                entityColumn.validate();
                finderEntityColumns.add(entityColumn);
            }
            entityFinders.add(new EntityFinder(finderName, finderReturn, finderUnique, finderWhere, finderDBWhere, finderDBIndex, finderEntityColumns));
        }
        ArrayList<Entity> referenceEntities = new ArrayList<Entity>();
        ArrayList<String> unresolvedReferenceEntityNames = new ArrayList<String>();
        if (this._build) {
            TreeSet<String> referenceEntityNames = new TreeSet<String>();
            List referenceElements = entityElement.elements("reference");
            for (Element referenceElement : referenceElements) {
                String referencePackagePath = referenceElement.attributeValue("package-path");
                String referenceEntityName = referenceElement.attributeValue("entity");
                referenceEntityNames.add(referencePackagePath + "." + referenceEntityName);
            }
            if (!this._packagePath.equals("com.liferay.counter")) {
                referenceEntityNames.add("com.liferay.counter.Counter");
            }
            if (this._autoImportDefaultReferences) {
                referenceEntityNames.add("com.liferay.portal.ClassName");
                referenceEntityNames.add("com.liferay.portal.Resource");
                referenceEntityNames.add("com.liferay.portal.User");
            }
            for (String referenceEntityName : referenceEntityNames) {
                try {
                    String apiPackagePath;
                    Entity entity = this.getEntity(referenceEntityName);
                    if (this._dtdVersion.isPreviousVersionThan("7.1.0") && (apiPackagePath = entity.getApiPackagePath()).equals("com.liferay.message.boards")) {
                        entity.setApiPackagePath(apiPackagePath + ".kernel");
                    }
                    referenceEntities.add(entity);
                }
                catch (RuntimeException re) {
                    unresolvedReferenceEntityNames.add(referenceEntityName);
                }
            }
        }
        ArrayList<String> txRequiredMethodNames = new ArrayList<String>();
        List txRequiredElements = entityElement.elements("tx-required");
        if (!txRequiredElements.isEmpty()) {
            System.err.println("The tx-required attribute is deprecated in favor annotating the service impl method with com.liferay.portal.kernel.transaction.Transactional");
            for (Element txRequiredElement : txRequiredElements) {
                String txRequired = txRequiredElement.getText();
                txRequiredMethodNames.add(txRequired);
            }
        }
        boolean resourceActionModel = this._resourceActionModels.contains(this._apiPackagePath + ".model." + entityName);
        Entity entity = new Entity(this, this._packagePath, this._apiPackagePath, this._portletShortName, entityName, humanName, tableName, alias, uuid, uuidAccessor, externalReferenceCode, localService, remoteService, persistence, persistenceClassName, finderClassName, dataSource, sessionFactory, txManager, cacheEnabled, changeTrackingEnabled, dynamicUpdateEnabled, jsonEnabled, mvccEnabled, trashEnabled, uadApplicationName, uadAutoDelete, uadOutputPath, uadPackagePath, deprecated, pkEntityColumns, regularEntityColumns, blobEntityColumns, collectionEntityColumns, entityColumns, entityOrder, entityFinders, referenceEntities, unresolvedReferenceEntityNames, txRequiredMethodNames, resourceActionModel);
        if (changeTrackingEnabled) {
            if (!mvccEnabled) {
                throw new ServiceBuilderException("MVCC must be enabled to use change tracking for " + entityName);
            }
            if (entity.isHierarchicalTree()) {
                throw new ServiceBuilderException("Change tracking with hierarchical tree is not supported for " + entityName);
            }
            if (pkEntityColumns.size() > 1) {
                throw new ServiceBuilderException("Compound primary key with change tracked columns is not supported for " + entityName);
            }
            EntityColumn pkEntityColumn = (EntityColumn)pkEntityColumns.get(0);
            if (!Objects.equals("long", pkEntityColumn.getType())) {
                throw new ServiceBuilderException("Primary key must be of type long to enable change tracking for " + entityName);
            }
            if (pkEntityColumn.getCTColumnResolutionType() != CTColumnResolutionType.PK) {
                throw new ServiceBuilderException(StringBundler.concat("Illegal change-tracking-resolution-type ", String.valueOf((Object)pkEntityColumn.getCTColumnResolutionType()), " for entity ", entityName, " on column ", pkEntityColumn.getName()));
            }
            for (EntityFinder entityFinder : entityFinders) {
                for (EntityColumn entityColumn3 : entityFinder.getEntityColumns()) {
                    if (!entityColumn3.isChangeTrackingMerge()) continue;
                    throw new ServiceBuilderException(StringBundler.concat("Illegal change-tracking-resolution-type ", String.valueOf((Object)entityColumn3.getCTColumnResolutionType()), " for entity ", entityName, " on column ", pkEntityColumn.getName()));
                }
            }
        }
        this._entities.add(entity);
        if (entity.isUADEnabled()) {
            if (!this._uadApplicationEntities.containsKey(uadApplicationName)) {
                this._uadApplicationEntities.put(uadApplicationName, ListUtil.fromArray(entity));
            } else {
                List<Entity> uadApplicationEntities = this._uadApplicationEntities.get(uadApplicationName);
                uadApplicationEntities.add(entity);
            }
        }
        if (versioned) {
            this._parseVersionEntity(entity, columnElements);
        }
        if (localizedEntityElement != null) {
            this._parseLocalizedEntity(entity, localizedEntityElement);
            if (versioned) {
                Entity localizedEntity = entity.getLocalizedEntity();
                entity.addReferenceEntity(localizedEntity.getVersionEntity());
            }
        }
        if (versioned) {
            EntityColumn headEntityColumn = new EntityColumn("head", "head", "boolean", false, false, false, null, null, null, null, true, false, false, false, CTColumnResolutionType.STRICT, false, false, null, false);
            headEntityColumn.setComparator("=");
            headEntityColumn.setFinderPath(true);
            headEntityColumn.setInterfaceColumn(false);
            List<EntityColumn> databaseRegularEntityColumns = entity.getDatabaseRegularEntityColumns();
            int index = databaseRegularEntityColumns.indexOf(new EntityColumn("headId"));
            databaseRegularEntityColumns.add(index + 1, headEntityColumn);
            List<EntityColumn> entityFinderColumns = entity.getFinderEntityColumns();
            entityFinderColumns.add(headEntityColumn);
            Collections.sort(entityFinderColumns);
            String localizedPKEntityColumn = entityElement.attributeValue("localized-pk-entity-column");
            ListIterator<EntityFinder> listIterator = entityFinders.listIterator();
            while (listIterator.hasNext()) {
                EntityFinder entityFinder = (EntityFinder)listIterator.next();
                String finderName = entityFinder.getName();
                if (finderName.equals("HeadId") || localizedPKEntityColumn != null && entityFinder.hasEntityColumn(localizedPKEntityColumn)) continue;
                listIterator.set(new EntityFinder(entityFinder.getName(), "Collection", false, entityFinder.getWhere(), entityFinder.getDBWhere(), entityFinder.isDBIndex(), new ArrayList<EntityColumn>(entityFinder.getEntityColumns())));
                List<EntityColumn> finderEntityColumns = entityFinder.getEntityColumns();
                finderEntityColumns.add(headEntityColumn);
                listIterator.add(new EntityFinder(entityFinder.getName() + "_Head", entityFinder.getReturnType(), entityFinder.isUnique(), entityFinder.getWhere(), entityFinder.getDBWhere(), entityFinder.isDBIndex(), finderEntityColumns));
            }
        }
        return entity;
    }

    private void _parseLocalizedEntity(Entity entity, Element localizedEntityElement) throws Exception {
        Object newColumnElement;
        List<EntityColumn> pkEntityColumns;
        String localizedEntityTableName;
        if (!entity.hasLocalService()) {
            throw new IllegalArgumentException(entity.getName() + " must have a local service to use localized entity");
        }
        for (EntityColumn entityColumn : entity.getEntityColumns()) {
            if (!entityColumn.isLocalized()) continue;
            throw new IllegalArgumentException(StringBundler.concat("Unable to use localized entity with localized column ", entityColumn.getName(), " in ", entity.getName()));
        }
        Element newLocalizedEntityElement = DocumentHelper.createElement((String)"entity");
        if (Validator.isNotNull(entity.getDataSource())) {
            newLocalizedEntityElement.addAttribute("data-source", entity.getDataSource());
        }
        if (entity.isDeprecated()) {
            newLocalizedEntityElement.addAttribute("deprecated", "true");
        }
        newLocalizedEntityElement.addAttribute("local-service", "false");
        newLocalizedEntityElement.addAttribute("mvcc-enabled", "true");
        String localizedEntityName = GetterUtil.getString(localizedEntityElement.attributeValue("name"), entity.getName() + "Localization");
        newLocalizedEntityElement.addAttribute("name", localizedEntityName);
        newLocalizedEntityElement.addAttribute("remote-service", "false");
        if (Validator.isNotNull(entity.getSessionFactory())) {
            newLocalizedEntityElement.addAttribute("session-factory", entity.getSessionFactory());
        }
        if (Validator.isNotNull(localizedEntityTableName = localizedEntityElement.attributeValue("table"))) {
            newLocalizedEntityElement.addAttribute("table", localizedEntityTableName);
        }
        if (Validator.isNotNull(entity.getTXManager())) {
            newLocalizedEntityElement.addAttribute("tx-manager", entity.getTXManager());
        }
        if (entity.getVersionEntity() != null) {
            newLocalizedEntityElement.addAttribute("versioned", "true");
        }
        newLocalizedEntityElement.addAttribute("uuid", "false");
        Element newLocalizedColumnElement = newLocalizedEntityElement.addElement("column");
        newLocalizedColumnElement.addAttribute("name", TextFormatter.format(localizedEntityName + "Id", 8));
        newLocalizedColumnElement.addAttribute("primary", "true");
        newLocalizedColumnElement.addAttribute("type", "long");
        if (entity.hasEntityColumn("companyId")) {
            newLocalizedColumnElement = newLocalizedEntityElement.addElement("column");
            newLocalizedColumnElement.addAttribute("name", "companyId");
            newLocalizedColumnElement.addAttribute("type", "long");
        }
        if ((pkEntityColumns = entity.getPKEntityColumns()).size() > 1) {
            throw new IllegalArgumentException("Unable to use localized entity with compound primary key");
        }
        EntityColumn pkEntityColumn = pkEntityColumns.get(0);
        if (entity.getVersionEntity() != null) {
            newLocalizedEntityElement.addAttribute("localized-pk-entity-column", pkEntityColumn.getName());
        }
        newLocalizedColumnElement = newLocalizedEntityElement.addElement("column");
        newLocalizedColumnElement.addAttribute("name", pkEntityColumn.getName());
        newLocalizedColumnElement.addAttribute("type", pkEntityColumn.getType());
        newLocalizedColumnElement = newLocalizedEntityElement.addElement("column");
        newLocalizedColumnElement.addAttribute("name", "languageId");
        newLocalizedColumnElement.addAttribute("type", "String");
        List localizedColumnElements = localizedEntityElement.elements("localized-column");
        if (localizedColumnElements.isEmpty()) {
            throw new IllegalArgumentException("Unable to use localized entity table without localized columns");
        }
        ArrayList<EntityColumn> localizedEntityColumns = new ArrayList<EntityColumn>(localizedColumnElements.size());
        for (Element localizedColumnElement : localizedColumnElements) {
            String columnName = localizedColumnElement.attributeValue("name");
            String columnDBName = localizedColumnElement.attributeValue("db-name");
            if (Validator.isNull(columnDBName)) {
                columnDBName = columnName;
                if (this._badColumnNames.contains(columnName)) {
                    columnDBName = columnDBName + "_";
                }
            }
            localizedEntityColumns.add(new EntityColumn(columnName, columnDBName));
            newLocalizedColumnElement = newLocalizedEntityElement.addElement("column");
            newLocalizedColumnElement.addAttribute("name", columnName);
            newLocalizedColumnElement.addAttribute("db-name", columnDBName);
            newLocalizedColumnElement.addAttribute("type", "String");
        }
        Element newLocalizedFinderElement = newLocalizedEntityElement.addElement("finder");
        String finderName = TextFormatter.format(pkEntityColumn.getName(), 6);
        newLocalizedFinderElement.addAttribute("name", finderName);
        newLocalizedFinderElement.addAttribute("return-type", "Collection");
        Element newLocalizedFinderColumnElement = newLocalizedFinderElement.addElement("finder-column");
        newLocalizedFinderColumnElement.addAttribute("name", pkEntityColumn.getName());
        newLocalizedFinderElement = newLocalizedEntityElement.addElement("finder");
        newLocalizedFinderElement.addAttribute("name", finderName + "_LanguageId");
        newLocalizedFinderElement.addAttribute("return-type", localizedEntityName);
        newLocalizedFinderElement.addAttribute("unique", "true");
        newLocalizedFinderColumnElement = newLocalizedFinderElement.addElement("finder-column");
        newLocalizedFinderColumnElement.addAttribute("name", pkEntityColumn.getName());
        newLocalizedFinderColumnElement = newLocalizedFinderElement.addElement("finder-column");
        newLocalizedFinderColumnElement.addAttribute("name", "languageId");
        List columnElements = localizedEntityElement.elements("column");
        for (Element columnElement : columnElements) {
            String localized = columnElement.attributeValue("localized");
            if (localized != null) {
                throw new IllegalArgumentException("Unable to have localized columns in localized table for entity " + entity.getName());
            }
            newColumnElement = newLocalizedEntityElement.addElement("column", columnElement.getStringValue());
            List columnAttributes = columnElement.attributes();
            for (Object columnAttribute : columnAttributes) {
                newColumnElement.addAttribute(columnAttribute.getName(), columnAttribute.getStringValue());
            }
        }
        Element orderElement = localizedEntityElement.element("order");
        if (orderElement != null) {
            Element newOrderElement = newLocalizedEntityElement.addElement("order", orderElement.getStringValue());
            List orderAttributes = orderElement.attributes();
            newColumnElement = orderAttributes.iterator();
            while (newColumnElement.hasNext()) {
                Attribute orderAttribute = (Attribute)newColumnElement.next();
                newOrderElement.addAttribute(orderAttribute.getName(), orderAttribute.getStringValue());
            }
        }
        List finderElements = localizedEntityElement.elements("finder");
        for (Element finderElement : finderElements) {
            Element newFinderElement = newLocalizedEntityElement.addElement("finder", finderElement.getStringValue());
            List finderElementAttributes = finderElement.attributes();
            for (Attribute finderElementAttribute : finderElementAttributes) {
                newFinderElement.addAttribute(finderElementAttribute.getName(), finderElementAttribute.getStringValue());
            }
            List finderColumnElements = finderElement.elements("finder-column");
            for (Element finderColumnElement : finderColumnElements) {
                List finderColumnAttributes = finderColumnElement.attributes();
                Element newFinderColumnElement = newFinderElement.addElement("finder-column", finderColumnElement.getStringValue());
                for (Attribute finderColumnAttribute : finderColumnAttributes) {
                    newFinderColumnElement.addAttribute(finderColumnAttribute.getName(), finderColumnAttribute.getStringValue());
                }
            }
        }
        Entity localizedEntity = this._parseEntity(newLocalizedEntityElement);
        entity.setLocalizedEntityColumns(localizedEntityColumns);
        entity.setLocalizedEntity(localizedEntity);
    }

    private void _parseVersionEntity(Entity entity, List<Element> columnElements) throws Exception {
        Element versionEntityElement = DocumentHelper.createElement((String)"entity");
        if (Validator.isNotNull(entity.getDataSource())) {
            versionEntityElement.addAttribute("data-source", entity.getDataSource());
        }
        if (entity.isDeprecated()) {
            versionEntityElement.addAttribute("deprecated", "true");
        }
        versionEntityElement.addAttribute("local-service", "false");
        versionEntityElement.addAttribute("mvcc-enabled", "false");
        versionEntityElement.addAttribute("name", entity.getName() + "Version");
        versionEntityElement.addAttribute("remote-service", "false");
        if (Validator.isNotNull(entity.getSessionFactory())) {
            versionEntityElement.addAttribute("session-factory", entity.getSessionFactory());
        }
        if (Validator.isNotNull(entity.getTXManager())) {
            versionEntityElement.addAttribute("tx-manager", entity.getTXManager());
        }
        versionEntityElement.addAttribute("uuid", "false");
        Element versionEntityColumnElement = versionEntityElement.addElement("column");
        versionEntityColumnElement.addAttribute("name", entity.getVarName() + "VersionId");
        versionEntityColumnElement.addAttribute("primary", "true");
        versionEntityColumnElement.addAttribute("type", "long");
        List<EntityColumn> pkEntityColumns = entity.getPKEntityColumns();
        if (pkEntityColumns.size() > 1) {
            throw new IllegalArgumentException("Unable to use versioned entity with compound primary key");
        }
        EntityColumn pkEntityColumn = pkEntityColumns.get(0);
        if (!Objects.equals("long", pkEntityColumn.getType())) {
            throw new IllegalArgumentException("Must have long primary key to create versioned entity");
        }
        versionEntityColumnElement = versionEntityElement.addElement("column");
        versionEntityColumnElement.addAttribute("name", "version");
        versionEntityColumnElement.addAttribute("type", "int");
        for (Element columnElement : columnElements) {
            String name = columnElement.attributeValue("name");
            if (name.equals("mvccVersion") || name.equals("headId")) continue;
            versionEntityColumnElement = versionEntityElement.addElement("column");
            List columnAttributes = columnElement.attributes();
            for (Object attribute : columnAttributes) {
                String attributeName = attribute.getName();
                if (attributeName.equals("primary") || attributeName.equals("uad-anonymize-field-name") || attributeName.equals("uad-nonanonymizable")) continue;
                versionEntityColumnElement.addAttribute(attributeName, attribute.getValue());
            }
        }
        Element orderElement = versionEntityElement.addElement("order");
        Element orderColumnElement = orderElement.addElement("order-column");
        orderColumnElement.addAttribute("name", "version");
        orderColumnElement.addAttribute("order-by", "desc");
        Element versionFinderElement = versionEntityElement.addElement("finder");
        String finderName = TextFormatter.format(pkEntityColumn.getName(), 6);
        versionFinderElement.addAttribute("name", finderName);
        versionFinderElement.addAttribute("return-type", "Collection");
        Element versionColumnElement = versionFinderElement.addElement("finder-column");
        versionColumnElement.addAttribute("name", pkEntityColumn.getName());
        versionFinderElement = versionEntityElement.addElement("finder");
        versionFinderElement.addAttribute("name", finderName + "_Version");
        versionFinderElement.addAttribute("return-type", entity.getName() + "Version");
        versionFinderElement.addAttribute("unique", "true");
        versionColumnElement = versionFinderElement.addElement("finder-column");
        versionColumnElement.addAttribute("name", pkEntityColumn.getName());
        versionColumnElement = versionFinderElement.addElement("finder-column");
        versionColumnElement.addAttribute("name", "version");
        for (EntityFinder entityFinder : entity.getEntityFinders()) {
            finderName = entityFinder.getName();
            if (finderName.equals("HeadId")) continue;
            versionFinderElement = versionEntityElement.addElement("finder");
            versionFinderElement.addAttribute("name", finderName);
            versionFinderElement.addAttribute("return-type", "Collection");
            for (EntityColumn entityColumn : entityFinder.getEntityColumns()) {
                versionColumnElement = versionFinderElement.addElement("finder-column");
                versionColumnElement.addAttribute("name", entityColumn.getName());
            }
            versionFinderElement = versionEntityElement.addElement("finder");
            versionFinderElement.addAttribute("name", finderName + "_Version");
            for (EntityColumn entityColumn : entityFinder.getEntityColumns()) {
                versionColumnElement = versionFinderElement.addElement("finder-column");
                versionColumnElement.addAttribute("name", entityColumn.getName());
            }
            versionColumnElement = versionFinderElement.addElement("finder-column");
            versionColumnElement.addAttribute("name", "version");
            if (entityFinder.isUnique()) {
                versionFinderElement.addAttribute("return-type", entity.getName() + "Version");
                versionFinderElement.addAttribute("unique", "true");
                continue;
            }
            versionFinderElement.addAttribute("return-type", "Collection");
        }
        Entity versionEntity = this._parseEntity(versionEntityElement);
        entity.setVersionEntity(versionEntity);
        versionEntity.setVersionedEntity(entity);
    }

    private String _processTemplate(String name, Map<String, Object> context) throws Exception {
        this._currentTplName = name;
        Configuration configuration = ServiceBuilder._getConfiguration();
        Template template = configuration.getTemplate(name);
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.process(context, (Writer)unsyncStringWriter);
        return StringUtil.removeChar(unsyncStringWriter.toString(), '\r');
    }

    private Map<String, Object> _putDeprecatedKeys(Map<String, Object> context, JavaClass javaClass) {
        DocletTag tag;
        Entity entity = (Entity)context.get("entity");
        context.put("classDeprecated", entity.isDeprecated());
        context.put("classDeprecatedComment", "");
        if (javaClass != null && (tag = javaClass.getTagByName("deprecated")) != null) {
            context.put("classDeprecated", true);
            context.put("classDeprecatedComment", tag.getValue());
        }
        return context;
    }

    private String _read(String fileName) throws IOException {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        String resourceName = _TPL_ROOT + fileName;
        InputStream inputStream = classLoader.getResourceAsStream(resourceName);
        String content = StringUtil.read(inputStream);
        return StringUtil.replace(content, "\r\n", "\n");
    }

    private Set<String> _readLines(String fileName) throws Exception {
        Class<?> clazz = this.getClass();
        ClassLoader classLoader = clazz.getClassLoader();
        HashSet<String> lines = new HashSet<String>();
        StringUtil.readLines(classLoader.getResourceAsStream(fileName), lines);
        return lines;
    }

    private void _removeActionableDynamicQuery(Entity entity) {
        File file = new File(StringBundler.concat(this._oldServiceOutputPath, "/service/persistence/", entity.getName(), "ActionableDynamicQuery.java"));
        file.delete();
        file = new File(StringBundler.concat(this._serviceOutputPath, "/service/persistence/", entity.getName(), "ActionableDynamicQuery.java"));
        file.delete();
    }

    private void _removeBaseUADAnonymizer(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADOutputPath(), "/uad/anonymizer/Base", entity.getName(), "UADAnonymizer.java"));
    }

    private void _removeBaseUADDisplay(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADOutputPath(), "/uad/display/Base", entity.getName(), "UADDisplay.java"));
    }

    private void _removeBaseUADExporter(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADOutputPath(), "/uad/exporter/Base", entity.getName(), "UADExporter.java"));
    }

    private void _removeBlobModels(Entity entity, String outputPath) {
        for (EntityColumn entityColumn : this._getBlobEntityColumns(entity)) {
            this._deleteFile(StringBundler.concat(outputPath, "/model/", entity.getName(), entityColumn.getMethodName(), "BlobModel.java"));
        }
    }

    private void _removeEJBPK(Entity entity, String outputPath) {
        List<EntityColumn> pkEntityColumns = entity.getPKEntityColumns();
        if (pkEntityColumns.size() <= 1) {
            return;
        }
        this._deleteFile(StringBundler.concat(outputPath, "/service/persistence/", entity.getPKClassName(), ".java"));
    }

    private void _removeExportActionableDynamicQuery(Entity entity) {
        File file = new File(StringBundler.concat(this._oldServiceOutputPath, "/service/persistence/", entity.getName(), "ExportActionableDynamicQuery.java"));
        file.delete();
        file = new File(StringBundler.concat(this._serviceOutputPath, "/service/persistence/", entity.getName(), "ExportActionableDynamicQuery.java"));
        file.delete();
    }

    private void _removeExtendedModel(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/model/", entity.getName(), ".java"));
    }

    private void _removeFinder(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/service/persistence/", entity.getName(), "Finder.java"));
    }

    private void _removeFinderBaseImpl(Entity entity) {
        this._deleteFile(StringBundler.concat(this._outputPath, "/service/persistence/impl/", entity.getName(), "FinderBaseImpl.java"));
    }

    private void _removeFinderUtil(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/service/persistence/", entity.getName(), "FinderUtil.java"));
    }

    private void _removeModel(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/model/", entity.getName(), "Model.java"));
    }

    private void _removeModelClp(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/model/", entity.getName(), "Clp.java"));
    }

    private void _removeModelSoap(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/model/", entity.getName(), "Soap.java"));
    }

    private void _removeModelWrapper(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/model/", entity.getName(), "Wrapper.java"));
    }

    private void _removeOldServices(Entity entity) {
        this._removeModelClp(entity, this._oldServiceOutputPath);
        this._removeServiceClp(entity, 1, this._oldServiceOutputPath);
        this._removeServiceClp(entity, 0, this._oldServiceOutputPath);
        this._removeServiceClpInvoker(entity, 1);
        this._removeServiceClpInvoker(entity, 0);
        this._removeServiceClpMessageListener(this._oldServiceOutputPath);
        this._removeServiceClpSerializer(this._oldServiceOutputPath);
        if (this._oldServiceOutputPath.equals(this._serviceOutputPath)) {
            return;
        }
        this._removeBlobModels(entity, this._oldServiceOutputPath);
        this._removeEJBPK(entity, this._oldServiceOutputPath);
        this._removeExtendedModel(entity, this._oldServiceOutputPath);
        this._removeFinder(entity, this._oldServiceOutputPath);
        this._removeFinderUtil(entity, this._oldServiceOutputPath);
        this._removeModel(entity, this._oldServiceOutputPath);
        this._removeModelSoap(entity, this._oldServiceOutputPath);
        this._removeModelWrapper(entity, this._oldServiceOutputPath);
        this._removePersistence(entity, this._oldServiceOutputPath);
        this._removePersistenceUtil(entity, this._oldServiceOutputPath);
        this._removeService(entity, 1, this._oldServiceOutputPath);
        this._removeService(entity, 0, this._oldServiceOutputPath);
        this._removeServiceUtil(entity, 1, this._oldServiceOutputPath);
        this._removeServiceUtil(entity, 0, this._oldServiceOutputPath);
        this._removeServiceWrapper(entity, 1, this._oldServiceOutputPath);
        this._removeServiceWrapper(entity, 0, this._oldServiceOutputPath);
        this._removeServletContextUtil(this._serviceOutputPath);
    }

    private void _removePersistence(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/service/persistence/", entity.getName(), "Persistence.java"));
    }

    private void _removePersistenceUtil(Entity entity, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/service/persistence/", entity.getName(), "Util.java"));
    }

    private void _removeService(Entity entity, int sessionType, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "Service.java"));
    }

    private void _removeServiceBaseImpl(Entity entity, int sessionType) {
        this._deleteFile(StringBundler.concat(this._outputPath, "/service/base/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceBaseImpl.java"));
    }

    private void _removeServiceClp(Entity entity, int sessionType, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceClp.java"));
    }

    private void _removeServiceClpInvoker(Entity entity, int sessionType) {
        this._deleteFile(StringBundler.concat(this._outputPath, "/service/base/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceClpInvoker.java"));
    }

    private void _removeServiceClpMessageListener(String outputPath) {
        this._deleteFile(outputPath + "/service/messaging/ClpMessageListener.java");
    }

    private void _removeServiceClpSerializer(String outputPath) {
        this._deleteFile(outputPath + "/service/ClpSerializer.java");
    }

    private void _removeServiceHttp(Entity entity) {
        this._deleteFile(StringBundler.concat(this._outputPath, "/service/http/", entity.getName(), "ServiceHttp.java"));
    }

    private void _removeServiceImpl(Entity entity, int sessionType) {
        this._deleteFile(StringBundler.concat(this._outputPath, "/service/impl/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceImpl.java"));
    }

    private void _removeServiceJson(Entity entity) {
        File file = new File(StringBundler.concat(this._outputPath, "/service/http/", entity.getName(), "ServiceJSON.java"));
        if (file.exists()) {
            System.out.println("Removing deprecated " + file);
            file.delete();
        }
    }

    private void _removeServiceJsonSerializer(Entity entity) {
        File file = new File(StringBundler.concat(this._serviceOutputPath, "/service/http/", entity.getName(), "JSONSerializer.java"));
        if (file.exists()) {
            System.out.println("Removing deprecated " + file);
            file.delete();
        }
    }

    private void _removeServiceSoap(Entity entity) {
        this._deleteFile(StringBundler.concat(this._outputPath, "/service/http/", entity.getName(), "ServiceSoap.java"));
    }

    private void _removeServiceUtil(Entity entity, int sessionType, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceUtil.java"));
    }

    private void _removeServiceWrapper(Entity entity, int sessionType, String outputPath) {
        this._deleteFile(StringBundler.concat(outputPath, "/service/", entity.getName(), this._getSessionTypeName(sessionType), "ServiceWrapper.java"));
    }

    private void _removeServletContextUtil(String outputPath) {
        this._deleteFile(outputPath + "/service/ServletContextUtil.java");
    }

    private void _removeUADAnonymizer(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADOutputPath(), "/uad/anonymizer/", entity.getName(), "UADAnonymizer.java"));
    }

    private void _removeUADAnonymizerTest(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADTestIntegrationOutputPath(), "/uad/anonymizer/test/", entity.getName(), "UADAnonymizerTest.java"));
    }

    private void _removeUADDisplay(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADOutputPath(), "/uad/display/", entity.getName(), "UADDisplay.java"));
    }

    private void _removeUADDisplayTest(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADTestIntegrationOutputPath(), "/uad/display/test/", entity.getName(), "UADDisplayTest.java"));
    }

    private void _removeUADExporter(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADOutputPath(), "/uad/exporter/", entity.getName(), "UADExporter.java"));
    }

    private void _removeUADExporterTest(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADTestIntegrationOutputPath(), "/uad/exporter/test/", entity.getName(), "UADExporterTest.java"));
    }

    private void _removeUADTestHelper(Entity entity) {
        this._deleteFile(StringBundler.concat(entity.getUADTestIntegrationOutputPath(), "/uad/test/", entity.getName(), "UADTestHelper.java"));
    }

    private void _resolveEntity(Entity entity) throws Exception {
        if (entity.isResolved()) {
            return;
        }
        for (String referenceEntityNames : entity.getUnresolvedResolvedReferenceEntityNames()) {
            Entity referenceEntity = this.getEntity(referenceEntityNames);
            if (referenceEntity == null) {
                throw new ServiceBuilderException(StringBundler.concat("Unable to resolve reference ", referenceEntityNames, " in ", ListUtil.toString(this._entities, Entity.NAME_ACCESSOR)));
            }
            entity.addReferenceEntity(referenceEntity);
        }
        entity.setResolved();
    }

    private void _write(File file, String content, Set<String> modifiedFileNames) throws Exception {
        String header = null;
        header = this._commercialPlugin ? this._read("copyright-commercial.txt") : this._read("copyright.txt");
        content = header + "\n\n" + content;
        ToolsUtil.writeFileRaw(file, JavaParser.parse(file, content, 80, false), modifiedFileNames);
    }

    static {
        _dtdVersionPattern = Pattern.compile(".*service-builder_([^\\.]+)\\.dtd");
        _getterPattern = Pattern.compile(StringBundler.concat("public .* get.*", Pattern.quote("("), "|public boolean is.*", Pattern.quote("(")));
        _setterPattern = Pattern.compile("public void set.*" + Pattern.quote("("));
    }
}

