/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools;

import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.io.unsync.UnsyncBufferedReader;
import com.liferay.portal.kernel.io.unsync.UnsyncStringReader;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.tools.JavaImportsFormatter;
import com.liferay.portal.xml.SAXReaderFactory;
import de.hunsicker.io.FileFormat;
import de.hunsicker.jalopy.Jalopy;
import de.hunsicker.jalopy.storage.Convention;
import de.hunsicker.jalopy.storage.ConventionKeys;
import de.hunsicker.jalopy.storage.Environment;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class ToolsUtil {
    public static final String AUTHOR = "Brian Wing Shun Chan";
    public static final int PLUGINS_MAX_DIR_LEVEL = 3;
    public static final int PORTAL_MAX_DIR_LEVEL = 7;

    public static String getContent(String fileName) throws Exception {
        Document document = ToolsUtil._getContentDocument(fileName);
        Element rootElement = document.getRootElement();
        Element authorElement = null;
        Element namespaceElement = null;
        TreeMap<String, Element> entityElements = new TreeMap<String, Element>();
        TreeMap<String, Element> exceptionElements = new TreeMap<String, Element>();
        List elements = rootElement.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (elementName.equals("author")) {
                element.detach();
                if (authorElement != null) {
                    throw new IllegalArgumentException("There can only be one author element");
                }
                authorElement = element;
                continue;
            }
            if (elementName.equals("namespace")) {
                element.detach();
                if (namespaceElement != null) {
                    throw new IllegalArgumentException("There can only be one namespace element");
                }
                namespaceElement = element;
                continue;
            }
            if (elementName.equals("entity")) {
                element.detach();
                String name = element.attributeValue("name");
                entityElements.put(StringUtil.toLowerCase(name), element);
                continue;
            }
            if (!elementName.equals("exceptions")) continue;
            element.detach();
            List exceptionElementsList = element.elements("exception");
            for (Element exceptionElement : exceptionElementsList) {
                exceptionElement.detach();
                exceptionElements.put(exceptionElement.getText(), exceptionElement);
            }
        }
        if (authorElement != null) {
            rootElement.add(authorElement);
        }
        if (namespaceElement == null) {
            throw new IllegalArgumentException("The namespace element is required");
        }
        rootElement.add(namespaceElement);
        ToolsUtil._addElements(rootElement, entityElements);
        if (!exceptionElements.isEmpty()) {
            Element exceptionsElement = rootElement.addElement("exceptions");
            ToolsUtil._addElements(exceptionsElement, exceptionElements);
        }
        return document.asXML();
    }

    public static int getLevel(String s) {
        return ToolsUtil.getLevel(s, new String[]{"("}, new String[]{")"}, 0);
    }

    public static int getLevel(String s, String increaseLevelString, String decreaseLevelString) {
        return ToolsUtil.getLevel(s, new String[]{increaseLevelString}, new String[]{decreaseLevelString}, 0);
    }

    public static int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings) {
        return ToolsUtil.getLevel(s, increaseLevelStrings, decreaseLevelStrings, 0);
    }

    public static int getLevel(String s, String[] increaseLevelStrings, String[] decreaseLevelStrings, int startLevel) {
        int level = startLevel;
        for (String increaseLevelString : increaseLevelStrings) {
            level = ToolsUtil._adjustLevel(level, s, increaseLevelString, 1);
        }
        for (String decreaseLevelString : decreaseLevelStrings) {
            level = ToolsUtil._adjustLevel(level, s, decreaseLevelString, -1);
        }
        return level;
    }

    public static String getPackagePath(File file) {
        String fileName = StringUtil.replace(file.toString(), '\\', '/');
        return ToolsUtil.getPackagePath(fileName);
    }

    public static String getPackagePath(String fileName) {
        int x = Math.max(fileName.lastIndexOf("/com/"), fileName.lastIndexOf("/org/"));
        int y = fileName.lastIndexOf(47);
        String packagePath = fileName.substring(x + 1, y);
        return StringUtil.replace(packagePath, '/', '.');
    }

    public static boolean isInsideQuotes(String s, int pos) {
        return ToolsUtil.isInsideQuotes(s, pos, true);
    }

    public static boolean isInsideQuotes(String s, int pos, boolean allowEscapedQuotes) {
        int end;
        int start = s.lastIndexOf(10, pos);
        if (start == -1) {
            start = 0;
        }
        if ((end = s.indexOf(10, pos)) == -1) {
            end = s.length();
        }
        String line = s.substring(start, end);
        pos -= start;
        char delimeter = ' ';
        boolean insideQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (insideQuotes) {
                if (c == delimeter) {
                    if (!allowEscapedQuotes) {
                        insideQuotes = false;
                    } else {
                        int precedingBackSlashCount = 0;
                        for (int j = i - 1; j >= 0 && line.charAt(j) == '\\'; --j) {
                            ++precedingBackSlashCount;
                        }
                        if (precedingBackSlashCount == 0 || precedingBackSlashCount % 2 == 0) {
                            insideQuotes = false;
                        }
                    }
                }
            } else if (c == '\'' || c == '\"') {
                delimeter = c;
                insideQuotes = true;
            }
            if (pos != i) continue;
            return insideQuotes;
        }
        return false;
    }

    @Deprecated
    public static String stripFullyQualifiedClassNames(String content) throws IOException {
        return ToolsUtil.stripFullyQualifiedClassNames(content, null);
    }

    public static String stripFullyQualifiedClassNames(String content, String packagePath) throws IOException {
        return ToolsUtil.stripFullyQualifiedClassNames(content, JavaImportsFormatter.getImports(content), packagePath);
    }

    public static String stripFullyQualifiedClassNames(String content, String imports, String packagePath) throws IOException {
        if (Validator.isNull(content) || Validator.isNull(imports)) {
            return content;
        }
        String afterImportsContent = null;
        int pos = content.lastIndexOf("\nimport ");
        if (pos == -1) {
            afterImportsContent = content;
        } else {
            pos = content.indexOf("\n", pos + 1);
            afterImportsContent = content.substring(pos);
        }
        afterImportsContent = ToolsUtil._stripFullyQualifiedClassNames(imports, afterImportsContent, packagePath);
        afterImportsContent = ToolsUtil._stripFullyQualifiedClassNames(imports, afterImportsContent, "java.lang");
        try (UnsyncBufferedReader unsyncBufferedReader = new UnsyncBufferedReader(new UnsyncStringReader(imports));){
            String line = null;
            block12: while ((line = unsyncBufferedReader.readLine()) != null) {
                String importPackageAndClassName;
                int x = line.indexOf("import ");
                if (x == -1 || (importPackageAndClassName = line.substring(x + 7, line.lastIndexOf(";"))).contains("*")) continue;
                Pattern pattern = Pattern.compile(StringBundler.concat("[^\\w.](", StringUtil.replace(importPackageAndClassName, '.', "\\.\\s*"), ")\\W"));
                block13: while (true) {
                    Matcher matcher = pattern.matcher(afterImportsContent);
                    while (matcher.find()) {
                        String s;
                        x = matcher.start();
                        int y = afterImportsContent.lastIndexOf(10, x);
                        if (y == -1) {
                            y = 0;
                        }
                        if (ToolsUtil.isInsideQuotes(s = afterImportsContent.substring(y, x + 1), x - y) || (s = StringUtil.trim(s)).startsWith("//")) continue;
                        int z = importPackageAndClassName.lastIndexOf(".");
                        afterImportsContent = StringUtil.replaceFirst(afterImportsContent, matcher.group(1), importPackageAndClassName.substring(z + 1), x);
                        continue block13;
                    }
                    continue block12;
                    break;
                }
            }
            if (pos == -1) {
                String string = afterImportsContent;
                return string;
            }
            String string = content.substring(0, pos) + afterImportsContent;
            return string;
        }
    }

    public static void writeFile(File file, String content, Set<String> modifiedFileNames) throws IOException {
        ToolsUtil.writeFile(file, content, AUTHOR, modifiedFileNames);
    }

    public static void writeFile(File file, String content, String author, Map<String, Object> jalopySettings, Set<String> modifiedFileNames) throws IOException {
        ToolsUtil.writeFile(file, content, null, author, jalopySettings, modifiedFileNames, null);
    }

    public static void writeFile(File file, String content, String author, Map<String, Object> jalopySettings, Set<String> modifiedFileNames, String packagePath) throws IOException {
        ToolsUtil.writeFile(file, content, null, author, jalopySettings, modifiedFileNames, packagePath);
    }

    public static void writeFile(File file, String content, String author, Set<String> modifiedFileNames) throws IOException {
        ToolsUtil.writeFile(file, content, author, null, modifiedFileNames);
    }

    public static void writeFile(File file, String content, String header, String author, Map<String, Object> jalopySettings, Set<String> modifiedFileNames, String packagePath) throws IOException {
        if (!file.exists()) {
            ToolsUtil._write(file, "");
        }
        if (Validator.isNull(packagePath)) {
            packagePath = ToolsUtil.getPackagePath(file);
        }
        String className = file.getName();
        className = className.substring(0, className.length() - 5);
        JavaImportsFormatter importsFormatter = new JavaImportsFormatter();
        content = importsFormatter.format(content, packagePath, className);
        StringBuffer sb = new StringBuffer();
        Jalopy jalopy = new Jalopy();
        jalopy.setFileFormat(FileFormat.UNIX);
        jalopy.setInput((InputStream)new ByteArrayInputStream(content.getBytes()), file.getPath());
        jalopy.setOutput(sb);
        File jalopyXmlFile = new File("tools/jalopy.xml");
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../tools/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("misc/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../misc/jalopy.xml");
        }
        if (!jalopyXmlFile.exists()) {
            jalopyXmlFile = new File("../../misc/jalopy.xml");
        }
        if (jalopyXmlFile.exists()) {
            Jalopy.setConvention((File)jalopyXmlFile);
        } else {
            URL url = ToolsUtil._readJalopyXmlFromClassLoader();
            Jalopy.setConvention((URL)url);
        }
        if (jalopySettings == null) {
            jalopySettings = new HashMap<String, Object>();
        }
        Environment env = Environment.getInstance();
        author = GetterUtil.getString((String)jalopySettings.get("author"), author);
        env.set("author", (Object)author);
        boolean failOnFormatError = MapUtil.getBoolean(jalopySettings, "failOnFormatError");
        env.set("fileName", (Object)file.getName());
        Convention convention = Convention.getInstance();
        if (Validator.isNotNull(header)) {
            convention.put(ConventionKeys.HEADER_TEXT, header);
        }
        String classMask = "/**\n * @author $author$\n*/";
        convention.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_CLASS, env.interpolate(classMask));
        convention.put(ConventionKeys.COMMENT_JAVADOC_TEMPLATE_INTERFACE, env.interpolate(classMask));
        boolean formatSuccess = jalopy.format();
        String newContent = sb.toString();
        newContent = newContent.replaceFirst("(?m)^[ \t]*((?:package|import) .*;)\\s*^[ \t]*/\\*\\*", "$1\n\n/**");
        ToolsUtil.writeFileRaw(file, newContent, modifiedFileNames);
        if (failOnFormatError && !formatSuccess) {
            throw new IOException("Unable to beautify " + file);
        }
    }

    public static void writeFileRaw(File file, String content, Set<String> modifiedFileNames) throws IOException {
        if (!file.exists() || !content.equals(ToolsUtil._read(file))) {
            ToolsUtil._write(file, content);
            if (modifiedFileNames != null) {
                modifiedFileNames.add(file.getAbsolutePath());
            }
            System.out.println("Writing " + file);
        }
    }

    private static void _addElements(Element element, Map<String, Element> elements) {
        for (Map.Entry<String, Element> entry : elements.entrySet()) {
            Element childElement = entry.getValue();
            element.add(childElement);
        }
    }

    private static int _adjustLevel(int level, String text, String s, int diff) {
        boolean multiLineComment = false;
        for (String line : StringUtil.splitLines(text)) {
            if ((line = StringUtil.trim(line)).startsWith("/*")) {
                multiLineComment = true;
            }
            if (multiLineComment) {
                if (!line.endsWith("*/")) continue;
                multiLineComment = false;
                continue;
            }
            if (line.startsWith("//") || line.startsWith("*")) continue;
            int x = -1;
            while ((x = line.indexOf(s, x + 1)) != -1) {
                if (ToolsUtil.isInsideQuotes(line, x)) continue;
                level += diff;
            }
        }
        return level;
    }

    private static Document _getContentDocument(String fileName) throws Exception {
        SAXReader saxReader = ToolsUtil._getSAXReader();
        Document document = saxReader.read(new File(fileName));
        Element rootElement = document.getRootElement();
        List elements = rootElement.elements();
        for (Element element : elements) {
            String elementName = element.getName();
            if (!elementName.equals("service-builder-import")) continue;
            element.detach();
            String dirName = fileName.substring(0, fileName.lastIndexOf("/") + 1);
            String serviceBuilderImportFileName = element.attributeValue("file");
            Document serviceBuilderImportDocument = ToolsUtil._getContentDocument(dirName + serviceBuilderImportFileName);
            Element serviceBuilderImportRootElement = serviceBuilderImportDocument.getRootElement();
            List serviceBuilderImportElements = serviceBuilderImportRootElement.elements();
            for (Element serviceBuilderImportElement : serviceBuilderImportElements) {
                serviceBuilderImportElement.detach();
                rootElement.add(serviceBuilderImportElement);
            }
        }
        return document;
    }

    private static SAXReader _getSAXReader() {
        return SAXReaderFactory.getSAXReader(null, false, false);
    }

    private static String _read(File file) throws IOException {
        String s = new String(Files.readAllBytes(file.toPath()), StandardCharsets.UTF_8);
        return StringUtil.replace(s, "\r\n", "\n");
    }

    private static URL _readJalopyXmlFromClassLoader() {
        ClassLoader classLoader = ToolsUtil.class.getClassLoader();
        URL url = classLoader.getResource("jalopy.xml");
        if (url == null) {
            throw new RuntimeException("Unable to load jalopy.xml from the class loader");
        }
        return url;
    }

    private static String _stripFullyQualifiedClassNames(String imports, String afterImportsContent, String packagePath) {
        Pattern pattern1 = Pattern.compile(StringBundler.concat("\n(.*)", StringUtil.replace(packagePath, '.', "\\.\\s*"), "\\.\\s*([A-Z]\\w+)\\W"));
        block0: while (true) {
            Matcher matcher1 = pattern1.matcher(afterImportsContent);
            while (matcher1.find()) {
                String lineStart = StringUtil.trimLeading(matcher1.group(1));
                if (lineStart.contains("//") || ToolsUtil.isInsideQuotes(afterImportsContent, matcher1.start(2))) continue;
                String className = matcher1.group(2);
                Pattern pattern2 = Pattern.compile("import [\\w.]+\\." + className + ";");
                Matcher matcher2 = pattern2.matcher(imports);
                if (matcher2.find()) continue;
                afterImportsContent = StringUtil.replaceFirst(afterImportsContent, packagePath + ".", "", matcher1.start());
                continue block0;
            }
            break;
        }
        return afterImportsContent;
    }

    private static void _write(File file, String s) throws IOException {
        Path path = file.toPath();
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, s.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }
}

