/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.io.Deserializer;
import com.liferay.portal.kernel.io.Serializer;
import com.liferay.portal.kernel.util.StringBundler;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class MethodKey
implements Externalizable {
    private static final Map<MethodKey, Method> _methods = new ConcurrentHashMap<MethodKey, Method>();
    private static final long serialVersionUID = 1L;
    private Class<?> _declaringClass;
    private String _methodName;
    private Class<?>[] _parameterTypes;
    private String _toString;

    public static void resetCache() {
        _methods.clear();
    }

    public MethodKey() {
    }

    public MethodKey(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        this._declaringClass = declaringClass;
        this._methodName = methodName;
        this._parameterTypes = parameterTypes;
    }

    public MethodKey(Method method) {
        this(method.getDeclaringClass(), method.getName(), method.getParameterTypes());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodKey)) {
            return false;
        }
        MethodKey methodKey = (MethodKey)obj;
        return this._declaringClass == methodKey._declaringClass && Objects.equals(this._methodName, methodKey._methodName) && Arrays.equals(this._parameterTypes, methodKey._parameterTypes);
    }

    public Class<?> getDeclaringClass() {
        return this._declaringClass;
    }

    public Method getMethod() throws NoSuchMethodException {
        Method method = _methods.get(this);
        if (method == null) {
            method = this._declaringClass.getDeclaredMethod(this._methodName, this._parameterTypes);
            _methods.put(this, method);
        }
        method.setAccessible(true);
        return method;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public Class<?>[] getParameterTypes() {
        return this._parameterTypes;
    }

    public int hashCode() {
        String declaringClassName = this._declaringClass.getName();
        return declaringClassName.hashCode() ^ this._methodName.hashCode();
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        int size = objectInput.readInt();
        byte[] data = new byte[size];
        objectInput.readFully(data);
        Deserializer deserializer = new Deserializer(ByteBuffer.wrap(data));
        this._declaringClass = (Class)deserializer.readObject();
        this._methodName = deserializer.readString();
        int parameterTypesLength = deserializer.readInt();
        this._parameterTypes = new Class[parameterTypesLength];
        for (int i = 0; i < parameterTypesLength; ++i) {
            this._parameterTypes[i] = (Class)deserializer.readObject();
        }
    }

    public String toString() {
        if (this._toString != null) {
            return this._toString;
        }
        StringBundler sb = new StringBundler(4 + this._parameterTypes.length * 2);
        sb.append(this._declaringClass.getName());
        sb.append(".");
        sb.append(this._methodName);
        sb.append("(");
        for (Class<?> parameterType : this._parameterTypes) {
            sb.append(parameterType.getName());
            sb.append(",");
        }
        if (this._parameterTypes.length != 0) {
            sb.setIndex(sb.index() - 1);
        }
        sb.append(")");
        this._toString = sb.toString();
        return this._toString;
    }

    public MethodKey transform(ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> declaringClass = classLoader.loadClass(this._declaringClass.getName());
        Class[] parameterTypes = new Class[this._parameterTypes.length];
        for (int i = 0; i < this._parameterTypes.length; ++i) {
            parameterTypes[i] = classLoader.loadClass(this._parameterTypes[i].getName());
        }
        return new MethodKey(declaringClass, this._methodName, parameterTypes);
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        Serializer serializer = new Serializer();
        serializer.writeObject(this._declaringClass);
        serializer.writeString(this._methodName);
        serializer.writeInt(this._parameterTypes.length);
        for (Class<?> parameterType : this._parameterTypes) {
            serializer.writeObject(parameterType);
        }
        ByteBuffer byteBuffer = serializer.toByteBuffer();
        objectOutput.writeInt(byteBuffer.remaining());
        objectOutput.write(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining());
    }
}

