/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.portal.tools.service.builder;

/**
 * @author Glenn Powell
 * @author Brian Wing Shun Chan
 */
public class EntityMapping {

	public EntityMapping(
		String tableName, String entityName1, String entityName2) {

		_tableName = tableName;

		_entityNames[0] = "com.liferay.portal.Company";
		_entityNames[1] = entityName1;
		_entityNames[2] = entityName2;
	}

	public String getEntityName(int index) {
		try {
			return _entityNames[index];
		}
		catch (Exception e) {
			return null;
		}
	}

	public String getTableName() {
		return _tableName;
	}

	private final String[] _entityNames = new String[3];
	private final String _tableName;

}