/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.tools.service.builder;

import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.tools.service.builder.Entity;
import com.liferay.portal.tools.service.builder.EntityColumn;
import java.util.List;

public class EntityFinder {
    private final boolean _dbIndex;
    private final List<EntityColumn> _entityColumns;
    private final String _name;
    private final String _returnType;
    private final boolean _unique;
    private final String _where;

    public EntityFinder(String name, String returnType, boolean unique, String where, boolean dbIndex, List<EntityColumn> entityColumns) {
        this._name = name;
        this._returnType = returnType;
        this._unique = unique;
        this._where = where;
        this._dbIndex = dbIndex;
        this._entityColumns = entityColumns;
        if (this.isCollection() && this.isUnique() && !this.hasArrayableOperator()) {
            throw new IllegalArgumentException("A finder cannot return a Collection and be unique unless it has an arrayable column. See the ExpandoColumn service.xml declaration for an example.");
        }
        if ((!this.isCollection() || this.isUnique()) && this.hasCustomComparator()) {
            throw new IllegalArgumentException("A unique finder cannot have a custom comparator");
        }
    }

    public EntityColumn getEntityColumn(String name) {
        for (EntityColumn entityColumn : this._entityColumns) {
            if (!name.equals(entityColumn.getName())) continue;
            return entityColumn;
        }
        return null;
    }

    public List<EntityColumn> getEntityColumns() {
        return this._entityColumns;
    }

    public String getHumanConditions(boolean arrayable) {
        if (this._entityColumns.size() == 1) {
            EntityColumn entityColumn = this._entityColumns.get(0);
            return entityColumn.getHumanCondition(arrayable);
        }
        StringBundler sb = new StringBundler(this._entityColumns.size() * 2);
        for (EntityColumn column : this._entityColumns) {
            sb.append(column.getHumanCondition(arrayable));
            sb.append(" and ");
        }
        if (!this._entityColumns.isEmpty()) {
            sb.setIndex(sb.index() - 1);
        }
        return sb.toString();
    }

    public String getName() {
        return this._name;
    }

    public String getNames() {
        return TextFormatter.formatPlural(this._name);
    }

    public String getReturnType() {
        return this._returnType;
    }

    public String getWhere() {
        return this._where;
    }

    public boolean hasArrayableOperator() {
        for (EntityColumn column : this._entityColumns) {
            if (!column.hasArrayableOperator()) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomComparator() {
        for (EntityColumn column : this._entityColumns) {
            String comparator = column.getComparator();
            if (comparator.equals("=")) continue;
            return true;
        }
        return false;
    }

    public boolean hasEntityColumn(String name) {
        return Entity.hasEntityColumn(name, this._entityColumns);
    }

    public boolean isCollection() {
        return this._returnType != null && this._returnType.equals("Collection");
    }

    public boolean isDBIndex() {
        return this._dbIndex;
    }

    public boolean isUnique() {
        return this._unique;
    }
}

