<#setting number_format = "0">

<#assign parentPKColumn = "" />

<#if entity.isHierarchicalTree()>
	<#assign
		pkEntityColumn = entity.PKEntityColumns?first

		parentPKColumn = entity.getEntityColumn("parent" + pkEntityColumn.methodName)
	/>
</#if>

package ${packagePath}.model.impl;

<#if entity.hasCompoundPK()>
	import ${apiPackagePath}.service.persistence.${entity.name}PK;
</#if>

import ${apiPackagePath}.model.${entity.name};
import ${apiPackagePath}.model.${entity.name}Model;
import ${apiPackagePath}.model.${entity.name}Soap;

<#list entity.blobEntityColumns as entityColumn>
	<#if entityColumn.lazy>
		import ${apiPackagePath}.model.${entity.name}${entityColumn.methodName}BlobModel;
	</#if>
</#list>

<#if entity.localizedEntity??>
	import ${apiPackagePath}.model.${entity.name}Localization;
</#if>

import ${apiPackagePath}.service.${entity.name}LocalServiceUtil;

import aQute.bnd.annotation.ProviderType;

import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.bean.AutoEscapeBeanHandler;
import com.liferay.portal.kernel.exception.LocaleException;
import com.liferay.portal.kernel.exception.NoSuchModelException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSON;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.impl.BaseModelImpl;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.DateUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.LocaleThreadLocal;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.LocalizationUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowConstants;

import java.io.Serializable;

import java.math.BigDecimal;

import java.sql.Blob;
import java.sql.Types;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;

/**
 * The base model implementation for the ${entity.name} service. Represents a row in the &quot;${entity.table}&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This implementation and its corresponding interface {@link ${apiPackagePath}.model.${entity.name}Model} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link ${entity.name}Impl}.
 * </p>
 *
 * @author ${author}
 * @see ${entity.name}Impl
 * @see ${apiPackagePath}.model.${entity.name}
 * @see ${apiPackagePath}.model.${entity.name}Model
<#if classDeprecated>
 * @deprecated ${classDeprecatedComment}
</#if>
 * @generated
 */

<#if classDeprecated>
	@Deprecated
</#if>

<#if entity.jsonEnabled>
	@JSON(strict = true)
</#if>

@ProviderType
public class ${entity.name}ModelImpl extends BaseModelImpl<${entity.name}> implements ${entity.name}Model {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ${entity.humanName} model instance should use the {@link ${apiPackagePath}.model.${entity.name}} interface instead.
	 */

	public static final String TABLE_NAME = "${entity.table}";

	<#compress>
		public static final Object[][] TABLE_COLUMNS = {
			<#list entity.regularEntityColumns as entityColumn>
				<#assign sqlType = serviceBuilder.getSqlType(entity.getName(), entityColumn.getName(), entityColumn.getType()) />

				{"${entityColumn.DBName}", Types.${sqlType}}

				<#if entityColumn_has_next>
					,
				</#if>
			</#list>
		};

		public static final Map<String, Integer> TABLE_COLUMNS_MAP = new HashMap<String, Integer>();

		static {
			<#list entity.regularEntityColumns as entityColumn>
				<#assign sqlType = serviceBuilder.getSqlType(entity.getName(), entityColumn.getName(), entityColumn.getType()) />

				TABLE_COLUMNS_MAP.put("${entityColumn.DBName}", Types.${sqlType});
			</#list>
		}
	</#compress>

	public static final String TABLE_SQL_CREATE = "${serviceBuilder.getCreateTableSQL(entity)}";

	public static final String TABLE_SQL_DROP = "drop table ${entity.table}";

	<#if entity.entityOrder??>
		<#assign orderList = entity.entityOrder.entityColumns />
	<#else>
		<#assign orderList = entity.PKEntityColumns />
	</#if>

	<#assign orderByJPQL = "" />

	<#list orderList as order>
		<#if entity.hasCompoundPK() && order.isPrimary()>
			<#assign orderByJPQL = orderByJPQL + entity.alias + ".id." + order.name />
		<#else>
			<#assign orderByJPQL = orderByJPQL + entity.alias + "." + order.name />
		</#if>

		<#if order.isOrderByAscending()>
			<#assign orderByJPQL = orderByJPQL + " ASC" />
		<#else>
			<#assign orderByJPQL = orderByJPQL + " DESC" />
		</#if>

		<#if order_has_next>
			<#assign orderByJPQL = orderByJPQL + ", " />
		</#if>
	</#list>

	public static final String ORDER_BY_JPQL = " ORDER BY ${orderByJPQL}";

	<#assign orderBySQL = "" />

	<#list orderList as order>
		<#assign orderBySQL = orderBySQL + entity.table + "." + order.DBName />

		<#if order.isOrderByAscending()>
			<#assign orderBySQL = orderBySQL + " ASC" />
		<#else>
			<#assign orderBySQL = orderBySQL + " DESC" />
		</#if>

		<#if order_has_next>
			<#assign orderBySQL = orderBySQL + ", " />
		</#if>
	</#list>

	public static final String ORDER_BY_SQL = " ORDER BY ${orderBySQL}";

	public static final String DATA_SOURCE = "${entity.dataSource}";

	public static final String SESSION_FACTORY = "${entity.sessionFactory}";

	public static final String TX_MANAGER = "${entity.getTXManager()}";

	<#if entity.hasEagerBlobColumn()>
		public static final boolean ENTITY_CACHE_ENABLED = false;

		public static final boolean FINDER_CACHE_ENABLED = false;
	<#else>
		public static final boolean ENTITY_CACHE_ENABLED = GetterUtil.getBoolean(${propsUtil}.get("value.object.entity.cache.enabled.${apiPackagePath}.model.${entity.name}"),

		<#if entity.isCacheEnabled()>
			true
		<#else>
			false
		</#if>

		);

		public static final boolean FINDER_CACHE_ENABLED = GetterUtil.getBoolean(${propsUtil}.get("value.object.finder.cache.enabled.${apiPackagePath}.model.${entity.name}"),

		<#if entity.isCacheEnabled()>
			true
		<#else>
			false
		</#if>

		);

		<#assign columnBitmaskEnabled = true />

		<#if entity.finderEntityColumns?size == 0>
			public static final boolean COLUMN_BITMASK_ENABLED = false;

			<#assign columnBitmaskEnabled = false />
		</#if>

		<#if entity.finderEntityColumns?size &gt; 64>
			public static final boolean COLUMN_BITMASK_ENABLED = false;

			<#assign columnBitmaskEnabled = false />
		</#if>

		<#if columnBitmaskEnabled>
			public static final boolean COLUMN_BITMASK_ENABLED = GetterUtil.getBoolean(${propsUtil}.get("value.object.column.bitmask.enabled.${apiPackagePath}.model.${entity.name}"), true);

			<#assign columnBitmask = 1 />

			<#list entity.finderEntityColumns as entityColumn>
				public static final long ${entityColumn.name?upper_case}_COLUMN_BITMASK = ${columnBitmask}L;

				<#assign columnBitmask = columnBitmask * 2 />
			</#list>

			<#list orderList as order>
				<#if !entity.finderEntityColumns?seq_contains(order)>
					public static final long ${order.name?upper_case}_COLUMN_BITMASK = ${columnBitmask}L;

					<#assign columnBitmask = columnBitmask * 2 />
				</#if>
			</#list>
		</#if>
	</#if>

	<#if entity.hasRemoteService()>
		/**
		 * Converts the soap model instance into a normal model instance.
		 *
		 * @param soapModel the soap model instance to convert
		 * @return the normal model instance
		 */
		public static ${entity.name} toModel(${entity.name}Soap soapModel) {
			if (soapModel == null) {
				return null;
			}

			${entity.name} model = new ${entity.name}Impl();

			<#list entity.regularEntityColumns as entityColumn>
				model.set${entityColumn.methodName}(soapModel.get${entityColumn.methodName}());
			</#list>

			return model;
		}

		/**
		 * Converts the soap model instances into normal model instances.
		 *
		 * @param soapModels the soap model instances to convert
		 * @return the normal model instances
		 */
		public static List<${entity.name}> toModels(${entity.name}Soap[] soapModels) {
			if (soapModels == null) {
				return null;
			}

			List<${entity.name}> models = new ArrayList<${entity.name}>(soapModels.length);

			for (${entity.name}Soap soapModel : soapModels) {
				models.add(toModel(soapModel));
			}

			return models;
		}
	</#if>

	<#list entity.entityColumns as entityColumn>
		<#if entityColumn.mappingTableName??>
			<#assign entityShortName = stringUtil.shorten(entity.name, 9, "") />

			public static final String MAPPING_TABLE_${stringUtil.upperCase(entityColumn.mappingTableName)}_NAME = "${entityColumn.mappingTableName}";

			<#compress>
				public static final Object[][] MAPPING_TABLE_${stringUtil.upperCase(entityColumn.mappingTableName)}_COLUMNS = {
					<#assign mappingEntities = serviceBuilder.getMappingEntities(entityColumn.mappingTableName) />

					<#list mappingEntities?keys as mapEntityName>
						<#list mappingEntities[mapEntityName] as mapColumn>
							<#assign sqlType = serviceBuilder.getSqlType(mapEntityName, mapColumn.getName(), mapColumn.getType()) />

							{"${mapColumn.DBName}", Types.${sqlType}}

							<#if mapEntityName_has_next || mapColumn_has_next>
								,
							</#if>
						</#list>
					</#list>
				};
			</#compress>

			public static final String MAPPING_TABLE_${stringUtil.upperCase(entityColumn.mappingTableName)}_SQL_CREATE = "${serviceBuilder.getCreateMappingTableSQL(serviceBuilder.getEntityMapping(entityColumn.mappingTableName))}";

			public static final boolean FINDER_CACHE_ENABLED_${stringUtil.upperCase(entityColumn.mappingTableName)} = GetterUtil.getBoolean(${propsUtil}.get("value.object.finder.cache.enabled.${entityColumn.mappingTableName}"), true);
		</#if>
	</#list>

	public static final long LOCK_EXPIRATION_TIME = GetterUtil.getLong(${propsUtil}.get("lock.expiration.time.${apiPackagePath}.model.${entity.name}"));

	public ${entity.name}ModelImpl() {
	}

	@Override
	public ${entity.PKClassName} getPrimaryKey() {
		<#if entity.hasCompoundPK()>
			return new ${entity.PKClassName}(

			<#list entity.PKEntityColumns as entityColumn>
				_${entityColumn.name}

				<#if entityColumn_has_next>
					,
				</#if>
			</#list>

			);
		<#else>
			return _${entity.PKEntityColumns[0].name};
		</#if>
	}

	@Override
	public void setPrimaryKey(${entity.PKClassName} primaryKey) {
		<#if entity.hasCompoundPK()>
			<#list entity.PKEntityColumns as entityColumn>
				set${entityColumn.methodName}(primaryKey.${entityColumn.name});
			</#list>
		<#else>
			set${entity.PKEntityColumns[0].methodName}(primaryKey);
		</#if>
	}

	@Override
	public Serializable getPrimaryKeyObj() {
		<#if entity.hasCompoundPK()>
			return new ${entity.PKClassName}(

			<#list entity.PKEntityColumns as entityColumn>
				_${entityColumn.name}

				<#if entityColumn_has_next>
					,
				</#if>
			</#list>

			);
		<#else>
			return _${entity.PKEntityColumns[0].name};
		</#if>
	}

	@Override
	public void setPrimaryKeyObj(Serializable primaryKeyObj) {
		setPrimaryKey(

		<#if entity.hasPrimitivePK()>
			((${serviceBuilder.getPrimitiveObj("${entity.PKClassName}")})
		<#else>
			(${entity.PKClassName})
		</#if>

		primaryKeyObj

		<#if entity.hasPrimitivePK()>
			)${serviceBuilder.getPrimitiveObjValue(serviceBuilder.getPrimitiveObj("${entity.PKClassName}"))}
		</#if>

		);
	}

	@Override
	public Class<?> getModelClass() {
		return ${entity.name}.class;
	}

	@Override
	public String getModelClassName() {
		return ${entity.name}.class.getName();
	}

	@Override
	public Map<String, Object> getModelAttributes() {
		Map<String, Object> attributes = new HashMap<String, Object>();

		<#list entity.regularEntityColumns as entityColumn>
			attributes.put("${entityColumn.name}", get${entityColumn.methodName}());
		</#list>

		attributes.put("entityCacheEnabled", isEntityCacheEnabled());
		attributes.put("finderCacheEnabled", isFinderCacheEnabled());

		return attributes;
	}

	@Override
	public void setModelAttributes(Map<String, Object> attributes) {
		<#list entity.regularEntityColumns as entityColumn>
			<#if entityColumn.isPrimitiveType()>
				${serviceBuilder.getPrimitiveObj(entityColumn.type)}
			<#else>
				${entityColumn.genericizedType}
			</#if>

			${entityColumn.name} =

			<#if entityColumn.isPrimitiveType()>
				(${serviceBuilder.getPrimitiveObj(entityColumn.type)})
			<#else>
				(${entityColumn.genericizedType})
			</#if>

			attributes.get("${entityColumn.name}");

			if (${entityColumn.name} != null) {
				set${entityColumn.methodName}(${entityColumn.name});
			}
		</#list>
	}

	<#if entity.localizedEntity??>
		<#assign localizedEntity = entity.localizedEntity />

		@Override
		public String[] getAvailableLanguageIds() {
			List<${localizedEntity.name}> ${localizedEntity.varNames} = ${entity.name}LocalServiceUtil.get${localizedEntity.names}(getPrimaryKey());

			String[] availableLanguageIds = new String[${localizedEntity.varNames}.size()];

			for (int i = 0; i < availableLanguageIds.length; i++) {
				${localizedEntity.name} ${localizedEntity.varName} = ${localizedEntity.varNames}.get(i);

				availableLanguageIds[i] = ${localizedEntity.varName}.getLanguageId();
			}

			return availableLanguageIds;
		}

		<#list entity.localizedEntityColumns as entityColumn>
			@Override
			public String get${entityColumn.methodName}() {
				return get${entityColumn.methodName}(getDefaultLanguageId(), false);
			}

			@Override
			public String get${entityColumn.methodName}(String languageId) {
				return get${entityColumn.methodName}(languageId, true);
			}

			@Override
			public String get${entityColumn.methodName}(String languageId, boolean useDefault) {
				if (useDefault) {
					return LocalizationUtil.getLocalization(
						new Function<String, String> () {

							@Override
							public String apply(String languageId) {
								return _get${entityColumn.methodName}(languageId);
							}

						},
						languageId, getDefaultLanguageId());
				}

				return _get${entityColumn.methodName}(languageId);
			}

			@Override
			public String get${entityColumn.methodName}MapAsXML() {
				return LocalizationUtil.getXml(getLanguageIdTo${entityColumn.methodName}Map(), getDefaultLanguageId(), "${entityColumn.methodName}");
			}

			@Override
			public Map<String, String> getLanguageIdTo${entityColumn.methodName}Map() {
				Map<String, String> languageIdTo${entityColumn.methodName}Map = new HashMap<String, String>();

				List<${localizedEntity.name}> ${localizedEntity.varNames} = ${entity.name}LocalServiceUtil.get${localizedEntity.names}(getPrimaryKey());

				for (${localizedEntity.name} ${localizedEntity.varName} : ${localizedEntity.varNames}) {
					languageIdTo${entityColumn.methodName}Map.put(${localizedEntity.varName}.getLanguageId(), ${localizedEntity.varName}.get${entityColumn.methodName}());
				}

				return languageIdTo${entityColumn.methodName}Map;
			}

			private String _get${entityColumn.methodName}(String languageId) {
				${localizedEntity.name} ${localizedEntity.varName} = ${entity.name}LocalServiceUtil.fetch${localizedEntity.name}(getPrimaryKey(), languageId);

				if (${localizedEntity.varName} == null) {
					return "";
				}

				return ${localizedEntity.varName}.get${entityColumn.methodName}();
			}
		</#list>
	</#if>

	<#list entity.regularEntityColumns as entityColumn>
		<#if stringUtil.equals(entityColumn.name, "classNameId") && !hasClassNameCacheField>
			@Override
			public String getClassName() {
				if (getClassNameId() <= 0) {
					return "";
				}

				return PortalUtil.getClassName(getClassNameId());
			}

			@Override
			public void setClassName(String className) {
				long classNameId = 0;

				if (Validator.isNotNull(className)) {
					classNameId = PortalUtil.getClassNameId(className);
				}

				setClassNameId(classNameId);
			}
		</#if>

		<#if entityColumn.jsonEnabled>
			@JSON
		<#elseif entity.jsonEnabled>
			@JSON(include = false)
		</#if>

		@Override
		public ${entityColumn.genericizedType} get${entityColumn.methodName}() {
			<#if stringUtil.equals(entityColumn.type, "String") && entityColumn.isConvertNull()>
				if (_${entityColumn.name} == null) {
					return "";
				}
				else {
					return _${entityColumn.name};
				}
			<#else>
				<#if stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy>
					if (_${entityColumn.name}BlobModel == null) {
						try {
							_${entityColumn.name}BlobModel = ${entity.name}LocalServiceUtil.get${entityColumn.methodName}BlobModel(getPrimaryKey());
						}
						catch (Exception e) {
						}
					}

					Blob blob = null;

					if (_${entityColumn.name}BlobModel != null) {
						blob = _${entityColumn.name}BlobModel.get${entityColumn.methodName}Blob();
					}

					return blob;
				<#else>
					return _${entityColumn.name};
				</#if>
			</#if>
		}

		<#if entityColumn.localized>
			@Override
			public String get${entityColumn.methodName}(Locale locale) {
				String languageId = LocaleUtil.toLanguageId(locale);

				return get${entityColumn.methodName}(languageId);
			}

			@Override
			public String get${entityColumn.methodName}(Locale locale, boolean useDefault) {
				String languageId = LocaleUtil.toLanguageId(locale);

				return get${entityColumn.methodName}(languageId, useDefault);
			}

			@Override
			public String get${entityColumn.methodName}(String languageId) {
				return LocalizationUtil.getLocalization(get${entityColumn.methodName}(), languageId);
			}

			@Override
			public String get${entityColumn.methodName}(String languageId, boolean useDefault) {
				return LocalizationUtil.getLocalization(get${entityColumn.methodName}(), languageId, useDefault);
			}

			@Override
			public String get${entityColumn.methodName}CurrentLanguageId() {
				return _${entityColumn.name}CurrentLanguageId;
			}

			@JSON
			@Override
			public String get${entityColumn.methodName}CurrentValue() {
				Locale locale = getLocale(_${entityColumn.name}CurrentLanguageId);

				return get${entityColumn.methodName}(locale);
			}

			@Override
			public Map<Locale, String> get${entityColumn.methodName}Map() {
				return LocalizationUtil.getLocalizationMap(get${entityColumn.methodName}());
			}
		</#if>

		<#if entityColumn.type== "boolean">
			<#if entityColumn.jsonEnabled>
				@JSON
			</#if>

			@Override
			public ${entityColumn.type} is${entityColumn.methodName}() {
				return _${entityColumn.name};
			}
		</#if>

		<#if entity.hasEntityColumn("createDate", "Date") && entity.hasEntityColumn("modifiedDate", "Date") && stringUtil.equals(entityColumn.name, "modifiedDate")>
			public boolean hasSetModifiedDate() {
				return _setModifiedDate;
			}
		</#if>

		@Override
		public void set${entityColumn.methodName}(${entityColumn.genericizedType} ${entityColumn.name}) {
			<#if stringUtil.equals(entityColumn.name, "uuid")>
				<#if entityColumn.isFinderPath()>
					if (_originalUuid == null) {
						_originalUuid = _uuid;
					}
				</#if>

				_uuid = uuid;
			<#else>
				<#if entity.hasEntityColumn("createDate", "Date") && entity.hasEntityColumn("modifiedDate", "Date") && stringUtil.equals(entityColumn.name, "modifiedDate")>
					_setModifiedDate = true;
				</#if>

				<#if entityColumn.isOrderColumn() && columnBitmaskEnabled>
					_columnBitmask = -1L;
				</#if>

				<#if entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name))>
					<#if !entityColumn.isOrderColumn() && columnBitmaskEnabled>
						_columnBitmask |= ${entityColumn.name?upper_case}_COLUMN_BITMASK;
					</#if>

					<#if entityColumn.isPrimitiveType()>
						if (!_setOriginal${entityColumn.methodName}) {
							_setOriginal${entityColumn.methodName} = true;
					<#else>
						if (_original${entityColumn.methodName} == null) {
					</#if>

						_original${entityColumn.methodName} = _${entityColumn.name};
					}
				</#if>

				<#if stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy>
					if (_${entityColumn.name}BlobModel == null) {
						_${entityColumn.name}BlobModel = new ${entity.name}${entityColumn.methodName}BlobModel(getPrimaryKey(), ${entityColumn.name});
					}
					else {
						_${entityColumn.name}BlobModel.set${entityColumn.methodName}Blob(${entityColumn.name});
					}
				<#else>
					_${entityColumn.name} = ${entityColumn.name};
				</#if>
			</#if>
		}

		<#if entityColumn.localized>
			@Override
			public void set${entityColumn.methodName}(String ${entityColumn.name}, Locale locale) {
				<#if entity.isGroupedModel()>
					set${entityColumn.methodName}(${entityColumn.name}, locale, LocaleUtil.getSiteDefault());
				<#else>
					set${entityColumn.methodName}(${entityColumn.name}, locale, LocaleUtil.getDefault());
				</#if>
			}

			@Override
			public void set${entityColumn.methodName}(String ${entityColumn.name}, Locale locale, Locale defaultLocale) {
				String languageId = LocaleUtil.toLanguageId(locale);
				String defaultLanguageId = LocaleUtil.toLanguageId(defaultLocale);

				if (Validator.isNotNull(${entityColumn.name})) {
					set${entityColumn.methodName}(LocalizationUtil.updateLocalization(get${entityColumn.methodName}(), "${entityColumn.methodName}", ${entityColumn.name}, languageId, defaultLanguageId));
				}
				else {
					set${entityColumn.methodName}(LocalizationUtil.removeLocalization(get${entityColumn.methodName}(), "${entityColumn.methodName}", languageId));
				}
			}

			@Override
			public void set${entityColumn.methodName}CurrentLanguageId(String languageId) {
				_${entityColumn.name}CurrentLanguageId = languageId;
			}

			@Override
			public void set${entityColumn.methodName}Map(Map<Locale, String> ${entityColumn.name}Map) {
				<#if entity.isGroupedModel()>
					set${entityColumn.methodName}Map(${entityColumn.name}Map, LocaleUtil.getSiteDefault());
				<#else>
					set${entityColumn.methodName}Map(${entityColumn.name}Map, LocaleUtil.getDefault());
				</#if>
			}

			@Override
			public void set${entityColumn.methodName}Map(Map<Locale, String> ${entityColumn.name}Map, Locale defaultLocale) {
				if (${entityColumn.name}Map == null) {
					return;
				}

				set${entityColumn.methodName}(LocalizationUtil.updateLocalization(${entityColumn.name}Map, get${entityColumn.methodName}(), "${entityColumn.methodName}", LocaleUtil.toLanguageId(defaultLocale)));
			}
		</#if>

		<#if stringUtil.equals(entityColumn.name, "resourcePrimKey") && entity.isResourcedModel()>
			@Override
			public boolean isResourceMain() {
				return true;
			}
		</#if>

		<#if entityColumn.userUuid>
			@Override
			public String get${entityColumn.methodUserUuidName}() {
				try {
					User user = UserLocalServiceUtil.getUserById(get${entityColumn.methodName}());

					return user.getUuid();
				}
				catch (PortalException pe) {
					return "";
				}
			}

			@Override
			public void set${entityColumn.methodUserUuidName}(String ${entityColumn.userUuidName}) {
			}
		</#if>

		<#if entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name))>
			public ${entityColumn.type} getOriginal${entityColumn.methodName}() {
				<#if stringUtil.equals(entityColumn.type, "String") && entityColumn.isConvertNull()>
					return GetterUtil.getString(_original${entityColumn.methodName});
				<#else>
					return _original${entityColumn.methodName};
				</#if>
			}
		</#if>
	</#list>

	<#list cacheFields as cacheField>
		<#assign
			variableName = serviceBuilder.getVariableName(cacheField)
			methodName = serviceBuilder.getCacheFieldMethodName(cacheField)
			typeName = serviceBuilder.getGenericValue(cacheField.getType())
		/>

		<#if !stringUtil.equals(methodName, "DefaultLanguageId")>
			public ${typeName} get${methodName}() {
				<#if cacheField.getType().isPrimitive()>
					<#if stringUtil.equals(typeName, "boolean")>
						return false;
					<#else>
						return 0;
					</#if>
				<#else>
					return null;
				</#if>
			}
		</#if>

		public void set${methodName}(${typeName} ${variableName}) {
		}
	</#list>

	<#if entity.isContainerModel()>
		<#assign hasParentContainerModelId = entity.hasEntityColumn("parentContainerModelId") />

		<#list entity.entityColumns as entityColumn>
			<#if entityColumn.isContainerModel() && !stringUtil.equals(entityColumn.name, "containerModelId")>
				@Override
				public long getContainerModelId() {
					return get${entityColumn.methodName}();
				}

				@Override
				public void setContainerModelId(long containerModelId) {
					_${entityColumn.name} = containerModelId;
				}
			</#if>

			<#if entityColumn.isParentContainerModel() && !stringUtil.equals(entityColumn.name, "parentContainerModelId")>
				<#assign hasParentContainerModelId = true />

				@Override
				public long getParentContainerModelId() {
					return get${entityColumn.methodName}();
				}

				@Override
				public void setParentContainerModelId(long parentContainerModelId) {
					_${entityColumn.name} = parentContainerModelId;
				}
			</#if>
		</#list>

		@Override
		public String getContainerModelName() {
			<#if entity.hasEntityColumn("name")>
				return String.valueOf(getName());
			<#elseif entity.hasEntityColumn("title")>
				<#assign titleColumn = entity.getEntityColumn("title") />

				return String.valueOf(getTitle(<#if titleColumn.isLocalized()>LocaleThreadLocal.getThemeDisplayLocale()</#if>));
			<#else>
				return String.valueOf(getContainerModelId());
			</#if>
		}

		<#if !hasParentContainerModelId>
			@Override
			public long getParentContainerModelId() {
				return 0;
			}

			@Override
			public void setParentContainerModelId(long parentContainerModelId) {
			}
		</#if>
	</#if>

	<#if entity.isHierarchicalTree()>
		public long getNestedSetsTreeNodeLeft() {
			return _left${pkEntityColumn.methodName};
		}

		public long getNestedSetsTreeNodeRight() {
			return _right${pkEntityColumn.methodName};
		}

		public long getNestedSetsTreeNodeScopeId() {
			<#if entity.hasEntityColumn("groupId")>
				<#assign scopeEntityColumn = entity.getEntityColumn("groupId") />
			<#else>
				<#assign scopeEntityColumn = entity.getEntityColumn("companyId") />
			</#if>

			return _${scopeEntityColumn.name};
		}

		public void setNestedSetsTreeNodeLeft(long nestedSetsTreeNodeLeft) {
			_left${pkEntityColumn.methodName} = nestedSetsTreeNodeLeft;
		}

		public void setNestedSetsTreeNodeRight(long nestedSetsTreeNodeRight) {
			_right${pkEntityColumn.methodName} = nestedSetsTreeNodeRight;
		}
	</#if>

	<#if entity.isStagedModel()>
		@Override
		public StagedModelType getStagedModelType() {
			<#if entity.isTypedModel()>
				return new StagedModelType(PortalUtil.getClassNameId(${entity.name}.class.getName()), getClassNameId());
			<#else>
				return new StagedModelType(PortalUtil.getClassNameId(${entity.name}.class.getName()));
			</#if>
		}
	</#if>

	<#if entity.isTrashEnabled()>
		<#if !entity.isWorkflowEnabled()>
			@Override
			public int getStatus() {
				return 0;
			}
		</#if>

		@Override
		public com.liferay.trash.kernel.model.TrashEntry getTrashEntry() throws PortalException {
			if (!isInTrash()) {
				return null;
			}

			com.liferay.trash.kernel.model.TrashEntry trashEntry = com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.fetchEntry(getModelClassName(), getTrashEntryClassPK());

			if (trashEntry != null) {
				return trashEntry;
			}

			com.liferay.portal.kernel.trash.TrashHandler trashHandler = getTrashHandler();

			if (Validator.isNotNull(trashHandler.getContainerModelClassName(getPrimaryKey()))) {
				ContainerModel containerModel = null;

				try {
					containerModel = trashHandler.getParentContainerModel(this);
				}
				catch (NoSuchModelException nsme) {
					return null;
				}

				while (containerModel != null) {
					if (containerModel instanceof TrashedModel) {
						TrashedModel trashedModel = (TrashedModel)containerModel;

						return trashedModel.getTrashEntry();
					}

					trashHandler = com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.getTrashHandler(trashHandler.getContainerModelClassName(containerModel.getContainerModelId()));

					if (trashHandler == null) {
						return null;
					}

					containerModel = trashHandler.getContainerModel(containerModel.getParentContainerModelId());
				}
			}

			return null;
		}

		@Override
		public long getTrashEntryClassPK() {
			return getPrimaryKey();
		}

		/**
		* @deprecated As of 7.0.0, with no direct replacement
		*/
		@Deprecated
		@Override
		public com.liferay.portal.kernel.trash.TrashHandler getTrashHandler() {
			return com.liferay.portal.kernel.trash.TrashHandlerRegistryUtil.getTrashHandler(getModelClassName());
		}

		@Override
		public boolean isInTrash() {
			if (getStatus() == WorkflowConstants.STATUS_IN_TRASH) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isInTrashContainer() {
			com.liferay.portal.kernel.trash.TrashHandler trashHandler = getTrashHandler();

			if ((trashHandler == null) || Validator.isNull(trashHandler.getContainerModelClassName(getPrimaryKey()))) {
				return false;
			}

			try {
				ContainerModel containerModel = trashHandler.getParentContainerModel(this);

				if (containerModel == null) {
					return false;
				}

				if (containerModel instanceof TrashedModel) {
					return ((TrashedModel)containerModel).isInTrash();
				}
			}
			catch (Exception e) {
			}

			return false;
		}

		@Override
		public boolean isInTrashExplicitly() {
			if (!isInTrash()) {
				return false;
			}

			com.liferay.trash.kernel.model.TrashEntry trashEntry = com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.fetchEntry(getModelClassName(), getTrashEntryClassPK());

			if (trashEntry != null) {
				return true;
			}

			return false;
		}

		@Override
		public boolean isInTrashImplicitly() {
			if (!isInTrash()) {
				return false;
			}

			com.liferay.trash.kernel.model.TrashEntry trashEntry = com.liferay.trash.kernel.service.TrashEntryLocalServiceUtil.fetchEntry(getModelClassName(), getTrashEntryClassPK());

			if (trashEntry != null) {
				return false;
			}

			return true;
		}
	</#if>

	<#if entity.isWorkflowEnabled()>
		@Override
		public boolean isApproved() {
			if (getStatus() == WorkflowConstants.STATUS_APPROVED) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isDenied() {
			if (getStatus() == WorkflowConstants.STATUS_DENIED) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isDraft() {
			if (getStatus() == WorkflowConstants.STATUS_DRAFT) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isExpired() {
			if (getStatus() == WorkflowConstants.STATUS_EXPIRED) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isInactive() {
			if (getStatus() == WorkflowConstants.STATUS_INACTIVE) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isIncomplete() {
			if (getStatus() == WorkflowConstants.STATUS_INCOMPLETE) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isPending() {
			if (getStatus() == WorkflowConstants.STATUS_PENDING) {
				return true;
			}
			else {
				return false;
			}
		}

		@Override
		public boolean isScheduled() {
			if (getStatus() == WorkflowConstants.STATUS_SCHEDULED) {
				return true;
			}
			else {
				return false;
			}
		}
	</#if>

	<#if columnBitmaskEnabled>
		public long getColumnBitmask() {
			return _columnBitmask;
		}
	</#if>

	<#if stringUtil.equals(entity.PKClassName, "long") && !stringUtil.startsWith(entity.name, "Expando")>
		@Override
		public ExpandoBridge getExpandoBridge() {
			return ExpandoBridgeFactoryUtil.getExpandoBridge(

				<#if entity.hasEntityColumn("companyId")>
					getCompanyId(),
				<#else>
					0,
				</#if>

				${entity.name}.class.getName(), getPrimaryKey());
		}

		@Override
		public void setExpandoBridgeAttributes(ServiceContext serviceContext) {
			ExpandoBridge expandoBridge = getExpandoBridge();

			expandoBridge.setAttributes(serviceContext);
		}
	</#if>

	<#if entity.isLocalizedModel()>
		@Override
		public String[] getAvailableLanguageIds() {
			Set<String> availableLanguageIds = new TreeSet<String>();

			<#list entity.regularEntityColumns as entityColumn>
				<#if entityColumn.localized>
					Map<Locale, String> ${entityColumn.name}Map = get${entityColumn.methodName}Map();

					for (Map.Entry<Locale, String> entry : ${entityColumn.name}Map.entrySet()) {
						Locale locale = entry.getKey();
						String value = entry.getValue();

						if (Validator.isNotNull(value)) {
							availableLanguageIds.add(LocaleUtil.toLanguageId(locale));
						}
					}
				</#if>
			</#list>

			return availableLanguageIds.toArray(new String[availableLanguageIds.size()]);
		}

		@Override
		public String getDefaultLanguageId() {
			<#list entity.regularEntityColumns as entityColumn>
				<#if entityColumn.localized>
					String xml = get${entityColumn.methodName}();

					if (xml == null) {
						return "";
					}

					<#if entity.isGroupedModel()>
						Locale defaultLocale = LocaleUtil.getSiteDefault();
					<#else>
						Locale defaultLocale = LocaleUtil.getDefault();
					</#if>

					return LocalizationUtil.getDefaultLanguageId(xml, defaultLocale);
					<#break>
				</#if>
			</#list>
		}

		@Override
		public void prepareLocalizedFieldsForImport() throws LocaleException {
			Locale defaultLocale = LocaleUtil.fromLanguageId(getDefaultLanguageId());

			Locale[] availableLocales = LocaleUtil.fromLanguageIds(getAvailableLanguageIds());

			Locale defaultImportLocale = LocalizationUtil.getDefaultImportLocale(${entity.name}.class.getName(), getPrimaryKey(), defaultLocale, availableLocales);

			prepareLocalizedFieldsForImport(defaultImportLocale);
		}

		@Override
		@SuppressWarnings("unused")
		public void prepareLocalizedFieldsForImport(Locale defaultImportLocale) throws LocaleException {
			<#if entity.isGroupedModel()>
				Locale defaultLocale = LocaleUtil.getSiteDefault();
			<#else>
				Locale defaultLocale = LocaleUtil.getDefault();
			</#if>

			String modelDefaultLanguageId = getDefaultLanguageId();

			<#list entity.regularEntityColumns as entityColumn>
				<#if entityColumn.localized>
					String ${entityColumn.name} = get${entityColumn.methodName}(defaultLocale);

					if (Validator.isNull(${entityColumn.name})) {
						set${entityColumn.methodName}(get${entityColumn.methodName}(modelDefaultLanguageId), defaultLocale);
					}
					else {
					  set${entityColumn.methodName}(get${entityColumn.methodName}(defaultLocale), defaultLocale, defaultLocale);
					}
				</#if>
			</#list>
		}
	</#if>

	@Override
	public ${entity.name} toEscapedModel() {
		if (_escapedModel == null) {
			_escapedModel = (${entity.name})ProxyUtil.newProxyInstance(_classLoader, _escapedModelInterfaces, new AutoEscapeBeanHandler(this));
		}

		return _escapedModel;
	}

	@Override
	public Object clone() {
		${entity.name}Impl ${entity.varName}Impl = new ${entity.name}Impl();

		<#list entity.regularEntityColumns as entityColumn>
			<#if !stringUtil.equals(entityColumn.type, "Blob")>
				${entity.varName}Impl.set${entityColumn.methodName}(

				<#if entityColumn.entityName??>
					(${entityColumn.entityName})get${entityColumn.methodName}().clone()
				<#else>
					get${entityColumn.methodName}()
				</#if>

				);
			</#if>
		</#list>

		${entity.varName}Impl.resetOriginalValues();

		return ${entity.varName}Impl;
	}

	@Override
	public int compareTo(${entity.name} ${entity.varName}) {
		<#if entity.isOrdered()>
			int value = 0;

			<#list entity.entityOrder.entityColumns as entityColumn>
				<#if entityColumn.isPrimitiveType()>
					<#if stringUtil.equals(entityColumn.type, "boolean")>
						value = Boolean.compare(get${entityColumn.methodName}(), ${entity.varName}.get${entityColumn.methodName}());
					<#else>
						if (get${entityColumn.methodName}() < ${entity.varName}.get${entityColumn.methodName}()) {
							value = -1;
						}
						else if (get${entityColumn.methodName}() > ${entity.varName}.get${entityColumn.methodName}()) {
							value = 1;
						}
						else {
							value = 0;
						}
					</#if>
				<#else>
					<#if stringUtil.equals(entityColumn.type, "Date")>
						value = DateUtil.compareTo(get${entityColumn.methodName}(), ${entity.varName}.get${entityColumn.methodName}());
					<#else>
						<#if entityColumn.isCaseSensitive()>
							value = get${entityColumn.methodName}().compareTo(${entity.varName}.get${entityColumn.methodName}());
						<#else>
							value = get${entityColumn.methodName}().compareToIgnoreCase(${entity.varName}.get${entityColumn.methodName}());
						</#if>
					</#if>
				</#if>

				<#if !entityColumn.isOrderByAscending()>
					value = value * -1;
				</#if>

				if (value != 0) {
					return value;
				}
			</#list>

			return 0;
		<#else>
			${entity.PKClassName} primaryKey = ${entity.varName}.getPrimaryKey();

			<#if entity.hasPrimitivePK()>
				if (getPrimaryKey() < primaryKey) {
					return -1;
				}
				else if (getPrimaryKey() > primaryKey) {
					return 1;
				}
				else {
					return 0;
				}
			<#else>
				return getPrimaryKey().compareTo(primaryKey);
			</#if>
		</#if>
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj) {
			return true;
		}

		if (!(obj instanceof ${entity.name})) {
			return false;
		}

		${entity.name} ${entity.varName} = (${entity.name})obj;

		${entity.PKClassName} primaryKey = ${entity.varName}.getPrimaryKey();

		<#if entity.hasPrimitivePK()>
			if (getPrimaryKey() == primaryKey) {
		<#else>
			if (getPrimaryKey().equals(primaryKey)) {
		</#if>

			return true;
		}
		else{
			return false;
		}
	}

	@Override
	public int hashCode() {
		<#if entity.hasPrimitivePK(false)>
			<#if stringUtil.equals(entity.PKClassName, "int")>
				return getPrimaryKey();
			<#else>
				return (int)getPrimaryKey();
			</#if>
		<#else>
			return getPrimaryKey().hashCode();
		</#if>
	}

	@Override
	public boolean isEntityCacheEnabled() {
		return ENTITY_CACHE_ENABLED;
	}

	@Override
	public boolean isFinderCacheEnabled() {
		return FINDER_CACHE_ENABLED;
	}

	@Override
	public void resetOriginalValues() {
		<#list entity.regularEntityColumns as entityColumn>
			<#if entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name)) || (stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy) || (entity.hasEntityColumn("createDate", "Date") && entity.hasEntityColumn("modifiedDate", "Date"))>
				<#if !cloneCastModelImpl??>
					<#assign cloneCastModelImpl = true />

					${entity.name}ModelImpl ${entity.varName}ModelImpl = this;
				</#if>
			</#if>

			<#if entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name))>
				${entity.varName}ModelImpl._original${entityColumn.methodName} = ${entity.varName}ModelImpl._${entityColumn.name};

				<#if entityColumn.isPrimitiveType()>
					${entity.varName}ModelImpl._setOriginal${entityColumn.methodName} = false;
				</#if>
			</#if>

			<#if stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy>
				${entity.varName}ModelImpl._${entityColumn.name}BlobModel = null;
			</#if>

			<#if entity.hasEntityColumn("createDate", "Date") && entity.hasEntityColumn("modifiedDate", "Date") && stringUtil.equals(entityColumn.name, "modifiedDate")>
				${entity.varName}ModelImpl._setModifiedDate = false;
			</#if>
		</#list>

		<#list cacheFields as cacheField>
			<#assign
				variableName = serviceBuilder.getVariableName(cacheField)
				methodName = serviceBuilder.getCacheFieldMethodName(cacheField)
			/>

			set${methodName}(null);
		</#list>

		<#if columnBitmaskEnabled>
			${entity.varName}ModelImpl._columnBitmask = 0;
		</#if>
	}

	@Override
	public CacheModel<${entity.name}> toCacheModel() {
		${entity.name}CacheModel ${entity.varName}CacheModel = new ${entity.name}CacheModel();

		<#if entity.hasCompoundPK()>
			${entity.varName}CacheModel.${entity.PKVarName} = getPrimaryKey();
		</#if>

		<#list entity.regularEntityColumns as entityColumn>
			<#if !stringUtil.equals(entityColumn.type, "Blob")>
				<#if stringUtil.equals(entityColumn.type, "Date")>
					Date ${entityColumn.name} = get${entityColumn.methodName}();

					if (${entityColumn.name} != null) {
						${entity.varName}CacheModel.${entityColumn.name} = ${entityColumn.name}.getTime();
					}
					else {
						${entity.varName}CacheModel.${entityColumn.name} = Long.MIN_VALUE;
					}
				<#else>
					${entity.varName}CacheModel.${entityColumn.name} = get${entityColumn.methodName}();

					<#if stringUtil.equals(entityColumn.type, "String")>
						String ${entityColumn.name} = ${entity.varName}CacheModel.${entityColumn.name};

						if ((${entityColumn.name} != null) && (${entityColumn.name}.length() == 0)) {
							${entity.varName}CacheModel.${entityColumn.name} = null;
						}
					</#if>
				</#if>
			</#if>
		</#list>

		<#list cacheFields as cacheField>
			<#assign methodName = serviceBuilder.getCacheFieldMethodName(cacheField) />

			${entity.varName}CacheModel.${cacheField.name} = get${methodName}();
		</#list>

		return ${entity.varName}CacheModel;
	}

	@Override
	public String toString() {
		<#assign initialCapacity = entity.regularEntityColumns?size * 2 + 1 />

		StringBundler sb = new StringBundler(${initialCapacity?c});

		<#list entity.regularEntityColumns as entityColumn>
			<#if !stringUtil.equals(entityColumn.type, "Blob") || !entityColumn.lazy>
				<#if entityColumn_index == 0>
					sb.append("{${entityColumn.name}=");
					sb.append(get${entityColumn.methodName}());
				<#elseif entityColumn_has_next>
					sb.append(", ${entityColumn.name}=");
					sb.append(get${entityColumn.methodName}());
				<#else>
					sb.append(", ${entityColumn.name}=");
					sb.append(get${entityColumn.methodName}());
					sb.append("}");
				</#if>
			</#if>
		</#list>

		return sb.toString();
	}

	@Override
	public String toXmlString() {
		<#assign initialCapacity = entity.regularEntityColumns?size * 3 + 4 />

		StringBundler sb = new StringBundler(${initialCapacity?c});

		sb.append("<model><model-name>");
		sb.append("${apiPackagePath}.model.${entity.name}");
		sb.append("</model-name>");

		<#list entity.regularEntityColumns as entityColumn>
			<#if !stringUtil.equals(entityColumn.type, "Blob") || !entityColumn.lazy>
				sb.append("<column><column-name>${entityColumn.name}</column-name><column-value><![CDATA[");
				sb.append(get${entityColumn.methodName}());
				sb.append("]]></column-value></column>");
			</#if>
		</#list>

		sb.append("</model>");

		return sb.toString();
	}

	private static final ClassLoader _classLoader = ${entity.name}.class.getClassLoader();

	private static final Class<?>[] _escapedModelInterfaces = new Class[] {${entity.name}.class};

	<#list entity.regularEntityColumns as entityColumn>
		<#if stringUtil.equals(entityColumn.type, "Blob") && entityColumn.lazy>
			private ${entity.name}${entityColumn.methodName}BlobModel _${entityColumn.name}BlobModel;
		<#else>
			private ${entityColumn.genericizedType} _${entityColumn.name};

			<#if entityColumn.localized>
				private String _${entityColumn.name}CurrentLanguageId;
			</#if>

			<#if entityColumn.isFinderPath() || (validator.isNotNull(parentPKColumn) && (parentPKColumn.name == entityColumn.name))>
				private ${entityColumn.type} _original${entityColumn.methodName};

				<#if entityColumn.isPrimitiveType()>
					private boolean _setOriginal${entityColumn.methodName};
				</#if>
			</#if>

			<#if entity.hasEntityColumn("createDate", "Date") && entity.hasEntityColumn("modifiedDate", "Date") && stringUtil.equals(entityColumn.name, "modifiedDate")>
				private boolean _setModifiedDate;
			</#if>
		</#if>
	</#list>

	<#if columnBitmaskEnabled>
		private long _columnBitmask;
	</#if>

	private ${entity.name} _escapedModel;

}