/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portlet.usersadmin.search;

import com.liferay.portal.kernel.dao.search.DisplayTerms;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portlet.usersadmin.search.UserDisplayTerms;
import com.liferay.portlet.usersadmin.search.UserSearchTerms;
import com.liferay.users.admin.kernel.util.UsersAdminUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletConfig;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;

public class UserSearch
extends SearchContainer<User> {
    public static final String EMPTY_RESULTS_MESSAGE = "no-users-were-found";
    public static List<String> headerNames = new ArrayList<String>();
    public static Map<String, String> orderableHeaders = new HashMap<String, String>();
    private static final Log _log;

    public UserSearch(PortletRequest portletRequest, PortletURL iteratorURL) {
        this(portletRequest, "cur", iteratorURL);
    }

    public UserSearch(PortletRequest portletRequest, String curParam, PortletURL iteratorURL) {
        super(portletRequest, (DisplayTerms)new UserDisplayTerms(portletRequest), (DisplayTerms)new UserSearchTerms(portletRequest), curParam, DEFAULT_DELTA, iteratorURL, headerNames, EMPTY_RESULTS_MESSAGE);
        PortletConfig portletConfig = (PortletConfig)portletRequest.getAttribute("javax.portlet.config");
        UserDisplayTerms displayTerms = (UserDisplayTerms)this.getDisplayTerms();
        UserSearchTerms searchTerms = (UserSearchTerms)this.getSearchTerms();
        String portletId = PortletProviderUtil.getPortletId((String)User.class.getName(), (PortletProvider.Action)PortletProvider.Action.VIEW);
        String portletName = portletConfig.getPortletName();
        if (!portletId.equals(portletName)) {
            displayTerms.setStatus(0);
            searchTerms.setStatus(0);
        }
        iteratorURL.setParameter("status", String.valueOf(displayTerms.getStatus()));
        iteratorURL.setParameter("emailAddress", displayTerms.getEmailAddress());
        iteratorURL.setParameter("firstName", displayTerms.getFirstName());
        iteratorURL.setParameter("lastName", displayTerms.getLastName());
        iteratorURL.setParameter("middleName", displayTerms.getMiddleName());
        iteratorURL.setParameter("organizationId", String.valueOf(displayTerms.getOrganizationId()));
        iteratorURL.setParameter("roleId", String.valueOf(displayTerms.getRoleId()));
        iteratorURL.setParameter("screenName", displayTerms.getScreenName());
        iteratorURL.setParameter("userGroupId", String.valueOf(displayTerms.getUserGroupId()));
        try {
            PortalPreferences preferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)portletRequest);
            String orderByCol = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByCol");
            String orderByType = ParamUtil.getString((PortletRequest)portletRequest, (String)"orderByType");
            if (Validator.isNotNull((String)orderByCol) && Validator.isNotNull((String)orderByType)) {
                preferences.setValue(portletId, "users-order-by-col", orderByCol);
                preferences.setValue(portletId, "users-order-by-type", orderByType);
            } else {
                orderByCol = preferences.getValue(portletId, "users-order-by-col", "last-name");
                orderByType = preferences.getValue(portletId, "users-order-by-type", "asc");
            }
            OrderByComparator orderByComparator = UsersAdminUtil.getUserOrderByComparator((String)orderByCol, (String)orderByType);
            this.setOrderableHeaders(orderableHeaders);
            this.setOrderByCol(orderByCol);
            this.setOrderByType(orderByType);
            this.setOrderByComparator(orderByComparator);
        }
        catch (Exception e) {
            _log.error((Object)"Unable to initialize user search", (Throwable)e);
        }
    }

    static {
        headerNames.add("first-name");
        headerNames.add("last-name");
        headerNames.add("screen-name");
        headerNames.add("job-title");
        headerNames.add("organizations");
        orderableHeaders.put("first-name", "first-name");
        orderableHeaders.put("last-name", "last-name");
        orderableHeaders.put("screen-name", "screen-name");
        orderableHeaders.put("job-title", "job-title");
        _log = LogFactoryUtil.getLog(UserSearch.class);
    }
}

